﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Net.WebSockets;
using System.Threading.Tasks;
using System.Xml;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class ProcessController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<ProcessController> _logger;
        UnitOfWork _unitOfWork;
        public ProcessController(ILogger<ProcessController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取消息提醒
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "sendNameId": ""
        ///         "size":10,
        ///         "page":0,
        ///         "processType":""
        ///         "messageType":"" //message消息，warning提醒
        ///     }
        ///
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllMessages")]
        public async Task<HttpResponseMessage> GetAllMessages([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);


                        string sendNameId = entity.sendNameId;
                        string messageType = entity.messageType;
                        Expression<Func<CommonJpMessage, bool>> expression = t => t.SendName.Equals(sendNameId) && t.State == 0 && !string.IsNullOrEmpty(t.OrderId);
                        if (messageType.Equals("message"))
                        {
                            expression = LambdaExtensions.And(expression, t => t.MessageType != ("rebackWaring") && t.MessageType != ("scrapWaring"));
                        }
                        else if (messageType.Equals("warning"))
                        {
                            expression = LambdaExtensions.And(expression, t => t.MessageType == ("rebackWaring") || t.MessageType == ("scrapWaring"));
                        }
                        if (!string.IsNullOrEmpty(entity.processType))
                        {
                            string processType = entity.processType;
                            expression = LambdaExtensions.And(expression, t => t.MessageType.Equals(processType));
                        }

                        var messageInfo = _unitOfWork.MessageRepository.GetPage(expression, "-SendTime", page, size);

                        var content = new
                        {
                            messageInfo.totalElements,
                            content = messageInfo.content
                        };

                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 已读提醒
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///            "messageId": ""
        ///       
        ///     }
        ///
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ReadMessage")]
        public async Task<HttpResponseMessage> ReadMessage([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);



                        string messageId = entity.messageId;
                        Expression<Func<CommonJpMessage, bool>> expression = t => t.State == 0 && t.Id.Equals(messageId);

                        var messageInfo = _unitOfWork.MessageRepository.Get(expression);
                        if (messageInfo != null)
                        {
                            if (messageInfo.MessageType.Equals("rebackWaring") || messageInfo.MessageType.Equals("scrapWaring"))
                            {
                                messageInfo.State = 1;

                                bool result = _unitOfWork.MessageRepository.Update(messageInfo, true);

                                if (result)
                                {
                                    GlobalContext.SendMessage(messageInfo.SendName);
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            else
                            {
                                bool result = _unitOfWork.MessageRepository.Delete(messageInfo, true);
                                if (result)
                                {
                                    GlobalContext.SendMessage(messageInfo.SendName);
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }

                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 获取全部消息(右上角提示)
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "userId":"用户ID",
        ///     }
        ///
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetMessageCount")]
        public async Task<HttpResponseMessage> GetMessageCount([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string userId = entity?.userId ?? "";


                        var param = new string[] {


                    };
                        string orderCode = entity.orderCode ?? "";

                        Expression<Func<CommonJpMessage, bool>> expression = t => t.SendName == userId && t.State == 0 && !string.IsNullOrEmpty(t.OrderId);





                        var messageList = _unitOfWork.MessageRepository.GetList(expression, p => p.SendTime, false, param);
                        var dataList = messageList.Where(p => p.MessageType != ("rebackWaring") && p.MessageType != ("scrapWaring")).AsEnumerable().GroupBy(p => p.MessageType).Select(p => new
                        {
                            Count = p.Count(),
                            Type = p.FirstOrDefault().MessageType
                        }).OrderByDescending(c => c.Type);
                        var warningDataList = messageList.Where(p => p.MessageType == ("rebackWaring") || p.MessageType == ("scrapWaring")).AsEnumerable().GroupBy(p => p.MessageType).Select(p => new
                        {
                            Count = p.Count(),
                            Type = p.FirstOrDefault().MessageType
                        }).OrderByDescending(c => c.Type);

                        var content = new
                        {
                            messageTotalElements = dataList.Count(),
                            messageContent = dataList,
                            warningTotalElements = warningDataList.Count(),
                            warningContent = warningDataList,
                        };



                        return JsonManager.ReturnSuccessResponse(content);



                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取全部列表
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "flowType":"purchase",
        ///         "approveType":"审核状态" 0待审核,1已完成,2已驳回
        ///         "userId":"用户ID",
        ///         "roleIds":"权限ID",
        ///         "orgId":"组织机构ID"
        ///         "size":10,
        ///         "page":0,
        ///         "orderCode":"", //订单号,
        ///         "startTime":"",
        ///         "endTime":""
        ///     }
        ///
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageHistoryProcessList")]
        //[NoSign]

        public async Task<HttpResponseMessage> GetPageHistoryProcessList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string userId = string.Empty;
                        string orgId = string.Empty;
                        string roleId = string.Empty;
                        string flowType = string.Empty;
                        string startTime = entity.startTime;
                        string endTime = entity.endTime;
                        string warehouseId = entity.warehouseId;

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.flowType ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"flowType is require");
                        }
                        else if (string.IsNullOrEmpty(entity.userId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"userId is require");
                        }
                        else
                        {

                            userId = entity.userId;
                            orgId = entity.orgId;
                            List<string> roleIds = new List<string>();
                            foreach (var item in entity.roleIds)
                            {


                                if (!string.IsNullOrEmpty(item))
                                {
                                    roleIds.Add(item);

                                }

                            }

                            flowType = entity.flowType;
                            int.TryParse(entity.page, out int page);
                            int.TryParse(entity.size, out int size);
                            var param = new string[] {

                     };

                            List<string> orgList = _unitOfWork.OrganizationRepository.GetList(p => p.ParentId.Equals(orgId) && p.State == 1).Select(p => p.Id).ToList();
                            //Expression<Func<CommonJpProcessCurrent, bool>> expression = t => t.Id != null;
                            Expression<Func<CommonJpProcessCurrent, bool>> expression = t =>
                            t.CommonJpProcessHistories.Where
                            (p => p.AuditUserId.Equals(userId)).Count() > 0     
                            || (userId.Equals(t.UserInfo) && !t.UserType.Equals("role"))
                            || (t.UserType.Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo) && t.DataScope.Equals("本级"))
                            || (t.DataScope.Equals("动态") && t.UserType.Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo))
                            ||(t.UserType.Equals("role") && t.DataScope.Equals("上级") && orgList.Contains(t.OrgId) && roleIds.Contains(t.UserInfo));


                            var roleInfo = _unitOfWork.RoleRepository.GetList(p => p.Id != null);
                            if (flowType.Equals("allocation"))
                            {
                                expression = LambdaExtensions.And(expression, t => t.FlowType.Equals("allocationDown") || t.FlowType.Equals("allocationUp"));
                            }
                            else
                            {
                                expression = LambdaExtensions.And(expression, t => t.FlowType.Equals(flowType));
                            }

                            if (!string.IsNullOrEmpty(entity.approveType))
                            {
                                string approveType = entity.approveType;
                                if (approveType.Equals("0")) //0待审核,1已完成,2已驳回
                                {
                                    expression = LambdaExtensions.And(expression, t => t.FlowState.Equals("false") && !string.IsNullOrEmpty(t.UserInfo));
                                }
                                else if (approveType.Equals("1"))
                                {
                                    expression = LambdaExtensions.And(expression, t => t.FlowState.Equals("true"));
                                }
                                else if (approveType.Equals("2"))
                                {
                                    expression = LambdaExtensions.And(expression, t => t.FlowState.Equals("false") && string.IsNullOrEmpty(t.UserInfo));
                                }

                            }
                            switch (flowType)
                            {

                                case "purchase"://采购
                                    param = new string[] {
                               "CommonJpPurchaseOrders",
                               "CommonJpPurchaseOrders.Warehouse" ,
                                "CommonJpProcessHistories"
                            };

                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpPurchaseOrders.FirstOrDefault().WarehouseId.Equals(warehouseId));
                                    }
                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpPurchaseOrders.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpPurchaseOrders.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }
                                    
                                    var purchaseList = _unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, null, false, param).OrderByDescending(t => ((t.UserInfo.Equals(userId) && !"role".Equals(t.UserType))
                             || ("role".Equals(t.UserType) && orgId.Equals(t.OrgId) && roleIds.Contains(t.UserInfo) && "本级".Equals(t.DataScope)) || ("role".Equals(t.UserType) && "上级".Equals(t.DataScope) && orgList.Contains(t.OrgId))) == true ? true : false).OrderByDescending(p => p.UpdateTime);
                                    var purchaseValue = new
                                    {
                                        totalElements = purchaseList.Count(),
                                        content = purchaseList.Skip(page * size).Take(size).ToList()
                                    };
                                    var purchaseData = purchaseValue.content.Select(t => new
                                    {

                                        currentState = ((userId.Equals(t.UserInfo) && !"role".Equals(t.UserType)) || ("动态".Equals(t.DataScope) && "role".Equals(t.UserType) && orgId.Equals(t.OrgId) && roleIds.Contains(t.UserInfo))
                                        || ("role".Equals(t.UserType) && orgId.Equals(t.OrgId) && roleIds.Contains(t.UserInfo) && "本级".Equals(t.DataScope)) || ("role".Equals(t.UserType) && "上级".Equals(t.DataScope) && orgList.Contains(t.OrgId))) == true ? true : false,
                                        t.NextStepId,
                                        t.FlowType,
                                        processActionType = t.ActionType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo))).FirstOrDefault().Name,
                                        t.DataScope,
                                        t.UserType,
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        actionResult = t.CommonJpProcessHistories.OrderByDescending(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(userId) ? "0" : "1",
                                        id = t.CommonJpPurchaseOrders?.FirstOrDefault()?.Id,
                                        warehouseId = t.CommonJpPurchaseOrders?.FirstOrDefault()?.WarehouseId,
                                        applyId = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyId,
                                        applyName = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyName,
                                        applyTime = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyTime,
                                        createTime = t.CommonJpPurchaseOrders?.FirstOrDefault()?.CreateTime,
                                        note = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyReason,
                                        warehouseName = t.CommonJpPurchaseOrders?.FirstOrDefault()?.Warehouse?.Name,
                                        t.CommonJpPurchaseOrders?.FirstOrDefault()?.OrderCode,
                                    });

                                    var purchaseContent = new
                                    {
                                        purchaseValue.totalElements,
                                        content = purchaseData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(purchaseContent);


                                case "borrowMy"://借用


                                    param = new string[] {
                                "CommonJpProcessHistories",
                                "CommonJpBorrowReturnApplies",
                                "CommonJpBorrowReturnApplies.ApprovalPersonNavigation" ,
                                "CommonJpBorrowReturnApplies.Warehouse" ,
                                "CommonJpBorrowReturnApplies.ApprovalPersonNavigation"

                            };

                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpBorrowReturnApplies.FirstOrDefault().WarehouseId.Equals(warehouseId));
                                    }
                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpBorrowReturnApplies.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpBorrowReturnApplies.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }
                                    expression = LambdaExtensions.And(expression, t => t.CommonJpBorrowReturnApplies.Where(P => P.ActionType == 0).Count() > 0);
                                    var borrowList = _unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, null, false, param).OrderByDescending(p => p.UpdateTime);
                                    var borrowValue = new
                                    {
                                        totalElements = borrowList.Count(),
                                        content = borrowList.Skip(page * size).Take(size).ToList()
                                    };
                                    var data = borrowValue.content.Select(t => new
                                    {

                                        currentState = ((t.UserInfo.Equals(userId) && !"role".Equals(t.UserType))
                            || ("role".Equals(t.UserType) && orgId.Equals(t.OrgId) && roleIds.Contains(t.UserInfo) && "本级".Equals(t.DataScope)) || ("role".Equals(t.UserType) && "上级".Equals(t.DataScope) && orgList.Contains(t.OrgId))) == true ? true : false,
                                        t.NextStepId,
                                        processActionType = t.ActionType,
                                        t.FlowType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        actionResult = t.CommonJpProcessHistories.OrderByDescending(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(userId) ? "0" : "1",
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo))).FirstOrDefault().Name,
                                        t.DataScope,
                                        t.UserType,
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        ActionType = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ActionType,
                                        id = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.Id,
                                        warehouseId = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.WarehouseId,
                                        applyId = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ApplyUser,
                                        applyName = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ApplyUserName,
                                        applyTime = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ApplyTime,
                                        note = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.Note,
                                        createTime = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.CreateTime,
                                        expectedTime = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ExpectedReturnTime,
                                        warehouseName = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.Warehouse?.Name,

                                        t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.OrderCode

                                    });

                                    var content = new
                                    {
                                        borrowValue.totalElements,
                                        content = data.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(content);


                                case "repair"://维修
                                case "scrap"://报废
                                    param = new string[] {
                                 "CommonJpFixReceiveApplies.Warehouse" ,
                                  "CommonJpProcessHistories"
                            };
                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpFixReceiveApplies.FirstOrDefault().WarehouseId.Equals(warehouseId));
                                    }
                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpFixReceiveApplies.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpFixReceiveApplies.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }

                                    var scrapList = _unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, null, false, param).OrderByDescending(p => p.UpdateTime);
                                    var contentValue = new
                                    {
                                        totalElements = scrapList.Count(),
                                        content = scrapList.Skip(page * size).Take(size).ToList()
                                    };
                                    var scrapData = contentValue.content.Select(t => new
                                    {
                                        currentState = ((t.UserInfo.Equals(userId) && !"role".Equals(t.UserType))
                                        || ("role".Equals(t.UserType) && orgId.Equals(t.OrgId) && roleIds.Contains(t.UserInfo) && "本级".Equals(t.DataScope)) || ("role".Equals(t.UserType) && "上级".Equals(t.DataScope) && orgList.Contains(t.OrgId))) == true ? true : false,
                                        t.NextStepId,
                                        t.FlowType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        actionResult = t.CommonJpProcessHistories?.OrderByDescending(p => p.UpdateTime)?.FirstOrDefault()?.AuditUserId?.Equals(userId) ?? false ? "0" : "1",
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo ?? "0")))?.FirstOrDefault()?.Name ?? "",
                                        t.UserType,
                                        t.DataScope,
                                        processActionType = t.ActionType == null ? "" : t.ActionType,
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        ActionType = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.Action,
                                        id = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.Id,
                                        warehouseId = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.WarehouseId,
                                        applyId = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApplyId,
                                        applyName = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApplyName,
                                        applyTime = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApplyTime,
                                        note = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApprovalName,
                                        createTime = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.CreateTime,
                                        warehouseName = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.Warehouse?.Name,
                                        t.CommonJpFixReceiveApplies?.FirstOrDefault()?.OrderCode
                                    });

                                    var scrapContent = new
                                    {
                                        contentValue.totalElements,
                                        content = scrapData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(scrapContent);

                                case "inventoryReturn"://装备回库
                                    param = new string[]
                                    {
                                        "CommonJpInventoryReturnApplies.Warehouse",
                                        "CommonJpProcessHistories"
                                    };
                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpInventoryReturnApplies.FirstOrDefault().WarehouseId.Equals(warehouseId));
                                    }
                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpInventoryReturnApplies.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpInventoryReturnApplies.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }

                                    var inventoryReturnList = _unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, null, false, param).OrderByDescending(p => p.UpdateTime);
                                    var inventoryReturnValue = new
                                    {
                                        totalElements = inventoryReturnList.Count(),
                                        content = inventoryReturnList.Skip(page * size).Take(size).ToList()
                                    };
                                    var inventoryReturnData = inventoryReturnValue.content.Select(t => new
                                    {
                                        currentState = ((t.UserInfo.Equals(userId) && !"role".Equals(t.UserType))
                                        || ("role".Equals(t.UserType) && orgId.Equals(t.OrgId) && roleIds.Contains(t.UserInfo) && "本级".Equals(t.DataScope)) || ("role".Equals(t.UserType) && "上级".Equals(t.DataScope) && orgList.Contains(t.OrgId))) == true ? true : false,
                                        t.NextStepId,
                                        t.FlowType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        actionResult = t.CommonJpProcessHistories?.OrderByDescending(p => p.UpdateTime)?.FirstOrDefault()?.AuditUserId?.Equals(userId) ?? false ? "0" : "1",
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo ?? "0")))?.FirstOrDefault()?.Name ?? "",
                                        t.UserType,
                                        t.DataScope,
                                        processActionType = t.ActionType == null ? "" : t.ActionType,
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        id = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.Id,
                                        warehouseId = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.WarehouseId,
                                        applyId = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.ApplyId,
                                        applyName = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.ApplyName,
                                        applyTime = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.ApplyTime,
                                        note = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.Note,
                                        createTime = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.CreateTime,
                                        warehouseName = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.Warehouse?.Name,
                                        t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.OrderCode
                                    });

                                    var inventoryReturnContent = new
                                    {
                                        inventoryReturnValue.totalElements,
                                        content = inventoryReturnData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(inventoryReturnContent);

                                case "allocation"://调拨下发
                                case "allocationDown"://调拨下发
                                case "allocationUp"://调拨申请
                                    param = new string[] {
                                "CommonJpProcessHistories",
                       "CommonJpTransferApplies.TransferWarehouseNavigation" ,
                       "CommonJpTransferApplies.Transfer" ,
                       "CommonJpTransferApplies.ApprovalPersonNavigation" ,

                            };
                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().TransferWarehouse.Equals(warehouseId));
                                    }
                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpTransferApplies.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }

                                    expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().ActionType.Equals(0));

                                    var allocationList = _unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, null, false, param).OrderByDescending(p => p.UpdateTime);
                                    //var allocationList = _unitOfWork.CommonJpProcessCurrentRepository.GetPage(expression, "-ActionType,-FlowState,-UpdateTime", page, size, false, param);
                                    var allocationValue = new
                                    {
                                        totalElements = allocationList.Count(),
                                        content = allocationList.Skip(page * size).Take(size).ToList()
                                    };
                                    var allocationData = allocationValue.content.Select(t => new
                                    {
                                        currentState = ((t.UserInfo.Equals(userId) && !"role".Equals(t.UserType == null ? "" : t.UserType))
                            || ("role".Equals(t.UserType == null ? "" : t.UserType) && orgId.Equals(t.OrgId) && roleIds.Contains(t.UserInfo) && "本级".Equals(t.DataScope)) || ("role".Equals(t.UserType == null ? "" : t.UserType) && "上级".Equals(t.DataScope) && orgList.Contains(t.OrgId))) == true ? true : false,
                                        t.NextStepId,
                                        t.FlowType,
                                        processActionType = t.ActionType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        actionResult = t.CommonJpProcessHistories.OrderByDescending(p => p.UpdateTime).FirstOrDefault().AuditUserId == (userId) ? "0" : "1",
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo))).FirstOrDefault()?.Name,
                                        t.UserType,
                                        t.DataScope,
                                        t.OrgId,
                                        t.CommonJpTransferApplies?.FirstOrDefault()?.UpdateTime,
                                        t.CurrentStepName,
                                        CurrentOrg = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferId,
                                        id = t.CommonJpTransferApplies?.FirstOrDefault()?.Id,
                                        applyId = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUser,
                                        applyName = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUserName,
                                        applyTime = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyTime,
                                        note = t.CommonJpTransferApplies?.FirstOrDefault()?.Reason,
                                        createTime = t.CommonJpTransferApplies?.FirstOrDefault()?.CreateTime,
                                        warehouseName = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferWarehouseNavigation?.Name,
                                        warehouseId = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferWarehouse,
                                        t.CommonJpTransferApplies?.FirstOrDefault()?.Order

                                    });

                                    var allocationContent = new
                                    {
                                        allocationValue.totalElements,
                                        content = allocationData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(allocationContent);
                                case "borrowOther"://跨仓库借用申请
                                case "returnOther"://跨仓库归还
                                    param = new string[] {
                                "CommonJpProcessHistories",
                       "CommonJpTransferApplies.TransferWarehouseNavigation" ,
                       "CommonJpTransferApplies.Transfer" ,
                       "CommonJpTransferApplies.ApprovalPersonNavigation" ,
                       "CommonJpTransferApplies.CommonJpTransfers" ,
                       "CommonJpTransferApplies.Target"
                            };

                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().TransferWarehouse.Equals(warehouseId));
                                    }
                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpTransferApplies.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }
                                    if (flowType.Equals("borrowOther"))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().ActionType.Equals(1));
                                    }
                                    else
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().ActionType.Equals(2));
                                    }
                                    var borrowOutlocationList = _unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, null, false, param).OrderByDescending(p => p.UpdateTime);
                                    //var allocationList = _unitOfWork.CommonJpProcessCurrentRepository.GetPage(expression, "-ActionType,-FlowState,-UpdateTime", page, size, false, param);
                                    var borrowOutlocationValue = new
                                    {
                                        totalElements = borrowOutlocationList.Count(),
                                        content = borrowOutlocationList.Skip(page * size).Take(size).ToList()
                                    };
                                    var borrowOutocationData = borrowOutlocationValue.content.Select(t => new
                                    {
                                        //            currentState = ((t.UserInfo.Equals(userId) && !"role".Equals(t.UserType))
                                        //|| ("role".Equals(t.UserType) && orgId.Equals(t.OrgId) && roleIds.Contains(t.UserInfo) && "本级".Equals(t.DataScope)) || ("role".Equals(t.UserType) && "上级".Equals(t.DataScope) && orgList.Contains(t.OrgId))) == true ? true : false,
                                        currentState = ((userId.Equals(t.UserInfo) && !(t.UserType == null ? "" : t.UserType).Equals("role"))//能否审批
                            || (t.DataScope.Equals("动态") && t.UserType.Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo))
                                        || ((t.UserType == null ? "" : t.UserType).Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo) && t.DataScope.Equals("本级")) || ((t.UserType == null ? "" : t.UserType).Equals("role") && t.DataScope.Equals("上级") && orgList.Contains(t.OrgId))) == true ? true : false,
                                        t.NextStepId,
                                        t.FlowType,
                                        processActionType = t.ActionType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        actionResult = t.CommonJpProcessHistories.OrderByDescending(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(userId) ? "0" : "1",
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo))).FirstOrDefault()?.Name,
                                        t.UserType,
                                        t.DataScope,
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        CurrentOrg = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferId,
                                        t.CommonJpTransferApplies?.FirstOrDefault()?.ExpectedReturnTime,
                                        orderCurrentState = t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransfers?.Count <= 0 ? null : t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransfers?.FirstOrDefault()?.CurrentState,
                                        id = t.CommonJpTransferApplies?.FirstOrDefault()?.Id,
                                        transferId = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferId,
                                        transferName = t.CommonJpTransferApplies?.FirstOrDefault()?.Transfer?.Name,
                                        targetId = t.CommonJpTransferApplies?.FirstOrDefault()?.TargetId,
                                        targetName = t.CommonJpTransferApplies?.FirstOrDefault()?.Target?.Name,
                                        applyId = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUser,
                                        applyName = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUserName,
                                        applyTime = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyTime,
                                        createTime = t.CommonJpTransferApplies?.FirstOrDefault()?.CreateTime,
                                        note = t.CommonJpTransferApplies?.FirstOrDefault()?.Reason,
                                        warehouseName = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferWarehouseNavigation?.Name,
                                        WarehouseId = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferWarehouse,
                                        t.CommonJpTransferApplies?.FirstOrDefault()?.Order
                                    });

                                    var borrowOutlocationContent = new
                                    {
                                        borrowOutlocationValue.totalElements,
                                        content = borrowOutocationData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(borrowOutlocationContent);
                                case "baseInfo"://基础信息

                                    param = new string[] {
                                 "CommonJpProcessHistories" ,
                                  "CommonJpTempEquipments",
                                  "CommonJpTempEquipments.Equipment"
                            };
                                    if (!string.IsNullOrEmpty(flowType))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.FlowType.Equals(flowType));
                                    }

                                    var equipmentsList = _unitOfWork.CommonJpProcessCurrentRepository.GetListAsync(expression, null, false, param).Result.OrderByDescending(p => p.UpdateTime);
                                    var equipmentValue = new
                                    {
                                        totalElements = equipmentsList.Count(),
                                        content = equipmentsList.Skip(page * size).Take(size).ToList()
                                    };
                                    var equipmentData = equipmentValue.content.Select(t => new
                                    {
                                        t.Id,
                                        t.NextStepId,
                                        t.FlowType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        actionResult = t.CommonJpProcessHistories?.OrderByDescending(p => p.UpdateTime)?.FirstOrDefault()?.AuditUserId?.Equals(userId) ?? false ? "0" : "1",
                                        t.UserInfo,
                                        applyName = t.CommonJpProcessHistories?.OrderBy(p => p.UpdateTime)?.FirstOrDefault()?.AuditUserName,
                                        sqnote = t.CommonJpProcessHistories?.OrderBy(p => p.UpdateTime)?.FirstOrDefault()?.AuditMind,
                                        spnote = t.CommonJpProcessHistories?.OrderByDescending(p => p.UpdateTime)?.FirstOrDefault()?.AuditMind,
                                        t.UserType,
                                        t.DataScope,
                                        processActionType = t.ActionType == null ? "" : t.ActionType,
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        approveName = t.CommonJpProcessHistories?.OrderByDescending(x => x.UpdateTime).FirstOrDefault()?.AuditUserName,
                                        historyList = t.CommonJpProcessHistories?.Select(x => new
                                        {
                                            x.Id,
                                            x.OrgId,
                                            x.StepName,
                                            x.UpdateTime,
                                            x.AuditUserId,
                                            x.AuditMind,
                                            x.AuditUserName
                                        }).OrderByDescending(c => c.UpdateTime),
                                        equipmentList = t.CommonJpTempEquipments?.Select(p => new
                                        {
                                            p.Id,
                                            p.Name,
                                            p.Code,
                                            p.DetailId,
                                            p.EpcType,
                                            p.ShortName,
                                            p.SupplierCode,
                                            p.Type,
                                            p.EquipmentId,
                                            equipmentName = p.Equipment?.Name
                                        })
                                    });

                                    var equipmentContent = new
                                    {
                                        equipmentValue.totalElements,
                                        content = equipmentData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(equipmentContent);
                                default:
                                    break;
                            }
                        }
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);


                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 获取全部待审核订单列表
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "userId":"用户ID",
        ///         "roleIds":"权限ID集合",
        ///         "orgId":"组织机构ID"，
        ///         "size":10,
        ///         "page":0,
        ///     }
        ///
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageAllOrderList")]
        //[NoSign]

        public async Task<HttpResponseMessage> GetPageAllOrderList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string userId = string.Empty;
                        string orgId = string.Empty;
                        string orderCode = entity.orderCode ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.userId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"userId is require");
                        }

                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else
                        {
                            List<string> roleIds = new List<string>();
                            foreach (var item in entity.roleIds)
                            {


                                if (!string.IsNullOrEmpty(item))
                                {
                                    roleIds.Add(item);

                                }

                            }
                            userId = entity.userId;
                            orgId = entity.orgId;
                            var roleInfo = _unitOfWork.RoleRepository.GetList(p => p.Id != null);
                            int.TryParse(entity.page, out int page);
                            int.TryParse(entity.size, out int size);
                            var param = new string[] {

                     };

                            List<string> orgList = _unitOfWork.OrganizationRepository.GetList(p => p.ParentId.Equals(orgId) && p.State == 1).Select(p => p.Id).ToList();

                            Expression<Func<ViewAllOrder, bool>> expression = t => (userId.Equals(t.UserInfo) && !t.UserType.Equals("role"))
                            || (t.UserType.Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo) && t.DataScope.Equals("本级")) ||
                            (t.DataScope.Equals("动态") && t.UserType.Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo))
                            || (t.UserType.Equals("role") && t.DataScope.Equals("上级") && orgList.Contains(t.OrgId) && roleIds.Contains(t.UserInfo));

                            var orderList = _unitOfWork.ViewAllOrderRepository.GetList(expression, null, false, param).OrderByDescending(p => p.UpdateTime);

                            var orderValue = new
                            {
                                totalElements = orderList.Count(),
                                content = orderList.Skip(page * size).Take(size).ToList()
                            };
                            var orderContent = new
                            {
                                orderValue.totalElements,
                                content = orderValue.content.ToList()
                            };
                            return JsonManager.ReturnSuccessResponse(orderContent);
                        }



                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 获取全部待审核列表
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "flowType":"purchase",
        ///         "userId":"用户ID",
        ///         "roleIds":"权限ID集合",
        ///         "orgId":"组织机构ID"，
        ///         "size":10,
        ///         "page":0,
        ///         "startTime":"",
        ///         "endTime":"",
        ///         "warehouseId":"",
        ///         "orderId":""
        ///     }
        ///
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageProcessList")]
        //[NoSignAttribute]
        public async Task<HttpResponseMessage> GetPageProcessList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string userId = string.Empty;
                        string orgId = string.Empty;
                        string startTime = entity.startTime;
                        string endTime = entity.endTime;
                        string warehouseId = entity.warehouseId;
                        string flowType = string.Empty;
                        string orderId = entity.orderId ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.flowType ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"flowType is require");
                        }
                        else if (string.IsNullOrEmpty(entity.userId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"userId is require");
                        }

                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else
                        {
                            List<string> roleIds = new List<string>();
                            foreach (var item in entity.roleIds)
                            {


                                if (!string.IsNullOrEmpty(item))
                                {
                                    roleIds.Add(item);

                                }

                            }
                            userId = entity.userId;
                            orgId = entity.orgId;
                            var roleInfo = _unitOfWork.RoleRepository.GetList(p => p.Id != null);
                            flowType = entity.flowType;
                            int.TryParse(entity.page, out int page);
                            int.TryParse(entity.size, out int size);
                            var param = new string[] {

                     };

                            List<string> orgList = _unitOfWork.OrganizationRepository.GetListAsync(p => p.ParentId.Equals(orgId) && p.State == 1).Result.Select(p => p.Id).ToList();

                            Expression<Func<CommonJpProcessCurrent, bool>> expression = t => (userId.Equals(t.UserInfo) && !t.UserType.Equals("role"))
                            || (t.UserType.Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo) && t.DataScope.Equals("本级")) ||
                            (t.DataScope.Equals("动态") && t.UserType.Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo))
                            || (t.UserType.Equals("role") && t.DataScope.Equals("上级") && orgList.Contains(t.OrgId) && roleIds.Contains(t.UserInfo));
                            if (!string.IsNullOrEmpty(entity.approveType))
                            {
                                string approveType = entity.approveType;
                                if (approveType.Equals("0")) //0待审核,1已完成,2已驳回
                                {
                                    expression = LambdaExtensions.And(expression, t => t.FlowState.Equals("false") && !string.IsNullOrEmpty(t.UserInfo));
                                }
                                else if (approveType.Equals("1"))
                                {
                                    expression = LambdaExtensions.And(expression, t => t.FlowState.Equals("true"));
                                }
                                else if (approveType.Equals("2"))
                                {
                                    expression = LambdaExtensions.And(expression, t => t.FlowState.Equals("false") && string.IsNullOrEmpty(t.UserInfo));
                                }

                            }
                            if (flowType.Equals("allocation"))
                            {
                                expression = LambdaExtensions.And(expression, t => t.FlowType.Equals("allocationDown") || t.FlowType.Equals("allocationUp"));
                            }
                            else
                            {
                                expression = LambdaExtensions.And(expression, t => t.FlowType.Equals(flowType));
                            }

                            if (!string.IsNullOrEmpty(orderId))
                            {
                                expression = LambdaExtensions.And(expression, t => t.OrderId.Equals(orderId));
                            }


                            switch (flowType)
                            {
                                case "purchase"://采购
                                    param = new string[] {
                               "CommonJpPurchaseOrders",
                               "CommonJpPurchaseOrders.Warehouse" ,
                                "CommonJpProcessHistories"
                            };


                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpPurchaseOrders.FirstOrDefault().WarehouseId.Equals(warehouseId));
                                    }
                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpPurchaseOrders.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpPurchaseOrders.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }
                                    var purchaseList = _unitOfWork.CommonJpProcessCurrentRepository.GetListAsync(expression, null, false, param).Result.OrderByDescending(t => ((t.UserInfo.Equals(userId) && !"role".Equals(t.UserType))
                             || ("role".Equals(t.UserType) && orgId.Equals(t.OrgId) && roleIds.Contains(t.UserInfo) && "本级".Equals(t.DataScope)) || ("role".Equals(t.UserType) && "上级".Equals(t.DataScope) && orgList.Contains(t.OrgId))) == true ? true : false).OrderByDescending(p => p.UpdateTime);
                                    var purchaseValue = new
                                    {
                                        totalElements = purchaseList.Count(),
                                        content = purchaseList.Skip(page * size).Take(size).ToList()
                                    };
                                    var purchaseData = purchaseValue.content.Select(t => new
                                    {

                                        currentState = ((userId.Equals(t.UserInfo) && !t.UserType.Equals("role"))
                                        || (t.DataScope.Equals("动态") && t.UserType.Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo)) ||
                                        (t.UserType.Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo) && t.DataScope.Equals("本级")) || (t.UserType.Equals("role") && t.DataScope.Equals("上级") && orgList.Contains(t.OrgId))) == true ? true : false,
                                        t.NextStepId,
                                        processActionType = t.ActionType,
                                        actionResult = t.CommonJpProcessHistories.OrderByDescending(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(userId) ? "0" : "1",
                                        t.FlowType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo))).FirstOrDefault().Name,
                                        t.DataScope,
                                        t.UserType,
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        id = t.CommonJpPurchaseOrders?.FirstOrDefault()?.Id,
                                        warehouseId = t.CommonJpPurchaseOrders?.FirstOrDefault()?.WarehouseId,
                                        applyId = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyId,
                                        applyName = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyName,
                                        applyTime = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyTime,
                                        note = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyReason,
                                        createTime = t.CommonJpPurchaseOrders?.FirstOrDefault()?.CreateTime,
                                        warehouseName = t.CommonJpPurchaseOrders?.FirstOrDefault()?.Warehouse?.Name,

                                        t.CommonJpPurchaseOrders?.FirstOrDefault()?.OrderCode


                                    });

                                    var purchaseContent = new
                                    {
                                        purchaseValue.totalElements,
                                        content = purchaseData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(purchaseContent);

                                case "collect"://领用
                                case "borrowMy"://借用
                                    param = new string[] {
                                "CommonJpProcessHistories",
                                "CommonJpBorrowReturnApplies",
                                "CommonJpBorrowReturnApplies.Warehouse"

                            };
                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpBorrowReturnApplies.FirstOrDefault().WarehouseId.Equals(warehouseId));
                                    }

                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpBorrowReturnApplies.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpBorrowReturnApplies.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }

                                    var borrowList = _unitOfWork.CommonJpProcessCurrentRepository.GetListAsync(expression, null, false, param).Result.OrderByDescending(p => p.UpdateTime);
                                    var borrowValue = new
                                    {
                                        totalElements = borrowList.Count(),
                                        content = borrowList.Skip(page * size).Take(size).ToList()
                                    };
                                    var data = borrowValue.content.Select(t => new
                                    {

                                        t.NextStepId,
                                        t.FlowType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo))).FirstOrDefault().Name,
                                        t.UserType,
                                        t.DataScope,
                                        processActionType = t.ActionType,
                                        actionResult = t.CommonJpProcessHistories.OrderByDescending(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(userId) ? "0" : "1",
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        ActionType = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ActionType,
                                        id = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.Id,
                                        warehouseId = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.WarehouseId,
                                        approvalId = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ApprovalUser,
                                        approvalName = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ApprovalUserName,
                                        applyId = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ApplyUser,
                                        applyName = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ApplyUserName,
                                        applyTime = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ApplyTime,
                                        note = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.Note,
                                        createTime = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.CreateTime,
                                        expectedTime = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.ExpectedReturnTime,
                                        warehouseName = t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.Warehouse?.Name,
                                        t.CommonJpBorrowReturnApplies?.FirstOrDefault()?.OrderCode

                                    });

                                    var content = new
                                    {
                                        borrowValue.totalElements,
                                        content = data.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(content);




                                case "repair"://维修 
                                case "scrap"://报废
                                    param = new string[] {
                                 "CommonJpFixReceiveApplies.Warehouse" ,
                                  "CommonJpProcessHistories"
                            };
                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpFixReceiveApplies.FirstOrDefault().WarehouseId.Equals(warehouseId));
                                    }
                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpFixReceiveApplies.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpFixReceiveApplies.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }
                                    var scrapList = _unitOfWork.CommonJpProcessCurrentRepository.GetListAsync(expression, null, false, param).Result.OrderByDescending(p => p.UpdateTime);
                                    var scrapValue = new
                                    {
                                        totalElements = scrapList.Count(),
                                        content = scrapList.Skip(page * size).Take(size).ToList()
                                    };
                                    var scrapData = scrapValue.content.Select(t => new
                                    {

                                        t.NextStepId,
                                        t.FlowType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        actionResult = t.CommonJpProcessHistories?.OrderByDescending(p => p.UpdateTime)?.FirstOrDefault()?.AuditUserId?.Equals(userId) ?? false ? "0" : "1",
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo ?? "0")))?.FirstOrDefault()?.Name ?? "",
                                        t.UserType,
                                        t.DataScope,
                                        processActionType = t.ActionType == null ? "" : t.ActionType,
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        ActionType = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.Action,
                                        id = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.Id,
                                        warehouseId = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.WarehouseId,
                                        applyId = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApplyId,
                                        applyName = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApplyName,
                                        applyTime = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApplyTime,
                                        note = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApprovalName,
                                        createTime = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.CreateTime,
                                        warehouseName = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.Warehouse?.Name,
                                        t.CommonJpFixReceiveApplies?.FirstOrDefault()?.OrderCode


                                    });

                                    var scrapContent = new
                                    {
                                        scrapValue.totalElements,
                                        content = scrapData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(scrapContent);


                                case "inventoryReturn"://装备回库
                                    param = new string[]
                                    {
                                        "CommonJpInventoryReturnApplies.Warehouse",
                                        "CommonJpProcessHistories"
                                    };
                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpInventoryReturnApplies.FirstOrDefault().WarehouseId.Equals(warehouseId));
                                    }
                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpInventoryReturnApplies.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpInventoryReturnApplies.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }
                                    var inventoryReturnList = _unitOfWork.CommonJpProcessCurrentRepository.GetListAsync(expression, null, false, param).Result.OrderByDescending(p => p.UpdateTime);
                                    var inventoryReturnValue = new
                                    {
                                        totalElements = inventoryReturnList.Count(),
                                        content = inventoryReturnList.Skip(page * size).Take(size).ToList()
                                    };
                                    var inventoryReturnData = inventoryReturnValue.content.Select(t => new
                                    {

                                        t.NextStepId,
                                        t.FlowType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        actionResult = t.CommonJpProcessHistories?.OrderByDescending(p => p.UpdateTime)?.FirstOrDefault()?.AuditUserId?.Equals(userId) ?? false ? "0" : "1",
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo ?? "0")))?.FirstOrDefault()?.Name ?? "",
                                        t.UserType,
                                        t.DataScope,
                                        processActionType = t.ActionType == null ? "" : t.ActionType,
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        id = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.Id,
                                        warehouseId = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.WarehouseId,
                                        applyId = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.ApplyId,
                                        applyName = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.ApplyName,
                                        applyTime = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.ApplyTime,
                                        note = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.Note,
                                        createTime = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.CreateTime,
                                        warehouseName = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.Warehouse?.Name,
                                        t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.OrderCode


                                    });

                                    var inventoryReturnContent = new
                                    {
                                        inventoryReturnValue.totalElements,
                                        content = inventoryReturnData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(inventoryReturnContent);

                                case "allocationDown"://调拨下发
                                case "allocation"://调拨全部
                                case "allocationUp"://调拨申请
                                    param = new string[] {
                                "CommonJpProcessHistories",
                       "CommonJpTransferApplies.CommonJpTransferDetailRealities" ,
                       "CommonJpTransferApplies.TransferWarehouseNavigation" ,
                       "CommonJpTransferApplies.Transfer" ,
                       "CommonJpTransferApplies.ApprovalPersonNavigation" ,

                            };
                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().TransferWarehouse.Equals(warehouseId));
                                    }
                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpTransferApplies.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }
                                    expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().ActionType.Equals(0));
                                    var allocationList = _unitOfWork.CommonJpProcessCurrentRepository.GetListAsync(expression, null, false, param).Result.OrderByDescending(p => p.UpdateTime);
                                    var allocationValue = new
                                    {
                                        totalElements = allocationList.Count(),
                                        content = allocationList.Skip(page * size).Take(size).ToList()
                                    };
                                    var allocationData = allocationValue.content.Select(t => new
                                    {

                                        t.NextStepId,
                                        t.FlowType,
                                        processActionType = t.ActionType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        actionResult = t.CommonJpProcessHistories.OrderByDescending(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(userId) ? "0" : "1",
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo))).FirstOrDefault().Name,
                                        t.UserType,
                                        t.DataScope,
                                        t.OrgId,
                                        t.CommonJpTransferApplies?.FirstOrDefault()?.UpdateTime,
                                        t.CurrentStepName,
                                        id = t.CommonJpTransferApplies?.FirstOrDefault()?.Id,
                                        applyId = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUser,
                                        applyName = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUserName,
                                        applyTime = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyTime,
                                        note = t.CommonJpTransferApplies?.FirstOrDefault()?.Reason,
                                        createTime = t.CommonJpTransferApplies?.FirstOrDefault()?.CreateTime,
                                        CurrentOrg = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferId,
                                        warehouseName = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferWarehouseNavigation?.Name,
                                        warehouseId = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferWarehouse,
                                        t.CommonJpTransferApplies?.FirstOrDefault()?.Order

                                    });

                                    var allocationContent = new
                                    {
                                        allocationValue.totalElements,
                                        content = allocationData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(allocationContent);
                                case "borrowOther"://跨仓库借用申请
                                case "returnOther"://跨仓库归还
                                    param = new string[] {
                                "CommonJpProcessHistories",
                       "CommonJpTransferApplies.TransferWarehouseNavigation" ,
                       "CommonJpTransferApplies.Transfer" ,
                       "CommonJpTransferApplies.ApprovalPersonNavigation" ,
                       "CommonJpTransferApplies.CommonJpTransfers" ,
                       "CommonJpTransferApplies.Target"
                            };
                                    if (!string.IsNullOrEmpty(warehouseId))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().TransferWarehouse.Equals(warehouseId));
                                    }
                                    if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().CreateTime >= Convert.ToDateTime(startTime) && t.CommonJpTransferApplies.FirstOrDefault().CreateTime <= Convert.ToDateTime(endTime));
                                    }
                                    if (flowType.Equals("borrowOther"))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().ActionType.Equals(1));
                                    }
                                    else
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.CommonJpTransferApplies.FirstOrDefault().ActionType.Equals(2));
                                    }

                                    var borrowlocationList = _unitOfWork.CommonJpProcessCurrentRepository.GetListAsync(expression, null, false, param).Result.OrderByDescending(t => ((t.UserInfo.Equals(userId) && !"role".Equals(t.UserType))
                             || ("role".Equals(t.UserType) && orgId.Equals(t.OrgId) && roleIds.Contains(t.UserInfo) && "本级".Equals(t.DataScope)) || ("role".Equals(t.UserType) && "上级".Equals(t.DataScope) && orgList.Contains(t.OrgId))) == true ? true : false)
                                        .ThenBy(t => string.IsNullOrEmpty(t.UserInfo) ? true : false).ThenBy(t => t.CommonJpProcessHistories.OrderByDescending(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(userId) ? 0 : 1).ThenBy(p => p.FlowState).ThenByDescending(p => p.UpdateTime);
                                    var borrowlocationValue = new
                                    {
                                        totalElements = borrowlocationList.Count(),
                                        content = borrowlocationList.Skip(page * size).Take(size).ToList()
                                    };
                                    var borrowlocationData = borrowlocationValue.content.Select(t => new
                                    {
                                        currentState = ((userId.Equals(t.UserInfo) && !t.UserType.Equals("role"))//能否审批
                            || (t.DataScope.Equals("动态") && t.UserType.Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo))
                                        || (t.UserType.Equals("role") && t.OrgId.Equals(orgId) && roleIds.Contains(t.UserInfo) && t.DataScope.Equals("本级")) || (t.UserType.Equals("role") && t.DataScope.Equals("上级") && orgList.Contains(t.OrgId))) == true ? true : false,
                                        t.NextStepId,
                                        t.FlowType,
                                        processActionType = t.ActionType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        actionResult = t.CommonJpProcessHistories.OrderByDescending(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(userId) ? "0" : "1",
                                        t.UserInfo,
                                        userInfoName = string.IsNullOrEmpty(t.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.UserInfo))).FirstOrDefault().Name,
                                        t.UserType,
                                        t.DataScope,
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        CurrentOrg = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferId,
                                        orderCurrentState = t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransfers.Count <= 0 ? null : t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransfers?.FirstOrDefault()?.CurrentState,
                                        t.CommonJpTransferApplies?.FirstOrDefault()?.ExpectedReturnTime,
                                        id = t.CommonJpTransferApplies?.FirstOrDefault()?.Id,
                                        transferId = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferId,
                                        transferName = t.CommonJpTransferApplies?.FirstOrDefault()?.Transfer?.Name,
                                        targetId = t.CommonJpTransferApplies?.FirstOrDefault()?.TargetId,
                                        note = t.CommonJpTransferApplies?.FirstOrDefault()?.Reason,
                                        targetName = t.CommonJpTransferApplies?.FirstOrDefault()?.Target?.Name,
                                        applyId = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUser,
                                        applyName = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUserName,
                                        applyTime = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyTime,
                                        createTime = t.CommonJpTransferApplies?.FirstOrDefault()?.CreateTime,
                                        warehouseName = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferWarehouseNavigation?.Name,
                                        warehouseId = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferWarehouse,
                                        t.CommonJpTransferApplies?.FirstOrDefault()?.Order

                                    });

                                    var borrowlocationContent = new
                                    {
                                        borrowlocationValue.totalElements,
                                        content = borrowlocationData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(borrowlocationContent);
                                case "baseInfo"://号型
                                    param = new string[] {
                                 "CommonJpProcessHistories" ,
                                  "CommonJpTempEquipments",
                                  "CommonJpTempEquipments.Equipment",
                            };
                                    if (!string.IsNullOrEmpty(flowType))
                                    {
                                        expression = LambdaExtensions.And(expression, t => t.FlowType.Equals(flowType));
                                    }

                                    var equipmentsList = _unitOfWork.CommonJpProcessCurrentRepository.GetListAsync(expression, null, false, param).Result.OrderByDescending(p => p.UpdateTime);
                                    var equipmentValue = new
                                    {
                                        totalElements = equipmentsList.Count(),
                                        content = equipmentsList.Skip(page * size).Take(size).ToList()
                                    };
                                    var equipmentData = equipmentValue.content.Select(t => new
                                    {
                                        t.Id,
                                        t.NextStepId,
                                        t.FlowType,
                                        flowState = Convert.ToBoolean(t.FlowState),
                                        actionResult = t.CommonJpProcessHistories?.OrderByDescending(p => p.UpdateTime)?.FirstOrDefault()?.AuditUserId?.Equals(userId) ?? false ? "0" : "1",
                                        t.UserInfo,
                                        applyName = t.CommonJpProcessHistories?.OrderBy(p => p.UpdateTime)?.FirstOrDefault()?.AuditUserName,
                                        sqnote = t.CommonJpProcessHistories?.OrderBy(p => p.UpdateTime)?.FirstOrDefault()?.AuditMind,
                                        spnote = t.CommonJpProcessHistories?.OrderByDescending(p => p.UpdateTime)?.FirstOrDefault()?.AuditMind,
                                        t.UserType,
                                        t.DataScope,
                                        processActionType = t.ActionType == null ? "" : t.ActionType,
                                        t.OrgId,
                                        t.UpdateTime,
                                        t.CurrentStepName,
                                        approveName = t.CommonJpProcessHistories?.OrderByDescending(x => x.UpdateTime).FirstOrDefault()?.AuditUserName,
                                        historyList = t.CommonJpProcessHistories?.Select(x => new
                                        {
                                            x.Id,
                                            x.OrgId,
                                            x.StepName,
                                            x.UpdateTime,
                                            x.AuditUserId,
                                            x.AuditMind,
                                            x.AuditUserName
                                        }).OrderByDescending(c => c.UpdateTime),
                                        equipmentList = t.CommonJpTempEquipments?.Select(p => new
                                        {
                                            p.Id,
                                            p.Name,
                                            p.Code,
                                            p.DetailId,
                                            p.EpcType,
                                            p.ShortName,
                                            p.SupplierCode,
                                            p.Type,
                                            p.EquipmentId,
                                            equipmentName = p.Equipment?.Name
                                        })
                                    });

                                    var equipmentContent = new
                                    {
                                        equipmentValue.totalElements,
                                        content = equipmentData.ToList()
                                    };
                                    return JsonManager.ReturnSuccessResponse(equipmentContent);
                                default:
                                    break;
                            }
                        }
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);


                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 获取流程信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "code":"purchase",
        ///         "orgId":"E05CC28D-C189-4389-8081-DD0D6E483B40",
        ///         "stepId":"SequenceFlow_0s99ae6",
        ///         "flowGateway":"同意"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetProcess")]
        public async Task<HttpResponseMessage> GetProcess([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.code ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"code is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else
                        {
                            string code = entity.code;    //流程类型
                            string orgId = entity.orgId;  //组织机构ID
                            string stepId = entity.stepId; //当前流程进度ID
                            string flowGateway = entity.flowGateway;//同意或者不同意

                            bool flowState = false;   //流程状态，是否结束

                            string userType = "";     //审核用户类型
                            string userInfo = "";     //审核用户名或角色名
                            string nextStepId = "";       //下一步流程ID
                            string currentStepName = "";  //当前流程名
                            string dataScope = "";   //本级或上级
                            string actionFlg = "";


                            Expression<Func<BaseJpProcess, bool>> ProcessExpression = t => t.Code.Equals(code) && (t.OrgId == null || t.OrgId.Equals(orgId)) && t.PublishStatus == true;

                            List<BaseJpProcess> ProcessList = _unitOfWork.BaseJpProcessRepository.GetList(ProcessExpression, t => t.OrgId, false).ToList();

                            if (ProcessList.Count == 0)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                            }
                            else
                            {
                                //用户是否有自定义流程
                                var process = ProcessList.Where(c => c.OrgId != null).FirstOrDefault();
                                if (process == null)
                                {
                                    //默认流程
                                    process = ProcessList.Where(c => c.OrgId == null).FirstOrDefault();
                                }

                                //解析XML流程定义字符
                                string processXml = process.ProcessXml;
                                if (string.IsNullOrEmpty(processXml))
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                }
                                else
                                {
                                    XmlDocument pXml = new XmlDocument();

                                    processXml = processXml.Replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
                                    pXml.LoadXml(processXml);

                                    string jsonStr = JsonConvert.SerializeXmlNode(pXml);

                                    JObject jsonObject = JObject.Parse(jsonStr);

                                    var definitionsJson = jsonObject["bpmn2:definitions"];

                                    var processJson = definitionsJson["bpmn2:process"];

                                    if (string.IsNullOrEmpty(stepId))
                                    {
                                        //流程发起 获取起启ID
                                        var startProcess = processJson["bpmn2:startEvent"];
                                        //起启ID对应的线
                                        var flowProcessId = startProcess["bpmn2:outgoing"];

                                        //线的集合
                                        var sequenceFlow = processJson["bpmn2:sequenceFlow"];

                                        //线对应userTask的ID
                                        var sequenceFlowId = "";
                                        foreach (var item in sequenceFlow)
                                        {
                                            if (item["@id"].Equals(flowProcessId))
                                            {
                                                sequenceFlowId = item["@targetRef"].ToString();
                                                break;
                                            }
                                        }

                                        var TaskList = processJson["bpmn2:task"];
                                        flowProcessId = TaskList["bpmn2:outgoing"].ToString();

                                        foreach (var item in sequenceFlow)
                                        {
                                            if (item["@id"].Equals(flowProcessId))
                                            {
                                                sequenceFlowId = item["@targetRef"].ToString();
                                                break;
                                            }
                                        }


                                        //任务的集合
                                        var userTaskList = processJson["bpmn2:userTask"];
                                        if (userTaskList.GetType().Name.Equals("JObject"))
                                        {
                                            userType = userTaskList["@userType"].ToString();
                                            if (userType.Equals("role"))
                                            {
                                                userInfo = userTaskList["@role"].ToString();
                                                dataScope = userTaskList["@dataScope"].ToString();
                                            }
                                            else
                                            {
                                                userInfo = userTaskList["@assignee"].ToString();
                                                dataScope = "";
                                            }

                                            if (userTaskList["@actionFlg"] != null)
                                            {
                                                actionFlg = userTaskList["@actionFlg"].ToString();
                                            }


                                            nextStepId = userTaskList["bpmn2:outgoing"].ToString();
                                            currentStepName = userTaskList["@name"].ToString();

                                        }
                                        else
                                        {
                                            foreach (var item in userTaskList)
                                            {
                                                if (item["@id"].ToString().Equals(sequenceFlowId))
                                                {
                                                    userType = item["@userType"].ToString();
                                                    if (userType.Equals("role"))
                                                    {
                                                        userInfo = item["@role"].ToString();
                                                        dataScope = item["@dataScope"].ToString();
                                                    }
                                                    else
                                                    {
                                                        userInfo = item["@assignee"].ToString();
                                                        dataScope = "";
                                                    }
                                                    if (item["@actionFlg"] != null)
                                                    {
                                                        actionFlg = item["@actionFlg"].ToString();
                                                    }
                                                    nextStepId = item["bpmn2:outgoing"].ToString();
                                                    currentStepName = item["@name"].ToString();

                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    else
                                    {
                                        //线的集合
                                        var sequenceFlow = processJson["bpmn2:sequenceFlow"];
                                        //判断的集合
                                        var gatewayList = processJson["bpmn2:exclusiveGateway"];
                                        //任务的集合
                                        var userTaskList = processJson["bpmn2:userTask"];
                                        //起点
                                        var TaskList = processJson["bpmn2:task"];

                                        var nextFlowId = "";
                                        foreach (var item in sequenceFlow)
                                        {
                                            if (item["@id"].ToString().Equals(stepId))
                                            {
                                                nextFlowId = item["@targetRef"].ToString();
                                                break;
                                            }
                                        }
                                        //判断是否结束
                                        if (nextFlowId.Contains("EndEvent"))
                                        {
                                            flowState = true;
                                        }
                                        else
                                        {
                                            //是否走网关
                                            if (nextFlowId.Contains("Gateway"))
                                            {
                                                JToken gatewayId = null;

                                                if (gatewayList.GetType().Name.Equals("JObject"))
                                                {
                                                    gatewayId = gatewayList["bpmn2:outgoing"];
                                                }
                                                else
                                                {
                                                    foreach (var item in gatewayList)
                                                    {
                                                        if (item["@id"].ToString().Equals(nextFlowId))
                                                        {
                                                            gatewayId = item["bpmn2:outgoing"];
                                                            break;
                                                        }
                                                    }
                                                }


                                                //判断是否同意，还是不同意.
                                                foreach (var gatewayItem in gatewayId)
                                                {
                                                    foreach (var item in sequenceFlow)
                                                    {
                                                        if (item["@id"].ToString().Equals(gatewayItem.ToString()))
                                                        {
                                                            if (item["@name"].ToString().Equals(flowGateway))
                                                            {
                                                                nextFlowId = item["@targetRef"].ToString();
                                                                break;
                                                            }
                                                        }
                                                    }
                                                }

                                                //取线ID
                                                foreach (var item in sequenceFlow)
                                                {
                                                    if (item["@id"].ToString().Equals(nextFlowId))
                                                    {
                                                        nextFlowId = item["@targetRef"].ToString();
                                                        break;
                                                    }
                                                }

                                                //判断是否结束
                                                if (nextFlowId.Contains("EndEvent"))
                                                {
                                                    flowState = true;
                                                }
                                                else
                                                {
                                                    if (nextFlowId.Contains("Task"))
                                                    {
                                                        var flg = true;
                                                        if (userTaskList.GetType().Name.Equals("JObject"))
                                                        {
                                                            if (userTaskList["@id"].ToString().Equals(nextFlowId))
                                                            {
                                                                flg = false;
                                                                userType = userTaskList["@userType"].ToString();
                                                                if (userType.Equals("role"))
                                                                {
                                                                    userInfo = userTaskList["@role"].ToString();
                                                                    dataScope = userTaskList["@dataScope"].ToString();
                                                                }
                                                                else
                                                                {
                                                                    userInfo = userTaskList["@assignee"].ToString();
                                                                    dataScope = "";
                                                                }

                                                                if (userTaskList["@actionFlg"] != null)
                                                                {
                                                                    actionFlg = userTaskList["@actionFlg"].ToString();
                                                                }

                                                                nextStepId = userTaskList["bpmn2:outgoing"].ToString();
                                                                currentStepName = userTaskList["@name"].ToString();
                                                            }
                                                        }
                                                        else
                                                        {
                                                            foreach (var item in userTaskList)
                                                            {
                                                                if (item["@id"].ToString().Equals(nextFlowId))
                                                                {
                                                                    flg = false;
                                                                    userType = item["@userType"].ToString();
                                                                    if (userType.Equals("role"))
                                                                    {
                                                                        userInfo = item["@role"].ToString();
                                                                        dataScope = item["@dataScope"].ToString();
                                                                    }
                                                                    else
                                                                    {
                                                                        userInfo = item["@assignee"].ToString();
                                                                        dataScope = "";
                                                                    }

                                                                    if (item["@actionFlg"] != null)
                                                                    {
                                                                        actionFlg = item["@actionFlg"].ToString();
                                                                    }

                                                                    nextStepId = item["bpmn2:outgoing"].ToString();
                                                                    currentStepName = item["@name"].ToString();

                                                                    break;
                                                                }
                                                            }
                                                        }

                                                        if (flg)
                                                        {
                                                            userType = "";
                                                            userInfo = "";
                                                            dataScope = "";
                                                            nextStepId = TaskList["bpmn2:outgoing"].ToString();
                                                            currentStepName = TaskList["@name"].ToString();
                                                        }
                                                    }
                                                    else
                                                    {
                                                        userType = "";
                                                        userInfo = "";
                                                        dataScope = "";
                                                        nextStepId = TaskList["bpmn2:outgoing"].ToString();
                                                        currentStepName = TaskList["@name"].ToString();
                                                    }
                                                }
                                            }
                                            else
                                            {
                                                //不是网关，直接走下一步。
                                                if (userTaskList.GetType().Name.Equals("JObject"))
                                                {
                                                    userType = userTaskList["@userType"].ToString();
                                                    if (userType.Equals("role"))
                                                    {
                                                        userInfo = userTaskList["@role"].ToString();
                                                        dataScope = userTaskList["@dataScope"].ToString();
                                                    }
                                                    else
                                                    {
                                                        userInfo = userTaskList["@assignee"].ToString();
                                                        dataScope = "";
                                                    }

                                                    if (userTaskList["@actionFlg"] != null)
                                                    {
                                                        actionFlg = userTaskList["@actionFlg"].ToString();
                                                    }

                                                    nextStepId = userTaskList["bpmn2:outgoing"].ToString();
                                                    currentStepName = userTaskList["@name"].ToString();
                                                }
                                                else
                                                {
                                                    foreach (var item in userTaskList)
                                                    {
                                                        if (item["@id"].ToString().Equals(nextFlowId))
                                                        {
                                                            userType = item["@userType"].ToString();
                                                            if (userType.Equals("role"))
                                                            {
                                                                userInfo = item["@role"].ToString();
                                                                dataScope = item["@dataScope"].ToString();
                                                            }
                                                            else
                                                            {
                                                                userInfo = item["@assignee"].ToString();
                                                                dataScope = "";
                                                            }

                                                            if (item["@actionFlg"] != null)
                                                            {
                                                                actionFlg = item["@actionFlg"].ToString();
                                                            }

                                                            nextStepId = item["bpmn2:outgoing"].ToString();
                                                            currentStepName = item["@name"].ToString();
                                                            break;
                                                        }
                                                    }
                                                }

                                            }
                                        }
                                    }

                                    var reData = new { userType = userType, userInfo = userInfo, dataScope = dataScope, actionFlg = actionFlg, nextStepId = nextStepId, currentStepName = currentStepName, flowType = process.Code, flowName = process.Name, flowId = process.Id, flowState = flowState, orgId = orgId };

                                    return JsonManager.ReturnSuccessResponse(reData);
                                }

                            }

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }


        //通过角色和（本级或上级）获取用户列表 
        private List<UsersRole> processGetUserList(string roleId, string dataScope, string orgId)
        {
            try
            {
                var param = new string[] {
                    "User",
                    "User.Organization"
                };

                Expression<Func<UsersRole, bool>> expressionProcess = t => t.RoleId.Equals(roleId);

                List<UsersRole> UsersRoleList = _unitOfWork.UsersRoleRepository.GetList(expressionProcess, t => t.RoleId, false, param).ToList();


                if (dataScope.Equals("本级"))
                {
                    UsersRoleList = UsersRoleList.Where(c => c.User.OrganizationId.Equals(orgId) && c.User.Enabled.Equals(1)).ToList();
                }
                else
                {
                    UsersRoleList = UsersRoleList.Where(c => c.User.Organization.ParentId.Equals(orgId) && c.User.Enabled.Equals(1)).ToList();
                }

                return UsersRoleList;
            }
            catch (Exception ex)
            {
                return null;
            }
        }


        /// <summary>
        /// 获取全部流程步骤信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "code":"borrow",
        ///         "orgId":"A51A6C15-3EE3-4BE0-82B4-4269AC313F9A"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllProcess")]
        public async Task<HttpResponseMessage> GetAllProcess([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.code ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"code is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else
                        {
                            string code = entity.code;    //流程类型
                            string orgId = entity.orgId;  //组织机构ID

                            Expression<Func<BaseJpProcess, bool>> ProcessExpression = t => t.Code.Equals(code) && (t.OrgId == null || t.OrgId.Equals(orgId)) && t.PublishStatus == true;

                            List<BaseJpProcess> ProcessList = _unitOfWork.BaseJpProcessRepository.GetList(ProcessExpression, t => t.OrgId, false).ToList();

                            if (ProcessList.Count == 0)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                            }
                            else
                            {
                                //用户是否有自定义流程
                                var process = ProcessList.Where(c => c.OrgId != null).FirstOrDefault();
                                if (process == null)
                                {
                                    //默认流程
                                    process = ProcessList.Where(c => c.OrgId == null).FirstOrDefault();
                                }

                                //解析XML流程定义字符
                                string processXml = process.ProcessXml;
                                if (string.IsNullOrEmpty(processXml))
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                }
                                else
                                {
                                    XmlDocument pXml = new XmlDocument();

                                    processXml = processXml.Replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
                                    pXml.LoadXml(processXml);

                                    string jsonStr = JsonConvert.SerializeXmlNode(pXml);

                                    JObject jsonObject = JObject.Parse(jsonStr);

                                    var definitionsJson = jsonObject["bpmn2:definitions"];

                                    var processJson = definitionsJson["bpmn2:process"];

                                    //任务的集合
                                    var userTaskList = processJson["bpmn2:userTask"];
                                    //起点
                                    var TaskList = processJson["bpmn2:task"];

                                    List<string> returnData = new List<string>();

                                    returnData.Add(TaskList["@name"].ToString());

                                    if (userTaskList.GetType().Name.Equals("JObject"))
                                    {
                                        returnData.Add(userTaskList["@name"].ToString());
                                    }
                                    else
                                    {
                                        foreach (var item in userTaskList)
                                        {
                                            returnData.Add(item["@name"].ToString());
                                        }
                                    }

                                    returnData.Add("结束");

                                    return JsonManager.ReturnSuccessResponse(returnData);
                                }

                            }

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }



    }
}
