﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking.Internal;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Runtime.CompilerServices;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class FixReceiveApplyController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<FixReceiveApplyController> _logger;
        UnitOfWork _unitOfWork;
        public FixReceiveApplyController(ILogger<FixReceiveApplyController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取维修报废订单详细信息
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "id":""
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetByID")]
        public async Task<HttpResponseMessage> GetByID([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = string.Empty;
                        id = entity.id;


                        var param = new string[] {
                       "CommonJpProcessHistories",
                       "CommonJpFixReceiveApplies",
                       "CommonJpFixReceiveApplies.Warehouse" ,
                       "CommonJpFixReceiveApplies.CommonJpFixReceiveApplyDetails" ,
                       "CommonJpFixReceiveApplies.CommonJpFixReceiveApplyDetails.Equipment" ,
                       "CommonJpFixReceiveApplies.CommonJpFixReceiveApplyDetails.Size" ,
                       "CommonJpFixReceiveApplies.CommonJpFixReceiveApplyDetails.Supplier" ,

                    };
                        Expression<Func<CommonJpProcessCurrent, bool>> expression = p => p.OrderId.Equals(id) || p.CommonJpFixReceiveApplies.Where(c => c.OrderCode.Equals(id)).Count() > 0;

                        var fix = _unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, null, false, param).ToList();
                        if (fix.Count > 0)
                        {


                            var fixData = fix.Select(t => new
                            {
                                type = t.CommonJpFixReceiveApplies.First().Action.Equals(0) ? 5 : 6,
                                t.NextStepId,
                                t.FlowType,
                                flowState = Convert.ToBoolean(t.FlowState),
                                t.UserInfo,
                                t.UserType,
                                t.DataScope,
                                processActionType = t.ActionType == null ? "" : t.ActionType,
                                OrgId = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.OrgId,
                                t.UpdateTime,
                                t.CurrentStepName,
                                ActionType = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.Action,
                                id = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.Id,
                                warehouseId = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.WarehouseId,
                                applyId = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApplyId,
                                applyName = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApplyName,
                                applyTime = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApplyTime,
                                note = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApprovalName,
                                createTime = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.CreateTime,
                                warehouseName = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.Warehouse?.Name,
                                t.CommonJpFixReceiveApplies?.FirstOrDefault()?.OrderCode,

                                actionResult = t.CommonJpProcessHistories?
                                    .OrderBy(p => p.UpdateTime)
                                    .FirstOrDefault()?
                                    .AuditUserId.Equals(t.CommonJpFixReceiveApplies?.FirstOrDefault()?.ApplyId) == true ? "0" : "1",


                                historyList = t.CommonJpProcessHistories?.Select(x => new
                                {
                                    x.Id,
                                    x.OrgId,
                                    x.StepName,
                                    x.UpdateTime,
                                    x.AuditUserId,
                                    AuditMind = x.AuditMind == null ? "" : x.AuditMind,
                                    x.AuditUserName
                                }).OrderByDescending(c => c.UpdateTime),
                                detailList = t.CommonJpFixReceiveApplies?.FirstOrDefault()?.CommonJpFixReceiveApplyDetails?.Select(x => new
                                {
                                    realityId = x.OrderId,
                                    equipmentId = x.Equipment?.Id,
                                    equipmentName = x.Equipment?.Name,
                                    equipmentSizeId = x.Size?.Id,
                                    equipmentSizeName = x.Size?.SizeName,
                                    quantity = x.Quantity,
                                    x.InsideRealCount,
                                    supplierId = x.Supplier?.Id,
                                    x.Epc,
                                    supplierName = x.Supplier?.Name,
                                })


                            }).FirstOrDefault();


                            return JsonManager.ReturnSuccessResponse(fixData);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }


                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取维修保养申请单
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "page":0,
        ///         "size":10,
        ///         "orderCode":"", //订单号
        ///         "approvalStatus":0,  //0待审批,1已审批,2已驳回
        ///         "action":0,
        ///         "applyId":"",
        ///         "startTime":"",
        ///         "endTime":"",
        ///         "warehouseId":"" 
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllFixs")]
        public async Task<HttpResponseMessage> GetAllFixs([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string applyId = entity?.applyId ?? "";
                        string approvalId = entity?.approvalId ?? "";
                        string startTime = entity.startTime;
                        string endTime = entity.endTime;
                        if (size == 0)
                        {
                            size = 10;
                        }
                        if (string.IsNullOrEmpty(applyId) && string.IsNullOrEmpty(approvalId))
                        {
                            return JsonManager.SimpleCustResponse("applyId or approvalId is require");
                        }

                        var param = new string[] {
                       "ProcessCurrent",
                       "ProcessCurrent.CommonJpProcessHistories",
                       "CommonJpFixReceiveApplyDetails" ,
                       "Warehouse" ,
                       "CommonJpFixReceiveApplyDetails.Equipment" ,
                       "CommonJpFixReceiveApplyDetails.Size" ,
                       "CommonJpFixReceiveApplyDetails.Supplier" ,
                    };

                        string orderCode = entity.orderCode ?? "";
                        string warehouseId = entity.warehouseId;
                        string actions = entity.action;
                        var bSta = int.TryParse(entity.approvalStatus ?? "", out int approvalStatus);
                        Expression<Func<CommonJpFixReceiveApply, bool>> expression = t => t.ApplyId == applyId;
                        if (string.IsNullOrEmpty(actions))
                        {
                            return JsonManager.SimpleCustResponse("action is require");

                        }
                        if (!string.IsNullOrEmpty(warehouseId))
                        {
                            expression = LambdaExtensions.And(expression, t => t.WarehouseId.Equals(warehouseId));
                        }
                        if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                        {
                            expression = LambdaExtensions.And(expression, t => t.CreateTime >= Convert.ToDateTime(startTime) && t.CreateTime <= Convert.ToDateTime(endTime));
                        }
                        if (!string.IsNullOrEmpty(orderCode))
                        {
                            expression = LambdaExtensions.And(expression, t => t.OrderCode.Contains(orderCode));
                        }

                        expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowType.Equals(actions));

                        if (!string.IsNullOrEmpty(entity.approveType))
                        {
                            string approveType = entity.approveType;
                            if (approveType.Equals("0")) //0待审核,1已完成,2已驳回
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("false") && !string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }
                            else if (approveType.Equals("1"))
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("true"));
                            }
                            else if (approveType.Equals("2"))
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("false") && string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }

                        }
                        var roleInfo = _unitOfWork.RoleRepository.GetList(p => p.Id != null);
                        //var applyList = _unitOfWork.FixReceiveApplyRepository.GetPage(expression, "-ApprovalTime", page, size, false, param);

                        var applyList = _unitOfWork.FixReceiveApplyRepository.GetList(expression, null, false, param).OrderByDescending(p => p.ProcessCurrent.UpdateTime);
                        var applyValue = new
                        {
                            totalElements = applyList.Count(),
                            content = applyList.Skip(page * size).Take(size).ToList()
                        };

                        var data = applyValue?.content.Select(t => new
                        {
                            ActionType = t.Action,
                            id = t.Id,
                            warehouseId = t.WarehouseId,
                            approvalId = t.ApprovalId,
                            note = t.ApprovalName,
                            t.ProcessCurrent.UserInfo,
                            actionResult = t.ProcessCurrent.CommonJpProcessHistories.OrderBy(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(applyId) ? "0" : "1",
                            UserInfoName = string.IsNullOrEmpty(t.ProcessCurrent.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.ProcessCurrent.UserInfo))).FirstOrDefault().Name,
                            t.ProcessCurrent.UpdateTime,
                            t.ProcessCurrent.OrgId,
                            t.ProcessCurrent.NextStepId,
                            t.ProcessCurrent.CurrentStepName,
                            t.ProcessCurrent.DataScope,
                            t.ProcessCurrent.UserType,
                            t.ProcessCurrent.FlowType,
                            processActionType = t.ProcessCurrent.ActionType,
                            flowState = Convert.ToBoolean(t.ProcessCurrent.FlowState),
                            applyId = t.ApplyId,
                            applyTime = t.ApplyTime,
                            createTime = t.CreateTime,
                            warehouseName = t.Warehouse?.Name,
                            orderCode = t.OrderCode,
                            applyName = t.ApplyName,
                            historyList = t.ProcessCurrent.CommonJpProcessHistories.Select(x => new
                            {
                                x.Id,
                                x.OrgId,
                                x.StepName,
                                x.UpdateTime,
                                x.AuditUserId,
                                x.AuditMind,
                                x.AuditUserName
                            }).OrderByDescending(c => c.UpdateTime),
                            detailList = t.CommonJpFixReceiveApplyDetails.Select(x => new
                            {
                                equipmentId = x?.EquipmentId,
                                equipmentName = x?.Equipment?.Name,
                                equipmentSizeId = x.SizeId,
                                equipmentSizeName = x?.Size?.SizeName,
                                quantity = x.Quantity,
                                supplierId = x?.SupplierId,
                                supplierName = x?.Supplier?.Name,
                                typeId = x?.Equipment?.EquipmentId,
                                id = x.Id,
                                x.Epc
                            }),

                        });


                        var content = new
                        {
                            applyValue?.totalElements,
                            content = data
                        };
                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增/更新维修报废单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"", //新增可不填
        ///         "action":0, //0维修申请，1报废申请
        ///         "applyId":"",
        ///         "warehouseId":"",
        ///         "orgId":"",
        ///         "orgCode":"",
        ///         "applyName":"",
        ///         "note":"请求理由",//可为空
        ///         "detailList":[
        ///         {
        ///            "id":"",//新增可不填
        ///            "equipmentId":"",
        ///            "equipmentSizeId":"",
        ///            "quantity":"",
        ///            "supplierId":"",
        ///            "epc":""
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateFixed")]
        //[NoSign]
        public async Task<HttpResponseMessage> AddOrUpdateFixed([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        //_logger.LogDebug("Fix/AddOrUpdateFixed维修报废新增:" + jdata.ToString());
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.action ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"action is require");
                        }
                        else if (string.IsNullOrEmpty(entity.applyId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.applyName ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyName is require");
                        }

                        else if (string.IsNullOrEmpty(entity.orgCode ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgCode is require");
                        }
                        else if (string.IsNullOrEmpty(entity.warehouseId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (entity.detailList == null || entity.detailList.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"detailList is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            bool processResult = _unitOfWork.CheckProcess(id);
                            if (!processResult)
                            {
                                var order = _unitOfWork.DbContext.CommonJpFixReceiveApplies.Include(t => t.CommonJpFixReceiveApplyDetails).FirstOrDefault(t => t.Id == id);
                                if (order == null)
                                {
                                    return JsonManager.SimpleCustResponse($"id:{id}数据不存在");
                                }
                                else
                                {
                                    _unitOfWork.ApproveMessage(order.Id);
                                    string flowState = (string)entity.flowState.ToLower();
                                    _unitOfWork.AuditProcess((string)entity.actionType, order.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                     (string)entity.currentStepName, flowState, (string)entity.note, (string)entity.applyId, (string)entity.applyName, (string)entity.orgId, "update");

                                    order.Action = int.Parse(entity.action);
                                    order.ApplyId = entity.applyId;
                                    order.ApplyTime = DateTime.Now;
                                    order.CreateTime = DateTime.Now;

                                    order.WarehouseId = entity.warehouseId;
                                    order.OrgId = entity.orgId;
                                    order.ApplyName = entity.applyName;
                                    order.ApprovalName = entity.note;


                                    List<string> tmpList = JsonManager.GetDetailIds(entity.detailList);
                                    var tmpDetail = order.CommonJpFixReceiveApplyDetails?.Where(t => !tmpList.Contains(t.Id)).ToList();
                                    for (int i = tmpDetail.Count() - 1; i >= 0; i--)
                                    {
                                        var tmp_dtl = tmpDetail.ElementAt(i);
                                        order.CommonJpFixReceiveApplyDetails.Remove(tmp_dtl);
                                    }

                                    foreach (var item in entity.detailList)
                                    {
                                        int.TryParse(item.quantity, out int qty);
                                        if (string.IsNullOrEmpty(item.equipmentId ?? ""))
                                        {
                                            return JsonManager.SimpleCustResponse("equipmentId is require");
                                        }
                                        if (string.IsNullOrEmpty(item.epc ?? ""))
                                        {
                                            return JsonManager.SimpleCustResponse("epc is require");
                                        }
                                        else if (string.IsNullOrEmpty(item.supplierId ?? ""))
                                        {
                                            return JsonManager.SimpleCustResponse("supplierId is require");
                                        }
                                        else if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                        {
                                            return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                        }
                                        else if (qty <= 0)
                                        {
                                            return JsonManager.SimpleCustResponse("quantity field error");
                                        }
                                        else
                                        {
                                            //新增明细
                                            if (string.IsNullOrEmpty(item.id ?? ""))
                                            {
                                                order.CommonJpFixReceiveApplyDetails.Add(new CommonJpFixReceiveApplyDetail()
                                                {
                                                    Id = Guid.NewGuid().ToString(),
                                                    EquipmentId = item.equipmentId,
                                                    SizeId = item.equipmentSizeId,
                                                    OrderId = order.Id,
                                                    Quantity = qty,
                                                    SupplierId = item.supplierId,
                                                    Epc = item.epc ?? ""

                                                });
                                            }
                                            else
                                            {
                                                var detail = order.CommonJpFixReceiveApplyDetails.FirstOrDefault(t => t.Id == item.id);
                                                if (detail == null)
                                                {
                                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                                }
                                                else
                                                {
                                                    detail.EquipmentId = item.equipmentId;
                                                    detail.SizeId = item.equipmentSizeId;
                                                    detail.OrderId = order.Id;
                                                    detail.Quantity = qty;
                                                    detail.SupplierId = item.supplierId;
                                                    detail.Epc = item.epc ?? "";
                                                    detail.State = 0;
                                                }
                                            }
                                        }
                                    }

                                    bool result = _unitOfWork.FixReceiveApplyRepository.Update(order, true);
                                    if (result)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ACCOUNT_IS_AUDITED);
                            }
                        }
                        else
                        {
                            string orderID = Guid.NewGuid().ToString();
                            string processCurrentId = Guid.NewGuid().ToString();
                            string flowState = (string)entity.flowState.ToLower();
                            int action = int.Parse(entity.action);
                            string head_str = action == 0 ? "WX" : "BF";
                            string orderCode = $"{entity.orgCode}{head_str}{DateTime.Now.ToString("yyyyMMddHHmmss")}";
                            var ExistOrder = _unitOfWork.FixReceiveApplyRepository.Get(p => p.OrderCode == orderCode);
                            var fixEpcs = _unitOfWork.FixReceiveApplyDetailRepository.GetList(p => p.Id != null).Select(x =>
                                    x.Epc.ToString()
                            ).ToList();
                            if (ExistOrder != null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORDER_IS_EXIST);
                            }
                            bool processResult = _unitOfWork.AddProcess(processCurrentId, orderID, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId, (string)entity.currentStepName
                                , (string)entity.flowType, (string)entity.flowName, (string)entity.flowId, flowState, (string)entity.orgId, (string)entity.note, (string)entity.applyId, (string)entity.applyName, orderCode);




                            //新增数据
                            CommonJpFixReceiveApply order = new CommonJpFixReceiveApply()
                            {
                                Action = action,
                                ApplyId = entity.applyId,
                                ApplyTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ApprovalTime = null,
                                ApprovalResult = (int)ApproveType.待审批,
                                ApprovalId = entity.approvalId,
                                ApprovalName = entity.note,
                                WarehouseId = entity.warehouseId,
                                Id = orderID,
                                OrgId = entity.orgId,
                                ApplyName = entity.applyName,
                                ProcessCurrentId = processCurrentId,
                                OrderCode = orderCode
                            };


                            List<CommonJpFixReceiveApplyDetail> detailsList = new List<CommonJpFixReceiveApplyDetail>();
                            foreach (var item in entity.detailList)
                            {
                                string getEpc = item.epc;
                                int.TryParse(item.quantity, out int qty);
                                if (string.IsNullOrEmpty(item.equipmentId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("equipmentId is require");
                                }
                                else if (string.IsNullOrEmpty(item.epc ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("epc is require");
                                }
                                else if (string.IsNullOrEmpty(item.supplierId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("supplierId is require");
                                }
                                else if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                }
                                else if (qty <= 0)
                                {
                                    return JsonManager.SimpleCustResponse("quantity field error");
                                }
                                else if (fixEpcs.Contains(getEpc))
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.BASE_EXIST);
                                }
                                else
                                {
                                    detailsList.Add(new CommonJpFixReceiveApplyDetail()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        EquipmentId = item.equipmentId,
                                        SizeId = item.equipmentSizeId,
                                        OrderId = order.Id,
                                        Quantity = qty,
                                        SupplierId = item.supplierId,
                                        Epc = item.epc ?? "",
                                        State = 0
                                    });
                                }
                            }

                            order.CommonJpFixReceiveApplyDetails = detailsList;

                            bool result = _unitOfWork.FixReceiveApplyRepository.Insert(order, true);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 删除维修报废单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"",
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteOrder")]
        public async Task<HttpResponseMessage> DeleteOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else if (string.IsNullOrEmpty(entity.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse("id is require");
                        }
                        string id = entity.id ?? "";
                        var order = _unitOfWork.DbContext.CommonJpFixReceiveApplies.FirstOrDefault(t => t.Id == id);
                        if (order == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else
                        {
                            bool result = _unitOfWork.FixReceiveApplyRepository.Delete(order);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }

                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        private static object FixSign = new object();
        /// <summary>
        /// 审批维修/保养单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "idList":[{id:"99a776d7-f9ae-40f8-87e2-be4fa5eb42c6"}],
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ApproveOrder")]
        //[NoSign]
        public async Task<HttpResponseMessage> ApproveOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    lock (FixSign)
                    {
                        if (jdata != null)
                        {


                            var entity = JsonManager.GetJsonEntity(jdata);
                            var isLost = entity?.isLost ?? false;
                            if (entity == null)
                            {
                                return JsonManager.SimpleCustResponse($"model is null");
                            }
                            else if (string.IsNullOrEmpty(entity.id ?? ""))
                            {
                                return JsonManager.SimpleCustResponse($"id is require");
                            }
                            else if (string.IsNullOrEmpty(entity?.flowState ?? ""))
                            {
                                return JsonManager.SimpleCustResponse($"flowState is require");
                            }
                            else
                            {



                                string id = entity.id ?? "";
                                if (string.IsNullOrEmpty(id))
                                {
                                    return JsonManager.SimpleCustResponse($"id is require");
                                }
                                var orderInfo = _unitOfWork.DbContext.CommonJpFixReceiveApplies.Include(t => t.CommonJpFixReceiveApplyDetails).Include(t => t.ProcessCurrent).FirstOrDefault(t => t.Id == id);
                                var flowState = (string)(entity.flowState).ToLower();
                                if (orderInfo.ProcessCurrent.FlowState == "ture")
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.ORDER_OPERATE_ERROR);
                                }
                                else
                                {
                                    bool processResult = _unitOfWork.CheckProcess(orderInfo.Id);
                                    if (processResult)
                                    {
                                        _unitOfWork.ApproveMessage(orderInfo.Id);
                                        _unitOfWork.AuditProcess((string)entity.actionType, orderInfo.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                         (string)entity.currentStepName, flowState, (string)entity.approvalMsg, (string)entity.auditUser, (string)entity.auditUserName, (string)entity.orgId, "approve");
                                        orderInfo.ApprovalTime = DateTime.Now;

                                        if (flowState == "true")
                                        {
                                            orderInfo.CurrentState = flowState == "true" ? 1 : 0;
                                            //更新子表状态
                                            foreach (var detail in orderInfo.CommonJpFixReceiveApplyDetails)
                                            {
                                                detail.State = 1;
                                            }
                                            //生成流水表
                                            GenerateRecord(orderInfo);
                                            //反写库存状态
                                            UpdateInvState(orderInfo.CommonJpFixReceiveApplyDetails?.Select(x => x.Epc).ToList(), orderInfo.Action, orderInfo.OrderCode, isLost);


                                        }

                                        //更新审批状态
                                        bool result = _unitOfWork.FixReceiveApplyRepository.Update(orderInfo, true);
                                        if (!result)
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);


                                        }
                                        else
                                        {
                                            //报废成功，重新计算阈值
                                            var sizeList = orderInfo.CommonJpFixReceiveApplyDetails
                                                .Select(x => x.SizeId)
                                                .ToList();
                                            _unitOfWork.CalcThreshold(sizeList, orderInfo.OrgId, orderInfo.WarehouseId);
                                            return JsonManager.ReturnSuccessResponse(new
                                            {
                                                orderCode = orderInfo.OrderCode
                                            });
                                        }
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                    }
                                }

                            }
                        }
                        else
                        {
                            return JsonManager.SimpleCustResponse($"invalid parameter");
                        }
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 根据EPC获取物资信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///        "epc:":"xxx-xxx-xxx-xxx"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetWzByEpc")]
        public async Task<HttpResponseMessage> GetWzByEpc([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.epc ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"epc is require");
                        }
                        else
                        {
                            string epc = entity.epc ?? "";

                            //4维修中，6已报废
                            var wz_info = _unitOfWork.DbContext.CommonJpEquipmentInventories
                                .Include(t => t.SupplierCodeNavigation)
                                .Include(t => t.EquipmentCodeNavigation)
                                .Include(t => t.EquipmentSizecodeNavigation)
                                .Include(t => t.WarehouseCodeNavigation)
                                .FirstOrDefault(t => t.Epc.Equals(epc)
                                && t.CurrentState != 4
                                && t.CurrentState != 6
                                && (t.LostFlag == false || t.LostFlag == null));
                            if (wz_info == null)
                            {
                                return JsonManager.SimpleCustResponse("未找到物资信息");
                            }
                            else
                            {
                                var data = new
                                {
                                    equipmentId = wz_info.EquipmentCode,
                                    equipmentName = wz_info.EquipmentCodeNavigation?.Name,
                                    typeId = wz_info.EquipmentCodeNavigation.EquipmentId,
                                    typeName = wz_info.EquipmentCodeNavigation?.Equipment?.Name,
                                    equipmentSizeId = wz_info.EquipmentSizecode,
                                    equipmentSizeName = wz_info.EquipmentSizecodeNavigation?.SizeName,
                                    supplierId = wz_info.SupplierCode,
                                    supplierName = wz_info.SupplierCodeNavigation?.Name,
                                    epc = wz_info.Epc,
                                    warehouseId = wz_info?.WarehouseCode,
                                    warehouseName = wz_info?.WarehouseCodeNavigation?.Name,
                                    isBindBag = !string.IsNullOrEmpty(wz_info.BagInventoryId)
                                };
                                return JsonManager.ReturnSuccessResponse(data);
                            }

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 生成报废/维修流水记录
        /// </summary>
        private void GenerateRecord(CommonJpFixReceiveApply order)
        {
            //string head_str = order.Action == 0 ? "WX" : "BF";
            //string orgCode = order.OrderCode.Substring(0, 6);
            CommonJpFixUseless useless = new CommonJpFixUseless()
            {
                Id = Guid.NewGuid().ToString(),
                Action = order.Action,
                ApplyId = order.ApplyId,
                CreateTime = DateTime.Now,
                CreateUser = "李四",
                FixTime = DateTime.Now,
                EstimateId = order.Id,
                OrderCode = order.OrderCode,//$"{orgCode}{head_str}{DateTime.Now.ToString("yyyyMMddHHmmss")}",
                OrgId = order.OrgId,
                WarehouseId = order.WarehouseId,
                CommonJpFixUselessDetails = new List<CommonJpFixUselessDetail>(),
                CurrentState = 1
            };
            foreach (var item in order.CommonJpFixReceiveApplyDetails)
            {
                var tmpEntity = new CommonJpFixUselessDetail()
                {
                    Id = Guid.NewGuid().ToString(),
                    OrderId = useless.Id,
                    Quantity = item.Quantity,
                    State = 1,
                    Epc = item.Epc,
                    EquipmentId = item.EquipmentId,
                    SizeId = item.SizeId,
                    SupplierId = item.SupplierId,
                    RealCount = 1
                };
                useless.CommonJpFixUselessDetails.Add(tmpEntity);
                var tmpState = GenerateState(order.OrderCode, tmpEntity.Epc, useless.Action, tmpEntity.Id, useless.WarehouseId, useless.OrgId, order.ApplyId);
                if (tmpState != null)
                {
                    tmpEntity.CommonJpEquipmentStates.Add(tmpState);
                }
            }
            _unitOfWork.FixUselessRepository.Insert(useless, false);

        }

        private CommonJpEquipmentState GenerateState(string orderCode, string epc, int action, string detailId, string warehouseId, string orgId, string applyId)
        {
            var invInfo = _unitOfWork.DbContext.CommonJpEquipmentInventories.FirstOrDefault(t => t.Epc.Contains(epc));
            if (invInfo != null)
            {
                CommonJpEquipmentState equState = new CommonJpEquipmentState()
                {
                    OrderCode = orderCode,
                    Id = Guid.NewGuid().ToString(),
                    State = 2,
                    ActionState = action == 0 ? 6 : 7,
                    EqiupmentId = invInfo.Id,
                    OutInState = 0,
                    FixId = detailId,
                    WarehouseId = warehouseId,
                    CreateTime = DateTime.Now,
                    OrgId = orgId,
                    OutTime = DateTime.Now,
                    PoliceId = _unitOfWork.DbContext.CommonJpUsers.FirstOrDefault(x => x.Id == applyId)?.PoliceId
                };
                return equState;
            }
            else { return default; }

        }

        private void UpdateInvState(List<string> epcList, int action, string orderCode, bool isLost)
        {
            if (epcList == null || epcList.Count == 0)
            {
                _logger.LogError($"[维修报废]未找到维修报废明细，{orderCode}");
            }
            var wz_info = _unitOfWork.DbContext.CommonJpEquipmentInventories.Where(t => epcList.Contains(t.Epc)).ToList();
            if (wz_info != null && wz_info.Count() > 0)
            {
                wz_info.ForEach(x =>
                {
                    x.LostFlag = isLost;
                    x.CurrentState = action == 0 ? 4 : 6;
                    if (x.CurrentState == 6)
                    {
                        //报废装备置于报废区 
                        x.ShelfId = "00000000-0000-0000-0000-000000000001";
                        x.ShelfRange = null;
                        x.ShelfRow = null;
                        x.ShelfColumn = null;
                    }
                    //单警柜解绑
                    x.CabinetId = null;
                    x.PoliceCode = null;
                    _unitOfWork.EquipmentInventoryRepository.Update(x, false);
                });

            }
        }


    }
}
