﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JmpModel.Model.Respository.BaseRepository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.RazorPages;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using static JmpModel.Model.Enumerates.EquipmentHistroyEnum;

namespace JunmpPoliceStation.Controllers
{

    [Route("api/[controller]")]
    [ApiController]
    public class CabinetController : ControllerBase
    {
        private HttpHelper _httpHelper;
        private ILogger<CabinetController> _logger;
        UnitOfWork _unitOfWork;
        public CabinetController(ILogger<CabinetController> logger, UnitOfWork unitOfWork, HttpHelper httpHelper)
        {
            _httpHelper = httpHelper;
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }
        public List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();
        //递归取数据
        private List<BaseJpOrganization> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }

        /// <summary>
        /// 获取EPC信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "cabinetNum": "柜号",
        ///            "RFIDList": [{
        ///            
        ///               }] }
        ///            
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetEpcInfo")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetEpcInfo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string cabinetNum = entity?.cabinetNum ?? "";
                        string childNum = entity?.childNum ?? "";
                        List<string> Rfids = new List<string>();
                        var param = new string[] {
                        "Cabinet",
                        "EquipmentCodeNavigation",
                        "EquipmentSizecodeNavigation"
                    };
                        if (entity.RFIDList != null)
                        {
                            foreach (var item in entity.RFIDList)
                            {
                                //string rfidItem = item;
                                if (!string.IsNullOrEmpty(item))
                                {
                                    //var rfidLeft = item.PadLeft(48, '0');
                                    var rfidLeft = item;//对方EPC格式有问题，更正后开启
                                    Rfids.Add(rfidLeft);//上报的RFID
                                }

                            }
                        }
                        Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.Id != null;
                        expression = LambdaExtensions.And(expression, t => t.Cabinet.CabinetRealNum.Equals(cabinetNum));


                        var Equipments = _unitOfWork.EquipmentInventoryRepository.GetList(expression, null, false, param);
                        var epcDetail = new Dictionary<string, string>();
                        foreach (var item in Rfids)
                        {
                            var invInfo = Equipments.Where(p => p.Epc.Equals(item)).FirstOrDefault();
                            if (invInfo != null)
                            {
                                epcDetail.Add(item, invInfo.EquipmentCodeNavigation?.Name + "-" + invInfo.EquipmentSizecodeNavigation?.SizeName);
                            }

                        }


                        return JsonManager.ReturnSuccessResponse(epcDetail);






                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 删除单警柜整柜
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "currentCabinetNum": "当前柜号",
        ///            
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteCabinet")]
        public async Task<HttpResponseMessage> DeleteCabinet([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string currentCabinetNum = entity?.currentCabinetNum ?? "";
                        var param = new string[] {
                        "Cabinet",
                    };
                        if (string.IsNullOrEmpty(currentCabinetNum))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }


                        var cabinets = _unitOfWork.CabinetRepository.GetList(p => p.CabinetRealNum.Equals(currentCabinetNum)).ToList();
                        if (cabinets.Count() > 0)
                        {
                            List<BaseJpPoliceman> polices = new List<BaseJpPoliceman>();

                            List<CommonJpEquipmentState> deleteStateList = new List<CommonJpEquipmentState>();
                            List<CommonJpEquipmentInventory> updateInvs = new List<CommonJpEquipmentInventory>();
                            foreach (var item in cabinets)
                            {
                                var deleteState = _unitOfWork.EquipmentStateRepository.GetList(p => p.CabinetIdInto.Equals(item.Id) || p.CabinetIdOut.Equals(item.Id)).ToList();
                                deleteStateList.AddRange(deleteState);
                                var updateInv = _unitOfWork.EquipmentInventoryRepository.GetList(p => p.CabinetId.Equals(item.Id)).ToList();
                                if (updateInv.Count > 0)
                                {
                                    var innerInv = updateInv.Where(x => x.CurrentState == 3).ToList();
                                    if (innerInv.Count > 0)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.CABINET_INVENTORY_EXIST);
                                    }
                                    var outInv = updateInv.Where(x => x.CurrentState == 7).ToList();
                                    foreach (var Inv in outInv)
                                    {
                                        Inv.CabinetId = null;
                                        updateInvs.Add(Inv);
                                    }
                                }

                            }

                            using (var scope = _unitOfWork.BeginTransaction())
                            {
                                try
                                {
                                    _unitOfWork.EquipmentStateRepository.Delete(deleteStateList, false);
                                    _unitOfWork.EquipmentInventoryRepository.Update(updateInvs, false);
                                    cabinets = _unitOfWork.CabinetRepository.GetList(p => p.CabinetRealNum.Equals(currentCabinetNum)).ToList();
                                    var policesInfos = _unitOfWork.PolicemanRepository.GetList(p => p.Cabinet.CabinetRealNum.Equals(currentCabinetNum), null, false, param);
                                    if (policesInfos.Count() > 0)
                                    {
                                        foreach (var item in policesInfos)
                                        {
                                            item.CabinetId = null;
                                            polices.Add(item);
                                        }
                                    }
                                    bool result = false;
                                    if (polices.Count() > 0)
                                    {
                                        _unitOfWork.PolicemanRepository.Update(polices, false);
                                        result = _unitOfWork.CabinetRepository.Delete(cabinets, true);
                                    }
                                    else
                                    {
                                        result = _unitOfWork.CabinetRepository.Delete(cabinets, true);
                                    }

                                    if (result)
                                    {
                                        if (updateInvs.Count > 0)
                                        {
                                            var httpResult = _httpHelper.GetHtml(new HttpItem()
                                            {
                                                URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                                Encoding = Encoding.UTF8,
                                                Method = "POST",
                                                ContentType = "application/json",
                                                Timeout = 5000,
                                                Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                                {
                                                    data = updateInvs.Select(x => new
                                                    {
                                                        editType = "UPDATE",
                                                        id = x.Id,
                                                        supplierCode = x.SupplierCode,
                                                        epc = x.Epc,
                                                        policeCode = x.PoliceCode,
                                                        equipmentCode = x.EquipmentCode,
                                                        warehouseCode = x.WarehouseCode,
                                                        cabinetId = x.CabinetId,
                                                        equipmentSizecode = x.EquipmentSizecode,
                                                        equipmentLocation = x.EquipmentLocation,
                                                        currentState = x.CurrentState,
                                                        createTime = x.CreateTime,
                                                        warrantyCycle = x.WarrantyCycle,
                                                        repairCycle = x.RepairCycle,
                                                        productTime = x.ProductTime,
                                                        useTime = x.UseTime,
                                                        price = x.Price,
                                                        isBorrowed = x.IsBorrowed,
                                                        lostFlag = x.LostFlag,
                                                        inventoryState = x.InventoryState,
                                                        isInBox = x.IsInBox,
                                                        boxMarkId = x.BoxMarkId,
                                                        instantiationState = x.InstantiationState,
                                                    })
                                                }))
                                            });
                                            if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("远端上报数据失败");
                                            }
                                            var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                            if (obj.code != "10000")
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse(obj.msg);
                                            }
                                        }
                                        scope.Commit();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                    }
                                }
                                catch (Exception e)
                                {
                                    scope.Rollback();
                                    throw;
                                }
                            }
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.CABINET_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 替换单警柜柜号
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "currentCabinetNum": "当前柜号",
        ///            "replaceCabinetNum": "替换的单警柜编号"
        ///            
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ReplaceCabinet")]
        public async Task<HttpResponseMessage> ReplaceCabinet([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string currentCabinetNum = entity?.currentCabinetNum ?? "";
                        string replaceCabinetNum = entity?.replaceCabinetNum ?? "";

                        if (string.IsNullOrEmpty(currentCabinetNum) || string.IsNullOrEmpty(replaceCabinetNum))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        var existCabinet = _unitOfWork.CabinetRepository.Get(p => p
                         .CabinetRealNum.Equals(replaceCabinetNum));

                        if (existCabinet != null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.CABINET_SET_ERROR);
                        }
                        var Equipments = _unitOfWork.CabinetRepository.GetList(p => p.CabinetRealNum.Equals(currentCabinetNum));
                        if (Equipments.Count() > 0)
                        {
                            var first = Equipments.First();
                            var oldCabinetRealNum = first.CabinetRealNum;
                            List<BaseJpCabinet> Cabinets = new List<BaseJpCabinet>();
                            foreach (var item in Equipments)
                            {
                                item.CabinetRealNum = replaceCabinetNum;
                                Cabinets.Add(item);
                            }

                            using (var transaction = _unitOfWork.DbContext.Database.BeginTransaction())
                            {
                                var res = _unitOfWork.CabinetRepository.Update(Cabinets);
                                if (res)
                                {
                                    if (first.Type == 1 || first.Type == 2)  //1:值班柜   2:公共柜
                                    {
                                        //更新出入库数据
                                        _unitOfWork.DbContext.BaseJpCabinetOutinlogs
                                            .Where(x => x.DeviceNo == oldCabinetRealNum)
                                            .UpdateFromQuery(x => new BaseJpCabinetOutinlog { DeviceNo = replaceCabinetNum });
                                        //更新操作数据
                                        _unitOfWork.DbContext.BaseJpCabinetWorklogs
                                            .Where(x => x.DeviceNo == oldCabinetRealNum)
                                            .UpdateFromQuery(x => new BaseJpCabinetWorklog { DeviceNo = replaceCabinetNum });

                                    }
                                    transaction.Commit();
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    transaction.Rollback();
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                }
                            }
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.CABINET_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 替换单警柜柜号
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "currentCabinetNum": "当前柜号",
        ///            "cabinetNum": "更新柜名"
        ///            
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ReplaceCabinetNum")]
        public async Task<HttpResponseMessage> ReplaceCabinetNum([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string currentCabinetNum = entity?.currentCabinetNum ?? "";
                        string cabinetNum = entity?.cabinetNum ?? "";

                        if (string.IsNullOrEmpty(currentCabinetNum) || string.IsNullOrEmpty(cabinetNum))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        var Equipments = _unitOfWork.CabinetRepository.GetList(p => p.CabinetRealNum.Equals(currentCabinetNum));
                        if (Equipments.Count() > 0)
                        {
                            List<BaseJpCabinet> Cabinets = new List<BaseJpCabinet>();
                            foreach (var item in Equipments)
                            {
                                item.CabinetNum = cabinetNum;
                                Cabinets.Add(item);
                            }

                            if (_unitOfWork.CabinetRepository.Update(Cabinets))
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                            }
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.CABINET_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 盘点库存
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "cabinetNum": "柜号",
        ///            "childNum":"",
        ///            "type":"归类方式",//0:产品,1号型,供应商
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("InventoryCabinet")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> InventoryCabinet([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string orgId = entity?.orgId ?? "";
                        string cabinetNum = entity?.cabinetNum ?? "";
                        string childNum = entity?.childNum ?? "";
                        string type = entity?.type ?? "";
                        var param = new string[] {
                        "Cabinet",
                        "Cabinet.BaseJpPolicemen",
                       "EquipmentCodeNavigation",
                       "EquipmentSizecodeNavigation",
                       "SupplierCodeNavigation",
                       "PoliceCodeNavigation"
                    };
                        Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.Id != null;


                        expression = LambdaExtensions.And(expression, t => t.Cabinet.CabinetRealNum.Equals(cabinetNum) && t.CurrentState.Equals(3));

                        if (!String.IsNullOrEmpty(childNum))
                        {

                            expression = LambdaExtensions.And(expression, t => t.Cabinet.CabinetChildNum.Equals(Convert.ToInt32(childNum)));
                        }
                        var Equipments = _unitOfWork.EquipmentInventoryRepository.GetList(expression, p => p.Cabinet.CabinetChildNum, false, param).OrderBy(p => p.Cabinet.CabinetChildNum).ToList();
                        var countEq = Equipments.Count();
                        if (type.Equals("0"))//根据产品名称排序
                        {
                            var equipList = Equipments.Select(p => new
                            {
                                detailName = p.EquipmentCodeNavigation?.Name,
                                p.EquipmentSizecodeNavigation?.SizeName,
                                supplierName = p.SupplierCodeNavigation?.Name,
                                policeName = p.Cabinet?.BaseJpPolicemen?.FirstOrDefault()?.Name,
                                p.Cabinet?.CabinetNum,
                                p.Cabinet?.CabinetChildNum,
                                p.Cabinet?.CabinetRealNum,
                            }).GroupBy(t => new { t.detailName, t.CabinetChildNum }
                        ).Select(z => new
                        {
                            count = z.Count(),
                            z.FirstOrDefault().detailName,
                            z.FirstOrDefault().SizeName,
                            z.FirstOrDefault().supplierName,
                            z.FirstOrDefault().policeName,
                            z.FirstOrDefault().CabinetChildNum,
                            z.FirstOrDefault().CabinetNum,
                            z.FirstOrDefault().CabinetRealNum
                        });
                            var content = new
                            {
                                totalCount = countEq,
                                totalElements = equipList.Count(),
                                content = equipList
                            };
                            return JsonManager.ReturnSuccessResponse(content);
                        }
                        else if (type.Equals("1"))//根据产品号型排序
                        {
                            var equipList = Equipments.Select(p => new
                            {
                                detailName = p.EquipmentCodeNavigation?.Name,
                                p.EquipmentSizecodeNavigation?.SizeName,
                                supplierName = p.SupplierCodeNavigation?.Name,
                                policeName = p.Cabinet?.BaseJpPolicemen?.FirstOrDefault()?.Name,
                                p.Cabinet?.CabinetNum,
                                p.Cabinet?.CabinetChildNum,
                                p.Cabinet?.CabinetRealNum,
                            }).GroupBy(t => new { t.detailName, t.SizeName, t.CabinetChildNum }).Select(z => new
                            {
                                count = z.Count(),
                                z.FirstOrDefault().detailName,
                                z.FirstOrDefault().SizeName,
                                z.FirstOrDefault().supplierName,
                                z.FirstOrDefault().policeName,
                                z.FirstOrDefault().CabinetChildNum,
                                z.FirstOrDefault().CabinetNum,
                                z.FirstOrDefault().CabinetRealNum
                            });
                            var content = new
                            {
                                totalCount = countEq,
                                totalElements = equipList.Count(),
                                content = equipList
                            };
                            return JsonManager.ReturnSuccessResponse(content);
                        }
                        else if (type.Equals("2"))//根据产品供应商排序
                        {
                            var equipList = Equipments.Select(p => new
                            {
                                detailName = p.EquipmentCodeNavigation?.Name,
                                p.EquipmentSizecodeNavigation?.SizeName,
                                supplierName = p.SupplierCodeNavigation?.Name,
                                policeName = p.Cabinet?.BaseJpPolicemen?.FirstOrDefault()?.Name,
                                p.Cabinet?.CabinetNum,
                                p.Cabinet?.CabinetChildNum,
                                p.Cabinet?.CabinetRealNum,
                            }).GroupBy(t => new { t.detailName, t.supplierName, t.CabinetChildNum }).Select(z => new
                            {
                                count = z.Count(),
                                z.FirstOrDefault().detailName,
                                z.FirstOrDefault().SizeName,
                                z.FirstOrDefault().supplierName,
                                z.FirstOrDefault().policeName,
                                z.FirstOrDefault().CabinetChildNum,
                                z.FirstOrDefault().CabinetNum,
                                z.FirstOrDefault().CabinetRealNum
                            });
                            var content = new
                            {
                                totalCount = countEq,
                                totalElements = equipList.Count(),
                                content = equipList
                            };
                            return JsonManager.ReturnSuccessResponse(content);
                        }
                        else
                        {
                            var equipList = Equipments.Select(p => new
                            {
                                detailName = p.EquipmentCodeNavigation?.Name,
                                p.EquipmentSizecodeNavigation?.SizeName,
                                supplierName = p.SupplierCodeNavigation?.Name,
                                policeName = p.Cabinet?.BaseJpPolicemen?.FirstOrDefault()?.Name,
                                p.Cabinet?.CabinetNum,
                                p.Cabinet?.CabinetChildNum,
                                p.Cabinet?.CabinetRealNum,
                            }).GroupBy(x => x.CabinetChildNum).Select(z => new
                            {
                                count = z.Count(),
                                z.FirstOrDefault().detailName,
                                z.FirstOrDefault().SizeName,
                                z.FirstOrDefault().supplierName,
                                z.FirstOrDefault().policeName,
                                z.FirstOrDefault().CabinetChildNum,
                                z.FirstOrDefault().CabinetNum,
                                z.FirstOrDefault().CabinetRealNum
                            });
                            var content = new
                            {
                                totalCount = countEq,
                                totalElements = equipList.Count(),
                                content = equipList
                            };
                            return JsonManager.ReturnSuccessResponse(content);

                        }






                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 盘点库存
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "orgId": "组织机构代码",
        ///            "cabinetNum": "柜号",
        ///            "childNum":"箱号",
        ///            "type":"归类方式",//0:产品,1号型,供应商
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("Inventory")]
        public async Task<HttpResponseMessage> Inventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string orgId = entity?.orgId ?? "";
                        string cabinetNum = entity?.cabinetNum ?? "";
                        string childNum = entity?.childNum ?? "";
                        string type = entity?.type ?? "";
                        var param = new string[] {
                        "Cabinet",
                       "EquipmentCodeNavigation",
                       "EquipmentSizecodeNavigation",
                       "SupplierCodeNavigation",
                       "PoliceCodeNavigation"
                    };
                        Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.Cabinet.Organization.Id.Equals(orgId) && t.CurrentState.Equals(3);

                        if (!String.IsNullOrEmpty(cabinetNum))
                        {

                            expression = LambdaExtensions.And(expression, t => t.Cabinet.CabinetNum.Equals(cabinetNum));
                        }
                        if (!String.IsNullOrEmpty(childNum))
                        {

                            expression = LambdaExtensions.And(expression, t => t.Cabinet.CabinetChildNum.Equals(Convert.ToInt32(childNum)));
                        }
                        var Equipments = _unitOfWork.EquipmentInventoryRepository.GetList(expression, p => p.CreateTime, false, param).ToList();
                        if (type.Equals("0"))//根据产品名称排序
                        {
                            var equipList = Equipments.Select(p => new
                            {
                                cabinetName = p.Cabinet?.CabinetNum + "-" + p.Cabinet?.CabinetChildNum,
                                detailName = p.EquipmentCodeNavigation?.Name,
                                p.EquipmentSizecodeNavigation?.SizeName,
                                supplierName = p.SupplierCodeNavigation?.Name,
                                policeName = p.PoliceCodeNavigation?.Name
                            }).GroupBy(x => x.detailName).Select(z => new
                            {
                                count = z.Count(),
                                z.FirstOrDefault().cabinetName,
                                z.FirstOrDefault().detailName,
                                z.FirstOrDefault().SizeName,
                                z.FirstOrDefault().supplierName,
                                z.FirstOrDefault().policeName
                            });
                            var content = new
                            {
                                totalElements = equipList.Count(),
                                content = equipList
                            };
                            return JsonManager.ReturnSuccessResponse(content);
                        }
                        else if (type.Equals("1"))//根据产品号型排序
                        {
                            var equipList = Equipments.Select(p => new
                            {
                                cabinetName = p.Cabinet?.CabinetNum + "-" + p.Cabinet?.CabinetChildNum,
                                detailName = p.EquipmentCodeNavigation?.Name,
                                p.EquipmentSizecodeNavigation?.SizeName,
                                supplierName = p.SupplierCodeNavigation?.Name,
                                policeName = p.PoliceCodeNavigation?.Name
                            }).GroupBy(t => new { t.detailName, t.SizeName }).Select(z => new
                            {
                                count = z.Count(),
                                z.FirstOrDefault().cabinetName,
                                z.FirstOrDefault().detailName,
                                z.FirstOrDefault().SizeName,
                                z.FirstOrDefault().supplierName,
                                z.FirstOrDefault().policeName
                            });
                            var content = new
                            {
                                totalElements = equipList.Count(),
                                content = equipList
                            };
                            return JsonManager.ReturnSuccessResponse(content);
                        }
                        else if (type.Equals("2"))//根据产品供应商排序
                        {
                            var equipList = Equipments.Select(p => new
                            {
                                cabinetName = p.Cabinet?.CabinetNum + "-" + p.Cabinet?.CabinetChildNum,
                                detailName = p.EquipmentCodeNavigation?.Name,
                                p.EquipmentSizecodeNavigation?.SizeName,
                                supplierName = p.SupplierCodeNavigation?.Name,
                                policeName = p.PoliceCodeNavigation?.Name
                            }).GroupBy(t => new { t.detailName, t.supplierName }).Select(z => new
                            {
                                count = z.Count(),
                                z.FirstOrDefault().cabinetName,
                                z.FirstOrDefault().detailName,
                                z.FirstOrDefault().SizeName,
                                z.FirstOrDefault().supplierName,
                                z.FirstOrDefault().policeName
                            });
                            var content = new
                            {
                                totalElements = equipList.Count(),
                                content = equipList
                            };
                            return JsonManager.ReturnSuccessResponse(content);
                        }
                        else
                        {
                            var equipList = Equipments.Select(p => new
                            {
                                cabinetName = p.Cabinet?.CabinetNum + "-" + p.Cabinet?.CabinetChildNum,
                                //count = Equipments.Count(),
                                detailName = p.EquipmentCodeNavigation?.Name,
                                p.EquipmentSizecodeNavigation?.SizeName,
                                supplierName = p.SupplierCodeNavigation?.Name,
                                policeName = p.PoliceCodeNavigation?.Name
                            });

                            var content = new
                            {
                                totalElements = equipList.Count(),
                                content = equipList
                            };
                            return JsonManager.ReturnSuccessResponse(content);
                        }






                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取警员绑定的单警柜物资信息
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetBindEqu")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetBindEqu([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse("invalid id");
                        }
                        else
                        {
                            string[] param = new string[] {
                        "Cabinet",
                        "Cabinet.CommonJpEquipmentInventories",
                        "Cabinet.CommonJpEquipmentInventories.EquipmentCodeNavigation",
                        "Cabinet.CommonJpEquipmentInventories.EquipmentSizecodeNavigation"
                    };
                            var cab = _unitOfWork.DbContext.BaseJpPolicemen
                            .Include("CommonJpEquipmentInventories")
                                .Include("Cabinet")
                                .Include("Cabinet.CommonJpEquipmentInventories")
                                .Include("Cabinet.CommonJpEquipmentInventories.EquipmentCodeNavigation")
                                .Include("Cabinet.CommonJpEquipmentInventories.EquipmentSizecodeNavigation")
                                .FirstOrDefault(t => t.Id == id);
                            if (cab == null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.POLICE_ERROR);
                            }
                            else
                            {
                                var data = new
                                {
                                    cabinetChildNum = cab.Cabinet?.CabinetChildNum,
                                    cabinetRealNum = cab.Cabinet?.CabinetRealNum,
                                    instoreNum = cab.Cabinet?.CommonJpEquipmentInventories?.Where(s => s.CurrentState == 3).Count() ?? 0,
                                    equList = cab.Cabinet?.CommonJpEquipmentInventories?.Select(s => new
                                    {
                                        id = s.Id,
                                        name = s.EquipmentCodeNavigation?.Name,
                                        size = s.EquipmentSizecodeNavigation?.SizeName,
                                        stateCode = s.CurrentState,
                                        epc = s.Epc
                                    }).ToList()
                                };
                                return JsonManager.ReturnSuccessResponse(data);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse("invalid parameter");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// Rfid数据上报第三方
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "cabinetID": "0320200512000808",
        ///            "cabinetChildID": "1",
        ///            "RFIDList": [{
        ///            "RFID": "A12C621596CDF8A02B18538A"
        ///           	},{
        ///           	"RFID": "A12C6215BCE9F863C2896E0A"
        ///            },{
        ///           "RFID": "A12C6215BCE9F863C284DF0A"
        ///            }] }
        ///           
        ///     
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UploadUserRFID")]
        public async Task<HttpResponseMessage> UploadUserRFID([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        _logger.LogDebug("Cabinet/Rfid数据上报:" + jdata.ToString());
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetID ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetID is require");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetChildID ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetChildID is require");
                        }


                        string time = entity.time;
                        string cabinetID = entity.cabinetID;
                        string cabinetChildID = entity.cabinetChildID;

                        Expression<Func<BaseJpCabinet, bool>> cabinetExpression = t => t.CabinetRealNum == cabinetID && t.CabinetChildNum == Convert.ToInt32(cabinetChildID);

                        var cabinet = _unitOfWork.CabinetRepository.Get(t => t.CabinetRealNum.Equals(cabinetID) && t.CabinetChildNum == Convert.ToInt32(cabinetChildID));
                        Expression<Func<BaseJpPoliceman, bool>> policeExpression = t => t.CabinetId == cabinet.Id;
                        BaseJpPoliceman policeman = new BaseJpPoliceman();
                        if (cabinet != null)
                        {
                            policeman = _unitOfWork.PolicemanRepository.Get(policeExpression);
                        }
                        var param = new string[] {
                       "EquipmentCodeNavigation",
                       "EquipmentSizecodeNavigation"
                    };
                        var equipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6 && !string.IsNullOrEmpty(t.CabinetId) && t.CabinetId == cabinet.Id && t.CurrentState == 3, null, false, param);//单警柜的东西
                        var EpcEquipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6, null, false, param);
                        //var equipments = _unitOfWork.EquipmentInventoryRepository.GetPage(t => t.Cabinet.CabinetRealNum==cabinetID && t.Cabinet.CabinetChildNum==cabinetChildID,"Sort",0,1000).content;
                        #region 判断单警柜中存取逻辑

                        List<string> EpcList = equipments.Select(p => p.Epc).ToList();
                        List<string> EpcList2 = new List<string>();

                        EpcList2 = equipments.Select(p => p.Epc).ToList();


                        List<string> Rfids = new List<string>();
                        if (entity.RFIDList != null)
                        {
                            foreach (var item in entity.RFIDList)
                            {
                                //string rfidItem = item;
                                if (!string.IsNullOrEmpty(item))
                                {
                                    //var rfidLeft = item.PadLeft(48, '0');
                                    var rfidLeft = item;//对方EPC格式有问题，更正后开启
                                    Rfids.Add(rfidLeft);//上报的RFID
                                }

                            }
                        }

                        List<SendMsg> InvStates = new List<SendMsg>();
                        List<CommonJpEquipmentInventory> OutEpc = new List<CommonJpEquipmentInventory>();

                        List<CommonJpEquipmentState> InsertState = new List<CommonJpEquipmentState>();
                        CommonJpEquipmentInventory editEquipment = new CommonJpEquipmentInventory();
                        CommonJpEquipmentInventory editEpcEquipment = new CommonJpEquipmentInventory();
                        Expression<Func<BaseJpCabinet, bool>> expression = t => t.CabinetRealNum.Equals(cabinetID) && t.CabinetChildNum.Equals(int.Parse(cabinetChildID));

                        bool takeResult = false;
                        bool getResult = false;
                        string takeId = null;
                        string getId = null;
                        foreach (var epc in EpcList)
                        {
                            if (!Rfids.Contains(epc))
                            {
                                takeResult = true;
                                break;
                            }
                        }
                        if (takeResult)
                        {
                            takeResult = false;
                            takeId = Guid.NewGuid().ToString();
                            CommonJpEquipmentState history = new CommonJpEquipmentState
                            {
                                Id = takeId,
                                State = (int)EquipmentState.单警柜,
                                CabinetIdOut = cabinet.Id,
                                OutTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ActionState = 5,
                                OutInState = 0,
                                OrgId = cabinet.OrganizationId,
                                PoliceId = policeman != null ? policeman.Id : null
                            };
                            InsertState.Add(history);
                        }
                        foreach (var epc in EpcList)//找出被拿走的PEC物资
                        {

                            if (!Rfids.Contains(epc))
                            {

                                editEquipment = equipments.Where(p => p.Epc.Contains(epc)).FirstOrDefault();
                                editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜出库中;
                                editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.外出;
                                editEquipment.PoliceCode = policeman != null ? policeman.Id : null;
                                editEquipment.CabinetId = cabinet.Id;
                                //editEquipment.PoliceCode = null;
                                CommonJpEquipmentState history = new CommonJpEquipmentState
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    EqiupmentId = editEquipment.Id,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdOut = cabinet.Id,
                                    OutTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 0,
                                    OrgId = cabinet.OrganizationId,
                                    ParentId = takeId,
                                    PoliceId = policeman != null ? policeman.Id : null
                                };
                                SendMsg equipmentDic = new SendMsg();
                                equipmentDic.EPC = epc;
                                equipmentDic.State = "out";
                                equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                equipmentDic.Time = time;
                                equipmentDic.BoxNum = cabinet.CabinetChildNum.ToString();
                                equipmentDic.UserName = policeman?.Name;
                                InvStates.Add(equipmentDic);
                                InsertState.Add(history);
                                OutEpc.Add(editEquipment);

                            }
                        }

                        foreach (var rfid in Rfids)
                        {
                            if (!EpcList2.Contains(rfid.ToString()))
                            {
                                editEpcEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                if (editEpcEquipment == null)
                                {
                                    continue;
                                }
                                getResult = true;
                                break;
                            }
                        }
                        if (getResult)
                        {
                            getResult = false;
                            getId = Guid.NewGuid().ToString();
                            CommonJpEquipmentState history = new CommonJpEquipmentState
                            {
                                Id = getId,
                                State = (int)EquipmentState.单警柜,
                                CabinetIdInto = cabinet.Id,
                                IntoTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ActionState = 5,
                                OutInState = 1,
                                OrgId = cabinet.OrganizationId,
                                PoliceId = policeman != null ? policeman.Id : null
                            };
                            InsertState.Add(history);
                        }

                        foreach (var rfid in Rfids)//找出当前存放的EPC物资
                        {
                            if (!EpcList2.Contains(rfid.ToString()))
                            {
                                var CabinetVal = _unitOfWork.CabinetRepository.Get(expression);
                                string Cabinet = string.Empty;
                                if (CabinetVal != null)
                                {
                                    Cabinet = CabinetVal.Id;
                                }

                                editEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                if (editEquipment == null)
                                {
                                    continue;
                                }

                                editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜中;
                                editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.单警柜;
                                editEquipment.PoliceCode = policeman != null ? policeman.Id : null;
                                editEquipment.CabinetId = Cabinet;
                                OutEpc.Add(editEquipment);

                                CommonJpEquipmentState Insert = new CommonJpEquipmentState()
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    EqiupmentId = editEquipment.Id,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdInto = cabinet.Id,
                                    IntoTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 1,
                                    OrgId = cabinet.OrganizationId,
                                    ParentId = getId,
                                    PoliceId = policeman != null ? policeman.Id : null

                                };
                                InsertState.Add(Insert);

                                SendMsg equipmentDic = new SendMsg();
                                equipmentDic.EPC = rfid;
                                equipmentDic.State = "in";
                                equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                equipmentDic.Time = time;
                                equipmentDic.BoxNum = cabinet.CabinetChildNum.ToString();
                                equipmentDic.UserName = policeman?.Name;
                                InvStates.Add(equipmentDic);


                            }
                        }

                        using (var scope = _unitOfWork.BeginTransaction())
                        {
                            try
                            {
                                if (OutEpc.Count > 0)
                                {
                                    _unitOfWork.EquipmentInventoryRepository.Update(OutEpc, false);//更新被拿走的物资信息
                                }
                                if (InsertState.Count > 0)
                                {
                                    _unitOfWork.EquipmentStateRepository.Insert(InsertState, false);
                                }

                                if (_unitOfWork.SaveChanges() > 0)
                                {
                                    //上报数据
                                    var httpResult = _httpHelper.GetHtml(new HttpItem()
                                    {
                                        URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                        Encoding = Encoding.UTF8,
                                        Method = "POST",
                                        ContentType = "application/json",
                                        Timeout = 5000,
                                        Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                        {
                                            data = OutEpc.Select(x => new
                                            {
                                                editType = "UPDATE",
                                                id = x.Id,
                                                supplierCode = x.SupplierCode,
                                                epc = x.Epc,
                                                policeCode = x.PoliceCode,
                                                equipmentCode = x.EquipmentCode,
                                                warehouseCode = x.WarehouseCode,
                                                cabinetId = x.CabinetId,
                                                equipmentSizecode = x.EquipmentSizecode,
                                                equipmentLocation = x.EquipmentLocation,
                                                currentState = x.CurrentState,
                                                createTime = x.CreateTime,
                                                warrantyCycle = x.WarrantyCycle,
                                                repairCycle = x.RepairCycle,
                                                productTime = x.ProductTime,
                                                useTime = x.UseTime,
                                                price = x.Price,
                                                isBorrowed = x.IsBorrowed,
                                                lostFlag = x.LostFlag,
                                                inventoryState = x.InventoryState,
                                                isInBox = x.IsInBox,
                                                boxMarkId = x.BoxMarkId,
                                                instantiationState = x.InstantiationState,
                                            })
                                        }))
                                    });
                                    if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse("远端上报数据失败");
                                    }
                                    var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                    if (obj.code != "10000")
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse(obj.msg);
                                    }
                                    scope.Commit();
                                    return JsonManager.ReturnSuccessResponse(InvStates);
                                }
                                else
                                {
                                    scope.Rollback();
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            catch (Exception e)
                            {
                                scope.Rollback();
                                throw;
                            }
                        }
                        #endregion
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// Rfid数据上报
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "cabinetID": "0320200512000808",
        ///            "cabinetChildID": "1",
        ///            "RFIDList": [{
        ///            "RFID": "A12C621596CDF8A02B18538A"
        ///           	},{
        ///           	"RFID": "A12C6215BCE9F863C2896E0A"
        ///            },{
        ///           "RFID": "A12C6215BCE9F863C284DF0A"
        ///            }] 
        ///            }
        ///           
        ///     
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UploadRFIDDevelop")]
        //[NoSign]
        public async Task<HttpResponseMessage> UploadRFIDDevelop([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        _logger.LogDebug("Cabinet/Rfid数据上报:" + jdata.ToString());
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetID ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetID is require");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetChildID ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetChildID is require");
                        }


                        string time = entity.time;
                        string cabinetID = entity.cabinetID;
                        string cabinetChildID = entity.cabinetChildID;

                        Expression<Func<BaseJpCabinet, bool>> cabinetExpression = t => t.CabinetRealNum == cabinetID && t.CabinetChildNum == Convert.ToInt32(cabinetChildID);

                        var cabinet = _unitOfWork.CabinetRepository.Get(t => t.CabinetRealNum.Equals(cabinetID) && t.CabinetChildNum == Convert.ToInt32(cabinetChildID));
                        Expression<Func<BaseJpPoliceman, bool>> policeExpression = t => t.CabinetId == cabinet.Id;
                        BaseJpPoliceman policeman = new BaseJpPoliceman();
                        if (cabinet != null)
                        {
                            policeman = _unitOfWork.PolicemanRepository.Get(policeExpression);
                        }
                        var param = new string[] {
                       "EquipmentCodeNavigation",
                       "EquipmentSizecodeNavigation"
                    };
                        var equipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6 && !string.IsNullOrEmpty(t.CabinetId) && t.CabinetId == cabinet.Id && t.CurrentState == 3, null, false, param);//单警柜的东西
                        var EpcEquipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6 && (t.CurrentState == 7 || t.CurrentState == 8), null, false, param);
                        //var equipments = _unitOfWork.EquipmentInventoryRepository.GetPage(t => t.Cabinet.CabinetRealNum==cabinetID && t.Cabinet.CabinetChildNum==cabinetChildID,"Sort",0,1000).content;
                        #region 判断单警柜中存取逻辑

                        List<string> EpcList = equipments.Select(p => p.Epc).ToList();
                        List<string> EpcList2 = new List<string>();

                        EpcList2 = equipments.Select(p => p.Epc).ToList();


                        List<string> Rfids = new List<string>();
                        if (entity.RFIDList != null)
                        {
                            foreach (var item in entity.RFIDList)
                            {
                                //string rfidItem = item;
                                if (!string.IsNullOrEmpty(item))
                                {
                                    //var rfidLeft = item.PadLeft(48, '0');
                                    var rfidLeft = item;//对方EPC格式有问题，更正后开启
                                    Rfids.Add(rfidLeft);//上报的RFID
                                }

                            }
                        }

                        List<SendMsg> InvStates = new List<SendMsg>();
                        List<CommonJpEquipmentInventory> OutEpc = new List<CommonJpEquipmentInventory>();

                        List<CommonJpEquipmentState> InsertState = new List<CommonJpEquipmentState>();
                        CommonJpEquipmentInventory editEquipment = new CommonJpEquipmentInventory();
                        CommonJpEquipmentInventory editEpcEquipment = new CommonJpEquipmentInventory();
                        Expression<Func<BaseJpCabinet, bool>> expression = t => t.CabinetRealNum.Equals(cabinetID) && t.CabinetChildNum.Equals(int.Parse(cabinetChildID));

                        bool takeResult = false;
                        bool getResult = false;
                        string takeId = null;
                        string getId = null;
                        foreach (var epc in EpcList)
                        {
                            if (!Rfids.Contains(epc))
                            {
                                takeResult = true;
                                break;
                            }
                        }
                        if (takeResult)
                        {
                            takeResult = false;
                            takeId = Guid.NewGuid().ToString();
                            CommonJpEquipmentState history = new CommonJpEquipmentState
                            {
                                Id = takeId,
                                State = (int)EquipmentState.单警柜,
                                CabinetIdOut = cabinet.Id,
                                OutTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ActionState = 5,
                                OutInState = 0,
                                OrgId = cabinet.OrganizationId,
                                PoliceId = policeman != null ? policeman.Id : null
                            };
                            InsertState.Add(history);
                        }
                        foreach (var epc in EpcList)//找出被拿走的PEC物资
                        {

                            if (!Rfids.Contains(epc))
                            {

                                editEquipment = equipments.Where(p => p.Epc.Contains(epc)).FirstOrDefault();
                                editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜出库中;
                                editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.外出;
                                editEquipment.PoliceCode = policeman != null ? policeman.Id : null;
                                editEquipment.CabinetId = cabinet.Id;
                                //editEquipment.PoliceCode = null;
                                CommonJpEquipmentState history = new CommonJpEquipmentState
                                {
                                    HistorySafeLevel = editEquipment.SafeLevel,
                                    Id = Guid.NewGuid().ToString(),
                                    EqiupmentId = editEquipment.Id,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdOut = cabinet.Id,
                                    OutTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 0,
                                    OrgId = cabinet.OrganizationId,
                                    ParentId = takeId,
                                    PoliceId = policeman != null ? policeman.Id : null
                                };
                                SendMsg equipmentDic = new SendMsg();
                                equipmentDic.EPC = epc;
                                equipmentDic.State = "out";
                                equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                equipmentDic.Time = time;
                                equipmentDic.BoxNum = cabinet.CabinetChildNum.ToString();
                                equipmentDic.UserName = policeman?.Name;
                                InvStates.Add(equipmentDic);
                                InsertState.Add(history);
                                OutEpc.Add(editEquipment);

                            }
                        }

                        foreach (var rfid in Rfids)
                        {
                            if (!EpcList2.Contains(rfid.ToString()))
                            {
                                editEpcEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                if (editEpcEquipment == null)
                                {
                                    continue;
                                }
                                getResult = true;
                                break;
                            }
                        }
                        if (getResult)
                        {
                            getResult = false;
                            getId = Guid.NewGuid().ToString();
                            CommonJpEquipmentState history = new CommonJpEquipmentState
                            {
                                Id = getId,
                                State = (int)EquipmentState.单警柜,
                                CabinetIdInto = cabinet.Id,
                                IntoTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ActionState = 5,
                                OutInState = 1,
                                OrgId = cabinet.OrganizationId,
                                PoliceId = policeman != null ? policeman.Id : null
                            };
                            InsertState.Add(history);
                        }

                        foreach (var rfid in Rfids)//找出当前存放的EPC物资
                        {
                            if (!EpcList2.Contains(rfid.ToString()))
                            {
                                var CabinetVal = _unitOfWork.CabinetRepository.Get(expression);
                                string Cabinet = string.Empty;
                                if (CabinetVal != null)
                                {
                                    Cabinet = CabinetVal.Id;
                                }

                                editEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                if (editEquipment == null)
                                {
                                    continue;
                                }

                                editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜中;
                                editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.单警柜;
                                editEquipment.PoliceCode = policeman != null ? policeman.Id : null;
                                editEquipment.CabinetId = Cabinet;
                                OutEpc.Add(editEquipment);

                                CommonJpEquipmentState Insert = new CommonJpEquipmentState()
                                {
                                    HistorySafeLevel = editEquipment.SafeLevel,
                                    Id = Guid.NewGuid().ToString(),
                                    EqiupmentId = editEquipment.Id,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdInto = cabinet.Id,
                                    IntoTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 1,
                                    OrgId = cabinet.OrganizationId,
                                    ParentId = getId,
                                    PoliceId = policeman != null ? policeman.Id : null

                                };
                                InsertState.Add(Insert);

                                SendMsg equipmentDic = new SendMsg();
                                equipmentDic.EPC = rfid;
                                equipmentDic.State = "in";
                                equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                equipmentDic.Time = time;
                                equipmentDic.BoxNum = cabinet.CabinetChildNum.ToString();
                                equipmentDic.UserName = policeman?.Name;
                                InvStates.Add(equipmentDic);


                            }
                        }

                        using (var scope = _unitOfWork.BeginTransaction())
                        {
                            try
                            {
                                if (OutEpc.Count > 0)
                                {
                                    _unitOfWork.EquipmentInventoryRepository.Update(OutEpc, false);//更新被拿走的物资信息
                                }
                                if (InsertState.Count > 0)
                                {
                                    _unitOfWork.EquipmentStateRepository.Insert(InsertState, false);
                                }

                                var res = _unitOfWork.SaveChanges() > 0;
                                if (res)
                                {
                                    //上报数据
                                    var httpResult = _httpHelper.GetHtml(new HttpItem()
                                    {
                                        URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                        Encoding = Encoding.UTF8,
                                        Method = "POST",
                                        ContentType = "application/json",
                                        Timeout = 5000,
                                        Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                        {
                                            data = OutEpc.Select(x => new
                                            {
                                                editType = "UPDATE",
                                                id = x.Id,
                                                supplierCode = x.SupplierCode,
                                                epc = x.Epc,
                                                policeCode = x.PoliceCode,
                                                equipmentCode = x.EquipmentCode,
                                                warehouseCode = x.WarehouseCode,
                                                cabinetId = x.CabinetId,
                                                equipmentSizecode = x.EquipmentSizecode,
                                                equipmentLocation = x.EquipmentLocation,
                                                currentState = x.CurrentState,
                                                createTime = x.CreateTime,
                                                warrantyCycle = x.WarrantyCycle,
                                                repairCycle = x.RepairCycle,
                                                productTime = x.ProductTime,
                                                useTime = x.UseTime,
                                                price = x.Price,
                                                isBorrowed = x.IsBorrowed,
                                                lostFlag = x.LostFlag,
                                                inventoryState = x.InventoryState,
                                                isInBox = x.IsInBox,
                                                boxMarkId = x.BoxMarkId,
                                                instantiationState = x.InstantiationState,
                                            })
                                        }))
                                    });
                                    if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse("远端上报数据失败");
                                    }
                                    var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                    if (obj.code != "10000")
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse(obj.msg);
                                    }
                                }
                                scope.Commit();
                                return JsonManager.ReturnSuccessResponse(InvStates);
                            }
                            catch (Exception e)
                            {
                                scope.Rollback();
                                throw;
                            }
                        }
                        #endregion
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// Rfid数据上报
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "cabinetID": "0320200512000808",
        ///            "cabinetChildID": "1",
        ///            "RFIDList": [{
        ///            "RFID": "A12C621596CDF8A02B18538A"
        ///           	},{
        ///           	"RFID": "A12C6215BCE9F863C2896E0A"
        ///            },{
        ///           "RFID": "A12C6215BCE9F863C284DF0A"
        ///            }] }
        ///           
        ///     
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UploadRFID")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> UploadRFID([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        _logger.LogDebug("Cabinet/Rfid数据上报:" + jdata.ToString());
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetID ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetID is require");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetChildID ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetChildID is require");
                        }


                        string time = entity.time;
                        string cabinetID = entity.cabinetID;
                        string cabinetChildID = entity.cabinetChildID;

                        Expression<Func<BaseJpCabinet, bool>> cabinetExpression = t => t.CabinetRealNum == cabinetID && t.CabinetChildNum == Convert.ToInt32(cabinetChildID);

                        var cabinet = _unitOfWork.CabinetRepository.Get(t => t.CabinetRealNum.Equals(cabinetID) && t.CabinetChildNum == Convert.ToInt32(cabinetChildID));
                        Expression<Func<BaseJpPoliceman, bool>> policeExpression = t => t.CabinetId == cabinet.Id;
                        BaseJpPoliceman policeman = new BaseJpPoliceman();
                        if (cabinet != null)
                        {
                            policeman = _unitOfWork.PolicemanRepository.Get(policeExpression);
                        }
                        var param = new string[] {
                       "EquipmentCodeNavigation",
                       "EquipmentSizecodeNavigation"
                    };
                        var equipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6 && !string.IsNullOrEmpty(t.CabinetId) && t.CabinetId == cabinet.Id && t.CurrentState == 3, null, false, param);//单警柜的东西
                        var EpcEquipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6, null, false, param);
                        //var equipments = _unitOfWork.EquipmentInventoryRepository.GetPage(t => t.Cabinet.CabinetRealNum==cabinetID && t.Cabinet.CabinetChildNum==cabinetChildID,"Sort",0,1000).content;
                        #region 判断单警柜中存取逻辑

                        List<string> EpcList = equipments.Select(p => p.Epc).ToList();
                        List<string> EpcList2 = new List<string>();

                        EpcList2 = equipments.Select(p => p.Epc).ToList();


                        List<string> Rfids = new List<string>();
                        if (entity.RFIDList != null)
                        {
                            foreach (var item in entity.RFIDList)
                            {
                                //string rfidItem = item;
                                if (!string.IsNullOrEmpty(item))
                                {
                                    //var rfidLeft = item.PadLeft(48, '0');
                                    var rfidLeft = item;//对方EPC格式有问题，更正后开启
                                    Rfids.Add(rfidLeft);//上报的RFID
                                }

                            }
                        }

                        List<SendMsg> InvStates = new List<SendMsg>();
                        List<CommonJpEquipmentInventory> OutEpc = new List<CommonJpEquipmentInventory>();

                        List<CommonJpEquipmentState> InsertState = new List<CommonJpEquipmentState>();
                        CommonJpEquipmentInventory editEquipment = new CommonJpEquipmentInventory();
                        CommonJpEquipmentInventory editEpcEquipment = new CommonJpEquipmentInventory();
                        Expression<Func<BaseJpCabinet, bool>> expression = t => t.CabinetRealNum.Equals(cabinetID) && t.CabinetChildNum.Equals(int.Parse(cabinetChildID));

                        bool takeResult = false;
                        bool getResult = false;
                        string takeId = null;
                        string getId = null;
                        foreach (var epc in EpcList)
                        {
                            if (!Rfids.Contains(epc))
                            {
                                takeResult = true;
                                break;
                            }
                        }
                        if (takeResult)
                        {
                            takeResult = false;
                            takeId = Guid.NewGuid().ToString();
                            CommonJpEquipmentState history = new CommonJpEquipmentState
                            {
                                Id = takeId,
                                State = (int)EquipmentState.单警柜,
                                CabinetIdOut = cabinet.Id,
                                OutTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ActionState = 5,
                                OutInState = 0,
                                OrgId = cabinet.OrganizationId,
                                PoliceId = policeman != null ? policeman.Id : null
                            };
                            InsertState.Add(history);
                        }
                        foreach (var epc in EpcList)//找出被拿走的PEC物资
                        {

                            if (!Rfids.Contains(epc))
                            {

                                editEquipment = equipments.Where(p => p.Epc.Contains(epc)).FirstOrDefault();
                                editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜出库中;
                                editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.外出;
                                editEquipment.PoliceCode = policeman != null ? policeman.Id : null;
                                editEquipment.CabinetId = cabinet.Id;
                                //editEquipment.PoliceCode = null;
                                CommonJpEquipmentState history = new CommonJpEquipmentState
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    EqiupmentId = editEquipment.Id,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdOut = cabinet.Id,
                                    OutTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 0,
                                    OrgId = cabinet.OrganizationId,
                                    ParentId = takeId,
                                    PoliceId = policeman != null ? policeman.Id : null
                                };
                                SendMsg equipmentDic = new SendMsg();
                                equipmentDic.EPC = epc;
                                equipmentDic.State = "out";
                                equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                equipmentDic.Time = time;
                                equipmentDic.BoxNum = cabinet.CabinetChildNum.ToString();
                                equipmentDic.UserName = policeman?.Name;
                                InvStates.Add(equipmentDic);
                                InsertState.Add(history);
                                OutEpc.Add(editEquipment);

                            }
                        }

                        foreach (var rfid in Rfids)
                        {
                            if (!EpcList2.Contains(rfid.ToString()))
                            {
                                editEpcEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                if (editEpcEquipment == null)
                                {
                                    continue;
                                }
                                getResult = true;
                                break;
                            }
                        }
                        if (getResult)
                        {
                            getResult = false;
                            getId = Guid.NewGuid().ToString();
                            CommonJpEquipmentState history = new CommonJpEquipmentState
                            {
                                Id = getId,
                                State = (int)EquipmentState.单警柜,
                                CabinetIdInto = cabinet.Id,
                                IntoTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ActionState = 5,
                                OutInState = 1,
                                OrgId = cabinet.OrganizationId,
                                PoliceId = policeman != null ? policeman.Id : null
                            };
                            InsertState.Add(history);
                        }

                        foreach (var rfid in Rfids)//找出当前存放的EPC物资
                        {
                            if (!EpcList2.Contains(rfid.ToString()))
                            {
                                var CabinetVal = _unitOfWork.CabinetRepository.Get(expression);
                                string Cabinet = string.Empty;
                                if (CabinetVal != null)
                                {
                                    Cabinet = CabinetVal.Id;
                                }

                                editEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                if (editEquipment == null)
                                {
                                    continue;
                                }

                                editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜中;
                                editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.单警柜;
                                editEquipment.PoliceCode = policeman != null ? policeman.Id : null;
                                editEquipment.CabinetId = Cabinet;
                                OutEpc.Add(editEquipment);

                                CommonJpEquipmentState Insert = new CommonJpEquipmentState()
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    EqiupmentId = editEquipment.Id,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdInto = cabinet.Id,
                                    IntoTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 1,
                                    OrgId = cabinet.OrganizationId,
                                    ParentId = getId,
                                    PoliceId = policeman != null ? policeman.Id : null

                                };
                                InsertState.Add(Insert);

                                SendMsg equipmentDic = new SendMsg();
                                equipmentDic.EPC = rfid;
                                equipmentDic.State = "in";
                                equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                equipmentDic.Time = time;
                                equipmentDic.BoxNum = cabinet.CabinetChildNum.ToString();
                                equipmentDic.UserName = policeman?.Name;
                                InvStates.Add(equipmentDic);


                            }
                        }

                        using (var scope = _unitOfWork.BeginTransaction())
                        {
                            try
                            {
                                if (OutEpc.Count > 0)
                                {
                                    _unitOfWork.EquipmentInventoryRepository.Update(OutEpc, false);//更新被拿走的物资信息
                                }
                                if (InsertState.Count > 0)
                                {
                                    _unitOfWork.EquipmentStateRepository.Insert(InsertState, false);
                                }
                                if (_unitOfWork.SaveChanges() > 0)
                                {
                                    //上报数据
                                    var httpResult = _httpHelper.GetHtml(new HttpItem()
                                    {
                                        URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                        Encoding = Encoding.UTF8,
                                        Method = "POST",
                                        ContentType = "application/json",
                                        Timeout = 5000,
                                        Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                        {
                                            data = OutEpc.Select(x => new
                                            {
                                                editType = "UPDATE",
                                                id = x.Id,
                                                supplierCode = x.SupplierCode,
                                                epc = x.Epc,
                                                policeCode = x.PoliceCode,
                                                equipmentCode = x.EquipmentCode,
                                                warehouseCode = x.WarehouseCode,
                                                cabinetId = x.CabinetId,
                                                equipmentSizecode = x.EquipmentSizecode,
                                                equipmentLocation = x.EquipmentLocation,
                                                currentState = x.CurrentState,
                                                createTime = x.CreateTime,
                                                warrantyCycle = x.WarrantyCycle,
                                                repairCycle = x.RepairCycle,
                                                productTime = x.ProductTime,
                                                useTime = x.UseTime,
                                                price = x.Price,
                                                isBorrowed = x.IsBorrowed,
                                                lostFlag = x.LostFlag,
                                                inventoryState = x.InventoryState,
                                                isInBox = x.IsInBox,
                                                boxMarkId = x.BoxMarkId,
                                                instantiationState = x.InstantiationState,
                                            })
                                        }))
                                    });
                                    if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse("远端上报数据失败");
                                    }
                                    var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                    if (obj.code != "10000")
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse(obj.msg);
                                    }
                                    scope.Commit();
                                    return JsonManager.ReturnSuccessResponse(InvStates);
                                }
                                else
                                {
                                    scope.Rollback();
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            catch (Exception e)
                            {
                                scope.Rollback();
                                throw;
                            }
                        }
                        #endregion
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增值班柜出入库数据
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///	    "cabinetMainNo": "JPTM810BAE4C862C",
        ///	    "logList": [{
        ///		"boxNum": "2",
        ///     "state": "in",
        ///		"count": "1",
        ///		"name": "伸缩警棍-公安部基础型",
        ///		"photo": "",
        ///		"time": "2021/08/16 14:11:50",
        ///		"userName": "李老四",
        ///     "epc": ""
        ///    }
        ///}
        ///           
        ///     
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddInOutlog")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> AddInOutlog([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"cabinetMainNo is null");
                        }

                        string cabinetMainNo = entity.cabinetMainNo;
                        var cabinet = _unitOfWork.CabinetRepository.Get(x => x.CabinetRealNum == cabinetMainNo);
                        if (cabinet == null)
                        {
                            return JsonManager.SimpleCustResponse($"cabinet is null");
                        }
                        List<BaseJpCabinetOutinlog> logList = new List<BaseJpCabinetOutinlog>();
                        foreach (var item in entity.logList)
                        {
                            BaseJpCabinetOutinlog outinLog = new BaseJpCabinetOutinlog();
                            outinLog.DeviceNo = cabinetMainNo;
                            outinLog.BoxNum = item.boxNum;
                            outinLog.Id = Guid.NewGuid().ToString();
                            outinLog.Count = item.count;
                            outinLog.Epc = item.epc;
                            outinLog.Name = item.name;
                            outinLog.Photo = item.photo;
                            outinLog.UserName = item.userName;
                            outinLog.State = item.state;
                            outinLog.PushTime = DateTime.Now;
                            outinLog.OperationTime = Convert.ToDateTime(item.time);
                            outinLog.OrganizationId = cabinet.OrganizationId;
                            logList.Add(outinLog);
                        }
                        bool result = false;
                        if (logList.Count > 0)
                        {
                            result = _unitOfWork.CabineOutInlogRepository.Insert(logList);
                        }
                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取值班柜出入库数据
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///	    "type": 1:值班柜   2:公共柜,
        ///	    "cabinetMainNo": "JPTM810BAE4C862C",
        ///	    "state": "in out",
        ///     "organizationId":"organizationId",
        ///     "actionUserName":"操作用户名",
        ///     "deviceNo":"实际柜号",
        ///     "boxNum":"箱号",
        ///    }
        ///           
        ///     
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetInOutlog")]
        public async Task<HttpResponseMessage> GetInOutlog([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"entity is null");
                        }
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpCabinetOutinlog, bool>> query = x => !string.IsNullOrEmpty(x.State);
                        string organizationId = entity.organizationId;
                        if (string.IsNullOrEmpty(organizationId))
                        {
                            return JsonManager.SimpleCustResponse($"organizationId is require");
                        }
                        else
                        {
                            query = query.AndAlso(x => x.OrganizationId == organizationId);
                        }

                        var b_type = int.TryParse(entity.type, out int type);
                        string cabinetMainNo = entity.cabinetMainNo;
                        string state = entity.state;
                        string actionUserName = entity.actionUserName;
                        string deviceNo = entity.deviceNo;
                        string boxNum = entity.boxNum;

                        if (!string.IsNullOrEmpty(cabinetMainNo))
                        {
                            query = query.AndAlso(x => x.DeviceNo.Contains(cabinetMainNo));
                        }
                        if (!string.IsNullOrEmpty(state))
                        {
                            query = query.AndAlso(x => x.State == state);
                        }
                        else
                        {
                            query = query.AndAlso(x => x.State == "in" || x.State == "out");
                        }

                        if (b_type == false || (type != 1 && type != 2))
                        {
                            return JsonManager.SimpleCustResponse($"type is require");
                        }

                        if (!string.IsNullOrEmpty(actionUserName))
                        {
                            query = query.AndAlso(x => x.UserName == actionUserName);
                        }
                        if (!string.IsNullOrEmpty(deviceNo))
                        {
                            query = query.AndAlso(x => x.DeviceNo == deviceNo);
                            if (!string.IsNullOrEmpty(boxNum))
                            {
                                query = query.AndAlso(x => x.BoxNum == boxNum);
                            }
                        }

                        var include = new[]
                        {
                            "Organization"
                        };

                        var data = _unitOfWork.DbContext.BaseJpCabinetOutinlogs
                            .AsNoTracking()
                            .Include(x => x.Organization)
                            .Where(query)
                            .OrderByDescending(x => x.OperationTime)
                            .Join(
                                _unitOfWork.DbContext.BaseJpCabinets,
                                log => new { a = log.DeviceNo, b = log.BoxNum },
                                cabinet => new { a = cabinet.CabinetRealNum, b = cabinet.CabinetChildNum.ToString() },
                                (log, cabinet) => new
                                {
                                    pushTime = log.PushTime,
                                    operationTime = log.OperationTime,
                                    deviceNo = log.DeviceNo,
                                    boxNum = log.BoxNum,
                                    id = log.Id,
                                    count = log.Count,
                                    epc = log.Epc,
                                    name = log.Name,
                                    photo = log.Photo,
                                    userName = log.UserName,
                                    state = log.State,
                                    type = cabinet.Type,
                                    orgId = log.Organization.Id,
                                    orgName = log.Organization.Name
                                });

                        var list = data.Where(x => x.type == type);
                        return JsonManager.ReturnSuccessResponse(new
                        {
                            totalElements = list.Count(),
                            content = list.Skip(page * size).Take(size).ToList()
                        });
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增值班柜操作数据
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///	    "cabinetMainNo": "JPTM810BAE4C862C",
        ///	    "logList": [{
        ///		"date": "2021/08/17 13:22:43",
        ///		"id": 157,
        ///		"isDeal": "false",
        ///		"logInfo": "管理员登陆操作系统",
        ///		"name": "管理员",
        ///		"photo": "20210817/20210817132232.jpg",
        ///		"type": "operation"
        ///    }
        ///}
        ///           
        ///     
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddWorklog")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> AddWorklog([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"cabinetMainNo is null");
                        }

                        string cabinetMainNo = entity.cabinetMainNo;
                        List<BaseJpCabinetWorklog> logList = new List<BaseJpCabinetWorklog>();
                        foreach (var item in entity.logList)
                        {
                            BaseJpCabinetWorklog workLog = new BaseJpCabinetWorklog();
                            workLog.DeviceNo = cabinetMainNo;
                            workLog.Date = item.date;
                            workLog.Id = Guid.NewGuid().ToString();
                            workLog.IsDeal = item.isDeal;
                            workLog.LogInfo = item.logInfo;
                            workLog.Name = item.name;
                            workLog.Photo = item.photo;
                            workLog.Type = item.type;
                            logList.Add(workLog);
                        }
                        bool result = false;
                        if (logList.Count > 0)
                        {
                            result = _unitOfWork.CabinetWorklogRepository.Insert(logList);
                        }
                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// Rfid离线数据上报内部使用
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///     	"RFIDUpList": [{
        ///            "cabinetID": "0320200512000808",
        ///            "cabinetChildID": "1",
        ///            "time": "",
        ///            "RFIDList": [{
        ///            }] 
        ///            	}]
        ///            }
        ///           
        ///     
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UploadRFIDListInnerDevelop")]
        public async Task<HttpResponseMessage> UploadRFIDListInnerDevelop([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        _logger.LogDebug("Cabinet/UploadRFIDListInner离线数据上报:" + jdata.ToString());
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        List<OutLineRfid> RfidUpList = new List<OutLineRfid>();
                        if (entity.RFIDUpList != null)
                        {
                            foreach (var item in entity.RFIDUpList)
                            {
                                if (string.IsNullOrEmpty(item.time))
                                {
                                    return JsonManager.SimpleCustResponse($"time is null");
                                }
                                if (string.IsNullOrEmpty(item.cabinetID))
                                {
                                    return JsonManager.SimpleCustResponse($"cabinetID is null");
                                }
                                if (string.IsNullOrEmpty(item.cabinetChildID))
                                {
                                    return JsonManager.SimpleCustResponse($"cabinetChildID is null");
                                }
                                OutLineRfid outLine = new OutLineRfid();
                                outLine.time = item.time;
                                outLine.cabinetID = item.cabinetID;
                                outLine.cabinetChildID = item.cabinetChildID;
                                List<string> rfidList = new List<string>();
                                if (item.RFIDList != null)
                                {
                                    foreach (var rfids in item.RFIDList)
                                    {
                                        rfidList.Add(rfids);
                                    }
                                }
                                outLine.RFIDList = rfidList;
                                RfidUpList.Add(outLine);

                            }
                        }
                        RfidUpList = RfidUpList.OrderBy(p => p.time).ToList();
                        var param = new string[] {
                       "EquipmentCodeNavigation",
                       "EquipmentSizecodeNavigation"
                    };
                        List<CommonJpEquipmentInventory> OutEpc = new List<CommonJpEquipmentInventory>();
                        List<CommonJpEquipmentState> InsertState = new List<CommonJpEquipmentState>();
                        List<SendMsg> InvStates = new List<SendMsg>();

                        Expression<Func<BaseJpCabinet, bool>> cabinetExpression = t => t.CabinetRealNum == RfidUpList.FirstOrDefault().cabinetID;

                        var cabinetList = _unitOfWork.CabinetRepository.GetList(cabinetExpression).ToList();
                        var policeman = _unitOfWork.PolicemanRepository.GetList(p => p.OrgizationCode.Equals(cabinetList.FirstOrDefault().OrganizationId));//找出本次上报单警柜下组织机构中其他的警员信息

                        var equipmentList = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6 && !string.IsNullOrEmpty(t.CabinetId) && t.CurrentState == 3, null, false, param);//单警柜的东西
                        var EpcEquipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6 && (t.CurrentState == 7 || t.CurrentState == 8), null, false, param);
                        List<CommonJpEquipmentInventory> currentEquipments = new List<CommonJpEquipmentInventory>();
                        foreach (var item in RfidUpList)
                        {
                            string time = item.time;
                            string cabinetID = item.cabinetID;
                            string cabinetChildID = item.cabinetChildID;

                            var cabinet = cabinetList.Where(p => p.CabinetChildNum.Equals(int.Parse(item.cabinetChildID))).FirstOrDefault();


                            Expression<Func<BaseJpPoliceman, bool>> policeExpression = t => t.CabinetId == cabinet.Id;
                            BaseJpPoliceman police = new BaseJpPoliceman();
                            if (cabinet != null)
                            {
                                police = policeman.Where(p => !string.IsNullOrEmpty(p.CabinetId) && p.CabinetId.Equals(cabinet.Id)).FirstOrDefault();

                            }
                            var curEquipments = equipmentList.Where(p => p.CabinetId.Equals(cabinet.Id)).ToList();
                            currentEquipments.AddRange(curEquipments);
                            //var EpcEquipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc), null, false, param);
                            //var equipments = _unitOfWork.EquipmentInventoryRepository.GetPage(t => t.Cabinet.CabinetRealNum==cabinetID && t.Cabinet.CabinetChildNum==cabinetChildID,"Sort",0,1000).content;
                            #region 判断单警柜中存取逻辑

                            List<string> EpcList = currentEquipments.Select(p => p.Epc).ToList();
                            List<string> EpcList2 = new List<string>();

                            EpcList2 = currentEquipments.Select(p => p.Epc).ToList();


                            List<string> Rfids = new List<string>();
                            if (item.RFIDList != null)
                            {
                                foreach (var rfidItem in item.RFIDList)
                                {

                                    if (!string.IsNullOrEmpty(rfidItem))
                                    {
                                        Rfids.Add(rfidItem);//上报的RFID
                                    }

                                }
                            }




                            CommonJpEquipmentInventory editEpcEquipment = new CommonJpEquipmentInventory();
                            CommonJpEquipmentInventory editEquipment = new CommonJpEquipmentInventory();
                            Expression<Func<BaseJpCabinet, bool>> expression = t => t.CabinetRealNum.Equals(cabinetID) && t.CabinetChildNum.Equals(int.Parse(cabinetChildID));

                            bool takeResult = false;
                            bool getResult = false;
                            string takeId = null;
                            string getId = null;
                            foreach (var epc in EpcList)
                            {
                                if (!Rfids.Contains(epc))
                                {
                                    takeResult = true;
                                    break;
                                }
                            }
                            if (takeResult)
                            {
                                takeResult = false;
                                takeId = Guid.NewGuid().ToString();
                                CommonJpEquipmentState history = new CommonJpEquipmentState
                                {
                                    Id = takeId,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdOut = cabinet.Id,
                                    OutTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 0,
                                    OrgId = cabinet.OrganizationId,
                                    PoliceId = police != null ? police.Id : null
                                };
                                InsertState.Add(history);
                            }


                            foreach (var epc in EpcList)//找出被拿走的PEC物资
                            {

                                if (!Rfids.Contains(epc))
                                {

                                    editEquipment = currentEquipments.Where(p => p.Epc.Contains(epc)).FirstOrDefault();
                                    editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜出库中;
                                    editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.外出;
                                    editEquipment.PoliceCode = police != null ? police.Id : null;
                                    editEquipment.CabinetId = cabinet.Id;
                                    CommonJpEquipmentState history = new CommonJpEquipmentState
                                    {
                                        HistorySafeLevel = editEquipment.SafeLevel,
                                        Id = Guid.NewGuid().ToString(),
                                        EqiupmentId = editEquipment.Id,
                                        State = (int)EquipmentState.单警柜,
                                        CabinetIdOut = cabinet.Id,
                                        OutTime = Convert.ToDateTime(item.time),
                                        CreateTime = Convert.ToDateTime(item.time),
                                        ActionState = 5,
                                        OutInState = 0,
                                        OrgId = cabinet.OrganizationId,
                                        ParentId = takeId,
                                        PoliceId = police != null ? police.Id : null
                                    };
                                    SendMsg equipmentDic = new SendMsg();
                                    equipmentDic.EPC = epc;
                                    equipmentDic.State = "out";
                                    equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                    equipmentDic.Time = time;
                                    equipmentDic.BoxNum = cabinetChildID;
                                    equipmentDic.UserName = police?.Name;
                                    InvStates.Add(equipmentDic);
                                    InsertState.Add(history);
                                    OutEpc.Add(editEquipment);
                                    currentEquipments.Remove(editEquipment);
                                }
                            }
                            foreach (var rfid in Rfids)
                            {
                                if (!EpcList2.Contains(rfid.ToString()))
                                {
                                    editEpcEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                    if (editEpcEquipment == null)
                                    {
                                        continue;
                                    }
                                    getResult = true;
                                    break;
                                }
                            }
                            if (getResult)
                            {
                                getResult = false;
                                getId = Guid.NewGuid().ToString();
                                CommonJpEquipmentState history = new CommonJpEquipmentState
                                {
                                    Id = getId,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdInto = cabinet.Id,
                                    IntoTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 1,
                                    OrgId = cabinet.OrganizationId,
                                    PoliceId = police != null ? police.Id : null
                                };
                                InsertState.Add(history);
                            }
                            foreach (var rfid in Rfids)//找出当前存放的EPC物资
                            {
                                if (!EpcList2.Contains(rfid.ToString()))
                                {
                                    var CabinetVal = cabinetList.Where(t => t.CabinetRealNum.Equals(cabinetID) && t.CabinetChildNum.Equals(int.Parse(cabinetChildID))).FirstOrDefault();

                                    string Cabinet = string.Empty;
                                    if (CabinetVal != null)
                                    {
                                        Cabinet = CabinetVal.Id;
                                    }

                                    editEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                    if (editEquipment == null)
                                    {
                                        continue;
                                    }
                                    editEquipment.CabinetId = Cabinet;
                                    editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜中;
                                    editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.单警柜;
                                    editEquipment.PoliceCode = police != null ? police.Id : null;
                                    OutEpc.Add(editEquipment);

                                    CommonJpEquipmentState Insert = new CommonJpEquipmentState()
                                    {
                                        HistorySafeLevel = editEquipment.SafeLevel,
                                        Id = Guid.NewGuid().ToString(),
                                        EqiupmentId = editEquipment.Id,
                                        State = (int)EquipmentState.单警柜,
                                        CabinetIdInto = cabinet.Id,
                                        IntoTime = Convert.ToDateTime(item.time),
                                        CreateTime = Convert.ToDateTime(item.time),
                                        ActionState = 5,
                                        OutInState = 1,
                                        OrgId = cabinet.OrganizationId,
                                        ParentId = getId,
                                        PoliceId = police != null ? police.Id : null

                                    };
                                    InsertState.Add(Insert);

                                    SendMsg equipmentDic = new SendMsg();
                                    equipmentDic.EPC = rfid;
                                    equipmentDic.State = "in";
                                    equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                    equipmentDic.Time = time;
                                    equipmentDic.BoxNum = cabinetChildID;
                                    equipmentDic.UserName = police?.Name;
                                    InvStates.Add(equipmentDic);
                                    currentEquipments.Add(editEquipment);//把放入的物资存入记录中
                                                                         //}

                                }
                            }
                        }

                        using (var scope = _unitOfWork.BeginTransaction())
                        {
                            try
                            {
                                if (OutEpc.Count > 0)
                                {
                                    _unitOfWork.EquipmentInventoryRepository.Update(OutEpc, false);//更新被拿走的物资信息
                                }
                                if (InsertState.Count > 0)
                                {
                                    _unitOfWork.EquipmentStateRepository.Insert(InsertState, false);
                                }
                                var res = _unitOfWork.SaveChanges() > 0;
                                if (res)
                                {
                                    //上报数据
                                    var httpResult = _httpHelper.GetHtml(new HttpItem()
                                    {
                                        URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                        Encoding = Encoding.UTF8,
                                        Method = "POST",
                                        ContentType = "application/json",
                                        Timeout = 5000,
                                        Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                        {
                                            data = OutEpc.Select(x => new
                                            {
                                                editType = "UPDATE",
                                                id = x.Id,
                                                supplierCode = x.SupplierCode,
                                                epc = x.Epc,
                                                policeCode = x.PoliceCode,
                                                equipmentCode = x.EquipmentCode,
                                                warehouseCode = x.WarehouseCode,
                                                cabinetId = x.CabinetId,
                                                equipmentSizecode = x.EquipmentSizecode,
                                                equipmentLocation = x.EquipmentLocation,
                                                currentState = x.CurrentState,
                                                createTime = x.CreateTime,
                                                warrantyCycle = x.WarrantyCycle,
                                                repairCycle = x.RepairCycle,
                                                productTime = x.ProductTime,
                                                useTime = x.UseTime,
                                                price = x.Price,
                                                isBorrowed = x.IsBorrowed,
                                                lostFlag = x.LostFlag,
                                                inventoryState = x.InventoryState,
                                                isInBox = x.IsInBox,
                                                boxMarkId = x.BoxMarkId,
                                                instantiationState = x.InstantiationState,
                                            })
                                        }))
                                    });
                                    if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse("远端上报数据失败");
                                    }
                                    var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                    if (obj.code != "10000")
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse(obj.msg);
                                    }
                                }
                                scope.Commit();
                                return JsonManager.ReturnSuccessResponse(InvStates);
                            }
                            catch (Exception e)
                            {
                                scope.Rollback();
                                throw;
                            }
                        }
                        #endregion
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// Rfid离线数据上报内部使用
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///     	"RFIDUpList": [{
        ///            "cabinetID": "0320200512000808",
        ///            "cabinetChildID": "1",
        ///            "time": "",
        ///            "RFIDList": [{
        ///            }] 
        ///            	}]
        ///            }
        ///           
        ///     
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UploadRFIDListInner")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> UploadRFIDListInner([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        _logger.LogDebug("Cabinet/UploadRFIDListInner离线数据上报:" + jdata.ToString());
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        List<OutLineRfid> RfidUpList = new List<OutLineRfid>();
                        if (entity.RFIDUpList != null)
                        {
                            foreach (var item in entity.RFIDUpList)
                            {
                                if (string.IsNullOrEmpty(item.time))
                                {
                                    return JsonManager.SimpleCustResponse($"time is null");
                                }
                                if (string.IsNullOrEmpty(item.cabinetID))
                                {
                                    return JsonManager.SimpleCustResponse($"cabinetID is null");
                                }
                                if (string.IsNullOrEmpty(item.cabinetChildID))
                                {
                                    return JsonManager.SimpleCustResponse($"cabinetChildID is null");
                                }
                                OutLineRfid outLine = new OutLineRfid();
                                outLine.time = item.time;
                                outLine.cabinetID = item.cabinetID;
                                outLine.cabinetChildID = item.cabinetChildID;
                                List<string> rfidList = new List<string>();
                                if (item.RFIDList != null)
                                {
                                    foreach (var rfids in item.RFIDList)
                                    {
                                        rfidList.Add(rfids);
                                    }
                                }
                                outLine.RFIDList = rfidList;
                                RfidUpList.Add(outLine);

                            }
                        }
                        RfidUpList = RfidUpList.OrderBy(p => p.time).ToList();
                        var param = new string[] {
                       "EquipmentCodeNavigation",
                       "EquipmentSizecodeNavigation"
                    };
                        List<CommonJpEquipmentInventory> OutEpc = new List<CommonJpEquipmentInventory>();
                        List<CommonJpEquipmentState> InsertState = new List<CommonJpEquipmentState>();
                        List<SendMsg> InvStates = new List<SendMsg>();

                        Expression<Func<BaseJpCabinet, bool>> cabinetExpression = t => t.CabinetRealNum == RfidUpList.FirstOrDefault().cabinetID;

                        var cabinetList = _unitOfWork.CabinetRepository.GetList(cabinetExpression).ToList();
                        var policeman = _unitOfWork.PolicemanRepository.GetList(p => p.OrgizationCode.Equals(cabinetList.FirstOrDefault().OrganizationId));//找出本次上报单警柜下组织机构中其他的警员信息

                        var equipmentList = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6 && !string.IsNullOrEmpty(t.CabinetId) && t.CurrentState == 3, null, false, param);//单警柜的东西
                        var EpcEquipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6 && (t.CurrentState == 7 || t.CurrentState == 8), null, false, param);
                        List<CommonJpEquipmentInventory> currentEquipments = new List<CommonJpEquipmentInventory>();
                        foreach (var item in RfidUpList)
                        {
                            string time = item.time;
                            string cabinetID = item.cabinetID;
                            string cabinetChildID = item.cabinetChildID;

                            var cabinet = cabinetList.Where(p => p.CabinetChildNum.Equals(int.Parse(item.cabinetChildID))).FirstOrDefault();


                            Expression<Func<BaseJpPoliceman, bool>> policeExpression = t => t.CabinetId == cabinet.Id;
                            BaseJpPoliceman police = new BaseJpPoliceman();
                            if (cabinet != null)
                            {
                                police = policeman.Where(p => !string.IsNullOrEmpty(p.CabinetId) && p.CabinetId.Equals(cabinet.Id)).FirstOrDefault();

                            }
                            var curEquipments = equipmentList.Where(p => p.CabinetId.Equals(cabinet.Id)).ToList();
                            currentEquipments.AddRange(curEquipments);
                            //var EpcEquipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => !string.IsNullOrEmpty(t.Epc), null, false, param);
                            //var equipments = _unitOfWork.EquipmentInventoryRepository.GetPage(t => t.Cabinet.CabinetRealNum==cabinetID && t.Cabinet.CabinetChildNum==cabinetChildID,"Sort",0,1000).content;
                            #region 判断单警柜中存取逻辑

                            List<string> EpcList = currentEquipments.Select(p => p.Epc).ToList();
                            List<string> EpcList2 = new List<string>();

                            EpcList2 = currentEquipments.Select(p => p.Epc).ToList();


                            List<string> Rfids = new List<string>();
                            if (item.RFIDList != null)
                            {
                                foreach (var rfidItem in item.RFIDList)
                                {

                                    if (!string.IsNullOrEmpty(rfidItem))
                                    {
                                        Rfids.Add(rfidItem);//上报的RFID
                                    }

                                }
                            }




                            CommonJpEquipmentInventory editEpcEquipment = new CommonJpEquipmentInventory();
                            CommonJpEquipmentInventory editEquipment = new CommonJpEquipmentInventory();
                            Expression<Func<BaseJpCabinet, bool>> expression = t => t.CabinetRealNum.Equals(cabinetID) && t.CabinetChildNum.Equals(int.Parse(cabinetChildID));

                            bool takeResult = false;
                            bool getResult = false;
                            string takeId = null;
                            string getId = null;
                            foreach (var epc in EpcList)
                            {
                                if (!Rfids.Contains(epc))
                                {
                                    takeResult = true;
                                    break;
                                }
                            }
                            if (takeResult)
                            {
                                takeResult = false;
                                takeId = Guid.NewGuid().ToString();
                                CommonJpEquipmentState history = new CommonJpEquipmentState
                                {
                                    Id = takeId,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdOut = cabinet.Id,
                                    OutTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 0,
                                    OrgId = cabinet.OrganizationId,
                                    PoliceId = police != null ? police.Id : null
                                };
                                InsertState.Add(history);
                            }


                            foreach (var epc in EpcList)//找出被拿走的PEC物资
                            {

                                if (!Rfids.Contains(epc))
                                {

                                    editEquipment = currentEquipments.Where(p => p.Epc.Contains(epc)).FirstOrDefault();
                                    editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜出库中;
                                    editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.外出;
                                    editEquipment.PoliceCode = police != null ? police.Id : null;
                                    editEquipment.CabinetId = cabinet.Id;
                                    CommonJpEquipmentState history = new CommonJpEquipmentState
                                    {
                                        HistorySafeLevel = editEquipment.SafeLevel,
                                        Id = Guid.NewGuid().ToString(),
                                        EqiupmentId = editEquipment.Id,
                                        State = (int)EquipmentState.单警柜,
                                        CabinetIdOut = cabinet.Id,
                                        OutTime = Convert.ToDateTime(item.time),
                                        CreateTime = Convert.ToDateTime(item.time),
                                        ActionState = 5,
                                        OutInState = 0,
                                        OrgId = cabinet.OrganizationId,
                                        ParentId = takeId,
                                        PoliceId = police != null ? police.Id : null
                                    };
                                    SendMsg equipmentDic = new SendMsg();
                                    equipmentDic.EPC = epc;
                                    equipmentDic.State = "out";
                                    equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                    equipmentDic.Time = time;
                                    equipmentDic.BoxNum = cabinetChildID;
                                    equipmentDic.UserName = police?.Name;
                                    InvStates.Add(equipmentDic);
                                    InsertState.Add(history);
                                    OutEpc.Add(editEquipment);
                                    currentEquipments.Remove(editEquipment);
                                }
                            }
                            foreach (var rfid in Rfids)
                            {
                                if (!EpcList2.Contains(rfid.ToString()))
                                {
                                    editEpcEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                    if (editEpcEquipment == null)
                                    {
                                        continue;
                                    }
                                    getResult = true;
                                    break;
                                }
                            }
                            if (getResult)
                            {
                                getResult = false;
                                getId = Guid.NewGuid().ToString();
                                CommonJpEquipmentState history = new CommonJpEquipmentState
                                {
                                    Id = getId,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdInto = cabinet.Id,
                                    IntoTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 1,
                                    OrgId = cabinet.OrganizationId,
                                    PoliceId = police != null ? police.Id : null
                                };
                                InsertState.Add(history);
                            }
                            foreach (var rfid in Rfids)//找出当前存放的EPC物资
                            {
                                if (!EpcList2.Contains(rfid.ToString()))
                                {
                                    var CabinetVal = cabinetList.Where(t => t.CabinetRealNum.Equals(cabinetID) && t.CabinetChildNum.Equals(int.Parse(cabinetChildID))).FirstOrDefault();

                                    string Cabinet = string.Empty;
                                    if (CabinetVal != null)
                                    {
                                        Cabinet = CabinetVal.Id;
                                    }

                                    editEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                    if (editEquipment == null)
                                    {
                                        continue;
                                    }
                                    editEquipment.CabinetId = Cabinet;
                                    editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜中;
                                    editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.单警柜;
                                    editEquipment.PoliceCode = police != null ? police.Id : null;
                                    OutEpc.Add(editEquipment);

                                    CommonJpEquipmentState Insert = new CommonJpEquipmentState()
                                    {
                                        HistorySafeLevel = editEquipment.SafeLevel,
                                        Id = Guid.NewGuid().ToString(),
                                        EqiupmentId = editEquipment.Id,
                                        State = (int)EquipmentState.单警柜,
                                        CabinetIdInto = cabinet.Id,
                                        IntoTime = Convert.ToDateTime(item.time),
                                        CreateTime = Convert.ToDateTime(item.time),
                                        ActionState = 5,
                                        OutInState = 1,
                                        OrgId = cabinet.OrganizationId,
                                        ParentId = getId,
                                        PoliceId = police != null ? police.Id : null

                                    };
                                    InsertState.Add(Insert);

                                    SendMsg equipmentDic = new SendMsg();
                                    equipmentDic.EPC = rfid;
                                    equipmentDic.State = "in";
                                    equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                    equipmentDic.Time = time;
                                    equipmentDic.BoxNum = cabinetChildID;
                                    equipmentDic.UserName = police?.Name;
                                    InvStates.Add(equipmentDic);
                                    currentEquipments.Add(editEquipment);//把放入的物资存入记录中
                                                                         //}

                                }
                            }
                        }

                        using (var scope = _unitOfWork.BeginTransaction())
                        {
                            try
                            {
                                if (OutEpc.Count > 0)
                                {
                                    _unitOfWork.EquipmentInventoryRepository.Update(OutEpc, false);//更新被拿走的物资信息
                                }
                                if (InsertState.Count > 0)
                                {
                                    _unitOfWork.EquipmentStateRepository.Insert(InsertState, false);
                                }
                                if (_unitOfWork.SaveChanges() > 0)
                                {
                                    //上报数据
                                    var httpResult = _httpHelper.GetHtml(new HttpItem()
                                    {
                                        URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                        Encoding = Encoding.UTF8,
                                        Method = "POST",
                                        ContentType = "application/json",
                                        Timeout = 5000,
                                        Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                        {
                                            data = OutEpc.Select(x => new
                                            {
                                                editType = "UPDATE",
                                                id = x.Id,
                                                supplierCode = x.SupplierCode,
                                                epc = x.Epc,
                                                policeCode = x.PoliceCode,
                                                equipmentCode = x.EquipmentCode,
                                                warehouseCode = x.WarehouseCode,
                                                cabinetId = x.CabinetId,
                                                equipmentSizecode = x.EquipmentSizecode,
                                                equipmentLocation = x.EquipmentLocation,
                                                currentState = x.CurrentState,
                                                createTime = x.CreateTime,
                                                warrantyCycle = x.WarrantyCycle,
                                                repairCycle = x.RepairCycle,
                                                productTime = x.ProductTime,
                                                useTime = x.UseTime,
                                                price = x.Price,
                                                isBorrowed = x.IsBorrowed,
                                                lostFlag = x.LostFlag,
                                                inventoryState = x.InventoryState,
                                                isInBox = x.IsInBox,
                                                boxMarkId = x.BoxMarkId,
                                                instantiationState = x.InstantiationState,
                                            })
                                        }))
                                    });
                                    if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse("远端上报数据失败");
                                    }
                                    var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                    if (obj.code != "10000")
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse(obj.msg);
                                    }
                                    scope.Commit();
                                    return JsonManager.ReturnSuccessResponse(InvStates);
                                }
                                else
                                {
                                    scope.Rollback();
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            catch (Exception e)
                            {
                                scope.Rollback();
                                throw;
                            }
                        }
                        #endregion
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// Rfid数据上报内部使用
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "cabinetID": "0320200512000808",
        ///            "cabinetChildID": "1",
        ///            "url":"",
        ///            "time": "",
        ///            "rebind":"",//是否被重新绑定模式，true/false
        ///            "RFIDList": [{
        ///            }] }
        ///           
        ///     
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UploadRFIDInner")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> UploadRFIDInner([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        _logger.LogDebug("Cabinet/UploadRFIDInner数据上报:" + jdata.ToString());
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetID ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetID is require");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetChildID ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetChildID is require");
                        }


                        string time = entity.time;
                        string cabinetID = entity.cabinetID;
                        string cabinetChildID = entity.cabinetChildID;
                        string rebind = entity.rebind;
                        string picUrl = entity.url;
                        Expression<Func<BaseJpCabinet, bool>> cabinetExpression = t => t.CabinetRealNum == cabinetID && t.CabinetChildNum == Convert.ToInt32(cabinetChildID);

                        var cabinet = _unitOfWork.CabinetRepository.Get(cabinetExpression);
                        Expression<Func<BaseJpPoliceman, bool>> policeExpression = t => t.CabinetId == cabinet.Id;
                        BaseJpPoliceman policeman = new BaseJpPoliceman();
                        if (cabinet != null)
                        {
                            policeman = _unitOfWork.PolicemanRepository.Get(policeExpression);
                        }
                        var param = new string[] {
                       "EquipmentCodeNavigation",
                       "EquipmentSizecodeNavigation",
                       "Cabinet",
                       "PoliceCodeNavigation"
                    };
                        var equipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => t.InventoryState != "loss" && !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6 && !string.IsNullOrEmpty(t.CabinetId) && t.CabinetId == cabinet.Id && t.CurrentState == 3, null, false, param);//单警柜的东西
                        var EpcEquipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => t.InventoryState != "loss" && !string.IsNullOrEmpty(t.Epc) && t.CurrentState != 5 && t.CurrentState != 6 && (t.CurrentState == 7 || t.CurrentState == 8), null, false, param);
                        //var equipments = _unitOfWork.EquipmentInventoryRepository.GetPage(t => t.Cabinet.CabinetRealNum==cabinetID && t.Cabinet.CabinetChildNum==cabinetChildID,"Sort",0,1000).content;
                        #region 判断单警柜中存取逻辑

                        List<string> EpcList = equipments.Select(p => p.Epc).ToList();
                        List<string> EpcList2 = new List<string>();

                        EpcList2 = equipments.Select(p => p.Epc).ToList();


                        List<string> Rfids = new List<string>();
                        if (entity.RFIDList != null)
                        {
                            foreach (var item in entity.RFIDList)
                            {
                                //string rfidItem = item;
                                if (!string.IsNullOrEmpty(item))
                                {
                                    //var rfidLeft = item.PadLeft(48, '0');
                                    var rfidLeft = item;//对方EPC格式有问题，更正后开启
                                    Rfids.Add(rfidLeft);//上报的RFID
                                }

                            }
                        }

                        List<SendMsg> InvStates = new List<SendMsg>();
                        List<CommonJpEquipmentInventory> OutEpc = new List<CommonJpEquipmentInventory>();

                        List<CommonJpEquipmentState> InsertState = new List<CommonJpEquipmentState>();
                        CommonJpEquipmentInventory editEquipment = new CommonJpEquipmentInventory();
                        CommonJpEquipmentInventory editEpcEquipment = new CommonJpEquipmentInventory();
                        Expression<Func<BaseJpCabinet, bool>> expression = t => t.CabinetRealNum.Equals(cabinetID) && t.CabinetChildNum.Equals(int.Parse(cabinetChildID));


                        bool takeResult = false;
                        bool getResult = false;
                        string takeId = null;
                        string getId = null;
                        foreach (var epc in EpcList)
                        {
                            if (!Rfids.Contains(epc))
                            {
                                takeResult = true;
                                break;
                            }
                        }
                        if (takeResult)
                        {
                            takeResult = false;
                            takeId = Guid.NewGuid().ToString();
                            CommonJpEquipmentState history = new CommonJpEquipmentState
                            {
                                Id = takeId,
                                PicUrl = picUrl,

                                State = (int)EquipmentState.单警柜,
                                CabinetIdOut = cabinet.Id,
                                OutTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ActionState = 5,
                                OutInState = 0,
                                OrgId = cabinet.OrganizationId,
                                PoliceId = policeman != null ? policeman.Id : null
                            };
                            InsertState.Add(history);
                        }

                        foreach (var epc in EpcList)//找出被拿走的PEC物资
                        {

                            if (!Rfids.Contains(epc))
                            {

                                editEquipment = equipments.Where(p => p.Epc.Contains(epc)).FirstOrDefault();
                                editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜出库中;
                                editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.外出;
                                editEquipment.PoliceCode = policeman != null ? policeman.Id : null;
                                editEquipment.CabinetId = cabinet.Id;
                                editEquipment.OutTime = DateTime.Now; //todo 临时使用
                                CommonJpEquipmentState history = new CommonJpEquipmentState
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    //PicUrl = picUrl,
                                    EqiupmentId = editEquipment.Id,
                                    HistorySafeLevel = editEquipment.SafeLevel,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdOut = cabinet.Id,
                                    OutTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 0,
                                    OrgId = cabinet.OrganizationId,
                                    ParentId = takeId,
                                    PoliceId = policeman != null ? policeman.Id : null
                                };
                                SendMsg equipmentDic = new SendMsg();
                                equipmentDic.EPC = epc;
                                equipmentDic.State = "out";
                                equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                equipmentDic.Time = time;
                                equipmentDic.BoxNum = cabinetChildID;
                                equipmentDic.UserName = policeman?.Name;
                                InvStates.Add(equipmentDic);
                                InsertState.Add(history);
                                OutEpc.Add(editEquipment);

                            }
                        }
                        foreach (var rfid in Rfids)
                        {

                            if (!EpcList2.Contains(rfid.ToString()))


                            {

                                editEpcEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                if (editEpcEquipment == null || (!string.IsNullOrEmpty(editEpcEquipment.PoliceCode) && !editEpcEquipment.PoliceCode.Equals(policeman.Id)))
                                {
                                    continue;
                                }
                                getResult = true;
                                break;
                            }
                        }
                        if (getResult)
                        {
                            getResult = false;
                            getId = Guid.NewGuid().ToString();

                            CommonJpEquipmentState history = new CommonJpEquipmentState
                            {
                                Id = getId,
                                PicUrl = picUrl,
                                State = (int)EquipmentState.单警柜,
                                CabinetIdInto = cabinet.Id,
                                IntoTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ActionState = 5,
                                OutInState = 1,
                                OrgId = cabinet.OrganizationId,
                                PoliceId = policeman != null ? policeman.Id : null
                            };
                            InsertState.Add(history);
                        }

                        //List<string> EpcList2 = equipments.Where(p=>p.CurrentState.Equals()) .Select(p => p.Epc).ToList();
                        SendMsg errEquipmentDic = new SendMsg();
                        errEquipmentDic.State = "error";
                        errEquipmentDic.Time = time;
                        errEquipmentDic.BoxNum = cabinetChildID;
                        errEquipmentDic.UserName = editEquipment.PoliceCodeNavigation?.Name;
                        errEquipmentDic.Msg = "wrongReturn";
                        errEquipmentDic.CurrentUserName = policeman != null ? policeman.Name : null;
                        foreach (var rfid in Rfids)//找出当前存放的EPC物资
                        {
                            if (!EpcList2.Contains(rfid.ToString()))
                            {
                                var CabinetVal = _unitOfWork.CabinetRepository.Get(expression);
                                string Cabinet = string.Empty;
                                if (CabinetVal != null)
                                {
                                    Cabinet = CabinetVal.Id;
                                }

                                editEquipment = EpcEquipments.Where(p => p.Epc.Contains(rfid)).FirstOrDefault();
                                if (editEquipment == null)
                                {
                                    continue;
                                }
                                if (!string.IsNullOrEmpty(editEquipment.PoliceCode) && !editEquipment.PoliceCode.Equals(policeman.Id))//该物资已被绑定
                                {
                                    errEquipmentDic.UserName = editEquipment.Cabinet?.BaseJpPolicemen?.FirstOrDefault().Name;
                                    errEquipmentDic.EPC = string.IsNullOrEmpty(errEquipmentDic.EPC) ? rfid : errEquipmentDic.EPC + "," + rfid;
                                    errEquipmentDic.Name = string.IsNullOrEmpty(errEquipmentDic.Name) ? editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName + "-" +
                                    editEquipment.PoliceCodeNavigation?.Name : errEquipmentDic.Name + "," + editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName + "-" + editEquipment.PoliceCodeNavigation?.Name;

                                    continue;
                                }
                                editEquipment.CabinetId = Cabinet;
                                editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.单警柜中;
                                editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.单警柜;
                                editEquipment.PoliceCode = policeman != null ? policeman.Id : null;
                                OutEpc.Add(editEquipment);

                                CommonJpEquipmentState Insert = new CommonJpEquipmentState()
                                {
                                    //PicUrl = picUrl,
                                    HistorySafeLevel = editEquipment.SafeLevel,
                                    Id = Guid.NewGuid().ToString(),
                                    EqiupmentId = editEquipment.Id,
                                    State = (int)EquipmentState.单警柜,
                                    CabinetIdInto = cabinet.Id,
                                    IntoTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 5,
                                    OutInState = 1,
                                    OrgId = cabinet.OrganizationId,
                                    ParentId = getId,
                                    PoliceId = policeman != null ? policeman.Id : null

                                };
                                InsertState.Add(Insert);

                                SendMsg equipmentDic = new SendMsg();
                                equipmentDic.EPC = rfid;
                                equipmentDic.State = "in";
                                equipmentDic.Name = editEquipment.EquipmentCodeNavigation.Name + "-" + editEquipment.EquipmentSizecodeNavigation.SizeName;
                                equipmentDic.Time = time;
                                equipmentDic.BoxNum = cabinetChildID;
                                equipmentDic.UserName = policeman?.Name;
                                InvStates.Add(equipmentDic);
                                //}

                            }
                        }
                        if (!string.IsNullOrEmpty(errEquipmentDic.EPC))
                        {
                            InvStates.Add(errEquipmentDic);
                        }
                        if (rebind.Equals("true"))
                        {
                            var CurrentBindEquipments = _unitOfWork.EquipmentInventoryRepository.GetList(t => t.InventoryState != "loss" && t.CabinetId.Equals(cabinet.Id), null, false, param);//单警柜的东西
                            SendMsg equipmentDic = new SendMsg();
                            equipmentDic.State = "rebind";
                            equipmentDic.Msg = "";
                            equipmentDic.Time = time;
                            equipmentDic.BoxNum = cabinetChildID;
                            equipmentDic.UserName = policeman?.Name;

                            foreach (var item in CurrentBindEquipments)
                            {
                                if (!Rfids.Contains(item.Epc))
                                {
                                    item.CabinetId = null;
                                    item.PoliceCode = null;
                                    OutEpc.Add(item);
                                    equipmentDic.EPC = string.IsNullOrEmpty(equipmentDic.EPC) ? item.Epc : equipmentDic.EPC + "," + item.Epc;
                                    equipmentDic.Name = string.IsNullOrEmpty(equipmentDic.Name) ? item.EquipmentCodeNavigation.Name + "-" + item.EquipmentSizecodeNavigation.SizeName : equipmentDic.Name + "," + item.EquipmentCodeNavigation.Name + "-" + item.EquipmentSizecodeNavigation.SizeName;

                                }
                            }
                            if (!string.IsNullOrEmpty(equipmentDic.EPC))
                            {
                                InvStates.Add(equipmentDic);
                            }
                        }

                        using (var scope = _unitOfWork.BeginTransaction())
                        {
                            try
                            {
                                if (InsertState.Count > 0)
                                {
                                    _unitOfWork.EquipmentStateRepository.Insert(InsertState, false);
                                }
                                if (OutEpc.Count > 0)
                                {
                                    _unitOfWork.EquipmentInventoryRepository.Update(OutEpc, false);//更新被拿走的物资信息
                                }

                                _unitOfWork.SaveChanges();

                                if (OutEpc.Count > 0)
                                {
                                    //上报数据
                                    var httpResult = _httpHelper.GetHtml(new HttpItem()
                                    {
                                        URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                        Encoding = Encoding.UTF8,
                                        Method = "POST",
                                        ContentType = "application/json",
                                        Timeout = 5000,
                                        Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                        {
                                            data = OutEpc.Select(x => new
                                            {
                                                editType = "UPDATE",
                                                id = x.Id,
                                                supplierCode = x.SupplierCode,
                                                epc = x.Epc,
                                                policeCode = x.PoliceCode,
                                                equipmentCode = x.EquipmentCode,
                                                warehouseCode = x.WarehouseCode,
                                                cabinetId = x.CabinetId,
                                                equipmentSizecode = x.EquipmentSizecode,
                                                equipmentLocation = x.EquipmentLocation,
                                                currentState = x.CurrentState,
                                                createTime = x.CreateTime,
                                                warrantyCycle = x.WarrantyCycle,
                                                repairCycle = x.RepairCycle,
                                                productTime = x.ProductTime,
                                                useTime = x.UseTime,
                                                price = x.Price,
                                                isBorrowed = x.IsBorrowed,
                                                lostFlag = x.LostFlag,
                                                inventoryState = x.InventoryState,
                                                isInBox = x.IsInBox,
                                                boxMarkId = x.BoxMarkId,
                                                instantiationState = x.InstantiationState,
                                            })
                                        }))
                                    });
                                    if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse("远端上报数据失败");
                                    }
                                    var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                    if (obj.code != "10000")
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse(obj.msg);
                                    }
                                }
                                scope.Commit();

                                var CurrentEI = _unitOfWork.EquipmentInventoryRepository.GetList(p => p.InventoryState != "loss" && p.Cabinet.CabinetRealNum.Equals(cabinetID) && p.Cabinet.CabinetChildNum.Equals(Convert.ToInt32(cabinetChildID)), null, false, param);
                                var InsideEI = CurrentEI.Where(p => p.CurrentState.Equals(3)).ToList();//在单警柜中的物资
                                var OutsideEI = CurrentEI.Where(p => p.CurrentState.Equals(7)).ToList();//在单警柜外的物资
                                if (rebind.Equals("false") && ((InsertState.Where(p => p.ActionState.Equals(5) && p.OutInState.Equals(1)).ToList().Count > 0 && InsertState.Where(p => p.ActionState.Equals(5)
                                       && p.OutInState.Equals(0)).ToList().Count > 0 && InsideEI.Count() > 0) || (InsertState.Where(p => p.ActionState.Equals(5) && p.OutInState.Equals(1)).ToList()
                                .Count <= 0 && InsertState.Where(p => p.ActionState.Equals(5)
                                && p.OutInState.Equals(0)).ToList().Count <= 0 && OutsideEI.Count > 0 && InsideEI.Count > 0)))//有拿有还则选择拿的
                                {
                                    if (policeman != null)
                                    {
                                        SendMsg equipmentDic = new SendMsg();
                                        equipmentDic.State = "error";
                                        equipmentDic.Msg = "missTake";
                                        equipmentDic.Time = time;
                                        equipmentDic.BoxNum = cabinetChildID;
                                        equipmentDic.UserName = policeman?.Name;
                                        foreach (var item in InsideEI)
                                        {
                                            equipmentDic.EPC = string.IsNullOrEmpty(equipmentDic.EPC) ? item.Epc : equipmentDic.EPC + "," + item.Epc;
                                            equipmentDic.Name = string.IsNullOrEmpty(equipmentDic.Name) ? item.EquipmentCodeNavigation.Name + "-" + item.EquipmentSizecodeNavigation.SizeName : equipmentDic.Name + "," + item.EquipmentCodeNavigation.Name + "-" + item.EquipmentSizecodeNavigation.SizeName;
                                        }
                                        InvStates.Add(equipmentDic);
                                    }
                                }
                                else if (rebind.Equals("false") && (InsertState.Where(p => p.ActionState.Equals(5) && p.OutInState.Equals(1)).ToList().Count > 0 && InsertState.Where(p => p.ActionState.Equals(5)
                                && p.OutInState.Equals(0)).ToList().Count <= 0 && OutsideEI.Count() > 0))//放入了物资 少还了物资
                                {
                                    if (policeman != null)
                                    {
                                        SendMsg equipmentDic = new SendMsg();
                                        equipmentDic.State = "error";
                                        equipmentDic.Msg = "missReturn";
                                        equipmentDic.Time = time;
                                        equipmentDic.BoxNum = cabinetChildID;
                                        equipmentDic.UserName = policeman?.Name;
                                        foreach (var item in OutsideEI)
                                        {
                                            equipmentDic.EPC = string.IsNullOrEmpty(equipmentDic.EPC) ? item.Epc : equipmentDic.EPC + "," + item.Epc;
                                            equipmentDic.Name = string.IsNullOrEmpty(equipmentDic.Name) ? item.EquipmentCodeNavigation.Name + "-" + item.EquipmentSizecodeNavigation.SizeName : equipmentDic.Name + "," + item.EquipmentCodeNavigation.Name + "-" + item.EquipmentSizecodeNavigation.SizeName;
                                        }
                                        InvStates.Add(equipmentDic);

                                    }


                                }
                                else if (rebind.Equals("false") && (InsertState.Where(p => p.ActionState.Equals(5) && p.OutInState.Equals(1)).ToList().Count <= 0 && InsertState.Where(p => p.ActionState.Equals(5)
                                && p.OutInState.Equals(0)).ToList().Count > 0 && InsideEI.Count() > 0))//拿出了物资 少拿了物资
                                {
                                    if (policeman != null)
                                    {
                                        SendMsg equipmentDic = new SendMsg();
                                        equipmentDic.State = "error";
                                        equipmentDic.Msg = "missTake";
                                        equipmentDic.Time = time;
                                        equipmentDic.BoxNum = cabinetChildID;
                                        equipmentDic.UserName = policeman?.Name;
                                        foreach (var item in InsideEI)
                                        {
                                            equipmentDic.EPC = string.IsNullOrEmpty(equipmentDic.EPC) ? item.Epc : equipmentDic.EPC + "," + item.Epc;
                                            equipmentDic.Name = string.IsNullOrEmpty(equipmentDic.Name) ? item.EquipmentCodeNavigation.Name + "-" + item.EquipmentSizecodeNavigation.SizeName : equipmentDic.Name + "," + item.EquipmentCodeNavigation.Name + "-" + item.EquipmentSizecodeNavigation.SizeName;
                                        }
                                        InvStates.Add(equipmentDic);
                                    }

                                }
                                var InsideTimeEq = OutEpc.Where(p => p.WarrantyCycle != 0 && p.ProductTime != null).ToList();

                                InsideTimeEq = InsideTimeEq.Where(p => p.ProductTime.Value.AddMonths(Convert.ToInt32(p.WarrantyCycle)) <= DateTime.Now).ToList();


                                if (InsideTimeEq.Count > 0)
                                {
                                    foreach (var item in InsideTimeEq)
                                    {
                                        SendMsg outTimeEq = new SendMsg();//过期判断
                                        outTimeEq.State = "exceed";
                                        outTimeEq.Time = time;
                                        outTimeEq.BoxNum = cabinetChildID;
                                        outTimeEq.UserName = policeman?.Name;
                                        outTimeEq.EPC = string.Empty;
                                        outTimeEq.Name = item.EquipmentCodeNavigation.Name + "-" + item.EquipmentSizecodeNavigation.SizeName;
                                        outTimeEq.EPC = string.IsNullOrEmpty(outTimeEq.EPC) ? item.Epc : outTimeEq.EPC + "," + item.Epc;
                                        outTimeEq.Msg = "物资:" + item.EquipmentCodeNavigation.Name + "-" + item.EquipmentSizecodeNavigation.SizeName + "已于" +
                                        item.ProductTime.Value.AddMonths(Convert.ToInt32(item.WarrantyCycle)).ToString() + "过期";

                                        InvStates.Add(outTimeEq);

                                    }
                                }

                                //预警记录 记录 error：异常 exceed：过期 
                                _unitOfWork.DbContext.BaseJpCabinetInvErrorMsgs.AddRange(InvStates
                                    .Where(x => x.State == "error" || x.State == "exceed")
                                    .Select(x => new BaseJpCabinetInvErrorMsg
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        CabinetRealNum = cabinet.CabinetRealNum,
                                        CabinetNum = cabinet.CabinetNum,
                                        CabinetChildNum = cabinet.CabinetChildNum,
                                        CabinetId = cabinet.Id,
                                        OrganizationId = cabinet.OrganizationId,
                                        State = x.State,
                                        Msg = x.Msg,
                                        PushTime = DateTime.Now,
                                        UserName = x.UserName,
                                        CurrentUserName = x.CurrentUserName,
                                        Epc = x.EPC,
                                    }));
                                _unitOfWork.SaveChanges();

                                _logger.LogDebug("Cabinet/UploadRFIDInner数据上报数据返回:" + JsonConvert.SerializeObject(InvStates).ToString());
                                return JsonManager.ReturnSuccessResponse(InvStates);

                            }
                            catch (Exception e)
                            {
                                scope.Rollback();
                                throw;
                            }
                        }
                        #endregion
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError("Cabinet/UploadRfidInner 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增单警柜新箱
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "num":"箱数",
        ///            "cabinetRealNum":"实际柜号",
        ///            "buyTime":"购买时间",
        ///            "useTime":"使用时间",
        ///            "state":"使用状态"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddExtraCabinet")]
        public async Task<HttpResponseMessage> AddExtraCabinet([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.num ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"num is require");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetRealNum ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetRealNum is require");
                        }
                        else
                        {
                            string cabinetRealNum = entity.cabinetRealNum;
                            string state = entity.state;
                            int currentState = 0;
                            if (!string.IsNullOrEmpty(state))
                            {
                                currentState = int.Parse(state);
                            }
                            var cabinetEx = _unitOfWork.CabinetRepository.GetList(p => p.CabinetRealNum.Equals(cabinetRealNum)).OrderByDescending(p => p.CabinetChildNum);
                            if (cabinetEx != null)
                            {
                                var cabinetInfo = cabinetEx.FirstOrDefault();
                                int currentNum = cabinetInfo.CabinetChildNum;
                                List<BaseJpCabinet> cabinets = new List<BaseJpCabinet>();
                                //新增数据
                                for (int i = 1; i <= int.Parse(entity.num); i++)
                                {
                                    BaseJpCabinet addObject = new BaseJpCabinet()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        CabinetNum = cabinetInfo.CabinetNum,
                                        CabinetChildNum = i + currentNum,
                                        Location = cabinetInfo.Location,
                                        State = currentState,
                                        OrganizationId = cabinetInfo.OrganizationId,
                                        ShortName = cabinetInfo.ShortName,
                                        CabinetRealNum = cabinetInfo.CabinetRealNum,
                                        Type = 0
                                    };
                                    if (!string.IsNullOrEmpty(entity.buyTime ?? ""))
                                    {
                                        addObject.BuyTime = Convert.ToDateTime(entity.buyTime);

                                    }
                                    if (!string.IsNullOrEmpty(entity.useTime))
                                    {

                                        addObject.UseTime = Convert.ToDateTime(entity.useTime);
                                    }
                                    cabinets.Add(addObject);
                                }
                                bool result = _unitOfWork.CabinetRepository.Insert(cabinets);

                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleCustResponse($"单警柜不存在");
                            }




                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增单警柜信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "cabinetNum"= "柜号",
        ///            "num"="箱数",
        ///            "cabinetRealNum"= "实际柜号",
        ///            "location" = "位置",
        ///            "state" = "状态",
        ///            "organizationId" = "组织机构号",
        ///            "shortName" = "简称(可为空)",
        ///            "buyTime" = "购买时间",
        ///            "useTime" = "使用时间(可为空)",
        ///            "type" = "模式，0 普通模式，1值班,2 公共柜"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddCabinet")]
        public async Task<HttpResponseMessage> AddCabinet([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.organizationId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        if (string.IsNullOrEmpty(entity.cabinetNum ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"CabinetNum is require");
                        }
                        else if (string.IsNullOrEmpty(entity.type ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"type is require");
                        }
                        else
                        {
                            string cabinetRealNum = entity.cabinetRealNum;
                            var cabinetEx = _unitOfWork.CabinetRepository.Get(p => p.CabinetRealNum.Equals(cabinetRealNum));
                            if (cabinetEx != null)
                            {
                                return JsonManager.SimpleCustResponse($"单警柜已存在");
                            }
                            List<BaseJpCabinet> cabinets = new List<BaseJpCabinet>();
                            string state = "0";
                            string type = "0";
                            DateTime buyTime = DateTime.Now;
                            if (!string.IsNullOrEmpty(entity.buyTime))
                            {
                                buyTime = Convert.ToDateTime(entity.buyTime);
                            }
                            if (!string.IsNullOrEmpty(entity.state))
                            {
                                state = entity.state;
                            }
                            if (!string.IsNullOrEmpty(entity.type))
                            {
                                type = entity.type;
                            }
                            //新增数据
                            for (int i = 1; i <= int.Parse(entity.num); i++)
                            {
                                BaseJpCabinet addObject = new BaseJpCabinet()
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    CabinetNum = entity.cabinetNum,
                                    CabinetChildNum = i,
                                    Location = entity.location,

                                    State = Convert.ToInt32(state),
                                    OrganizationId = entity.organizationId,
                                    ShortName = entity.shortName,
                                    CabinetRealNum = entity.cabinetRealNum,
                                    Type = Convert.ToInt32(type)
                                };
                                if (!string.IsNullOrEmpty(entity.buyTime ?? ""))
                                {
                                    addObject.BuyTime = Convert.ToDateTime(entity.buyTime);

                                }
                                if (!string.IsNullOrEmpty(entity.useTime))
                                {

                                    addObject.UseTime = Convert.ToDateTime(entity.useTime);
                                }
                                cabinets.Add(addObject);
                            }


                            bool result = _unitOfWork.CabinetRepository.Insert(cabinets);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 修改单警柜信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///            "id" : "单警柜ID",
        ///            "cabinetNum"= "柜号",
        ///            "cabinetChildNum"="箱号",
        ///            "cabinetRealNum"= "实际柜号",
        ///            "location" = "位置",
        ///            "state" = "状态",
        ///            "organizationId" = "组织机构号",
        ///            "shortName" = "简称(可为空)",
        ///            "buyTime" = "购买时间",
        ///            "useTime" = "使用时间(可为空)",
        ///            "policeId" = "警用ID"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UpdateCabinet")]
        //[NoSign]
        public async Task<HttpResponseMessage> UpdateCabinet([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetNum ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"CabinetNum is require");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetChildNum ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"CabinetChildNum is require");
                        }
                        else if (string.IsNullOrEmpty(entity.location ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"Location is require");
                        }

                        else if (string.IsNullOrEmpty(entity.state ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"State is require");
                        }
                        else if (string.IsNullOrEmpty(entity.organizationId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"OrganizationId is require");
                        }

                        else if (string.IsNullOrEmpty(entity.buyTime ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"BuyTime is require");
                        }


                        else if (!string.IsNullOrEmpty(id))//修改
                        {
                            Expression<Func<BaseJpCabinet, bool>> expression = t => t.Id.Equals(id);
                            BaseJpCabinet updateObject = _unitOfWork.CabinetRepository.Get(expression);
                            if (updateObject != null)
                            {
                                if (!string.IsNullOrEmpty(entity.buyTime ?? ""))
                                {
                                    updateObject.BuyTime = Convert.ToDateTime(entity.buyTime);

                                }
                                if (!string.IsNullOrEmpty(entity.useTime))
                                {

                                    updateObject.UseTime = Convert.ToDateTime(entity.useTime);
                                }
                                if (!string.IsNullOrEmpty(entity.state))
                                {

                                    updateObject.State = Convert.ToInt32(entity.state);
                                }
                                if (!string.IsNullOrEmpty(entity.policeId))
                                {
                                    string policeId = entity.policeId;
                                    var currentPolice = _unitOfWork.PolicemanRepository.Get(p => p.CabinetId.Equals(id));
                                    if (currentPolice != null)
                                    {
                                        currentPolice.CabinetId = null;
                                        var bindPolice = _unitOfWork.PolicemanRepository.Get(p => p.Id.Equals(policeId));
                                        if (bindPolice != null)
                                        {
                                            bindPolice.CabinetId = id;
                                        }
                                        _unitOfWork.PolicemanRepository.Update(currentPolice, false);
                                        _unitOfWork.PolicemanRepository.Update(bindPolice, false);
                                    }
                                    else
                                    {
                                        var bindPolice = _unitOfWork.PolicemanRepository.Get(p => p.Id.Equals(policeId));
                                        if (bindPolice != null)
                                        {
                                            bindPolice.CabinetId = id;
                                        }
                                        _unitOfWork.PolicemanRepository.Update(bindPolice, false);
                                    }
                                }
                                else
                                {
                                    if (updateObject.Type.Equals(0))//普通柜
                                    {
                                        var currentPolice = _unitOfWork.PolicemanRepository.Get(p => p.CabinetId.Equals(id));
                                        if (currentPolice != null)
                                        {
                                            currentPolice.CabinetId = null;
                                            _unitOfWork.PolicemanRepository.Update(currentPolice, false);
                                        }
                                    }


                                }
                                updateObject.CabinetNum = entity.cabinetNum;
                                updateObject.CabinetChildNum = Convert.ToInt32(entity.cabinetChildNum);
                                updateObject.Location = entity.location;

                                updateObject.OrganizationId = entity.organizationId;
                                updateObject.ShortName = entity.shortName;
                                if (!string.IsNullOrEmpty(entity.cabinetRealNum))
                                {
                                    updateObject.CabinetRealNum = entity.cabinetRealNum;
                                }


                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            bool result = _unitOfWork.CabinetRepository.Update(updateObject, true);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {

                            //新增数据
                            BaseJpCabinet addObject = new BaseJpCabinet()
                            {
                                Id = Guid.NewGuid().ToString(),
                                CabinetNum = entity.cabinetNum,
                                CabinetChildNum = entity.cabinetChildNum,
                                Location = entity.location,

                                State = Convert.ToInt32(entity.State),
                                OrganizationId = entity.organizationId,
                                ShortName = entity.shortName,

                                //BuyTime = Convert.ToDateTime(entity.BuyTime),
                                CabinetRealNum = entity.cabinetRealNum
                            };
                            if (!string.IsNullOrEmpty(entity.buyTime ?? ""))
                            {
                                addObject.BuyTime = Convert.ToDateTime(entity.buyTime);

                            }
                            if (!string.IsNullOrEmpty(entity.useTime))
                            {

                                addObject.UseTime = Convert.ToDateTime(entity.useTime);
                            }
                            bool result = _unitOfWork.CabinetRepository.Insert(addObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 修改单警柜和警员信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "userId"://警员ID,
        ///         "type"://类型 0:密码,1:指纹,2：人脸
        ///         "typeValue1"://类型对应的信息,
        ///         "typeValue2"://类型对应的信息,
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UpdatePoliceAndCabinet")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> UpdatePoliceAndCabinet([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);


                        string organizationId = entity?.organizationId ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.userId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"userId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.type ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"type is require");
                        }

                        string policeId = entity.userId;
                        string type = entity.type;
                        string typeValue = entity.typeValue1;
                        string typeValue2 = entity.typeValue2;
                        var policemanInfo = _unitOfWork.PolicemanRepository.Get(p => p.Id == policeId);

                        if (policemanInfo == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.CABINET_ERROR);
                        }
                        switch (type)
                        {
                            case "0":
                                policemanInfo.Password = typeValue;
                                break;
                            case "1":
                                if (typeValue != null)
                                {
                                    policemanInfo.FingerInfo1 = typeValue;
                                }
                                if (typeValue2 != null)
                                {
                                    policemanInfo.FingerInfo2 = typeValue2;
                                }

                                //policemanInfo.FingerInfo2 = typeValue2;
                                break;
                            case "2":
                                policemanInfo.FaceInfo = typeValue;
                                break;
                            default:
                                break;
                        }
                        bool result = _unitOfWork.PolicemanRepository.Update(policemanInfo, true);

                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);

                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 解绑单警柜和警员信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "cabinetRealID"://单警柜号,
        ///         "cabinetChildID"://,单警柜箱号
        ///         "userId"://警员ID,
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeletePoliceAndCabinet")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> DeletePoliceAndCabinet([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        _logger.LogDebug("DeletePoliceAndCabinet" + jdata.ToString());

                        string organizationId = entity?.organizationId ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.userId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"userId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetRealID ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetRealID is require");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetChildID ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetChildID is require");
                        }
                        int cabinetChildNum = int.Parse(entity.cabinetChildID);
                        string cabinetRealNum = entity.cabinetRealID;
                        string policeId = entity.userId;
                        var policemanInfo = _unitOfWork.PolicemanRepository.Get(p => p.Id == policeId);
                        var cabinetInfo = _unitOfWork.CabinetRepository.Get(p => p.CabinetRealNum == cabinetRealNum && p.CabinetChildNum == cabinetChildNum);

                        if (policemanInfo == null || cabinetInfo == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.CABINET_ERROR);
                        }
                        policemanInfo.CabinetId = null;
                        var InvList = _unitOfWork.EquipmentInventoryRepository.GetList(p => p.PoliceCode.Equals(policemanInfo.Id));
                        List<CommonJpEquipmentInventory> EqInv = new List<CommonJpEquipmentInventory>();
                        var InsideInv = InvList.Where(p => p.CurrentState.Equals(3)).ToList();//在柜内物资
                        var OutsideInv = InvList.Where(p => p.CurrentState.Equals(7)).ToList();//在柜外物资
                        if (InsideInv.Count() > 0)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.DELETE_USER_ERROR);
                        }
                        if (OutsideInv.Count() > 0)
                        {
                            foreach (var item in OutsideInv)
                            {
                                item.CurrentState = 7;
                                item.PoliceCode = null;
                                item.CabinetId = null;
                                EqInv.Add(item);
                            }
                        }

                        using (var scope = _unitOfWork.BeginTransaction())
                        {
                            try
                            {
                                _unitOfWork.EquipmentInventoryRepository.Update(EqInv, false);
                                _unitOfWork.PolicemanRepository.Update(policemanInfo, false);
                                if (_unitOfWork.SaveChanges() > 0)
                                {
                                    //上报数据
                                    var httpResult = _httpHelper.GetHtml(new HttpItem()
                                    {
                                        URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                        Encoding = Encoding.UTF8,
                                        Method = "POST",
                                        ContentType = "application/json",
                                        Timeout = 5000,
                                        Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                        {
                                            data = EqInv.Select(x => new
                                            {
                                                editType = "UPDATE",
                                                id = x.Id,
                                                supplierCode = x.SupplierCode,
                                                epc = x.Epc,
                                                policeCode = x.PoliceCode,
                                                equipmentCode = x.EquipmentCode,
                                                warehouseCode = x.WarehouseCode,
                                                cabinetId = x.CabinetId,
                                                equipmentSizecode = x.EquipmentSizecode,
                                                equipmentLocation = x.EquipmentLocation,
                                                currentState = x.CurrentState,
                                                createTime = x.CreateTime,
                                                warrantyCycle = x.WarrantyCycle,
                                                repairCycle = x.RepairCycle,
                                                productTime = x.ProductTime,
                                                useTime = x.UseTime,
                                                price = x.Price,
                                                isBorrowed = x.IsBorrowed,
                                                lostFlag = x.LostFlag,
                                                inventoryState = x.InventoryState,
                                                isInBox = x.IsInBox,
                                                boxMarkId = x.BoxMarkId,
                                                instantiationState = x.InstantiationState,
                                            })
                                        }))
                                    });
                                    if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse("远端上报数据失败");
                                    }
                                    var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                    if (obj.code != "10000")
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse(obj.msg);
                                    }
                                    scope.Commit();
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    scope.Rollback();
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            catch (Exception e)
                            {
                                scope.Rollback();
                                throw;
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 绑定公共柜和警员信息 公共柜使用
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///          cabinetRealID：//单警柜号
        ///          userId ：//用户ID
        ///          boxNo：//单警柜箱号
        ///          list :[
        ///              {
        ///              boxNo：//单警柜箱号
        ///              userName：//用户名
        ///              userId：//用户ID
        ///              }
        ///          ]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddPoliceAndCabinetMutiple")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> AddPoliceAndCabinetMutiple([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);


                        string cabinetRealID = entity?.cabinetRealID ?? "";
                        List<BaseJpCabinetPolicemanMultiple> CPMList = new List<BaseJpCabinetPolicemanMultiple>();
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        var list = new List<dynamic>();
                        if (entity.list != null)
                        {
                            list = new List<dynamic>(entity.list);
                        }
                        string userId = entity.userId ?? "";
                        string boxNo = entity.boxNo ?? "";
                        if (string.IsNullOrEmpty(userId) && string.IsNullOrEmpty(boxNo))
                        {
                            return JsonManager.SimpleCustResponse($"userId and boxNo is null");
                        }
                        if (!string.IsNullOrEmpty(userId))
                        {
                            //绑用户
                            //清空旧数据
                            var delList = _unitOfWork.CabinetPolicemanMultipleRepository.GetList(x => x.CabinetRealId == cabinetRealID && x.UserId == userId).ToList();
                            _unitOfWork.DbContext.BaseJpCabinetPolicemanMultiples.RemoveRange(delList);

                        }
                        else
                        {
                            //绑柜子
                            //清空旧数据
                            var delList = _unitOfWork.CabinetPolicemanMultipleRepository.GetList(x => x.CabinetRealId == cabinetRealID && x.BoxNo == boxNo).ToList();
                            _unitOfWork.DbContext.BaseJpCabinetPolicemanMultiples.RemoveRange(delList);
                        }
                        foreach (var item in list)
                        {
                            CPMList.Add(new BaseJpCabinetPolicemanMultiple
                            {
                                Id = Guid.NewGuid().ToString(),
                                UserId = item.userId,
                                UserName = item.userName,
                                BoxNo = item.boxNo,
                                CabinetRealId = cabinetRealID
                            });
                        }
                        bool result = _unitOfWork.CabinetPolicemanMultipleRepository.Insert(CPMList);
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 绑定单警柜和警员信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "cabinetRealID"://单警柜号,
        ///         "cabinetChildID"://,单警柜箱号
        ///         "userId"://警员ID,
        ///         "password"://警员密码,
        ///         "finger1Features"://指纹信息,
        ///         "finger2Features"://指纹信息,
        ///         "faceFeatures"://人脸信息
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddPoliceAndCabinet")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> AddPoliceAndCabinet([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);


                        string organizationId = entity?.organizationId ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.userId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"userId is require");
                        }

                        int cabinetChildNum = int.Parse(entity.cabinetChildID);
                        string cabinetRealNum = entity.cabinetRealID;
                        string policeId = entity.userId;
                        string password = entity.password;
                        string fingerInfo = entity.finger1Features;
                        //int co = fingerInfo.Length;
                        string fingerInfo2 = entity.finger2Features;
                        string faceInfo = entity.faceFeatures;
                        //int co1 = faceInfo.Length;

                        using (var scope = _unitOfWork.BeginTransaction())
                        {
                            try
                            {
                                var policemanInfo = _unitOfWork.PolicemanRepository.Get(p => p.Id == policeId);
                                var cabinetInfo = _unitOfWork.CabinetRepository.Get(p => p.CabinetRealNum == cabinetRealNum && p.CabinetChildNum == cabinetChildNum);
                                var InvList = _unitOfWork.EquipmentInventoryRepository.GetList(p => p.PoliceCode.Equals(policemanInfo.Id));
                                List<CommonJpEquipmentInventory> EqInv = new List<CommonJpEquipmentInventory>();
                                var InsideInv = InvList.Where(p => p.CurrentState.Equals(3)).ToList();//在柜内物资
                                var OutsideInv = InvList.Where(p => p.CurrentState.Equals(7)).ToList();//在柜外物资
                                if (InsideInv.Count() > 0)
                                {
                                    scope.Rollback();
                                    return JsonManager.SimpleStatusResponse(ResultCode.DELETE_USER_ERROR);
                                }
                                if (OutsideInv.Count() > 0)
                                {
                                    foreach (var item in OutsideInv)
                                    {
                                        item.CurrentState = 7;
                                        item.PoliceCode = null;
                                        item.CabinetId = null;
                                        EqInv.Add(item);
                                    }
                                    _unitOfWork.EquipmentInventoryRepository.Update(EqInv, false);
                                }
                                if (policemanInfo == null)
                                {
                                    scope.Rollback();
                                    return JsonManager.SimpleStatusResponse(ResultCode.CABINET_ERROR);
                                }
                                if (cabinetInfo == null)
                                {
                                    var currentCabinets = _unitOfWork.CabinetRepository.GetList(p => p.CabinetRealNum == cabinetRealNum).OrderByDescending(p => p.CabinetChildNum).FirstOrDefault();

                                    List<BaseJpCabinet> cabinets = new List<BaseJpCabinet>();
                                    for (int i = currentCabinets.CabinetChildNum; i < cabinetChildNum; i++)
                                    {
                                        BaseJpCabinet cabinetAdd = new BaseJpCabinet();
                                        cabinetAdd.Id = Guid.NewGuid().ToString();
                                        cabinetAdd.State = 1;
                                        cabinetAdd.UseTime = DateTime.Now;
                                        cabinetAdd.BuyTime = DateTime.Now;
                                        cabinetAdd.CabinetRealNum = cabinetRealNum;
                                        cabinetAdd.CabinetChildNum = i + 1;
                                        cabinetAdd.CabinetNum = currentCabinets.CabinetNum;
                                        cabinetAdd.ShortName = currentCabinets.ShortName;
                                        cabinetAdd.Type = currentCabinets.Type;
                                        cabinetAdd.OrganizationId = currentCabinets.OrganizationId;
                                        cabinetAdd.Location = currentCabinets.Location;
                                        cabinets.Add(cabinetAdd);
                                    }
                                    cabinetInfo = cabinets.Where(p => p.CabinetRealNum == cabinetRealNum && p.CabinetChildNum == cabinetChildNum).FirstOrDefault();
                                    bool cabinetResult = _unitOfWork.CabinetRepository.Insert(cabinets, false);
                                }
                                //var policeExist = _unitOfWork.PolicemanRepository.Get(p => p.CabinetId.Equals(cabinetInfo.Id));
                                //if (policeExist != null)
                                //{
                                //    return JsonManager.SimpleStatusResponse(ResultCode.CABINET_SET_ERROR);
                                //}
                                policemanInfo.CabinetId = cabinetInfo.Id;
                                if (!string.IsNullOrEmpty(fingerInfo))
                                {
                                    policemanInfo.FingerInfo1 = fingerInfo;
                                }
                                if (!string.IsNullOrEmpty(fingerInfo2))
                                {
                                    policemanInfo.FingerInfo2 = fingerInfo;
                                }
                                if (!string.IsNullOrEmpty(faceInfo))
                                {
                                    policemanInfo.FaceInfo = faceInfo;
                                }
                                if (!string.IsNullOrEmpty(password))
                                {
                                    policemanInfo.Password = password;
                                }
                                bool result = _unitOfWork.PolicemanRepository.Update(policemanInfo, true);
                                if (result)
                                {
                                    if (EqInv.Count > 0)
                                    {
                                        //上报数据
                                        var httpResult = _httpHelper.GetHtml(new HttpItem()
                                        {
                                            URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                            Encoding = Encoding.UTF8,
                                            Method = "POST",
                                            ContentType = "application/json",
                                            Timeout = 5000,
                                            Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                            {
                                                data = EqInv.Select(x => new
                                                {
                                                    editType = "UPDATE",
                                                    id = x.Id,
                                                    supplierCode = x.SupplierCode,
                                                    epc = x.Epc,
                                                    policeCode = x.PoliceCode,
                                                    equipmentCode = x.EquipmentCode,
                                                    warehouseCode = x.WarehouseCode,
                                                    cabinetId = x.CabinetId,
                                                    equipmentSizecode = x.EquipmentSizecode,
                                                    equipmentLocation = x.EquipmentLocation,
                                                    currentState = x.CurrentState,
                                                    createTime = x.CreateTime,
                                                    warrantyCycle = x.WarrantyCycle,
                                                    repairCycle = x.RepairCycle,
                                                    productTime = x.ProductTime,
                                                    useTime = x.UseTime,
                                                    price = x.Price,
                                                    isBorrowed = x.IsBorrowed,
                                                    lostFlag = x.LostFlag,
                                                    inventoryState = x.InventoryState,
                                                    isInBox = x.IsInBox,
                                                    boxMarkId = x.BoxMarkId,
                                                    instantiationState = x.InstantiationState,
                                                })
                                            }))
                                        });
                                        if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("远端上报数据失败");
                                        }
                                        var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                        if (obj.code != "10000")
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse(obj.msg);
                                        }
                                    }
                                    scope.Commit();
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);

                                }
                                else
                                {
                                    scope.Rollback();
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                }
                            }
                            catch (Exception e)
                            {
                                scope.Rollback();
                                throw;
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 根据单警柜获取该组织机构下全部的警员信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         
        ///         "cabinetNum"://单警柜号
        ///         "type"://all全部,single单警柜下全部警员,allBind//单警柜对应组织机构下的所有人,allUser//单警柜的组织机构下全部已绑定柜子的警员
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllPoliceByCabinet")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetAllPoliceByCabinet([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);


                        string organizationId = entity?.organizationId ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.cabinetNum ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"cabinetNum is require");
                        }
                        else if (string.IsNullOrEmpty(entity.type ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"type is require");
                        }
                        var param = new string[] {
                       "OrgizationCodeNavigation",
                    };
                        string cabinetNum = entity.cabinetNum;
                        string type = entity.type;
                        string cabinetOrg = string.Empty;
                        var cabinets = _unitOfWork.CabinetRepository.GetList(p => p.CabinetRealNum.Equals(cabinetNum)).ToList();
                        if (cabinets.Count > 0)
                        {
                            cabinetOrg = cabinets.FirstOrDefault().OrganizationId;
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.CABINET_ERROR);
                        }

                        Expression<Func<BaseJpPoliceman, bool>> expression = t => t.OrgizationCode.Equals(cabinetOrg);
                        if (type.Equals("single"))
                        {
                            expression = LambdaExtensions.And(expression, t => t.Cabinet.CabinetRealNum == cabinetNum);
                        }
                        else if (type.Equals("all"))
                        {
                            expression = LambdaExtensions.And(expression, t => string.IsNullOrEmpty(t.CabinetId));
                        }
                        else if (type.Equals("allUser"))
                        {
                            expression = LambdaExtensions.And(expression, t => !string.IsNullOrEmpty(t.CabinetId));
                        }
                        else if (type.Equals("allBind"))
                        {

                        }
                        var policeman = _unitOfWork.PolicemanRepository.GetList(expression).ToList();//获取组织机构下全部的警员信息



                        var data = policeman.Select(t => new
                        {
                            userId = t.Id,
                            userCode = t.PoliceCode,
                            faceFeatures = t.FaceInfo,
                            finger1Features = t.FingerInfo1,
                            finger2Features = t.FingerInfo2,
                            userName = t.Name,
                            userSex = t.Sex,
                            psd = t.Password,
                            cabinetChildID = t.Cabinet?.CabinetRealNum + "-" + t.Cabinet?.CabinetChildNum,
                            orgName = t.OrgizationCodeNavigation?.Name,
                            t.CabinetId,
                        });
                        return JsonManager.ReturnSuccessResponse(data);


                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取全部单警柜信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "organizationId":"123",
        ///         "size":10,
        ///         "page":1
        ///         "state"://当前状态
        ///         "boxCode"://柜号
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCabinetListWeb")]
        public async Task<HttpResponseMessage> GetCabinetListWeb([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }
                        string organizationId = entity?.organizationId ?? "";


                        var param = new string[] {
                       "Organization",
                       "BaseJpPolicemen"
                    };


                        string OrgId = Guid.Empty.ToString();
                        if (!String.IsNullOrEmpty(entity.organizationId))
                        {
                            OrgId = entity.organizationId;
                        }

                        Expression<Func<BaseJpCabinet, bool>> expression = t => t.OrganizationId.Equals(OrgId);

                        if (!String.IsNullOrEmpty(entity.state))
                        {
                            string state = entity.state;
                            expression = LambdaExtensions.AndAlso(expression, t => t.State.Equals(int.Parse(state)));
                        }
                        if (!String.IsNullOrEmpty(entity.cabinetNum))
                        {
                            string cabinetNum = entity.cabinetNum;
                            expression = LambdaExtensions.AndAlso(expression, t => t.CabinetNum.Contains(cabinetNum));
                        }


                        var CabinetList = _unitOfWork.CabinetRepository.GetListDe(expression, p => p.CabinetChildNum, false, param);

                        var data = CabinetList.GroupBy(p => p.CabinetRealNum).Select(t => new
                        {
                            count = t.Count(p => p.Id != null),

                            t.FirstOrDefault().CabinetNum,
                            Id = t.FirstOrDefault().CabinetRealNum,
                            t.FirstOrDefault().OrganizationId,
                            t.FirstOrDefault().UseTime,
                            t.FirstOrDefault().BuyTime,

                            t.FirstOrDefault().Organization?.Name,
                            children = t.Select(t => new
                            {
                                policeName = t.BaseJpPolicemen?.FirstOrDefault()?.Name,
                                policeId = t.BaseJpPolicemen?.FirstOrDefault()?.Id,
                                t.BuyTime,
                                t.UseTime,
                                t.CabinetNum,
                                t.OrganizationId,
                                t.Organization?.Name,
                                t.CabinetChildNum,
                                t.State,
                                t.Location,
                                t.ShortName,
                                t.Id,
                                t.Type

                            })
                            //policeName = t.BaseJpPolicemen.FirstOrDefault()?.Name
                        });
                        var content = new
                        {
                            totalElements = data.Count(),
                            content = data.Skip(page * size).Take(size).ToList()
                        };
                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取全部单警柜信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "organizationId":"123",
        ///         "size":10,
        ///         "page":1
        ///         "state"://当前状态
        ///         "cabinetNum"://柜号
        ///         "isCurrentLevel":""//是否本级，true 是，false否
        ///         "type":"柜子类型 0：单警柜 1:值班柜 2：公共柜"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCabinetList")]
        public async Task<HttpResponseMessage> GetCabinetList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }
                        string organizationId = entity?.organizationId ?? "";
                        string isCurrentLevel = entity?.isCurrentLevel ?? "";
                        bool bType = int.TryParse(entity?.type ?? "", out int type);

                        var param = new string[] {
                       "Organization",
                       "BaseJpPolicemen"
                    };

                        Expression<Func<BaseJpOrganization, bool>> expressionOrg = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expressionOrg, t => t.Code).ToList();

                        string OrgId = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.organizationId))
                        {
                            OrgId = entity.organizationId;
                        }


                        Expression<Func<BaseJpCabinet, bool>> expression = t => t.Id != null;
                        if (isCurrentLevel.Equals("True"))//本级
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.OrganizationId.Equals(OrgId));
                        }
                        else //本级及下级
                        {
                            dataList = GetClassID(OrgId);

                            dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(OrgId))).ToList();

                            var orgNewList = _unitOfWork.OrganizationRepository.GetList(expressionOrg).Select(p => p.Id);
                            expression = LambdaExtensions.AndAlso(expression, t => dataList.Select(c => c.Id).Contains(t.OrganizationId));
                        }

                        if (!String.IsNullOrEmpty(entity.state))
                        {
                            string state = entity.state;
                            expression = LambdaExtensions.AndAlso(expression, t => t.State.Equals(int.Parse(state)));
                        }
                        if (!String.IsNullOrEmpty(entity.cabinetNum))
                        {
                            string cabinetNum = entity.cabinetNum;
                            expression = LambdaExtensions.AndAlso(expression, t => t.CabinetRealNum.Contains(cabinetNum));
                        }

                        if (bType)
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.Type == type);
                        }

                        var CabinetList = _unitOfWork.CabinetRepository.GetListDe(expression, p => p.CabinetChildNum, false, param);

                        var data = CabinetList.GroupBy(p => p.CabinetRealNum).Select(t => new
                        {
                            count = t.Count(p => p.Id != null),

                            t.FirstOrDefault().CabinetNum,
                            Id = t.FirstOrDefault().CabinetRealNum,
                            t.FirstOrDefault().OrganizationId,
                            t.FirstOrDefault().UseTime,
                            t.FirstOrDefault().BuyTime,

                            t.FirstOrDefault().Organization?.Name,
                            children = t.Select(t => new
                            {
                                policeName = t.BaseJpPolicemen?.FirstOrDefault()?.Name,
                                policeId = t.BaseJpPolicemen?.FirstOrDefault()?.Id,
                                t.BuyTime,
                                t.UseTime,
                                t.CabinetNum,
                                t.OrganizationId,
                                t.Organization?.Name,
                                t.CabinetChildNum,
                                t.State,
                                t.Location,
                                t.ShortName,
                                t.Id,
                                t.Type
                            })
                            //policeName = t.BaseJpPolicemen.FirstOrDefault()?.Name
                        });
                        var content = new
                        {
                            totalElements = data.Count(),
                            content = data.Skip(page * size).Take(size).ToList()
                        };
                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取全部单警柜信息(第三方使用)
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "organizationId":"123",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCabinetListDevelop")]
        public async Task<HttpResponseMessage> GetCabinetListDevelop([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.organizationId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        string organizationId = entity?.organizationId ?? "";
                        string isCurrentLevel = entity?.isCurrentLevel ?? "";

                        var param = new string[] {
                       "Organization",
                       "BaseJpPolicemen"
                    };

                        Expression<Func<BaseJpOrganization, bool>> expressionOrg = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expressionOrg, t => t.Code).ToList();

                        string OrgId = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.organizationId))
                        {
                            OrgId = entity.organizationId;
                        }


                        Expression<Func<BaseJpCabinet, bool>> expression = t => t.Id != null;
                        if (isCurrentLevel.Equals("True"))//本级
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.OrganizationId.Equals(OrgId));
                        }
                        else //本级及下级
                        {
                            dataList = GetClassID(OrgId);

                            dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(OrgId))).ToList();

                            var orgNewList = _unitOfWork.OrganizationRepository.GetList(expressionOrg).Select(p => p.Id);
                            expression = LambdaExtensions.AndAlso(expression, t => dataList.Select(c => c.Id).Contains(t.OrganizationId));
                        }

                        if (!String.IsNullOrEmpty(entity.state))
                        {
                            string state = entity.state;
                            expression = LambdaExtensions.AndAlso(expression, t => t.State.Equals(int.Parse(state)));
                        }
                        if (!String.IsNullOrEmpty(entity.cabinetNum))
                        {
                            string cabinetNum = entity.cabinetNum;
                            expression = LambdaExtensions.AndAlso(expression, t => t.CabinetRealNum.Contains(cabinetNum));
                        }


                        var CabinetList = _unitOfWork.CabinetRepository.GetListDe(expression, p => p.CabinetChildNum, false, param);

                        var data = CabinetList.GroupBy(p => p.CabinetRealNum).Select(t => new
                        {
                            count = t.Count(p => p.Id != null),

                            t.FirstOrDefault().CabinetNum,
                            Id = t.FirstOrDefault().CabinetRealNum,
                            t.FirstOrDefault().OrganizationId,

                            t.FirstOrDefault().Organization?.Name,
                            children = t.Select(t => new
                            {
                                t.CabinetChildNum,
                                t.Id
                            })
                            //policeName = t.BaseJpPolicemen.FirstOrDefault()?.Name
                        });
                        var content = new
                        {
                            totalElements = data.Count(),
                            content = data.ToList()
                        };
                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取柜子是否存在
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "organizationId":"123",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCabinetIsExist")]
        public async Task<HttpResponseMessage> GetCabinetIsExist([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string organizationId = entity?.organizationId ?? "";

                        var param = new string[] {
                       "Organization",
                       "BaseJpPolicemen"
                    };
                        //0 普通模式，1值班,2 公共柜
                        var djg = _unitOfWork.DbContext.BaseJpCabinets.Any(x => x.OrganizationId == organizationId && x.Type == 0);
                        var zbg = _unitOfWork.DbContext.BaseJpCabinets.Any(x => x.OrganizationId == organizationId && x.Type == 1);
                        var ggg = _unitOfWork.DbContext.BaseJpCabinets.Any(x => x.OrganizationId == organizationId && x.Type == 2);

                        var data = new
                        {
                            djg,
                            zbg,
                            ggg
                        };
                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取全部单警柜对应警员信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "organizationId":"123",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCabinetListPeople")]
        public async Task<HttpResponseMessage> GetCabinetListPeople([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string organizationId = entity?.organizationId ?? "";


                        var param = new string[] {
                       "Organization",
                       "BaseJpPolicemen"
                    };

                        Expression<Func<BaseJpCabinet, bool>> expression = t => t.OrganizationId.Equals(organizationId);

                        var CabinetList = _unitOfWork.CabinetRepository.GetArray(expression, p => p.CabinetChildNum, false, param).ToList();

                        var data = CabinetList.Select(t => new
                        {
                            t.OrganizationId,
                            cabinetId = t.Id,
                            cabinetName = t.CabinetNum + "-" + t.CabinetChildNum,
                            t.BaseJpPolicemen?.FirstOrDefault()?.Name,
                            t.BaseJpPolicemen?.FirstOrDefault()?.PoliceCode,
                            t.BaseJpPolicemen?.FirstOrDefault()?.Id
                        });

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取全部单警柜对应警员信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "organizationId":"123",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCabinetListPeopleSelect")]
        public async Task<HttpResponseMessage> GetCabinetListPeopleSelect([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string organizationId = entity?.organizationId ?? "";


                        var param = new string[] {
                       "Organization",
                       "BaseJpPolicemen"
                    };

                        Expression<Func<BaseJpCabinet, bool>> expression = t => t.OrganizationId.Equals(organizationId) && t.Type.Equals(0);

                        var CabinetList = _unitOfWork.CabinetRepository.GetArray(expression, p => p.CabinetChildNum, true, param).ToList();

                        var data = CabinetList.Select(t => new
                        {
                            t.OrganizationId,
                            cabinetId = t.Id,
                            t.CabinetNum,
                            CabinetChildNum = t.CabinetChildNum + "号柜",
                            t.BaseJpPolicemen?.FirstOrDefault()?.Name,
                            t.BaseJpPolicemen?.FirstOrDefault()?.PoliceCode,
                            t.BaseJpPolicemen?.FirstOrDefault()?.Id
                        }).ToLookup(c => c.CabinetNum);

                        List<Object> returnData = new List<Object>();
                        foreach (var item in data)
                        {
                            var cab = new
                            {
                                label = item.Key,
                                options = item
                            };
                            returnData.Add(cab);
                        }

                        return JsonManager.ReturnSuccessResponse(returnData);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取全部单警柜警员信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "cabinetID":"111111"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPeopleDataInner")]
        public async Task<HttpResponseMessage> GetPeopleDataInner([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"entity is null");

                        }
                        else
                        {
                            string cabinetID = entity?.cabinetID ?? "";
                            if (string.IsNullOrEmpty(cabinetID))
                            {
                                return JsonManager.SimpleCustResponse($"cabinetID is require");

                            }
                            else
                            {
                                var cabinets = _unitOfWork.DbContext.BaseJpCabinets
                                    .Include(t => t.BaseJpPolicemen)
                                    .Where(t => t.CabinetRealNum.Contains(cabinetID));
                                var res_data = new TmpDataInfo()
                                {
                                    cabinetID = cabinetID,
                                    cabinetInfos = new List<TmpPoliceInfo>()
                                };

                                foreach (var cab in cabinets)
                                {
                                    foreach (var police in cab.BaseJpPolicemen)
                                    {
                                        res_data.cabinetInfos.Add(new TmpPoliceInfo()
                                        {
                                            cabinetChildID = cab.CabinetChildNum.ToString(),
                                            rfiddelayTime = 3000,
                                            userId = police.Id,
                                            userCode = police.PoliceCode,
                                            userName = police.Name,
                                            userPhoto = police.Photo,
                                            userSex = police.Sex,
                                            readTime = 3000,
                                            power = null,
                                            sensitivity = null,
                                        });
                                    }
                                }
                                //res_obj["result"]["code"] = "10000";
                                //res_obj["result"]["msg"] = "success";
                                //res_obj["result"]["data"] = JToken.FromObject(res_data);
                                //return JsonManager.SimpleCustResponse(res_obj);
                                return JsonManager.ReturnSuccessResponse(res_data);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);

                    }

                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);

                }
            });
        }

        /// <summary>
        /// 获取全部单警柜警员信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "cabinetID":"111111"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPeopleData")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPeopleData([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                JObject res_obj = new JObject();
                res_obj.Add("result", JToken.FromObject(new
                {
                    code = "19999",
                    msg = "invalid parameter",
                    data = new { },
                    timestamp = JsonManager.GetCurrTimeStamp()
                }));

                try
                {
                    if (jdata != null)
                    {
                        _logger.LogDebug("Cabinet/获取警员信息:" + jdata.ToString());
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse(res_obj);
                        }
                        else
                        {
                            string cabinetID = entity?.cabinetID ?? "";
                            if (string.IsNullOrEmpty(cabinetID))
                            {
                                res_obj["result"]["msg"] = "cabinetID is require";
                                return JsonManager.SimpleCustResponse(res_obj);
                            }
                            else
                            {
                                var cabinets = _unitOfWork.DbContext.BaseJpCabinets
                                    .Include(t => t.BaseJpPolicemen)
                                    .Where(t => t.CabinetRealNum.Contains(cabinetID));
                                var res_data = new TmpDataInfo()
                                {
                                    cabinetID = cabinetID,
                                    cabinetInfos = new List<TmpPoliceInfo>()
                                };

                                foreach (var cab in cabinets)
                                {
                                    foreach (var police in cab.BaseJpPolicemen)
                                    {
                                        res_data.cabinetInfos.Add(new TmpPoliceInfo()
                                        {
                                            cabinetChildID = cab.CabinetChildNum.ToString(),
                                            rfiddelayTime = 3000,
                                            userCode = police.PoliceCode,
                                            userId = police.Id,
                                            userName = police.Name,
                                            userPhoto = police.Photo,
                                            userSex = police.Sex,
                                            readTime = 3000,
                                            power = null,
                                            sensitivity = null,
                                        });
                                    }
                                }
                                res_obj["result"]["code"] = "10000";
                                res_obj["result"]["msg"] = "success";
                                res_obj["result"]["data"] = JToken.FromObject(res_data);
                                return JsonManager.SimpleCustResponse(res_obj);

                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse(res_obj);

                    }

                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleCustResponse(res_obj);

                }
            });
        }

        /// <summary>
        /// 更新单警柜门开关状态
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "cabinetID":"111111",
        ///         "cabinetChildID":"111111",
        ///         "cabinetState":111111,
        ///         "actionTime":"111111"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("StateChange")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> StateChange([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                JObject res_obj = new JObject();
                res_obj.Add("result", JToken.FromObject(new
                {
                    code = "19999",
                    msg = "invalid parameter"
                }));

                try
                {
                    if (jdata != null)
                    {
                        _logger.LogDebug("Cabinet/状态数据上报:" + jdata.ToString());
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse(res_obj);
                        }
                        else
                        {
                            string cabinetID = entity?.cabinetID ?? "";
                            string cabinetChildID = entity?.cabinetChildID ?? "";
                            bool bState = int.TryParse(entity?.cabinetState ?? "0", out int cabinetState);
                            string actionTime = entity?.actionTime ?? "";

                            if (string.IsNullOrEmpty(cabinetID))
                            {
                                res_obj["result"]["msg"] = "cabinetID is require";
                                return JsonManager.SimpleCustResponse(res_obj);

                            }
                            else if (string.IsNullOrEmpty(cabinetChildID))
                            {
                                res_obj["result"]["msg"] = "cabinetChildID is require";
                                return JsonManager.SimpleCustResponse(res_obj);

                            }
                            else if (!bState || (cabinetState != 0 && cabinetState != 1))
                            {
                                res_obj["result"]["msg"] = "invalid parameter cabinetState";
                                return JsonManager.SimpleCustResponse(res_obj);

                            }
                            else
                            {
                                var cabinets = _unitOfWork.DbContext.BaseJpCabinets
                                    .Include(t => t.BaseJpPolicemen)
                                    .FirstOrDefault(t => t.CabinetRealNum.Contains(cabinetID)
                                    && t.CabinetChildNum.ToString().Contains(cabinetChildID));

                                if (cabinets == null)
                                {
                                    res_obj["result"]["code"] = "19999";
                                    res_obj["result"]["msg"] = "cabinet does not exist";
                                }
                                else
                                {
                                    res_obj["result"]["code"] = "10000";
                                    res_obj["result"]["msg"] = "success";
                                    cabinets.State = cabinetState;
                                    var result = _unitOfWork.CabinetRepository.Update(cabinets);
                                    if (!result)
                                    {
                                        res_obj["result"]["code"] = "19999";
                                        res_obj["result"]["msg"] = "operation failed";
                                    }
                                }

                                return JsonManager.SimpleCustResponse(res_obj);

                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse(res_obj);
                    }

                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleCustResponse(res_obj);
                }
            });
        }

        /// <summary>
        /// 物资绑定柜门（公共柜用）
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "cabinetID":"主柜号",
        ///         "cabinetChildID":"箱号",
        ///         "RFIDList":
        ///          [
        ///              {
        ///                  "RFID":"RFID信息" 
        ///              }
        ///          ] 
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("BindingInventory")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> BindingInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"entity is null");
                        }
                        else
                        {
                            string cabinetRealNum = entity.cabinetID ?? "";
                            bool bCabinetChildNum = int.TryParse(entity.cabinetChildID, out int cabinetChildNum);

                            List<string> Rfids = new List<string>();
                            if (entity.RFIDList != null)
                            {
                                foreach (var item in entity.RFIDList)
                                {
                                    //string rfidItem = item;
                                    if (!string.IsNullOrEmpty(item))
                                    {
                                        //var rfidLeft = item.PadLeft(48, '0');
                                        var rfidLeft = item;//对方EPC格式有问题，更正后开启
                                        Rfids.Add(rfidLeft);//上报的RFID
                                    }
                                }
                            }

                            if (string.IsNullOrEmpty(cabinetRealNum))
                            {
                                return JsonManager.SimpleCustResponse("cabinetId is require");
                            }
                            if (!bCabinetChildNum)
                            {
                                return JsonManager.SimpleCustResponse("cabinetChildID is require");

                            }
                            if (Rfids.Count == 0)
                            {
                                return JsonManager.SimpleCustResponse("Rfids is require");
                            }


                            var cabinet = _unitOfWork.DbContext.BaseJpCabinets
                                .FirstOrDefault(t => t.CabinetRealNum == cabinetRealNum && t.CabinetChildNum == cabinetChildNum);
                            if (cabinet == null)
                            {
                                return JsonManager.SimpleCustResponse("无效柜号，请检查配置");
                            }

                            using (var scope = _unitOfWork.BeginTransaction())
                            {
                                try
                                {
                                    var invList = new List<CommonJpEquipmentInventory>();
                                    foreach (var epc in Rfids)
                                    {
                                        var inv = _unitOfWork.DbContext.CommonJpEquipmentInventories
                                            .Include(x => x.EquipmentCodeNavigation)
                                            .Include(x => x.EquipmentSizecodeNavigation)
                                            .FirstOrDefault(x => x.Epc == epc);
                                        if (inv == null)
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("无效物资");
                                        }

                                        if (inv.CurrentState != 8)
                                        {
                                            //物资状态不是领用报错
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("物资状态不是领用");
                                        }
                                        inv.CabinetId = cabinet.Id;
                                        _unitOfWork.EquipmentInventoryRepository.Update(inv, false);
                                        invList.Add(inv);
                                    }

                                    if (_unitOfWork.SaveChanges() > 0)
                                    {
                                        var httpResult = _httpHelper.GetHtml(new HttpItem()
                                        {
                                            URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                            Encoding = Encoding.UTF8,
                                            Method = "POST",
                                            ContentType = "application/json",
                                            Timeout = 5000,
                                            Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                            {
                                                data = invList.Select(x => new
                                                {
                                                    editType = "UPDATE",
                                                    id = x.Id,
                                                    supplierCode = x.SupplierCode,
                                                    epc = x.Epc,
                                                    policeCode = x.PoliceCode,
                                                    equipmentCode = x.EquipmentCode,
                                                    warehouseCode = x.WarehouseCode,
                                                    cabinetId = x.CabinetId,
                                                    equipmentSizecode = x.EquipmentSizecode,
                                                    equipmentLocation = x.EquipmentLocation,
                                                    currentState = x.CurrentState,
                                                    createTime = x.CreateTime,
                                                    warrantyCycle = x.WarrantyCycle,
                                                    repairCycle = x.RepairCycle,
                                                    productTime = x.ProductTime,
                                                    useTime = x.UseTime,
                                                    price = x.Price,
                                                    isBorrowed = x.IsBorrowed,
                                                    lostFlag = x.LostFlag,
                                                    inventoryState = x.InventoryState,
                                                    isInBox = x.IsInBox,
                                                    boxMarkId = x.BoxMarkId,
                                                    instantiationState = x.InstantiationState,
                                                })
                                            }))
                                        });
                                        if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("远端上报数据失败");
                                        }
                                        var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                        if (obj.code != "10000")
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse(obj.msg);
                                        }
                                        scope.Commit();
                                        return JsonManager.ReturnSuccessResponse(invList.Select(x => new
                                        {
                                            epc = x.Epc,
                                            equName = x.EquipmentCodeNavigation?.Name,
                                            sizeName = x.EquipmentSizecodeNavigation?.SizeName,
                                            warrantyCycle = x.WarrantyCycle,
                                            expireTime = x.ProductTime?.AddMonths(x.WarrantyCycle ?? 0)
                                        }));
                                    }
                                    else
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                    }

                                }
                                catch (Exception e)
                                {
                                    scope.Rollback();
                                    throw;
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 物资绑定人员（公共柜用，目前只绑定人不更新物资状态）
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///
        ///     {
        ///         "isBind":"true 绑定 false 解绑"
        ///         "policeId":"警员id",
        ///         "RFIDList":
        ///          [
        ///              {
        ///                  "RFID":"RFID信息" 
        ///              }
        ///          ] 
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("BindingInventoryByPoliceId")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> BindingInventoryByPoliceId([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"entity is null");
                        }
                        else
                        {
                            string policeId = entity.policeId ?? "";

                            List<string> Rfids = new List<string>();
                            if (entity.RFIDList != null)
                            {
                                foreach (var item in entity.RFIDList)
                                {
                                    //string rfidItem = item;
                                    if (!string.IsNullOrEmpty(item.RFID))
                                    {
                                        //var rfidLeft = item.PadLeft(48, '0');
                                        var rfidLeft = item.RFID;//对方EPC格式有问题，更正后开启
                                        Rfids.Add(rfidLeft);//上报的RFID
                                    }
                                }
                            }

                            var bIsBind = bool.TryParse(entity.isBind, out bool isBind);
                            if (!bIsBind)
                            {
                                return JsonManager.SimpleCustResponse("isBind is require");
                            }
                            if (Rfids.Count == 0)
                            {
                                return JsonManager.SimpleCustResponse("Rfids is require");
                            }

                            using (var scope = _unitOfWork.BeginTransaction())
                            {
                                try
                                {

                                    if (isBind)
                                    {
                                        //绑定
                                        if (string.IsNullOrEmpty(policeId))
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("policeId is require");
                                        }
                                        var police = _unitOfWork.PolicemanRepository.Get(policeId);
                                        if (police == null)
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("policeId is require");
                                        }

                                        var invList = new List<CommonJpEquipmentInventory>();
                                        foreach (var epc in Rfids)
                                        {
                                            var inv = _unitOfWork.DbContext.CommonJpEquipmentInventories
                                                .Include(x => x.EquipmentCodeNavigation)
                                                .Include(x => x.EquipmentSizecodeNavigation)
                                                .FirstOrDefault(x => x.Epc == epc);
                                            if (inv == null)
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("操作失败", new
                                                {
                                                    error = new
                                                    {
                                                        errEpc = epc,
                                                        errMsg = "无效物资",
                                                        equipmentName = (string)null
                                                    }
                                                });
                                            }

                                            if (inv.CurrentState == 6)
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("操作失败", new
                                                {
                                                    error = new
                                                    {
                                                        errEpc = epc,
                                                        errMsg = "物资已报废",
                                                        equipmentName = inv.EquipmentCodeNavigation?.Name
                                                    }
                                                });
                                            }
                                            if (!string.IsNullOrEmpty(inv.PoliceCode))
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("操作失败", new
                                                {
                                                    error = new
                                                    {
                                                        errEpc = epc,
                                                        errMsg = "物资已被绑定",
                                                        equipmentName = inv.EquipmentCodeNavigation?.Name
                                                    }
                                                });
                                            }
                                            inv.PoliceCode = police.Id;
                                            _unitOfWork.EquipmentInventoryRepository.Update(inv, false);
                                            invList.Add(inv);
                                        }

                                        if (_unitOfWork.SaveChanges() > 0)
                                        {
                                            //上报数据
                                            var httpResult = _httpHelper.GetHtml(new HttpItem()
                                            {
                                                URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                                Encoding = Encoding.UTF8,
                                                Method = "POST",
                                                ContentType = "application/json",
                                                Timeout = 5000,
                                                Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                                {
                                                    data = invList.Select(x => new
                                                    {
                                                        editType = "UPDATE",
                                                        id = x.Id,
                                                        supplierCode = x.SupplierCode,
                                                        epc = x.Epc,
                                                        policeCode = x.PoliceCode,
                                                        equipmentCode = x.EquipmentCode,
                                                        warehouseCode = x.WarehouseCode,
                                                        cabinetId = x.CabinetId,
                                                        equipmentSizecode = x.EquipmentSizecode,
                                                        equipmentLocation = x.EquipmentLocation,
                                                        currentState = x.CurrentState,
                                                        createTime = x.CreateTime,
                                                        warrantyCycle = x.WarrantyCycle,
                                                        repairCycle = x.RepairCycle,
                                                        productTime = x.ProductTime,
                                                        useTime = x.UseTime,
                                                        price = x.Price,
                                                        isBorrowed = x.IsBorrowed,
                                                        lostFlag = x.LostFlag,
                                                        inventoryState = x.InventoryState,
                                                        isInBox = x.IsInBox,
                                                        boxMarkId = x.BoxMarkId,
                                                        instantiationState = x.InstantiationState,
                                                    })
                                                }))
                                            });
                                            if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("远端上报数据失败");
                                            }
                                            var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                            if (obj.code != "10000")
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse(obj.msg);
                                            }
                                            scope.Commit();
                                            var success = invList.Select(x => new
                                            {
                                                successEpc = x.Epc,
                                                equipmentName = x.EquipmentCodeNavigation?.Name
                                            });
                                            return JsonManager.ReturnSuccessResponse(new
                                            {
                                                success = success
                                            }
                                            );
                                        }
                                        scope.Rollback();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                    }
                                    else
                                    {
                                        //解绑
                                        var invList = new List<CommonJpEquipmentInventory>();
                                        foreach (var epc in Rfids)
                                        {
                                            var inv = _unitOfWork.DbContext.CommonJpEquipmentInventories
                                                .Include(x => x.EquipmentCodeNavigation)
                                                .Include(x => x.EquipmentSizecodeNavigation)
                                                .FirstOrDefault(x => x.Epc == epc);
                                            if (inv == null)
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("操作失败", new
                                                {
                                                    error = new
                                                    {
                                                        errEpc = epc,
                                                        errMsg = "无效物资",
                                                        equipmentName = (string)null
                                                    }
                                                });
                                            }

                                            inv.PoliceCode = null;
                                            _unitOfWork.EquipmentInventoryRepository.Update(inv, false);
                                            invList.Add(inv);
                                        }
                                        if (_unitOfWork.SaveChanges() > 0)
                                        {
                                            //上报数据
                                            var httpResult = _httpHelper.GetHtml(new HttpItem()
                                            {
                                                URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                                Encoding = Encoding.UTF8,
                                                Method = "POST",
                                                ContentType = "application/json",
                                                Timeout = 5000,
                                                Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                                {
                                                    data = invList.Select(x => new
                                                    {
                                                        editType = "UPDATE",
                                                        id = x.Id,
                                                        supplierCode = x.SupplierCode,
                                                        epc = x.Epc,
                                                        policeCode = x.PoliceCode,
                                                        equipmentCode = x.EquipmentCode,
                                                        warehouseCode = x.WarehouseCode,
                                                        cabinetId = x.CabinetId,
                                                        equipmentSizecode = x.EquipmentSizecode,
                                                        equipmentLocation = x.EquipmentLocation,
                                                        currentState = x.CurrentState,
                                                        createTime = x.CreateTime,
                                                        warrantyCycle = x.WarrantyCycle,
                                                        repairCycle = x.RepairCycle,
                                                        productTime = x.ProductTime,
                                                        useTime = x.UseTime,
                                                        price = x.Price,
                                                        isBorrowed = x.IsBorrowed,
                                                        lostFlag = x.LostFlag,
                                                        inventoryState = x.InventoryState,
                                                        isInBox = x.IsInBox,
                                                        boxMarkId = x.BoxMarkId,
                                                        instantiationState = x.InstantiationState,
                                                    })
                                                }))
                                            });
                                            if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("远端上报数据失败");
                                            }
                                            var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                            if (obj.code != "10000")
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse(obj.msg);
                                            }
                                            scope.Commit();
                                            var success = invList.Select(x => new
                                            {
                                                successEpc = x.Epc,
                                                equipmentName = x.EquipmentCodeNavigation?.Name
                                            });
                                            return JsonManager.ReturnSuccessResponse(new
                                            {
                                                success = success
                                            }
                                            );
                                        }
                                        scope.Rollback();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                    }
                                }
                                catch (Exception e)
                                {
                                    scope.Rollback();
                                    throw;
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
    }
    class CabinetInfo
    {
        public string[] RFIDList { get; set; }
        public string cabinetChildID { get; set; }
        public string cabinetID { get; set; }
    }
    class TmpPoliceInfo
    {
        public string cabinetChildID { get; set; }
        public string userName { get; set; }
        public string userId { get; set; }
        public string userPhoto { get; set; }
        public string userSex { get; set; }
        public string userCode { get; set; }
        public int rfiddelayTime { get; set; }
        public int readTime { get; set; }
        public int? sensitivity { get; set; }
        public int? power { get; set; }
    }
    class TmpDataInfo
    {
        public string cabinetID { get; set; } = "";
        public List<TmpPoliceInfo> cabinetInfos { get; set; } = new List<TmpPoliceInfo>();
    }

    /// <summary>
    /// 返回给单警柜的数据信息
    /// </summary>
    class SendMsg
    {
        public string BoxNum { get; set; }
        public string UserName { get; set; }
        public string CurrentUserName { get; set; }
        public string EPC { get; set; }
        public string State { get; set; }
        public string Name { get; set; }
        public string Time { get; set; }
        public string Msg { get; set; }
    }
    class OutLineRfid
    {

        public string cabinetID { get; set; }
        public string cabinetChildID { get; set; }
        public string time { get; set; }
        public List<string> RFIDList { get; set; }

    }


}