﻿using LiteDB;
using Microsoft.Extensions.Logging;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;

namespace JmpCommon.Tools
{
    /// <summary>
    /// EPC生成公共类
    /// </summary>
    public static class GenerateEpcNum
    {
        private static object syncObj = new object();
        //private static List<NumInfo> genList = new List<NumInfo>();

        ///// <summary>
        ///// 生成EPC流水
        ///// </summary>
        ///// <param name="supplierCode">供应商代码</param>
        ///// <param name="equcode">物资代码</param>
        ///// <returns></returns>
        //private static ushort GenNum(string supplierCode, string equcode, string sizeCode, uint productTime)
        //{
        //    //初次加载数据
        //    if (genList.Count == 0) { genList = QueryList(); }

        //    var gen = genList.FirstOrDefault(t => t.ProductTime == productTime && t.SizeCode == sizeCode && t.EquCode == equcode && t.SupplierCode == supplierCode);
        //    if (gen == null)
        //    {
        //        gen = new NumInfo()
        //        {
        //            SizeCode = sizeCode,
        //            ProductTime = productTime,
        //            SupplierCode = supplierCode,
        //            EquCode = equcode,
        //            Num = 1
        //        };
        //        var res = AddOrUpdate(gen);
        //        if (res.Item1)
        //        {
        //            gen.Id = res.Item2;
        //            genList.Add(gen);
        //            return gen.Num;
        //        }
        //        else { return 9998; }
        //    }
        //    else
        //    {
        //        ushort num = (ushort)(gen.Num + 1);
        //        if (num > 4095)
        //        {
        //            return 9999;
        //        }
        //        else
        //        {
        //            return num;
        //        }
        //    }
        //}

        ///// <summary>
        ///// 查询本地库缓存记录
        ///// </summary>
        ///// <returns></returns>
        //private static List<NumInfo> QueryList()
        //{
        //    var path = AppContext.BaseDirectory;
        //    using (var db = new LiteDatabase($"{path}generateepc.db"))
        //    {
        //        // Get customer collection
        //        var col = db.GetCollection<NumInfo>("NumInfo");
        //        if (col != null)
        //        {
        //            return col.FindAll().ToList();
        //        }
        //        else
        //        {
        //            return new List<NumInfo>();
        //        }
        //    }

        //}

        ///// <summary>
        ///// 更新最新流水至本地库
        ///// </summary>
        ///// <param name="entity"></param>
        ///// <returns></returns>
        //private static Tuple<bool, int> AddOrUpdate(NumInfo entity)
        //{
        //    var path = AppContext.BaseDirectory;
        //    using (var db = new LiteDatabase($"{path}generateepc.db"))
        //    {
        //        // Get customer collection
        //        var col = db.GetCollection<NumInfo>("NumInfo");

        //        if (entity.Id == 0)
        //        {
        //            var res = col.Insert(entity);
        //            return new Tuple<bool, int>(res.AsInt32 > 0, res.AsInt32);
        //        }
        //        else
        //        {
        //            var res = col.Update(entity);
        //            return new Tuple<bool, int>(res, entity.Id);
        //        }
        //    }

        //}

        ///// <summary>
        ///// 更新最新流水至本地库
        ///// </summary>
        ///// <param name="entity"></param>
        ///// <returns></returns>
        //private static void AddOrUpdate(string gysdm, string equCode, string sizeCode, uint productTime, ushort num)
        //{
        //    var path = AppContext.BaseDirectory;
        //    using (var db = new LiteDatabase($"{path}generateepc.db"))
        //    {
        //        var col = db.GetCollection<NumInfo>("NumInfo");
        //        var entity = genList.FirstOrDefault(t => t.ProductTime == productTime && t.SizeCode == sizeCode && t.EquCode == equCode && t.SupplierCode == gysdm);
        //        if (entity != null)
        //        {
        //            entity.Num = num;
        //            col.Update(entity);
        //        }
        //        else
        //        {
        //            return;
        //        }
        //    }

        //}

        ///// <summary>
        ///// 生成1.0版本EPC
        ///// </summary>
        ///// <param name="wzdm">物资代码</param>
        ///// <param name="gysdm">供应商代码</param>
        ///// <param name="orgCode">组织机构</param>
        ///// <param name="packType">包装类型</param>
        ///// <param name="wzsl">生成张数</param>
        ///// <param name="epcsl">EPC内数量</param>
        ///// <returns></returns>
        //public static List<GenEpcInfo> GenEpcs(string equCode, string supplierCode, string sizeCode, uint productTime, out string msg, int wzsl = 1)
        //{
        //    try
        //    {
        //        msg = string.Empty;
        //        lock (syncObj)
        //        {
        //            var _wzdm = Convert.ToUInt64(equCode, 16);
        //            var _hxdm = Convert.ToUInt64(sizeCode, 16);
        //            if (_wzdm <= 0 || _hxdm > 0xff)
        //            {
        //                msg = "物资代码或号型代码无效";
        //                return new List<GenEpcInfo>();
        //            }
        //            else
        //            {
        //                List<GenEpcInfo> epcList = new List<GenEpcInfo>();
        //                Analyzingepc epc = new Analyzingepc();
        //                epc.Header = 17;
        //                epc.IssuerId = 1;
        //                epc.OrganizationCode = supplierCode.PadLeft(9, '0').ToUpper();
        //                epc.WzdmLen = 7;
        //                epc.ProductionDate = productTime;
        //                //epc.ExpiryDateUnit= 10;
        //                //epc.ExpiryDate = warrantyCycle;
        //                epc.Wzdm = _wzdm;
        //                epc.Hxdm = _hxdm;
        //                epc.SerialLen = 0xD;
        //                epc.Ver = 0x01;
        //                epc.TagType = 0;
        //                epc.PackingType = 1;
        //                epc.ProductionDate = Convert.ToUInt32(DateTime.Now.ToString("yyMMdd"), 16);
        //                epc.ExpiryDateUnit = 2;
        //                epc.SubPackageNum = 0;
        //                epc.WzCount = 1;
        //                epc.BoxNo = 0;

        //                //获取供应商对应的物资流水号
        //                var num = GenNum(supplierCode, equCode, sizeCode, productTime);
        //                var tmp = num + wzsl - 1;
        //                if (num == 9999)
        //                {
        //                    msg = $"当前日期流水号已满，请更换日期后重试";
        //                    return new List<GenEpcInfo>();
        //                }
        //                else if (num == 9998)
        //                {
        //                    msg = $"流水号生成失败，请更换日期后重试";
        //                    return new List<GenEpcInfo>();
        //                }
        //                else if (tmp > 4095)
        //                {
        //                    msg = $"数量超出当日剩余流水号，剩余{4095 - (num - 1)}个";
        //                    return new List<GenEpcInfo>();
        //                }
        //                else
        //                {
        //                    for (int i = 0; i < wzsl; i++)
        //                    {
        //                        epc.NoInBox = num;
        //                        string res_epc = EpcConvert.Hex16ByteToHex16String(EpcConvert.Epc1Gen(epc)).Replace(" ", "");
        //                        epcList.Add(new GenEpcInfo()
        //                        {
        //                            Num = num,
        //                            Epc = res_epc
        //                        });

        //                        //判断最后一轮循环
        //                        if (i == (wzsl - 1))
        //                        {
        //                            break;
        //                        }
        //                        else
        //                        {
        //                            num++;
        //                        }
        //                    }
        //                    //更新最后流水至数据库
        //                    AddOrUpdate(supplierCode, equCode, sizeCode, productTime, num);
        //                    return epcList;
        //                }
        //            }
        //        }

        //    }
        //    catch (Exception ex)
        //    {
        //        msg = ex.Message ?? ex.InnerException?.Message ?? "";
        //        return new List<GenEpcInfo>();
        //    }
        //}

        /// <summary>
        /// 生成2.0版本EPC
        /// </summary>
        /// <param name="serverNum"></param>
        /// <param name="equCode"></param>
        /// <param name="supplierCode"></param>
        /// <param name="sizeCode"></param>
        /// <param name="productTime"></param>
        /// <param name="msg"></param>
        /// <param name="wzsl"></param>
        /// <returns></returns>
        public static List<GenEpcInfo> GenEpcs(byte serverNum, ulong equCode, string supplierCode, ulong sizeCode, uint productTime, out string msg, int wzsl = 1)
        {
            if (wzsl > 4095)
            {
                msg = "单次生成数量不能超过4095";
                return new List<GenEpcInfo>();
            }
            else
            {

                List<GenEpcInfo> epcList = new List<GenEpcInfo>();
                Analyzingepc epc = new Analyzingepc();
                epc.Header = 17;
                epc.IssuerId = 1;
                epc.OrganizationCode = supplierCode.PadLeft(9, '0').ToUpper();
                epc.WzdmLen = 7;
                epc.ProductionDate = productTime;
                epc.Wzdm = Convert.ToUInt64($"{equCode}", 16);
                epc.Hxdm = Convert.ToUInt64($"{sizeCode}", 16); ;
                epc.SerialLen = 0xD;
                epc.Ver = 0x02;
                epc.TagType = 0;
                epc.PackingType = 1;
                epc.ProductionDate = Convert.ToUInt32(DateTime.Now.ToString("yyMMdd"), 16);

                epc.MachineNum = serverNum;
                epc.NoInBox = 1;
                ushort num = 1;
                for (int i = 0; i < wzsl; i++)
                {
                    epc.TimeSpan = GetTimeStamp();
                    epc.NoInBox = num;
                    string res_epc = EpcConvert.Hex16ByteToHex16String(EpcConvert.Epc2Gen(epc)).Replace(" ", "");
                    epcList.Add(new GenEpcInfo()
                    {
                        Num = num,
                        Epc = res_epc
                    });
                    num++;

                }
                msg = "";
                return epcList;
            }

        }

        /// <summary>
        /// 生成1.0版本EPC(箱标）
        /// 注：箱标生成字段只有1.0epc存在
        /// </summary>
        /// <param name="serverNum"></param>
        /// <param name="equCode"></param>
        /// <param name="supplierCode"></param>
        /// <param name="sizeCode"></param>
        /// <param name="productTime"></param>
        /// <param name="oneBoxNum">单箱数量</param>
        /// <param name="boxNo">包装箱序列号 redis设置保存</param>
        /// <param name="msg"></param>
        /// <param name="wzsl"></param>
        /// <returns></returns>
        public static List<GenEpcInfo> GenBoxMarkEpcs(byte serverNum, ulong equCode, string supplierCode, ulong sizeCode, uint productTime, uint oneBoxNum, uint boxNo, out string msg, int wzsl = 1)
        {
            if (wzsl > 4095)
            {
                msg = "单次生成数量不能超过4095";
                return new List<GenEpcInfo>();
            }
            else
            {

                List<GenEpcInfo> epcList = new List<GenEpcInfo>();
                Analyzingepc epc = new Analyzingepc();
                epc.Header = 17;
                epc.IssuerId = 1;
                epc.OrganizationCode = supplierCode.PadLeft(9, '0').ToUpper();
                epc.WzdmLen = 7;
                epc.ProductionDate = productTime;
                epc.Wzdm = Convert.ToUInt64($"{equCode}", 16);
                epc.Hxdm = Convert.ToUInt64($"{sizeCode}", 16); ;
                epc.SerialLen = 0xD;
                epc.Ver = 0x01;         //版本1.0
                epc.TagType = 0x01;     //箱标标记
                epc.PackingType = 1;
                epc.WzCount = (ushort)oneBoxNum;
                epc.ProductionDate = Convert.ToUInt32(DateTime.Now.ToString("yyMMdd"), 16);

                epc.MachineNum = serverNum;
                epc.BoxNo = boxNo;
                epc.NoInBox = 1;
                ushort num = 1;
                for (int i = 0; i < wzsl; i++)
                {
                    epc.TimeSpan = GetTimeStamp();
                    epc.NoInBox = num;
                    string res_epc = EpcConvert.Hex16ByteToHex16String(EpcConvert.Epc1Gen(epc)).Replace(" ", "");
                    epcList.Add(new GenEpcInfo()
                    {
                        Num = num,
                        Epc = res_epc
                    });
                    num++;

                }
                msg = "";
                return epcList;
            }

        }

        /// <summary>
        /// 生成1.0版本EPC(装备包）
        /// 注：装备包生成字段只有1.0epc存在
        /// </summary>
        /// <param name="serverNum"></param>
        /// <param name="equCode"></param>
        /// <param name="supplierCode"></param>
        /// <param name="sizeCode"></param>
        /// <param name="productTime"></param>
        /// <param name="oneBoxNum">单箱数量</param>
        /// <param name="boxNo">包装箱序列号 redis设置保存</param>
        /// <param name="msg"></param>
        /// <param name="wzsl"></param>
        /// <returns></returns>
        public static List<GenEpcInfo> GenBagEpcs(byte serverNum, uint productTime, uint oneBoxNum, uint boxNo, out string msg, int wzsl = 1)
        {
            if (wzsl > 4095)
            {
                msg = "单次生成数量不能超过4095";
                return new List<GenEpcInfo>();
            }
            else
            {
                List<GenEpcInfo> epcList = new List<GenEpcInfo>();
                Analyzingepc epc = new Analyzingepc();
                epc.Header = 17;
                epc.IssuerId = 1;
                epc.OrganizationCode = "".PadLeft(9, '0').ToUpper();
                epc.WzdmLen = 7;
                epc.ProductionDate = productTime;
                epc.Wzdm = Convert.ToUInt64($"0", 16);
                epc.Hxdm = Convert.ToUInt64($"0", 16);
                epc.SerialLen = 0xD;
                epc.Ver = 0x01;         //版本1.0
                epc.TagType = 0x02;     //装备包标记
                epc.PackingType = 1;
                epc.WzCount = (ushort)oneBoxNum;
                epc.ProductionDate = Convert.ToUInt32(DateTime.Now.ToString("yyMMdd"), 16);

                epc.MachineNum = serverNum;
                epc.BoxNo = boxNo;
                epc.NoInBox = 1;
                ushort num = 1;
                for (int i = 0; i < wzsl; i++)
                {
                    epc.TimeSpan = GetTimeStamp();
                    epc.NoInBox = num;
                    string res_epc = EpcConvert.Hex16ByteToHex16String(EpcConvert.Epc1Gen(epc)).Replace(" ", "");
                    epcList.Add(new GenEpcInfo()
                    {
                        Num = num,
                        Epc = res_epc
                    });
                    num++;
                }
                msg = "";
                return epcList;
            }
        }

        /// <summary>
        /// 获取时间戳
        /// </summary>
        /// <returns></returns>
        private static ulong GetTimeStamp()
        {
            TimeSpan ts = DateTime.UtcNow - new DateTime(1970, 1, 1, 0, 0, 0, 0);
            return Convert.ToUInt64(ts.TotalMilliseconds);
        }
        ///// <summary>
        ///// 回滚流水，避免浪费
        ///// </summary>
        ///// <param name="wzdm"></param>
        ///// <param name="gysdm"></param>
        ///// <param name="hxdm"></param>
        ///// <param name="productTime"></param>
        ///// <param name="wzsl"></param>
        //public static void RollBackNum(string equCode, string supplierCode, string sizeCode, uint productTime, int wzsl = 1)
        //{
        //    lock (syncObj)
        //    {
        //        var gen = genList.FirstOrDefault(t => t.ProductTime == productTime && t.EquCode == equCode && t.SupplierCode == supplierCode && t.SizeCode == sizeCode);
        //        if (gen == null) { return; }
        //        else
        //        {
        //            var res = gen.Num - (ushort)wzsl;
        //            if (res < 0) { return; }
        //            else
        //            {
        //                gen.Num = (ushort)res;
        //                AddOrUpdate(gen);
        //            }
        //        }
        //    }
        //}

        /// <summary>
        /// EPC流水缓存表
        /// </summary>
        //public class NumInfo
        //{
        //    public uint ProductTime { get; set; }
        //    public int Id { get; set; }
        //    public string SupplierCode { get; set; }
        //    //public DateTime GenDate { get; set; }
        //    public string EquCode { get; set; }
        //    public string SizeCode { get; set; }
        //    public ushort Num { get; set; }
        //}

        public class GenEpcInfo
        {
            public int Num { get; set; }
            public string Epc { get; set; }
        }
    }
}
