'use strict';
/**
 * <pre>
 *
 * 描述：封装APDU指令的响应
 * 版本：1.0.0
 * 日期：2019/01/16
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */


const statusCodes = {
    '^9000$': '正常结束',
    '^61(.{2})$': '正常结束，有XX个有效数据可取'
};


class ResApdu {

    constructor(buffer) {
        this.buffer = buffer;
        this.data = buffer.toString('hex');
    }

    /**
     * 获取响应的4位状态码
     */
    getStatusCode() {
        return this.data.substr(-4);
    }

    /**
     * 获取响应的数据
     */
    getDataOnly() {
        return this.data.substr(0, this.data.length - 4);
    }

    /**
     * 响应是否成功
     */
    isOk() {
        return this.getStatusCode() === '9000';
    }

    buffer() {
        return this.buffer;
    }

    /**
     * 验证61XX响应码是否还有数据需要读取
     */
    hasMoreBytesAvailable() {
        return this.data.substr(-4, 2) === '61';
    }

    /**
     * 结合61XX返回byte的长度
     * @see hasMoreBytesAvailable
     */
    numberOfBytesAvailable() {
        let hexLength = this.data.substr(-2, 2);
        return parseInt(hexLength, 16);
    }

    /**
     * 是否长度错误
     */
    isWrongLength() {
        return this.data.substr(-4, 2) === '6c';
    }

    /**
     * 校正长度
     */
    correctLength() {
        let hexLength = this.data.substr(-2, 2);
        return parseInt(hexLength, 16);
    }

    toString() {
        return this.data.toString('hex');
    }

}


export default ResApdu;