'use strict';

/**
 * <pre>
 *
 *
 * 描述：读写器设备操作
 * 版本：1.0.0
 * 日期：2019/01/16
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */

const pcsclite = require('@pokusew/pcsclite');
import {EventEmitter} from 'events';
import Device from './Device';


class Devices extends EventEmitter {
    constructor() {
        super();
        this.pcsc = pcsclite();
        this.devices = {};

        this.pcsc.on('reader', (reader) => {
            const device = new Device(reader);
            this.devices[reader.name] = device;

            //设备保活事件
            this.emit('device-activated', {device, devices: this.listDevices()});

            //设备断开
            reader.on('end', () => {
                delete this.devices[reader.name];
                this.emit('device-deactivated', {device, devices: this.listDevices()});
            });
            //设备异常错误
            reader.on('error', (error) => {
                this.emit('error', {reader, error});
            });
        });

        this.pcsc.on('error', (error) => {
            this.emit('error', {error});
        });
    }

    /**
     * 设备激活状态
     */
    onActivated() {
        return new Promise((resolve, reject) => {
            this.on('device-activated', event => resolve(event));
        });
    };

    /**
     * 设备非激活状态
     */
    onDeactivated() {
        return new Promise((resolve, reject) => {
            this.on('device-deactivated', event => resolve(event));
        });
    };

    /**
     * 设备列表
     */
    listDevices() {
        return Object.keys(this.devices).map((k) => this.devices[k])
    };

    lookup(name) {
        return this.devices[name];
    };

    toString() {
        return `Devices('${this.listDevices()}')`;
    }
}


module.exports = Devices;