'use strict';
/**
 * <pre>
 *
 *
 * 描述：设备对卡的操作
 * 版本：1.0.0
 * 日期：2019/01/16
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */

import Card from './Card';
import {EventEmitter} from 'events';

class Device extends EventEmitter {

    constructor(reader) {
        super();
        this.reader = reader;
        this.name = reader.name;
        this.card = null;

        /**
         * 卡片是否已插入
         *
         * @param changes
         * @param reader  读写设备
         * @param status  设备状态值
         */
        const isCardInserted = (changes, reader, status) => {
            return (changes & reader.SCARD_STATE_PRESENT) && (status.state & reader.SCARD_STATE_PRESENT);
        };

        /**
         * 卡片是否已拔出
         *
         * @param changes
         * @param reader  读写设备
         * @param status  设备状态值
         */
        const isCardRemoved = (changes, reader, status) => {
            return (changes & reader.SCARD_STATE_EMPTY) && (status.state & reader.SCARD_STATE_EMPTY);
        };

        /**
         * 卡片已插入
         */
        const cardInserted = (reader, status) => {
            reader.connect({share_mode: 2}, (err, protocol) => {
                if (err) {
                    this.emit('error', err);
                } else {
                    this.card = new Card(this, status.atr, protocol);
                    //卡片已插入监听事件
                    this.emit('card-inserted', {device: this, card: this.card});
                }
            });
        };

        /**
         * 卡片已拔出
         */
        const cardRemoved = (reader) => {
            const name = reader.name;
            reader.disconnect(reader.SCARD_LEAVE_CARD, (err) => {
                if (err) {
                    this.emit('error', err);
                } else {
                    //卡片已拔出监听事件
                    this.emit('card-removed', {name, card: this.card});
                    this.card = null;
                }
            });
        };

        /**
         * 状态触发事件
         */
        reader.on('status', (status) => {
            var changes = reader.state ^ status.state;
            if (changes) {
                if (isCardRemoved(changes, reader, status)) {
                    cardRemoved(reader);
                } else if (isCardInserted(changes, reader, status)) {
                    cardInserted(reader, status);
                }
            }
        });
    }

    /**
     * 指令传输
     *
     * @param data     传输数据
     * @param res_len  预期响应长度
     * @param protocol 传输协议
     * @param cb       回调
     */
    transmit(data, res_len, protocol, cb) {
        this.reader.transmit(data, res_len, protocol, cb);
    }

    getName() {
        return this.name;
    }

    toString() {
        return `${this.getName()}`;
    }
}

export default Device;