'use strict';
/**
 * <pre>
 *     CLA INS P1 P2 Lc
 *
 * 描述：APDU指令包装
 * 版本：1.0.0
 * 日期：2019/01/16
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */

import {EventEmitter} from 'events';
import hexify from 'hexify';


class CmdApdu {

    constructor(obj) {
        if (obj.bytes) {
            this.bytes = obj.bytes;
        } else {
            let size = obj.size;
            let cla = obj.cla;
            let ins = obj.ins;
            let p1 = obj.p1;
            let p2 = obj.p2;
            let data = obj.data;
            let le = obj.le || 0;
            let lc;

            // case 1
            if (!size && !data && !le) {
                size = 4;
            }
            // case 2
            else if (!size && !data) {
                //console.info('case 2');
                size = 4 + 2;
            }

            // case 3
            else if (!size && !le) {
                //console.info('case 3');
                size = data.length + 5 + 4;
                //le = -1;
            }

            // case 4
            else if (!size) {
                //console.info('case 4');
                size = data.length + 5 + 4;
            }

            // set data
            if (data) {
                lc = data.length;
            } else {
                //lc = 0;
            }


            this.bytes = [];
            this.bytes.push(cla);
            this.bytes.push(ins);
            this.bytes.push(p1);
            this.bytes.push(p2);

            if (data) {
                this.bytes.push(lc);
                this.bytes = this.bytes.concat(data);
            }
            if(le){
                this.bytes.push(le);
            }
        }
        console.log(this.toString());
    }

    toString() {
        return hexify.toHexString(this.bytes);
    }

    toByteArray() {
        return this.bytes;
    }

    toBuffer() {
        return new Buffer(this.bytes);
    }

    setLe(le) {
        this.bytes.pop();
        this.bytes.push(le);
    }
}

export default CmdApdu;