'use strict';
/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2019/01/16
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */

import {EventEmitter} from 'events';
import hexify from 'hexify';
import ResApdu from './ResApdu';

class Card extends EventEmitter {

    /**
     * PSAM卡构造方法
     *
     * @param device    读写设备
     * @param attr      PSAM卡序号
     * @param protocol  通讯协议
     */
    constructor(device, attr, protocol) {
        super();
        this.device = device;
        this.protocol = protocol;
        this.attr = attr.toString('hex');
    }

    /**
     * 获取PSAM卡序号
     */
    getAttr() {
        return this.attr;
    }

    toString() {
        return `Card(attr:'${this.attr}')`;
    }

    /**
     *  发送指令
     *
     *  @param cmdApdu APDU指令
     *  @param callback 回调函数
     */
    sendCmd(cmdApdu, callback) {

        let buffer;
        if (Array.isArray(cmdApdu)) {
            buffer = new Buffer(cmdApdu);
        } else if (typeof cmdApdu === 'string') {
            buffer = new Buffer(hexify.toByteArray(cmdApdu));
        } else if (Buffer.isBuffer(cmdApdu)) {
            buffer = cmdApdu;
        } else {
            buffer = cmdApdu.toBuffer();
        }
        const protocol = this.protocol;
        //指令发送事件
        this.emit('cmd-send', {card: this, command: cmdApdu});
        if (callback) {
            //如果有回调接受
            this.device.transmit(buffer, 0x102, protocol, (err, response) => {
                //响应接受事件
                this.emit('response-received', {
                    card: this,
                    command: cmdApdu,
                    response: new ResApdu(response)
                })
            });

        } else {
            // 定义默认回调接受
            return new Promise((resolve, reject) => {
                this.device.transmit(buffer, 0x102, protocol, (err, response) => {
                    if (err) {
                        reject(err);
                    } else {
                        this.emit('response-received', {
                            card: this,
                            command: cmdApdu,
                            response: new ResApdu(response)
                        });
                        resolve(response)
                    }
                });
            });

        }
    }


}

export default Card;