package com.junmp.v2.print.service;

import com.junmp.jyzb.api.bean.dto.printDto.*;
import com.junmp.jyzb.api.bean.req.PrintReq.*;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/9/4 下午1:29
 * 作者：xuzc@junmp.com.cn
 * <br>修改记录
 * <br>修改日期 修改人 修改内容
 *
 * </pre>
 */
public interface PrintService
{
    /**
     * 获取所有供应商
     * @return
     */
    PrintGenericDto<PrintSupplierDto> GetAllSupplier();

    /**
     * 获取所有供应商
     * @return
     */
    List<PrintEquipmentInfoDto> GetAllEquipments();

    /**
     * 获取装备号型、供应商
     * @return
     */
    PrintEquipmentInfoDto GetEquInfoById(GetEquInfoByIdReq req);


//    GetPrintOrderDto GetPrintOrder(GetPrintOrderReq req);

    //删除epc
    Boolean DeleteInventory(EpcInvReq req);

    /**
     * 直接报废箱标EPC（包括箱内物资）
     * @param req
     * @return
     */
    Boolean DeleteInventoryByEpcList(EpcInvReq req);


    /**
     * 通过箱标epc获取件标详细信息
     * @param req
     * @return
     */
    List<GetInvListByBoxMarkEpcDto> GetInventoryListByBoxMarkEpc(EpcInvReq req);

    /**
     * 获取箱标
     * @param req
     * @return
     */
    List<GetBoxMarkDto> GetBoxMarkList(GetBoxMarkReq req);

    /**
     * 获取打印单据
     * @param req
     * @return
     */
    GetPrintOrderDto GetPrintOrder(GetPrintOrderReq req);

    /**
     * 生成epc
     * @param req
     * @return
     */
    List<GenerateIntTagEpcDto> GenerateIntTagEpc(GenerateIntTagEpcReq req);

    /**
     * 拆箱还原epc inbox状态(多个epc,箱标限定）
     * @param req
     * @return
     */
    Boolean UnpackRangeInventory(EpcInvReq req);

    /**
     * 检查epc是否已被实例化过
     * @param req
     * @return
     */
    Boolean CheckEpcIsInstantiation(EpcInvReq req);

    /**
     * 根据采购单信息生成EPC
     * @param req
     * @return
     */
    Boolean GenerateExtTagEpc(GenerateExtTagEpcReq req);


    /**
     * 导入旧箱标数据（旧时间戳epc）
     * @param req
     * @return
     */
    ImportOldBoxMarkDto ImportOldBoxMark(ImportOldBoxMarkReq req);

    /**
     * 获取需要打印的重装箱箱标
     * @param req
     * @return
     */
    List<GetNeedPrintBoxMarkDto> GetNeedPrintBoxMarkList(GetNeedPrintBoxMarkReq req);

    /**
     * 装箱操作(内部版，箱标限定)
     * @param req
     * @return
     */
    Boolean BoxingInventory(BoxingInventoryReq req);

    /**
     * 装箱操作(用户版，箱标限定)
     * @param req
     * @return
     */
    Boolean BoxingInventoryNormalVersion(BoxingInventoryReq req);

    /**
     * 生成打印入库信息(打印程序内部使用）
     * @param req
     * @return
     */
    Boolean GenerateInventoryWithProgram(GenerateInvWithProgramReq req);

    /**
     * 生成打印入库信息(多个epc,箱标限定）
     * @param req
     * @return
     */
    Boolean GenerateRangeInventory(GenerateRangeInvReq req);

    /**
     * 更新EPC打印状态
     * @param req
     * @return
     */
    Boolean UpdateEpcState(UpdateEpcStateReq req);

    /**
     * Rfid数据上报
     * @param req
     * @return
     */
//    Boolean UploadRFIDNew(UploadRFIDNewReq req);

    /**
     * 获取全部打印列表
     * @param req
     * @return
     */
    GetPrintListDto GetPrintList(GetPrintListReq req);
}
