package com.junmp.v2.print.controller;

import com.junmp.jyzb.api.bean.dto.Api2Res;
import com.junmp.jyzb.api.bean.dto.printDto.*;
import com.junmp.jyzb.api.bean.req.PrintReq.*;
import com.junmp.jyzb.api.bean.validator.DecryptionRequired;
import com.junmp.v2.print.service.PrintService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/9/4 下午1:23
 * 作者：xuzc@junmp.com.cn
 * <br>修改记录
 * <br>修改日期 修改人 修改内容
 *
 * </pre>
 */
@RestController
@Slf4j
@RequestMapping("/api")
@Api(value = "Sample API",tags = "[2.0接口重构]打印接口")
public class PrintController
{
    @Resource
    public PrintService printService;

    @PostMapping(path = "/Print/GetAllSupplier", name = "获取所有供应商(打印程序用)#enable")
    @ApiOperation("获取所有供应商")
    @DecryptionRequired
    public Api2Res<PrintGenericDto<PrintSupplierDto>> GetAllSupplier()
    {
        return Api2Res.success(printService.GetAllSupplier());
    }

    @PostMapping(path = "/Print/GetAllEquipments", name = "获取装备信息(打印程序)#enable")
    @ApiOperation("获取装备信息")
    @DecryptionRequired
    public Api2Res<List<PrintEquipmentInfoDto>> GetAllEquipments()
    {
        return Api2Res.success(printService.GetAllEquipments());
    }

    @PostMapping(path = "/Print/GetEquInfoById", name = "获取装备号型、供应商#enable")
    @ApiOperation("获取装备号型、供应商")
    @DecryptionRequired
    public Api2Res<PrintEquipmentInfoDto> GetEquInfoById(@RequestBody GetEquInfoByIdReq req)
    {
        return Api2Res.success(printService.GetEquInfoById(req));
    }


    //获取打印单据
    @PostMapping(path = "/Print/GetPrintOrder", name = "获取打印单据#enable")
    @ApiOperation("获取打印单据")
    @DecryptionRequired
    public Api2Res<GetPrintOrderDto> GetPrintOrder(@RequestBody GetPrintOrderReq req)
//    public Api2Res<GetPrintOrderDto> GetPrintOrder(@RequestBody String a)
    {
//        System.out.println("a = " + a);
//        GetPrintOrderReq req = new GetPrintOrderReq();

        return Api2Res.success(printService.GetPrintOrder(req));
    }



    //删除epc
    @PostMapping(path = "/Print/DeleteInventory", name = "直接报废EPC#enable")
    @ApiOperation("直接报废EPC")
    @DecryptionRequired
    public Api2Res<Boolean> DeleteInventory(@RequestBody EpcInvReq req) {
        Boolean result = printService.DeleteInventory(req);
        if (result){
            return Api2Res.success();
        }else {
            return Api2Res.failure("更新失败");
        }
    }


    @PostMapping(path = "Print/DeleteInventoryByEpcList", name = "直接报废箱标EPC（包括箱内物资）#enable")
    @ApiOperation("直接报废箱标EPC（包括箱内物资）")
    @DecryptionRequired
    public Api2Res<Boolean> DeleteInventoryByEpcList(@RequestBody EpcInvReq req)
    {
        Boolean result =printService.DeleteInventoryByEpcList(req);
        if (result){
            return Api2Res.success();
        }else {
            return Api2Res.failure("更新失败");
        }
    }


    @PostMapping(path = "/EquipmentBoxMark/GetInventoryListByBoxMarkEpc", name = "通过箱标epc获取件标详细信息#enable")
    @ApiOperation("通过箱标epc获取件标详细信息")
    @DecryptionRequired
    public Api2Res<List<GetInvListByBoxMarkEpcDto>> GetInventoryListByBoxMarkEpc(@RequestBody  EpcInvReq req)
    {
        return Api2Res.success(printService.GetInventoryListByBoxMarkEpc(req));
    }


    @PostMapping(path = "/EquipmentBoxMark/GetBoxMarkList", name = "获取箱标#enable")
    @ApiOperation("获取箱标")
    @DecryptionRequired
    public Api2Res<List<GetBoxMarkDto>> GetBoxMarkList(@RequestBody GetBoxMarkReq req)
    {
        return Api2Res.success(printService.GetBoxMarkList(req));
    }


    @PostMapping(path = "/Print/GenerateIntTagEpc", name = "直接生成EPC#enable")
    @ApiOperation("直接生成EPC")
    @DecryptionRequired
    public Api2Res<List<GenerateIntTagEpcDto>> GenerateIntTagEpc(@RequestBody GenerateIntTagEpcReq req)
    {
        return Api2Res.success(printService.GenerateIntTagEpc(req));
    }



    @PostMapping(path = "Print/UnpackRangeInventory", name = "拆箱还原epc#enable")
    @ApiOperation("拆箱还原epc")
    @DecryptionRequired
    public Api2Res<ResponeOrderDto> UnpackRangeInventory(@RequestBody  EpcInvReq req)
    {
        Boolean result =printService.UnpackRangeInventory(req);
        if (result){
            ResponeOrderDto responeOrderDto = new ResponeOrderDto();
            List<ResponeOrderDto.OrderInfo> dto=new ArrayList<>();
            responeOrderDto.setRecord(dto);
            return Api2Res.success(responeOrderDto);
        }else {
            return Api2Res.failure("数据写入失败");
        }
    }


    @PostMapping(path = "Print/CheckEpcIsInstantiation", name = "检查epc是否已被实例化过#enable")
    @ApiOperation("检查epc是否已被实例化过")
    @DecryptionRequired
    public Api2Res<Boolean> CheckEpcIsInstantiation(@RequestBody  EpcInvReq req)
    {
        Boolean result =printService.CheckEpcIsInstantiation(req);
        if (result){
            return Api2Res.success();
        }else {
            return Api2Res.failure("无效参数");
        }
    }



    @PostMapping(path = "Print/GenerateExtTagEpc", name = "根据采购单信息生成EPC#enable")
    @ApiOperation("根据采购单信息生成EPC")
    @DecryptionRequired
    public Api2Res<Boolean> GenerateExtTagEpc(@RequestBody GenerateExtTagEpcReq req)
    {
        Boolean result =printService.GenerateExtTagEpc(req);
        if (result){
            return Api2Res.success();
        }else {
            return Api2Res.failure("数据保存失败");
        }
    }



    @PostMapping(path = "/Print/ImportOldBoxMark", name = "导入旧箱标数据（旧时间戳epc）#enable")
    @ApiOperation("导入旧箱标数据（旧时间戳epc）")
    @DecryptionRequired
    public Api2Res<ImportOldBoxMarkDto> ImportOldBoxMark(@RequestBody ImportOldBoxMarkReq req)
    {
        return Api2Res.success(printService.ImportOldBoxMark(req));
    }


    @PostMapping(path = "/EquipmentBoxMark/GetNeedPrintBoxMarkList", name = "获取需要打印的重装箱箱标#enable")
    @ApiOperation("获取需要打印的重装箱箱标")
    @DecryptionRequired
    public Api2Res<List<GetNeedPrintBoxMarkDto>> GetNeedPrintBoxMarkList(@RequestBody GetNeedPrintBoxMarkReq req)
    {
        return Api2Res.success(printService.GetNeedPrintBoxMarkList(req));
    }



    @PostMapping(path = "/Print/BoxingInventory", name = "装箱操作(内部版，箱标限定)#enable")
    @ApiOperation("装箱操作(内部版，箱标限定)")
    @DecryptionRequired
    public Api2Res<Boolean> BoxingInventory(@RequestBody BoxingInventoryReq req)
    {
        Boolean result =printService.BoxingInventory(req);
        if (result){
            return Api2Res.success();
        }else {
            return Api2Res.failure("失败");
        }
    }


    @PostMapping(path = "/Print/BoxingInventoryNormalVersion", name = "装箱操作(用户版，箱标限定)#enable")
    @ApiOperation("装箱操作(用户版，箱标限定)")
    @DecryptionRequired

    public Api2Res<ResponeOrderDto> BoxingInventoryNormalVersion(@RequestBody BoxingInventoryReq req)
    {
        Boolean result =printService.BoxingInventoryNormalVersion(req);
        if (result){
            ResponeOrderDto responeOrderDto = new ResponeOrderDto();
            List<ResponeOrderDto.OrderInfo> dto=new ArrayList<>();
            responeOrderDto.setRecord(dto);
            return Api2Res.success(responeOrderDto);
        }else {
            return Api2Res.failure("失败");
        }
    }

    @PostMapping(path = "/Print/GenerateInventoryWithProgram", name = "生成打印入库信息(打印程序内部使用）#enable")
    @ApiOperation("生成打印入库信息(打印程序内部使用）")
    @DecryptionRequired
    public Api2Res<Boolean> GenerateInventoryWithProgram(@RequestBody GenerateInvWithProgramReq req)
    {
        Boolean result =printService.GenerateInventoryWithProgram(req);
        if (result){
            return Api2Res.success();
        }else {
            return Api2Res.failure("失败");
        }
    }

    @PostMapping(path = "/Print/GenerateRangeInventory", name = "生成打印入库信息(多个epc,箱标限定）#enable")
    @ApiOperation("生成打印入库信息(多个epc,箱标限定）")
    @DecryptionRequired
    public Api2Res<ResponeOrderDto> GenerateRangeInventory(@RequestBody GenerateRangeInvReq req)
    {
        Boolean result =printService.GenerateRangeInventory(req);
        if (result){
            ResponeOrderDto responeOrderDto = new ResponeOrderDto();
            List<ResponeOrderDto.OrderInfo> dto=new ArrayList<>();
            responeOrderDto.setRecord(dto);
            return Api2Res.success(responeOrderDto);
        }else {
            return Api2Res.failure("失败");
        }
    }


    @PostMapping(path = "/Print/UpdateEpcState", name = "更新EPC打印状态#enable")
    @ApiOperation("更新EPC打印状态")
    @DecryptionRequired
    public Api2Res<Boolean> UpdateEpcState(@RequestBody UpdateEpcStateReq req)
    {
        Boolean result =printService.UpdateEpcState(req);
        if (result){
            return Api2Res.success();
        }else {
            return Api2Res.failure("失败");
        }
    }


//    @PostMapping(path = "/Inventory/UploadRFIDNew", name = "Rfid数据上报#enable")
//    @ApiOperation("Rfid数据上报")
//    public Api2Res<Boolean> UploadRFIDNew(@RequestBody @Validated(ValidationApi.edit.class) UploadRFIDNewReq req)
//    {
//        return Api2Res.success(printService.UploadRFIDNew(req));
//
//    }

    @PostMapping(path = "/Print/GetPrintList", name = "获取全部打印列表#enable")
    @ApiOperation("获取全部打印列表")
    @DecryptionRequired
    public Api2Res<GetPrintListDto> GetPrintList(@RequestBody  GetPrintListReq req){
        return Api2Res.success(printService.GetPrintList(req));
    }


}
