package com.junmp.v2.print.RFID;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.junmp.jyzb.utils.DateTimeUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public  class GenerateEpcNum {



    @Data
    public static class GenEpcInfo{

        @JsonProperty("Epc")
        private String Epc;

        @JsonProperty("Num")
        private Integer Num;
        public GenEpcInfo(Integer Num, String myString) {
            this.Num = Num;
            this.Epc = myString;
        }

    }

    /**
     * 生成2.0版本EPC
     */
    public static List<GenEpcInfo> GenEpcs(Byte serverNum,String equCode,String supplierCode,
                                           String sizeCode,Integer productTime,Integer wzsl,Integer totalNum){
        if (ObjectUtil.isNull(wzsl)){
            wzsl=1;
        }
        if (wzsl > 4095) {
            return new ArrayList<GenEpcInfo>();
        }else {
            List<GenEpcInfo> epcList=new ArrayList<>();
            AnalyzingEpc epc = new AnalyzingEpc();
            epc.setHeader((byte)17);
            epc.setIssuerId((byte)1);
            epc.setOrganizationCode(String.format("%1$9s", supplierCode).replace(' ', '0').toUpperCase());
            epc.setWzdmLen((byte)7);
            epc.setProductionDate(Integer.parseInt(DateTimeUtil.TimeDateToString(DateTimeUtil.getCurrentDateTime(),"yyMMdd"), 16));
            epc.setWzdm(Long.parseLong(equCode, 16));
            epc.setHxdm(Long.parseLong(sizeCode, 16));
            epc.setSerialLen((byte)0xD);
            epc.setVer((byte)0x02);
            epc.setTagType((byte)0);
            epc.setPackingType((byte)1);
            epc.setMachineNum(serverNum);
            epc.setNoInBox(1);
            epc.setExpiryDate((byte)0);
            epc.setExpiryDateUnit((byte)0);
//            epc.setEType((byte)0);
            if (totalNum==0){
                Integer num=1;
                for (int i=0;i<wzsl;i++){
                    epc.setTimeSpan(getTimeStamp());
                    epc.setNoInBox(num);
                    String resEpc=EpcConvert.hex16ByteToHex16String(EpcConvert.epc2Gen(epc)).replace(" ", "");
                    epcList.add(new GenEpcInfo(num, resEpc));
                    num++;
                }
            }else {
                Integer num=totalNum+1;
                for (int i=0;i<wzsl;i++){
                    epc.setTimeSpan(getTimeStamp());
                    epc.setNoInBox(num);
                    String resEpc=EpcConvert.hex16ByteToHex16String(EpcConvert.epc2Gen(epc)).replace(" ", "");
                    epcList.add(new GenEpcInfo(num, resEpc));
                    num++;
                }

            }

            return epcList;
        }

    }

    /**
     * 生成1.0版本EPC(箱标）
     * @return
     */
    public static List<GenEpcInfo> GenBoxMarkEpcs(byte serverNum, String equCode, String supplierCode, String sizeCode, Integer productTime, Integer oneBoxNum, Integer epcBoxNum, Integer wzsl) {

        if (ObjectUtil.isNull(wzsl)){
            wzsl=1;
        }
        if (wzsl > 4095) {
            return new ArrayList<GenEpcInfo>();
        }else {
            List<GenEpcInfo> epcList=new ArrayList<>();
            AnalyzingEpc epc = new AnalyzingEpc();
            epc.setHeader((byte)17);
            epc.setIssuerId((byte)1);
            epc.setOrganizationCode(StringUtils.leftPad(supplierCode,9,'0').toUpperCase());
            epc.setWzdmLen((byte)7);
            epc.setProductionDate(Integer.parseInt(DateTimeUtil.TimeDateToString(DateTimeUtil.getCurrentDateTime(),"yyMMdd"), 16));
            epc.setWzdm(Long.parseLong(equCode, 16));
            epc.setHxdm(Long.parseLong(sizeCode, 16));
            epc.setSerialLen((byte)0xD);
            epc.setVer((byte)0x01);
            epc.setTagType((byte)0x01);
            epc.setPackingType((byte)1);
            epc.setMachineNum(serverNum);
            epc.setNoInBox(1);
            epc.setBoxNo(epcBoxNum);
            epc.setWzCount(oneBoxNum);
            epc.setExpiryDate((byte)0);
            epc.setExpiryDateUnit((byte)0);
            Integer num=1;
            for (int i=0;i<wzsl;i++){
                epc.setTimeSpan(getTimeStamp());
                epc.setNoInBox(num);
                String resEpc=EpcConvert.hex16ByteToHex16String(EpcConvert.epc2Gen(epc)).replace(" ", "");
                epcList.add(new GenEpcInfo(num, resEpc));
                num++;
            }
            return epcList;
        }
    }



    private static long getTimeStamp() {
        long currentTimeMillis = DateTimeUtil.getCurrentDateTime().getTime();
        Long unixEpochMillis = DateTimeUtil.TimeDateToLong(DateTimeUtil.TimeStringToDate("1970-01-01 00:00:00", "yyyy-MM-dd HH:mm:ss"));
        return currentTimeMillis - unixEpochMillis.longValue();
    }


}
