package com.junmp.v2.print.RFID;

import lombok.Data;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/9/12 上午9:11
 * 作者：xuzc@junmp.com.cn
 * <br>修改记录
 * <br>修改日期 修改人 修改内容
 *
 * </pre>
 */
@Data
public class AnalyzingEpc
{
    private Byte Header;                 // 标头(8bits)： JY物资专用标头  0x11(00010001b)
    private Byte IssuerId;               // 发行机构标识符(6bits)：GA组织机构： 0x01(000001b) 国家组织机构:0x02(000010b)
    private String OrganizationCode;     // 组织机构代码(54bits)：JY物资生产厂商使用GA或国家组织机构代码，英文字母及数字的每一个字符转换为六位二进制
    private Byte WzdmLen;                // 物资代码长度(4bits): 指定物资代码的长度(N*8bits)，此处为0x7
    private Long Wzdm;                   // 物资代码(56bits): 使用警用物资编目数据的物资代码，按十进制转换成十六进制存储
    private Long Hxdm;
    private Byte SerialLen;              // 序列号长度(4bits): 指定序列号长度(N*8bits), 此处为0xD

    private Byte Ver;                    // 版本号(8bits): 0x01
    private Byte TagType;                // 标签类型(8bits):   0x00 件标   0x01 箱标
    private Byte PackingType;            // 包装类型(4bits):   0x1 单品， 0x2 外包装， 0x3 内包装， 0xF 零头配箱
    private Integer ProductionDate;      // 生产日期(24bits): 0x161201
    private Byte ExpiryDate;             // 有效期值(6bits):  0-63
    private Byte ExpiryDateUnit;         // 有效期时间单位(2bits): 1:01b-日， 2:10b-月， 3:11b-年
    private Byte SubPackageNum;          // 下级包装内数量(8bits)：最大255
    private Integer WzCount;             // 包装数量(12bits): MAX:4095, 每箱内产品总数
    private Integer BoxNo;               // 包装箱序列号(20bits): MAX:65535
    private Integer NoInBox;             // 箱内序列号(12bits): 每箱内产品序号， MAX4095
    private Long TimeSpan;               // 当前日期时间戳，精确到毫秒
    private Byte MachineNum;             // 服务器识别码(4bits)，用于区分测试服务器与正式服务器生成的数据，实际1b就够了，其他3b做保留
    private Byte EType;                  // 1单标签 2双标签 3三标签(兼容2.0标签 2.0解析输出0)
    private Byte EProperty;              // 资产类型:0固定资产 1非固定资产(仅限3.0标签)
}
