package com.junmp.v2.cs.service;

import com.junmp.jyzb.api.bean.dto.csDto.*;
import com.junmp.jyzb.api.bean.req.csReq.*;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/9/5 下午4:00
 * 作者：xuzc@junmp.com.cn
 * <br>修改记录
 * <br>修改日期 修改人 修改内容
 *
 * </pre>
 */
public interface ChargeStationService
{
    /**
     * 通过id获取对应仓库信息
     * @param req
     * @return
     */
    CsWarehouseDto GetWarehouseById(GetWarehouseByIdReq req);

    /**
     * 设置库存盘盈盘亏状态
     * @param req
     * @return
     */
    Boolean SetWarehouseState(CsWarehouseReq req);

    /**
     * 获取仓库下全部的装备
     * @param req
     * @return
     */
    List<CsWarehouseInventoryDto> GetAllInventoryList(CsWarehouseReq req);

    /**
     * 获取所有未完成的出入库单据
     * @param req
     * @return
     */
    CsOrderInfoDto GetOrderInfo(GetOrderInfoReq req);

    /**
     * 获取出入库单据明细
     * @param req
     * @return
     */
    List<CsOrderDetailDto> GetOrderDetail(GetOrderDetailReq req);

    /**
     * 强制结束单据
     * @param req
     * @return
     */
    Boolean CloseOrder(ControlOrderReq req);

    /**
     * 开启指定单据关闭其他单据
     * @param req
     * @return
     */
    Boolean OpenThisOrderAndCloseOther(ControlOrderReq req);

    /**
     * 新增领用单
     * @param req
     * @return
     */
    Boolean AddAndApprovalBorrowOrder(AddAndApprovalBorrowOrderReq req);
}
