package com.junmp.v2.cs.controller;

import com.junmp.jyzb.api.bean.dto.Api2Res;
import com.junmp.jyzb.api.bean.dto.csDto.CsOrderDetailDto;
import com.junmp.jyzb.api.bean.dto.csDto.CsOrderInfoDto;
import com.junmp.jyzb.api.bean.dto.csDto.CsWarehouseDto;
import com.junmp.jyzb.api.bean.dto.csDto.CsWarehouseInventoryDto;
import com.junmp.jyzb.api.bean.req.csReq.*;
import com.junmp.jyzb.api.bean.validator.DecryptionRequired;
import com.junmp.jyzb.api.exception.enums.JyzbV2ExceptionEnum;
import com.junmp.v2.cs.service.ChargeStationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/9/5 下午3:16
 * 作者：xuzc@junmp.com.cn
 * <br>修改记录
 * <br>修改日期 修改人 修改内容
 *
 * </pre>
 */
@RestController
@Slf4j
@RequestMapping("/api")
@Api(value = "ChargeStation API",tags = "[2.0接口重构]充电台接口")
public class ChargeStationController
{
    @Resource
    public ChargeStationService chargeStationService;

    @PostMapping(path = "/Warehouse/GetWarehouseById", name = "通过id获取对应仓库信息#enable")
    @ApiOperation("通过id获取对应仓库信息")
    @DecryptionRequired
    public Api2Res<CsWarehouseDto> GetWarehouseById(@RequestBody GetWarehouseByIdReq req)
    {
        return Api2Res.success(chargeStationService.GetWarehouseById(req));
    }

    @PostMapping(path = "/Inventory/SetWarehouseState", name = "设置库存盘盈盘亏状态#logType=30")
    @ApiOperation("设置库存盘盈盘亏状态")
    @DecryptionRequired
    public Api2Res SetWarehouseState(@RequestBody CsWarehouseReq req)
    {
        return chargeStationService.SetWarehouseState(req) ? Api2Res.success() : Api2Res.failure(JyzbV2ExceptionEnum.OPERATE_FAILED);
    }

    @PostMapping(path = "/Inventory/GetAllInventoryList", name = "获取仓库下全部的装备#enable")
    @ApiOperation("获取仓库下全部的装备")
    @DecryptionRequired
    public Api2Res<List<CsWarehouseInventoryDto>> GetAllInventoryList(@RequestBody CsWarehouseReq req)
    {
        return Api2Res.success(chargeStationService.GetAllInventoryList(req));
    }

    @PostMapping(path = "/Inventory/GetOrderInfo", name = "获取所有未完成的出入库单据#enable")
    @ApiOperation("获取所有未完成的出入库单据")
    @DecryptionRequired
    public Api2Res<CsOrderInfoDto> GetOrderInfo(@RequestBody GetOrderInfoReq req)
    {
        return Api2Res.success(chargeStationService.GetOrderInfo(req));
    }

    @PostMapping(path = "/Inventory/GetOrderDetail", name = "获取出入库单据明细#enable")
    @ApiOperation("获取出入库单据明细")
    @DecryptionRequired
    public Api2Res<List<CsOrderDetailDto>> GetOrderDetail(@RequestBody  GetOrderDetailReq req)
    {
        return Api2Res.success(chargeStationService.GetOrderDetail(req));
    }

    @PostMapping(path = "/Inventory/CloseOrder", name = "强制结束单据#logType=30")
    @ApiOperation("强制结束单据")
    @DecryptionRequired
    public Api2Res CloseOrder(@RequestBody  ControlOrderReq req)
    {
        return chargeStationService.CloseOrder(req) ? Api2Res.success() : Api2Res.failure(JyzbV2ExceptionEnum.OPERATE_FAILED);
    }

    @PostMapping(path = "/Inventory/OpenThisOrderAndCloseOther", name = "开启指定单据关闭其他单据#logType=30")
    @ApiOperation("开启指定单据关闭其他单据")
    @DecryptionRequired
    public Api2Res OpenThisOrderAndCloseOther(@RequestBody  ControlOrderReq req)
    {
        return chargeStationService.OpenThisOrderAndCloseOther(req) ? Api2Res.success() : Api2Res.failure(JyzbV2ExceptionEnum.OPERATE_FAILED);
    }

    @PostMapping(path = "/Borrow/AddAndApprovalBorrowOrder", name = "新增领用单#logType=30")
    @ApiOperation("新增领用单")
    @DecryptionRequired
    public Api2Res AddAndApprovalBorrowOrder(@RequestBody AddAndApprovalBorrowOrderReq req)
    {
        return chargeStationService.AddAndApprovalBorrowOrder(req) ? Api2Res.success() : Api2Res.failure(JyzbV2ExceptionEnum.OPERATE_FAILED);
    }

    @PostMapping(path = "/Borrow/AddAndApprovalBorrowJYOrder", name = "新增借用单#logType=30")
    @ApiOperation("新增借用单")
    @DecryptionRequired
    public Api2Res AddAndApprovalBorrowJYOrder(@RequestBody AddAndApprovalBorrowOrderReq req)
    {
        return chargeStationService.AddAndApprovalBorrowOrder(req) ? Api2Res.success() : Api2Res.failure(JyzbV2ExceptionEnum.OPERATE_FAILED);
    }
}
