package com.junmp.v2.channel.service;

import com.junmp.jyzb.api.bean.dto.ChannelDto.*;
import com.junmp.jyzb.api.bean.req.ChannelReq.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/9/6 上午9:07
 * 作者：xuzc@junmp.com.cn
 * <br>修改记录
 * <br>修改日期 修改人 修改内容
 *
 * </pre>
 */
public interface ChannelService
{
    /**
     * 获取仓库列表
     * @param req
     * @return
     */
    List<ChannelWarehouseDto> GetListWarehouse(GetListWarehouseReq req);

    /**
     * 获取组织机构对应的本仓库列表
     * @param req
     * @return
     */
    List<ChannelWarehouseDto> GetListOrgWarehouse(GetListWarehouseReq req);

    /**
     * 获取对应组织机构人员
     * @param req
     * @return
     */
    List<ChannelPoliceDto> GetOrgStaff(GetOrgStaffReq req);

    /**
     * 根据编号获取通道配置
     * @param req
     * @return
     */
    ChannelConfigDto GetCfgByNumV2(GetCfgByNumV2Req req);

    /**
     * 根据卡号获取警员信息
     * @param req
     * @return
     */
    ChannelPoliceCardNoDto GetPoliceByCardNo(GetPoliceByCardNoReq req);

    /**
     * 获取指定仓库货架列表
     * @param req
     * @return
     */
    List<ChannelShelfDto> GetListShelf(GetShelfReq req);

    /**
     * 获取指定仓库全部智能货架及物资
     * @param req
     * @return
     */
    List<ChannelShelfInventoryDto> GetListShelfAndInventory(GetShelfInventoryReq req);

    /**
     * 根据EPC集合获取物资信息
     * @param req
     * @return
     */
    List<ChannelEpcInfoReq> GetInvListByEpc(GetInvListByEpcReq req);

    /**
     * 获取指定仓库对应类型号型的装备存放货架位置
     * @param req
     * @return
     */
    List<ChannelShelfPositionDto> GetListEquipmentShelfPosition(GetListEquipmentShelfPositionReq req);

    /**
     * 更新指纹
     * @param req
     * @return
     */
    void UpdateFinger(UpdateFingerReq req);

    /**
     * 批量更新警员卡号
     * @param req
     */
    void BatchUpdateCardNo(BatchUpdateCardNoReq req);

    /**
     * 获取装备包打印列表
     * @param req
     * @return
     */
    List<ChannelBagDto> GetPrintBagList(GetPrintBagListReq req);

    /**
     * 更新装备包打印状态
     * @param req
     * @return
     */
    Boolean UpdateBagState(UpdateBagStateReq req);

    /**
     * 通过箱标EPC获取件标EPC
     * @param req
     * @return
     */
    List<ChannelEpcByBoxDto> GetEpcListByBoxMarkEpc(GetEpcListByBoxMarkEpcReq req);

    /**
     * 获取装备包内EPC信息
     * @param req
     * @return
     */
    List<ChannelEpcByBoxInvDto> GetEpcListByBagInvEpc(GetEpcListByBagInvEpcReq req);

    /**
     * 获取当前仓库开启的单据
     * @param req
     * @return
     */
    ChannelOpenOrderDto GetOpenOrderInfo(GetOpenOrderInfoReq req);

    /**
     * Rfid数据上报
     * @param req
     * @return
     */
    List<ChannelUploadRFIDDto> UploadRFIDNew(UploadRFIDReq req);

    /**
     * 警员图片上传
     * @param id
     * @param picture
     * @return
     */
    Boolean UploadFace(String id, MultipartFile picture);
}
