package com.junmp.v2.channel.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.api.bean.dto.ChannelDto.ChannelBagDto;
import com.junmp.jyzb.api.bean.dto.ChannelDto.ChannelEpcByBoxDto;
import com.junmp.jyzb.api.bean.dto.ChannelDto.ChannelEpcByBoxInvDto;
import com.junmp.jyzb.api.bean.req.ChannelReq.GetListEquipmentShelfPositionReq;
import com.junmp.jyzb.api.bean.req.ChannelReq.GetPrintBagListReq;
import com.junmp.jyzb.api.bean.vo.ChannelVo.*;
import com.junmp.jyzb.entity.Inventory;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/9/13 上午10:18
 * 作者：xuzc@junmp.com.cn
 * <br>修改记录
 * <br>修改日期 修改人 修改内容
 *
 * </pre>
 */
@Mapper
public interface ChannelMapper extends BaseMapper<Inventory> {
    //查询组织机构下面的装备信息
    List<ChannelShelfInventoryVo> GetShelfInventory(@Param("shelfIds") List<String> shelfIds);

    //查询组织机构下面的装备信息
    List<EquipmentShelfPositionVo> GetEquipmentShelfPosition(@Param("req") GetListEquipmentShelfPositionReq req);

    //获取装备包打印列表
    List<ChannelBagDto> GetPrintBagList(@Param("req") GetPrintBagListReq req);

    //通过箱标EPC获取件标EPC
    List<ChannelEpcByBoxDto> GetEpcListByBoxMarkEpc(@Param("req") List<String> req);

    //获取装备包内EPC信息
    List<ChannelEpcByBoxInvDto> GetEpcListByBagInvEpc(@Param("req") List<String> req);
}
