package com.junmp.v2.channel.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.io.ByteArrayInputStream;


/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/10/24 10:56
 * 作者：xuzc@junmp.com.cn
 * <br>修改记录
 * <br>修改日期 修改人 修改内容
 *
 * </pre>
 */
@RestController
@Slf4j
@RequestMapping("")
@Api(value = "Channel API",tags = "[2.0接口重构]图片获取接口")
public class PictureController
{
    //@Resource
    //private SysConfigService pubConfigService;

    private final RestTemplate restTemplate = new RestTemplate();

    @GetMapping("/jyzb/{filename}")
    public ResponseEntity<?> getPicture(@PathVariable String filename) {

//        SysConfig config = pubConfigService.getOne(new LambdaQueryWrapper<SysConfig>()
//                .eq(SysConfig::getConfigCode, "MINIO_ENDPOINT")
//        );
//
//        if(config == null){
//            return ResponseEntity.notFound().build();
//        }

        //文件地址
        String fileUrl = "http://192.168.3.40:9000/jyzb/" + filename;//config.getConfigValue() + "/jyzb/" + filename;

        try {
            // 从地址获取图片资源
            UrlResource resource = new UrlResource(fileUrl);

            if (resource.exists() || resource.isReadable()) {
                // 设置响应头
                HttpHeaders headers = new HttpHeaders();
                headers.add(HttpHeaders.CONTENT_DISPOSITION, "inline; filename=\"" + resource.getFilename() + "\"");

                ResponseEntity entity =ResponseEntity.ok()
                        .headers(headers)
                        .contentType(MediaType.IMAGE_JPEG)
                        .body(resource);

                // 返回图片资源
                return entity;
            } else {
                return ResponseEntity.notFound().build();
            }
        } catch (Exception e) {
            return ResponseEntity.badRequest().build();
        }
    }
}
