package com.junmp.v2.channel.controller;

import com.junmp.jyzb.api.bean.dto.Api2Res;
import com.junmp.jyzb.api.bean.dto.ChannelDto.*;
import com.junmp.jyzb.api.bean.req.ChannelReq.*;
import com.junmp.jyzb.api.bean.validator.DecryptionRequired;
import com.junmp.jyzb.api.exception.enums.JyzbV2ExceptionEnum;
import com.junmp.v2.channel.service.ChannelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/9/6 上午9:06
 * 作者：xuzc@junmp.com.cn
 * <br>修改记录
 * <br>修改日期 修改人 修改内容
 *
 * </pre>
 */
@RestController
@Slf4j
@RequestMapping("/api")
@Api(value = "Channel API",tags = "[2.0接口重构]通道接口")
public class ChannelController
{
    @Resource
    public ChannelService channelService;

    @PostMapping(path = "/Warehouse/GetListWarehouse", name = "获取仓库列表#enable")
    @ApiOperation("获取仓库列表")
    @DecryptionRequired
    public Api2Res<List<ChannelWarehouseDto>> GetListWarehouse(@RequestBody GetListWarehouseReq req)
    {
        return Api2Res.success(channelService.GetListWarehouse(req));
    }

    @PostMapping(path = "/Warehouse/GetListOrgWarehouse", name = "获取组织机构对应的本仓库列表#enable")
    @ApiOperation("获取组织机构对应的本仓库列表")
    @DecryptionRequired
    public Api2Res<List<ChannelWarehouseDto>> GetListOrgWarehouse(@RequestBody GetListWarehouseReq req)
    {
        return Api2Res.success(channelService.GetListOrgWarehouse(req));
    }

    @PostMapping(path = "/ChannelCfg/GetOrgStaff", name = "获取对应组织机构人员#enable")
    @ApiOperation("获取对应组织机构人员")
    @DecryptionRequired
    public Api2Res<List<ChannelPoliceDto>> GetOrgStaff(@RequestBody GetOrgStaffReq req)
    {
        return Api2Res.success(channelService.GetOrgStaff(req));
    }


    @PostMapping(path = "/ChannelCfg/GetCfgByNumV2", name = "根据编号获取通道配置#enable")
    @ApiOperation("根据编号获取通道配置")
    @DecryptionRequired
    public Api2Res<ChannelConfigDto> GetCfgByNumV2( @RequestBody GetCfgByNumV2Req req)
    {

        return Api2Res.success(channelService.GetCfgByNumV2(req));
    }

    @PostMapping(path = "/Common/GetPoliceByCardNo", name = "根据卡号获取警员信息#enable")
    @ApiOperation("根据卡号获取警员信息")
    @DecryptionRequired
    public Api2Res<ChannelPoliceCardNoDto> GetPoliceByCardNo(@RequestBody GetPoliceByCardNoReq req)
    {
        return Api2Res.success(channelService.GetPoliceByCardNo(req));
    }

    @PostMapping(path = "/Shelf/GetListShelf", name = "获取指定仓库货架列表#enable")
    @ApiOperation("获取指定仓库货架列表")
    @DecryptionRequired
    public Api2Res<List<ChannelShelfDto>> GetListShelf(@RequestBody GetShelfReq req)
    {
        return Api2Res.success(channelService.GetListShelf(req));
    }

    @PostMapping(path = "/Shelf/GetListShelfAndInventory", name = "获取指定仓库全部智能货架及物资#enable")
    @ApiOperation("获取指定仓库全部智能货架及物资")
    @DecryptionRequired
    public Api2Res<List<ChannelShelfInventoryDto>> GetListShelfAndInventory(@RequestBody GetShelfInventoryReq req)
    {
        return Api2Res.success(channelService.GetListShelfAndInventory(req));
    }

    @PostMapping(path = "/Inventory/GetInvListByEpc", name = "根据EPC集合获取物资信息#enable")
    @ApiOperation("根据EPC集合获取物资信息")
    @DecryptionRequired
    public Api2Res<List<ChannelEpcInfoReq>> GetInvListByEpc(@RequestBody GetInvListByEpcReq req)
    {
        return Api2Res.success(channelService.GetInvListByEpc(req));
    }

    @PostMapping(path = "/Shelf/GetListEquipmentShelfPosition", name = "获取指定仓库对应类型号型的装备存放货架位置#enable")
    @ApiOperation("获取指定仓库对应类型号型的装备存放货架位置")
    @DecryptionRequired
    public Api2Res<List<ChannelShelfPositionDto>> GetListEquipmentShelfPosition(@RequestBody GetListEquipmentShelfPositionReq req)
    {
        return Api2Res.success(channelService.GetListEquipmentShelfPosition(req));
    }

    @PostMapping(path = "/ChannelCfg/UpdateFinger", name = "更新指纹#logType=30")
    @ApiOperation("更新指纹")
    @DecryptionRequired
    public Api2Res UpdateFinger(@RequestBody UpdateFingerReq req)
    {
        channelService.UpdateFinger(req);
        return Api2Res.success();
    }

    @PostMapping(path = "/Policeman/BatchUpdateCardNo", name = "批量更新警员卡号#logType=30")
    @ApiOperation("批量更新警员卡号")
    @DecryptionRequired
    public Api2Res BatchUpdateCardNo(@RequestBody BatchUpdateCardNoReq req)
    {
        channelService.BatchUpdateCardNo(req);
        return Api2Res.success();
    }

    @PostMapping(path = "/Print/GetPrintBagList", name = "获取装备包打印列表#enable")
    @ApiOperation("获取装备包打印列表")
    @DecryptionRequired
    public Api2Res<List<ChannelBagDto>> GetPrintBagList(@RequestBody GetPrintBagListReq req)
    {
        return Api2Res.success(channelService.GetPrintBagList(req));
    }

    @PostMapping(path = "/Print/UpdateBagState", name = "更新装备包打印状态#logType=30")
    @ApiOperation("更新装备包打印状态")
    @DecryptionRequired
    public Api2Res UpdateBagState(@RequestBody UpdateBagStateReq req)
    {
        return channelService.UpdateBagState(req) ?
                Api2Res.success() :
                Api2Res.failure(JyzbV2ExceptionEnum.OPERATE_FAILED);
    }

    @PostMapping(path = "/EquipmentBoxMark/GetEpcListByBoxMarkEpc", name = "通过箱标EPC获取件标EPC#enable")
    @ApiOperation("通过箱标EPC获取件标EPC")
    @DecryptionRequired
    public Api2Res<List<ChannelEpcByBoxDto>> GetEpcListByBoxMarkEpc(@RequestBody GetEpcListByBoxMarkEpcReq req)
    {
        return Api2Res.success(channelService.GetEpcListByBoxMarkEpc(req));
    }

    @PostMapping(path = "/Mission/GetEpcListByBagInvEpc", name = "获取装备包内EPC信息#enable")
    @ApiOperation("获取装备包内EPC信息")
    @DecryptionRequired
    public Api2Res<List<ChannelEpcByBoxInvDto>> GetEpcListByBagInvEpc(@RequestBody GetEpcListByBagInvEpcReq req)
    {
        return Api2Res.success(channelService.GetEpcListByBagInvEpc(req));
    }

    @PostMapping(path = "/ChannelCfg/UploadFace", name = "警员图片上传#logType=30")
    @ApiOperation("警员图片上传")
    @DecryptionRequired
    public Api2Res UploadFace(@RequestParam("id") String id, @RequestPart("picture") MultipartFile picture)
    {
        return channelService.UploadFace(id, picture) ?
                Api2Res.success() :
                Api2Res.failure(JyzbV2ExceptionEnum.OPERATE_FAILED);
    }

    @PostMapping(path = "/Inventory/UploadRFIDNew", name = "Rfid数据上报#logType=30")
    @ApiOperation("Rfid数据上报")
    @DecryptionRequired
    public Api2Res<List<ChannelUploadRFIDDto>> UploadRFIDNew(@RequestBody UploadRFIDReq req)
    {
        return Api2Res.success(channelService.UploadRFIDNew(req));
    }

    @PostMapping(path = "/Inventory/GetOpenOrderInfo", name = "获取当前仓库开启的单据#enable")
    @ApiOperation("获取当前仓库开启的单据")
    @DecryptionRequired
    public Api2Res<ChannelOpenOrderDto> GetOpenOrderInfo(@RequestBody GetOpenOrderInfoReq req)
    {
        return Api2Res.success(channelService.GetOpenOrderInfo(req));
    }
}
