package com.junmp.jyzb.jyzbthirdparty.service;

import com.junmp.jyzb.jyzbthirdparty.bean.dto.*;
import com.junmp.jyzb.jyzbthirdparty.bean.req.*;
import com.junmp.jyzb.jyzbthirdparty.entity.TPCabinetBoxPolice;
import com.junmp.v2.sys.api.bean.role.dto.SysRoleDto;

import java.util.List;

public interface ThirdPartyService {

    /**
     * 组织机构信息同步
     * @param req
     * @return
     */
    List<TPPubOrgDto> SyncPubOrg(TPPubOrgReq req);


    /**
     * 仓库信息同步
     * @param req
     * @return
     */
    List<TPWarehouseDto> SyncWarehouse(TPWarehouseReq req);

    /**
     * 装备基础信息同步
     * @param req
     * @return
     */
    List<TPTypeDto> SyncType(TPTypeReq req);

    /**
     * 装备号型基础信息同步
     * @param req
     * @return
     */
    List<TPSizeDto> SyncSize(TPSizeReq req);

    /**
     * 供应商基础信息同步
     * @param req
     * @return
     */
    List<TPSupplierDto> SyncSupplier(TPSupplierReq req);


    /**
     * 用户信息同步
     * @param req
     * @return
     */
    List<TPUserDto> SyncUser(TPUserReq req);

    TPBaseInfoDto syncBaseInfo(TPBaseInfoReq req);

    /**
     * 警柜信息同步
     */
    List<TPCabinetDto> syncCabinet(TPCabinetReq req);

    /**
     * 入库单据同步
     * @param req
     * @return
     */
    List<TPInOrderDto> syncInOrder(TPInOrderReq req);

    /**
     * 出库单据同步
     * @param req
     * @return
     */
    List<TPOutOrderDto> syncOutOrder(TPOutOrderReq req);

    /**
     * 库存同步
     * @param req
     * @return
     */
    boolean syncInvSummary(TPSummaryReq req);

    /**
     * 出库单据记账
     * @param req
     * @return
     */
    boolean syncOutOrderAccounting(TPOutOrderAccountReq req);

    Boolean syncOutOrderLastInfo(TPOutOrderAccountReq req);

    /**
     * 入库单据记账
     * @param req
     * @return
     */
    boolean syncInOrderAccounting(TPInOrderAccountReq req);


    /**
     * 上报完成的入库单据（最后一次任务单据结束后上报）
     * @param req
     * @return
     */
    Boolean syncInOrderLastInfo(TPInOrderAccountReq req);

    /**
     * 下发单据
     */
    boolean dispatchOrder(TPDispatchOrderReq req);


    /**
     * 同步警员信息
     * @param req
     * @return
     */
    TPPoliceDto syncPoliceInfo(TPPoliceReq req);

    String createValueKey(String orgCode,String locationId,String typeId,String sizeId,String unitPrice,String property);

    boolean pushAddPoliceInfo(TPUpdatePoliceReq req);

    boolean pushAddCabinetInfo(TPCabDto req);

    boolean bindBoxToPolice(TPUpdatePoliceReq req);

    List<TPCabinetBoxPolice> syncBoxBindPoliceInfo(TPUpdatePoliceReq req);

    List<SysRoleDto> syncRoles();

    Boolean getTaskWokingState(String orderCode,String config);

    Boolean getLasterOrderInfo(String orderId,String orderType,String orderCode, String itemValue);

    Boolean editOrderStatus(String orderCode, String itemValue);
}
