package com.junmp.jyzb.jyzbthirdparty.service.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.jyzbthirdparty.entity.TPPoliceman;
import com.junmp.jyzb.jyzbthirdparty.exception.ThirdPartyException;
import com.junmp.jyzb.jyzbthirdparty.exception.enums.ErrorExceptionEnum;
import com.junmp.jyzb.jyzbthirdparty.mapper.TPPolicemanMapper;
import com.junmp.jyzb.jyzbthirdparty.service.TPPolicemanService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
@Slf4j
public class TPPolicemanServiceImpl extends ServiceImpl<TPPolicemanMapper, TPPoliceman> implements TPPolicemanService {


    /**
     * 根据userId判断警员是否存在
     * @param userId
     * @return
     */
    @Override
    public TPPoliceman policeExist(Long userId) {
        List<TPPoliceman> list = list(new LambdaQueryWrapper<TPPoliceman>().eq(TPPoliceman::getUserId, userId));
        if (CollectionUtil.isEmpty(list)){
            throw new ThirdPartyException(ErrorExceptionEnum.POLICE_ERROR);
        }
        return list.get(0);
    }
}
