package com.junmp.jyzb.jyzbthirdparty.mapper;
import com.junmp.jyzb.jyzbthirdparty.bean.dto.*;
import com.junmp.jyzb.jyzbthirdparty.bean.req.TPBaseInfoReq;
import com.junmp.jyzb.jyzbthirdparty.bean.req.TPInOrderReq;
import com.junmp.jyzb.jyzbthirdparty.bean.req.TPPoliceReq;
import com.junmp.v2.sys.api.bean.role.dto.SysRoleDto;
import com.junmp.v2.sys.user.entity.SysUserRole;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface ThirdPartyMapper {
    //同步组织机构信息
    List<TPPubOrgDto> SyncPubOrg(@Param("orgId") Long orgId,@Param("orgCode") String orgCode,@Param("updateTime") Date updateTime);

    List<TPWarehouseDto> SyncWarehouse(@Param("orgId") Long orgId,@Param("orgCode") String orgCode,@Param("updateTime") Date updateTime);

    List<TPTypeDto> SyncType(@Param("type") Integer type,@Param("updateTime") Date updateTime);

    List<TPSizeDto> SyncSize(@Param("typeCode") String typeCode,@Param("updateTime") Date updateTime);

    List<TPSupplierDto> SyncSupplier(@Param("updateTime") Date updateTime);

    List<TPUserDto> SyncUser(@Param("orgId") Long orgId,@Param("updateTime") Date updateTime);

    List<TPBaseInfoDto.goodsDto> getGoodList(@Param("updateTime") Date updateTime);

    List<TPBaseInfoDto.sizeDto> getSizeList(@Param("updateTime") Date updateTime);

    List<TPBaseInfoDto.typeDto> getTypeList(@Param("updateTime") Date updateTime);

    List<TPCabinetDto> getCabinetList(@Param("cabinetId") String cabinetId,@Param("orgId")  Long orgId, @Param("updateTime") Date updateTime);

    List<TPCabinetDto.TPCabinetBoxDto> getBoxList(@Param("cabinetIdList") List<String> cabinetIdList);

    TPOrgInfoDto getOrgInfo(@Param("orgId") Long orgId);

    List<TPInOrderDto> getInOrderList(@Param("orgId") Long orgId,@Param("updateTime") Date updateTime);

    List<TPOutOrderDto> getOutOrderList(@Param("orgId") Long orgId,@Param("updateTime") Date updateTime);

    List<TPInOrderDto.TPInOrderDetailDto> getInOrderDetailList(@Param("orderIdList") List<String> orderIdList);
    List<TPOutOrderDto.TPOutOrderDetailDto> getOutOrderDetailList(@Param("orderIdList") List<String> orderIdList);

    TPWarehouseDto getOneWarehouse(@Param("orgId")Long orgId);

    boolean updateSyncFlagByOrderIds(@Param("idList")List<String> successList);

    List<TPPoliceDto.PoliceDto> getPoliceList(@Param("orgId") Long orgId,@Param("updateTime") Date updateTime);

    List<TPPoliceDto.FingerDto> getFingerList(@Param("idList") List<String> policeIdList,@Param("updateTime")Date updateTime);

    List<SysRoleDto> syncRoles();

    List<SysUserRole> getRoleIdsByUserIds(@Param("list") List<Long> userIdsList);
}
