package com.junmp.jyzb.jyzbthirdparty.expander;

import cn.hutool.core.util.StrUtil;
import com.junmp.v2.config.api.context.ConfigContext;

/**
 * 配置文件的扩展
 */
public class ThirdPartyExpander {

    private static String SYNC_API_HOST = "http://192.168.3.10:10052";


    public static String getSyncApiHost(String configCode){
        return ConfigContext.getContext().getSysConfigValueWithDefault(configCode,String.class,SYNC_API_HOST);
    }

    public static  String syncInOrder(String config){
        String path = ConfigContext.getContext().getSysConfigValueWithDefault("SYNC_IN_ORDER", String.class, "/v2/wms/receive/receiveInOrder");
        return StrUtil.format("{}{}",getSyncApiHost(config),path);
    }
    public static String syncOutOrder(String config){
        String path = ConfigContext.getContext().getSysConfigValueWithDefault("SYNC_OUT_ORDER", String.class, "/v2/wms/receive/receiveOutOrder");
        return StrUtil.format("{}{}",getSyncApiHost(config),path);
    }

    /**
     * 判断是否有正在执行的任务
     * @param config
     * @return
     */
    public static String getTaskWokingState(String config) {
        String path = ConfigContext.getContext().getSysConfigValueWithDefault("GET_TASK_WORKING_STATE", String.class, "/v2/wms/receive/getRunningWork");
        return StrUtil.format("{}{}",getSyncApiHost(config),path);
    }

    /**
     * 获取最新的单据信息
     */
    public static String getLasterOrderInfo(String config) {
        String path = ConfigContext.getContext().getSysConfigValueWithDefault("GET_LASTER_ORDER_INFO", String.class, "/v2/wms/receive/getOrderData");
        return StrUtil.format("{}{}",getSyncApiHost(config),path);
    }

    /**
     * 修改单据状态
     * @param config
     * @return
     */
    public static String editOrderStatus(String config) {
        String path = ConfigContext.getContext().getSysConfigValueWithDefault("EDIT_ORDER_STATUS", String.class, "/v2/wms/receive/editOrderStatus");
        return StrUtil.format("{}{}",getSyncApiHost(config),path);
    }
}
