package com.junmp.jyzb.jyzbthirdparty.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum ErrorExceptionEnum  implements IExceptionEnum {

    ORG_ERROR(CommonConstant.DEFAULT_SYS_ERROR_CODE+1,"组织机构信息为空"),
    INV_SUMMARY_SYNC_ERROR(CommonConstant.DEFAULT_SYS_ERROR_CODE+2,"库存更新失败"),
    PARAM_ERROR(CommonConstant.DEFAULT_SYS_ERROR_CODE+3,"请求参数错误或为空"),
    POLICE_ERROR(CommonConstant.DEFAULT_SYS_ERROR_CODE+4,"警员信息不存在"),
    SEND_ORDER_ERROR(CommonConstant.DEFAULT_SYS_ERROR_CODE+4,"下发单据异常，没有配置对应组织机构"),
    ;

    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    ErrorExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
