package com.junmp.jyzb.jyzbthirdparty.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName base_log_detail
 */
@TableName(value ="base_log_detail")
@Data
public class TPLogDetail implements Serializable {
    /**
     * 出入库明细ID
     */
    @TableId(type = IdType.AUTO)
    private Long detailId;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 组织机构Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 出入库汇总id
     */
    @TableField(value = "summary_id")
    private Long summaryId;

    /**
     * 物资id
     */
    @TableField(value = "inventory_id")
    private String inventoryId;

    /**
     * 业务类型
     */
    @TableField(value = "bussiness_type")
    private String bussinessType;

    /**
     * EPC信息
     */
    @TableField(value = "epc")
    private String epc;

    /**
     * 装备类型id
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 装备类型名称
     */
    @TableField(value = "type_name")
    private String typeName;

    /**
     * 装备号型id
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 装备号型名称
     */
    @TableField(value = "size_name")
    private String sizeName;

    /**
     * 供应商id
     */
    @TableField(value = "supplier_id")
    private String supplierId;

    /**
     * 供应商名称
     */
    @TableField(value = "supplier_name")
    private String supplierName;

    /**
     * 装备类型:0单件/1装备包
     */
    @TableField(value = "equipment_type")
    private Integer equipmentType;

    /**
     * 箱门id
     */
    @TableField(value = "cabinetbox_id")
    private String cabinetboxId;

    /**
     * 状态，0正常/1异常
     */
    @TableField(value = "error_state")
    private Integer errorState;

    /**
     * 出入状态：in入库，out出库
     */
    @TableField(value = "out_in_state")
    private String outInState;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 更新人员
     */
    @TableField(value = "update_user")
    private String updateUser;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 照片信息
     */
    @TableField(value = "picture")
    private String picture;

    /**
     * 单价
     */
    @TableField(value = "price")
    private BigDecimal price;

    /**
     * epc类型（0固定资产，1库存物资非固定资产）
     */
    @TableField(value = "property")
    private Integer property;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}