package com.junmp.jyzb.jyzbthirdparty.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName base_inventory
 */
@TableName(value ="base_inventory")
@Data
public class TPInventory implements Serializable {
    /**
     * 装备ID
     */
    @TableId(value = "id",type= IdType.ASSIGN_UUID)
    private String id;

    /**
     * 装备包ID
     */
    @TableField("package_id")
    private String packageId;

    /**
     * 装备类型ID
     */
    @TableField("type_id")
    private String typeId;

    /**
     * 号型ID
     */
    @TableField("size_id")
    private String sizeId;

    /**
     * 供应商ID
     */
    @TableField("supplier_id")
    private String supplierId;

    /**
     * 部门id
     */
    @TableField("department_id")
    private Long departmentId;

    /**
     * 货架位置
     */
    @TableField("shelf_location")
    private String shelfLocation;

    /**
     * 货架ID
     */
    @TableField("shelf_id")
    private String shelfId;

    /**
     * EPC信息
     */
    private String epc;

    /**
     * 新版本组织机构外键
     */
    @TableField("org_id_int")
    private Long orgId;

    /**
     * 状态:normal正常/broken 报废或损坏/destory销毁/fix维修
     */
    private String state;

    /**
     * 业务状态:无业务:normal/调拨transfer/借用borrow/领用take/remove报废/destruction销毁/repair维修
     */
    @TableField("bussiness_state")
    private String bussinessState;

    /**
     * 在库状态:in在库，out出库
     */
    @TableField("location_state")
    private String locationState;

    /**
     * 生产日期
     */
    @TableField(value = "production_date")
    private Date productionDate;

    /**
     * 质保期
     */
    @TableField(value = "warranty_period")
    private Integer warrantyPeriod;

    /**
     * 维保期
     */
    @TableField(value = "maintenance_period")
    private Integer maintenancePeriod;

    /**
     * 维修次数
     */
    @TableField("fix_count")
    private Integer fixCount;

    /**
     * 仓库/单警柜ID
     */
    @TableField(value = "location_id")
    private String locationId;

    /**
     * 所属位置:0仓库，1单警柜
     */
    @TableField(value = "location_type")
    private Integer locationType;

    /**
     * 是否遗失
     */
    @TableField(value = "lost_flag")
    private Integer lostFlag;

    /**
     * 标签Tid，用于区分EPC相同的物资
     */
    private String tid;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 超期状态:0未超期，1已超期，2不再提醒
     */
    @TableField("term_state")
    private Integer termState;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 备注
     */
    private String note;

    /**
     * 更新人员
     */
    @TableField(value = "update_user")
    private String updateUser;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 0实体物资，1虚拟物资
     */
    @TableField("epc_type")
    private Integer epcType;

    /**
     * 区域id
     */
    @TableField("area_id")
    private String areaId;

    /**
     * epc类型（0为固定资产，1为库存物资非固定资产）
     */
    @TableField(value = "property")
    private Integer property;

    /**
     * 装备绑定状态（1表示绑定箱门，0或空表示解绑箱门或没有绑定）
     */
    @TableField(value = "eqs_bind_state")
    private Integer eqsBindState;

    /**
     * 警员id
     */
    @TableField(value = "police_id")
    private String policeId;

    /**
     * 箱标id
     */
    @TableField(value = "box_mark_id")
    private String boxMarkId;

    /**
     * 标签实例化状态（打印or绑定过）0：其他 1：未打印 2：已打印
     */
    @TableField(value = "instantiation_state")
    private Integer instantiationState;

    /**
     * 是否在箱内（箱标未拆箱）
     */
    @TableField(value = "is_in_box")
    private Integer isInBox;

    /**
     * 装备绑定位置（单警柜箱门id）
     */
    @TableField(value = "bind_location_id")
    private String bindLocationId;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}