package com.junmp.jyzb.jyzbthirdparty.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "com-junmp-jyzb-domain-Cabinet")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_cabinet")


public class TPCabinet implements Serializable {
    /**
     * 单警柜ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_UUID)
    private String id;
    /**
     * 单警柜名称
     */
    @ApiModelProperty(value = "单警柜名称")
    private String name;

    /**
     * 新版本组织机构号
     */
    @ApiModelProperty(value = "新版本组织机构号")
    @TableField("org_id_int")
    private Long orgIdInt;

    /**
     * 组织机构代码
     */
    @TableField("org_code")
    private String orgCode;

    /**
     * 单警柜编号
     */
    @TableField("dev_sn")
    private String devSn;

    /**
     * 旧版单警柜编号
     */
    @TableField("old_dev_sn")
    private String oldSevSn;

    /**
     * 部门id
     */
    @ApiModelProperty(value = "部门id")
    @TableField("department_id")
    private Integer departmentId;
    /**
     * 位置信息
     */
    @ApiModelProperty(value = "位置信息")
    private String location;

    /**
     * 单警柜当前状态，0正常，1异常
     */
    @ApiModelProperty(value = "单警柜当前状态，0正常，1异常")
    private Integer state;

    /**
     * 单警柜在线状态，0正常，1异常
     */
    @ApiModelProperty(value = "单警柜在线状态，0离线，1在线")
    @TableField("online_state")
    private Integer onlineState;
    /**
     * 装备总数
     */
    @ApiModelProperty(value = "装备总数")
    private Integer sum;

    /**
     * 在库装备总数
     */
    @ApiModelProperty(value = "在库装备总数")
    @TableField("in_sum")
    private Integer inSum;

    /**
     * 出库装备总数
     */
    @ApiModelProperty(value = "出库装备总数")
    @TableField("out_sum")
    private Integer outSum;

    /**
     * 主柜配置信息
     */
    @ApiModelProperty(value = "主柜配置信息")
    private String config;

    /**
     * 库存总价
     */
    @ApiModelProperty(value = "库存总价")
    @TableField("price_total")
    private BigDecimal priceTotal;

    @TableField(fill = FieldFill.INSERT_UPDATE, value = "create_time")
    private Date createTime;

    @TableField(fill = FieldFill.INSERT_UPDATE, value = "update_time")
    private Date updateTime;

    /**
     * 新增人员
     */
    @ApiModelProperty(value = "新增人员")
    @TableField("create_user")
    private String createUser;

    /**
     * 更新人员
     */
    @ApiModelProperty(value = "更新人员")
    @TableField("update_user")
    private String updateUser;

    /**
     * 箱数
     */
    @ApiModelProperty(value = "箱数")
    private Integer num;

    /**
     * 版本号
     */
    @TableField("version")
    private String version;

    /**
     * 是否升级（0不升级，1升级）
     */
    @TableField("is_upgrade")
    private Integer isUpgrade;


    @ApiModelProperty(value = "socket连接信息")
    @TableField("channel_id")
    private String channelId;

    @TableField(exist = false)
    private String policeName;
    @TableField(exist = false)
    private String policeId;
    @TableField(exist = false)
    private Integer boxNo;
    @TableField(exist = false)
    private String orgName;
    @TableField(exist = false)
    private String boxId;
    @TableField(exist = false)
    private String containType;
    @TableField(exist = false)
    private String boxState;
    @TableField(exist = false)
    private String equipmentConfig;
    private static final long serialVersionUID = 1L;
}
