package com.junmp.jyzb.jyzbthirdparty.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.junmp.jyzb.jyzbthirdparty.bean.dto.*;
import com.junmp.jyzb.jyzbthirdparty.bean.req.*;
import com.junmp.jyzb.jyzbthirdparty.entity.TPCabinetBoxPolice;
import com.junmp.jyzb.jyzbthirdparty.entity.TPInvSummary;
import com.junmp.jyzb.jyzbthirdparty.entity.TPInventory;
import com.junmp.jyzb.jyzbthirdparty.mapper.TPInventoryMapper;
import com.junmp.jyzb.jyzbthirdparty.service.TPInvSummaryService;
import com.junmp.jyzb.jyzbthirdparty.service.ThirdPartyService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.config.api.context.ConfigContext;
import com.junmp.v2.sys.api.bean.role.dto.SysRoleDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/thirdParty")
@Api(value = "ThirdParty API",tags = "[第三方]第三方接口")
@Slf4j
public class ThirdPartyController {

    @Resource
    private ThirdPartyService thirdPartyService;

    @Resource
    private TPInvSummaryService tpInvSummaryService;

    @Resource
    private TPInventoryMapper tpInventoryMapper;

    /**
     * 组织机构同步
     */
    @PostMapping("/syncPubOrg")
    @ApiOperation("同步组织机构")
    public Api3Res<List<TPPubOrgDto>> SyncPubOrg(@RequestBody TPPubOrgReq req){

        return Api3Res.success(thirdPartyService.SyncPubOrg(req));
    }

    /**
     * 库房信息同步
     */
    @PostMapping("/syncWarehouse")
    @ApiOperation("仓库信息同步")
    public Api3Res<List<TPWarehouseDto>> SyncWarehouse(@RequestBody TPWarehouseReq req){

        return Api3Res.success(thirdPartyService.SyncWarehouse(req));
    }


    /**
     *警柜信息同步
     */
    @PostMapping("/syncCabinet")
    @ApiOperation("警柜基础信息同步")
    public Api3Res<List<TPCabinetDto>> syncCabinet(@RequestBody TPCabinetReq req){
        return Api3Res.success(thirdPartyService.syncCabinet(req));
    }


    @PostMapping("/syncType")
    @ApiOperation("类型基础信息同步")
    public Api3Res<List<TPTypeDto>> SyncType(@RequestBody TPTypeReq req){

        return Api3Res.success(thirdPartyService.SyncType(req));
    }

    @PostMapping("/syncSize")
    @ApiOperation("号型基础信息同步")
    public Api3Res<List<TPSizeDto>> SyncSize(@RequestBody TPSizeReq req){

        return Api3Res.success(thirdPartyService.SyncSize(req));
    }

    /**
     * 装备基础信息同步
     */
    @PostMapping("/syncBaseInfo")
    @ApiOperation("装备基础信息同步")
    public Api3Res<TPBaseInfoDto> syncBaseInfo(@RequestBody TPBaseInfoReq req){

        return Api3Res.success(thirdPartyService.syncBaseInfo(req));
    }

    /**
     *供应商信息同步
     */
    @PostMapping("/syncSupplier")
    @ApiOperation("供应商信息同步")
    public Api3Res<List<TPSupplierDto>> SyncSupplier(@RequestBody TPSupplierReq req){

        return Api3Res.success(thirdPartyService.SyncSupplier(req));
    }

    /**
     *用户信息同步(除去警员的账号，警员的账号另外接口进行同步)
     */
    @PostMapping("/syncUser")
    @ApiOperation("用户信息同步")
    public Api3Res<List<TPUserDto>> SyncUser(@RequestBody @Validated(ValidationApi.detail.class) TPUserReq req){

        return Api3Res.success(thirdPartyService.SyncUser(req));
    }

    /**
     *角色信息同步
     */
    @PostMapping("/syncRoles")
    @ApiOperation("角色信息同步")
    public Api3Res<List<SysRoleDto>> syncRoles(){

        return Api3Res.success(thirdPartyService.syncRoles());
    }

    /**
     *警员信息同步
     */

    @PostMapping("/syncPoliceInfo")
    @ApiOperation("警员信息同步")
    public Api3Res<TPPoliceDto> syncPoliceInfo(@RequestBody TPPoliceReq req){
        return Api3Res.success(thirdPartyService.syncPoliceInfo(req));
    }

    /**
     *入库单据同步
     */
    @PostMapping("/syncInOrder")
    @ApiOperation("入库单据同步")
    public Api3Res<List<TPInOrderDto>> syncInOrder(@RequestBody TPInOrderReq req){
        return Api3Res.success(thirdPartyService.syncInOrder(req));
    }

    /**
     *入库单据记账
     */
    @PostMapping("/syncInOrderAccounting")
    @ApiOperation("入库单据记账")
    public Api3Res<Boolean> syncInOrderAccounting (@RequestBody TPInOrderAccountReq req){
        return Api3Res.success(thirdPartyService.syncInOrderAccounting(req));
    }

    /**
     * 上报完成的入库单据（最后一次任务单据结束后上报）
     * @param req
     * @return
     */
    @PostMapping("/syncInOrderLastInfo")
    @ApiOperation("上报完成的入库单据")
    public Api3Res<Boolean> syncInOrderLastInfo (@RequestBody TPInOrderAccountReq req){
        return Api3Res.success(thirdPartyService.syncInOrderLastInfo(req));
    }

    /**
     *出库单据同步
     */
    @PostMapping("/syncOutOrder")
    @ApiOperation("出库单据同步")
    public Api3Res<List<TPOutOrderDto>> syncInOrder(@RequestBody TPOutOrderReq req){
        return Api3Res.success(thirdPartyService.syncOutOrder(req));
    }
    /**
     *出库单据记账
     */
    @PostMapping("/syncOutOrderAccounting")
    @ApiOperation("出库单据记账")
    public Api3Res<Boolean> syncOutOrderAccounting (@RequestBody TPOutOrderAccountReq req){
        return Api3Res.success(thirdPartyService.syncOutOrderAccounting(req));
    }

    /**
     * 上报完成的出库单据（最后一次任务单据结束后上报）
     * @param req
     * @return
     */
    @PostMapping("/syncOutOrderLastInfo")
    @ApiOperation("上报完成的出库单据")
    public Api3Res<Boolean> syncOutOrderLastInfo (@RequestBody TPOutOrderAccountReq req){
        return Api3Res.success(thirdPartyService.syncOutOrderLastInfo(req));
    }

    /**
     *库存信息同步
     */
    @PostMapping("/syncInvSummary")
    @ApiOperation("库存汇总信息同步")
    public Api3Res<Boolean> syncInvSummary(@RequestBody TPSummaryReq req){
        return Api3Res.success(thirdPartyService.syncInvSummary(req));
    }

    @PostMapping("/pushAddPoliceInfo")
    @ApiOperation("下级推送的新增警员信息")
    public Api3Res<Boolean> pushAddPoliceInfo(@RequestBody TPUpdatePoliceReq req){
        return Api3Res.success(thirdPartyService.pushAddPoliceInfo(req));
    }


    @PostMapping("/pushAddCabinetInfo")
    @ApiOperation("下级推送的新增单警柜信息")
    public Api3Res<Boolean> pushAddCabinetInfo(@RequestBody TPCabDto req){
        return Api3Res.success(thirdPartyService.pushAddCabinetInfo(req));
    }

    @PostMapping("/bindBoxToPolice")
    @ApiOperation("绑定箱门到警员")
    public Api3Res<Boolean> bindBoxToPolice(@RequestBody TPUpdatePoliceReq req){
        return Api3Res.success(thirdPartyService.bindBoxToPolice(req));
    }

    @PostMapping("/syncBoxBindPoliceInfo")
    @ApiOperation("同步警员绑定的箱门信息")
    public Api3Res<List<TPCabinetBoxPolice>> syncBoxBindPoliceInfo(@RequestBody TPUpdatePoliceReq req){
        return Api3Res.success(thirdPartyService.syncBoxBindPoliceInfo(req));
    }

    @PostMapping("/dispatchOrder")
    @ApiOperation("下发单据")
    public Api3Res<Boolean> dispatchOrder(@RequestBody TPDispatchOrderReq req){
        return Api3Res.success(thirdPartyService.dispatchOrder(req));
    }

    @PostMapping("/test")
    public Api3Res<Boolean> test(){
        String configValue = ConfigContext.getContext().getConfigValue("SYNC_API_HOST", String.class);

        System.out.println("configValue = " + configValue);
        return Api3Res.success(true);
    }

    @GetMapping(path = "/getTest")
    public Api3Res<Boolean> getTest(String price){
        Map<String,Object[]> invMap=new HashMap<>();
        Map<String,Object[]> searchMap=new HashMap<>();
        String orgCode="330200000000";
        Long orgId=1369509498032812475L;
        String warehouseId="9715e5ac-b76f-4dd7-8b9c-56b3c592ce62";
        String typeId="4101004";
        String sizeId="d1fe4735-7227-4bf0-9ed8-3415e65b4abd";
        BigDecimal unitPrice=BigDecimal.ZERO;
        if (ObjectUtil.isNotNull(price) && ObjectUtil.isNotEmpty(price) ){
            unitPrice=new BigDecimal(price);

        }
        String valuekey=thirdPartyService.createValueKey(orgCode, warehouseId, typeId, sizeId, unitPrice.toString(), "0");
        if (invMap.containsKey(valuekey)){
            Object[] objects = invMap.get(valuekey);
            objects[4]=(int)objects[4]+2;
            invMap.put(valuekey,objects);
        }else {
            Object[] item=new Object[]{orgId, warehouseId, typeId, sizeId, unitPrice.toString(),2};
            invMap.put(valuekey,item);
        }

        List<TPInventory> invList;

        if (!invMap.isEmpty()){
            List<Object[]> itemList=new ArrayList<>(invMap.values());
            invList=tpInventoryMapper.getInfoList(itemList);
            log.info("invList = " + invList);
            for (TPInventory inventory:invList) {
                String key=inventory.getOrgId()+inventory.getLocationId()+inventory.getTypeId()+inventory.getSizeId()+inventory.getPrice();
                if (searchMap.containsKey(key)){
                    Object[] objects = searchMap.get(key);
                    objects[5]=(Integer)objects[5]+1;
                    searchMap.put(key,objects);
                }else {
                    Object[] item=new Object[]{inventory.getOrgId(),inventory.getLocationId(),inventory.getTypeId(),inventory.getSizeId(),inventory.getPrice(),1};
                    searchMap.put(key,item);
                }

            }
        }
        List<TPInvSummary> inventorySummaryList = tpInventoryMapper.selectSum(new ArrayList<>(searchMap.values()));
        log.info("inventorySummaryList = " + inventorySummaryList);

        return Api3Res.success(true);
    }


}
