package com.junmp.jyzb.jyzbthirdparty.cache;

import com.junmp.jyzb.jyzbthirdparty.bean.constant.ThirdPartyConstant;
import com.junmp.jyzb.jyzbthirdparty.bean.req.TPOrderRedisReq;
import com.junmp.v2.cache.AbstractRedisCache;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Component
public class OrderRedisCache extends AbstractRedisCache<Object> {
    public OrderRedisCache(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
    }

    @Override
    public String getCommonKeyPrefix() {
        return ThirdPartyConstant.TP_OUT_ORDER_PREFIX;
    }

    //添加失败的出库单存入redis
    public void addFailedUploadOutOrder(TPOrderRedisReq req, Long timestamp){
        getRedisTemplate().opsForZSet().add(ThirdPartyConstant.TP_OUT_ORDER_PREFIX,req,timestamp);
    }


    //从redis中获取失败的出库单
    public List<Object> getOutOrderList(String key){
        Set<Object> range = getRedisTemplate().opsForZSet().range(key, -1, -1);
        return new ArrayList<>(range);
    }


    //添加失败的入库单存入redis
    public void addFailedUploadInOrder(TPOrderRedisReq req, Long timestamp){
        getRedisTemplate().opsForZSet().add(ThirdPartyConstant.TP_IN_ORDER_PREFIX,req,timestamp);
    }


    //从redis中获取失败的入库单
    public List<Object> getInOrderList(String key){
        Set<Object> range = getRedisTemplate().opsForZSet().range(key, -1, -1);
        return new ArrayList<>(range);
    }

}
