package com.junmp.jyzb.jyzbthirdparty.bean.dto;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class TPInOrderDto {

    /**
     * 	主单据id
     */
    private String BillId;

    /**
     * 单据类型
     */
    private String orderType;

    /**
     * 工作年度
     */
    private String gznd;

    private String supplierId;

    private String supplierName;

    /**
     * 单据编号
     */
    private String orderNo;

    /**
     * 发物单位id
     */
    private String fwOrgCode;

    /**
     * 发物单位名称
     */
    private String fwOrgName;

    /**
     * 收物单位id
     */
    private String swOrgCode;

    /**
     * 收物单位名称
     */
    private String swOrgName;

    /**
     * 经办人id
     */
    private Long operatorId;

    /**
     * 经办人名称
     */
    private String operatorName;

    /**
     * 操作类型（1主平台同步，0下游自己创建）
     */
    private Integer source;

    /**
     * 库房编码
     */
    private String storeCode;

    private String storeId;

    private String storeName;

    /**
     * 计划数量
     */
    private Integer planQty;

    /**
     * 实际入库数量
     */
    private Integer actualQty;

    /**
     * 申请时间
     */
    private Date useDate;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 单据状态
     */
    private String orderState;

    /**
     * 备注
     */
    private String remark;

    /**
     * 附件地址
     */
    private String attachmentLocation;

    private List<TPInOrderDetailDto> detailList;

    @Data
    public static class TPInOrderDetailDto{
        /**
         * 子单据id
         */
        private String detailId;
        /**
         *主单据id
         */
        private String refBillId;
        /**
         *	单据编号（冗余）
         */
        private String orderNo;
        /**
         *物料编号
         */
        private String goodsCode;
        /**
         *物料名称
         */
        private String goodsName;
        /**
         *类型名称
         */
        private String modelName;
        /**
         * 号型id
         */
        private String specId;
        /**
         *号型编码
         */
        private String modelCode;
        /**
         *物料唯一编码
         */
        private String skuCode;
        /**
         *子单备注
         */
        private String remark;
        /**
         *计划数量
         */
        private BigDecimal planQty;
        /**
         *实际数量
         */
        private BigDecimal actualQty;
        /**
         *记账数量
         */
        private BigDecimal modifyQty;
        /**
         *创建时间
         */
        private Date createTime;
        /**
         *更新时间
         */
        private Date updateTime;
    }

}
