package com.junmp.jyzb.jyzbthirdparty.bean.dto;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import com.junmp.v2.common.exception.IExceptionEnum;

import java.io.Serializable;


public class Api3Res<T> implements Serializable {
    private int code;
    private T data;
    private String message = "ok";
    private long timestamp = System.currentTimeMillis();

    public Api3Res(int code, T data, String message) {
        this.code = code;
        this.data = data;
        this.message = message;
    }

    public static <S> Api3Res<S> success(S data) {
        return new Api3Res(99200, data, "操作成功");
    }

    public static Api3Res<Boolean> success() {
        return new Api3Res(99200, true, "操作成功");
    }

    private static <E> Api3Res<E> failure(int code, String message, Object... args) {
        String temp = StrUtil.isNotEmpty(message) ? message : "系统繁忙";
        if (null != args && args.length > 0) {
            temp = String.format(temp, args);
        }

        return new Api3Res(code, (Object)null, temp);
    }

    public static <E> Api3Res<E> failure(int code, String message) {
        return failure(code, message, (Object[])null);
    }

    public static <S> Api3Res<S> failure(int code,S data) {
        return new Api3Res(code, data, "操作失败");
    }

    public static <E> Api3Res<E> failure(IExceptionEnum enumCode) {
        return failure(enumCode.getCode(), enumCode.getMessage());
    }

    public static <E> Api3Res<E> failure(String message) {
        return failure(99500, message);
    }

    public String textJson() {
        return JSON.toJSONString(this);
    }

    public byte[] binaryJson() {
        return JSON.toJSONBytes(this);
    }

    public static <T> Api3Res.ApiResBuilder<T> builder() {
        return new Api3Res.ApiResBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Api3Res<T> setCode(final int code) {
        this.code = code;
        return this;
    }

    public Api3Res<T> setData(final T data) {
        this.data = data;
        return this;
    }

    public Api3Res<T> setMessage(final String message) {
        this.message = message;
        return this;
    }

    public Api3Res<T> setTimestamp(final long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof Api3Res)) {
            return false;
        } else {
            Api3Res<?> other = (Api3Res)o;
            if (!other.canEqual(this)) {
                return false;
            } else if (this.getCode() != other.getCode()) {
                return false;
            } else if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            } else {
                label40: {
                    Object this$data = this.getData();
                    Object other$data = other.getData();
                    if (this$data == null) {
                        if (other$data == null) {
                            break label40;
                        }
                    } else if (this$data.equals(other$data)) {
                        break label40;
                    }

                    return false;
                }

                Object this$message = this.getMessage();
                Object other$message = other.getMessage();
                if (this$message == null) {
                    if (other$message != null) {
                        return false;
                    }
                } else if (!this$message.equals(other$message)) {
                    return false;
                }

                return true;
            }
        }
    }

    protected boolean canEqual(final Object other) {
        return other instanceof Api3Res;
    }

    public int hashCode() {
//        int PRIME = true;
        int result = 1;
        result = result * 59 + this.getCode();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Object $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "ReturnPonse(code=" + this.getCode() + ", data=" + this.getData() + ", message=" + this.getMessage() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static class ApiResBuilder<T> {
        private int code;
        private T data;
        private String message;

        ApiResBuilder() {
        }

        public Api3Res.ApiResBuilder<T> code(final int code) {
            this.code = code;
            return this;
        }

        public Api3Res.ApiResBuilder<T> data(final T data) {
            this.data = data;
            return this;
        }

        public Api3Res.ApiResBuilder<T> message(final String message) {
            this.message = message;
            return this;
        }

        public Api3Res<T> build() {
            return new Api3Res(this.code, this.data, this.message);
        }

        public String toString() {
            return "ReturnPonse.ApiResBuilder(code=" + this.code + ", data=" + this.data + ", message=" + this.message + ")";
        }
    }

}
