package com.junmp.jyzb.jyzbthirdparty.api;


import com.dtflys.forest.annotation.*;
import com.dtflys.forest.converter.json.ForestJacksonConverter;
import com.junmp.jyzb.jyzbthirdparty.bean.dto.TPInOrderDto;
import com.junmp.jyzb.jyzbthirdparty.bean.dto.TPOutOrderDto;
import com.junmp.jyzb.jyzbthirdparty.bean.req.TPOrderNoReq;

import java.util.List;

public interface SyncOrderApi {

    //入库单据
    @Request(url = "{url}",type = "POST")
    @BodyType(type = "json", encoder = ForestJacksonConverter.class)
    String syncInOrder(@Var("url")String url, @JSONBody List<TPInOrderDto> dto);


    //出库单据
    @Request(url = "{url}",type = "POST")
    @BodyType(type = "json", encoder = ForestJacksonConverter.class)
    String syncOutOrder(@Var("url")String url, @JSONBody List<TPOutOrderDto> dto);


    /**
     * 判断单据是否存在正在执行的任务
     * @param url
     * @return
     */
    @Request(url = "{url}",type = "POST")
    @BodyType(type = "json", encoder = ForestJacksonConverter.class)
    String getTaskWokingState(@Var("url")String url, @JSONBody TPOrderNoReq req);

    /**
     * 获取单据最新信息
     * @param tpOrderNoReq
     * @return
     */
    @Request(url = "{url}",type = "POST")
    @BodyType(type = "json", encoder = ForestJacksonConverter.class)
    String getLasterOrderInfo(@Var("url")String url,@JSONBody TPOrderNoReq tpOrderNoReq);

    /**
     * 单据记账结束后将数据进行推送至半山平台
     * @param tpOrderNoReq
     * @return
     */
    @Request(url = "{url}",type = "POST")
    @BodyType(type = "json", encoder = ForestJacksonConverter.class)
    String editOrderStatus(@Var("url")String url,@JSONBody TPOrderNoReq tpOrderNoReq);
}
