package com.junmp.junmpProcess.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonToELConverter {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String convertToEL(JsonNode jsonNode) {
        StringBuilder expressionBuilder = new StringBuilder();
        JsonNode[] jsonArray = objectMapper.convertValue(jsonNode, JsonNode[].class);

        // 递归构建EL表达式
        buildExpression(expressionBuilder, jsonArray);

        return expressionBuilder.toString();
    }

    private static void buildExpression(StringBuilder expressionBuilder, JsonNode[] jsonArray) {
        for (int i = 0; i < jsonArray.length; i++) {
            JsonNode element = jsonArray[i];
            JsonNode conditionNode = element.get("condition");
            JsonNode conditionsNode = element.get("conditions");

            if (conditionNode != null && conditionNode.isTextual() && conditionsNode != null && conditionsNode.isArray()) {
                String condition = conditionNode.asText();
                JsonNode[] conditions = objectMapper.convertValue(conditionsNode, JsonNode[].class);

                if (i > 0) {
                    expressionBuilder.append(" ");
                    expressionBuilder.append("||");
                    expressionBuilder.append(" ");
                }

//                expressionBuilder.append("(");

                for (int j = 0; j < conditions.length; j++) {
                    JsonNode conditionObject = conditions[j];

                    JsonNode columnValueNode = conditionObject.get("columnValue");
                    JsonNode optTypeNode = conditionObject.get("optType");
                    JsonNode conditionValueNode = conditionObject.get("conditionValue");

                    if (  columnValueNode != null && columnValueNode.isTextual()
                            && optTypeNode != null && optTypeNode.isTextual()
                            && conditionValueNode != null && conditionValueNode.isArray()) {
                        String columnValue = columnValueNode.asText();
                        String optType = optTypeNode.asText();
                        JsonNode[] conditionValues = objectMapper.convertValue(conditionValueNode, JsonNode[].class);

                        if (j > 0) {
                            expressionBuilder.append(" ");
                            expressionBuilder.append("&&");
                            expressionBuilder.append(" ");
                        }

                        expressionBuilder.append("${");
                        expressionBuilder.append(columnValue);
                        expressionBuilder.append(" ");
                        expressionBuilder.append(optType);
                        expressionBuilder.append(" ");
                        expressionBuilder.append(conditionValues[0].asText());
                        expressionBuilder.append("}");
                    }
                }

//                expressionBuilder.append(")");
            }
        }
    }
}