package com.junmp.junmpProcess.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.junmpProcess.entity.QuickSuggestions;
import com.junmp.junmpProcess.service.QuickSuggestionsService;
import com.junmp.junmpProcess.mapper.QuickSuggestionsMapper;
import com.junmp.junmpProcess.utils.DateTimeUtil;
import com.junmp.jyzb.api.bean.dto.QuickSuggestionsDto;
import com.junmp.jyzb.api.bean.query.QueryQuickSuggestionsReq;
import com.junmp.jyzb.api.bean.req.UpdateQuickSuggestionsReq;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
* @author lxh专属坐骑
* @description 针对表【flw_quick_suggestions(快选意见表（审核流审批时的意见表）)】的数据库操作Service实现
* @createDate 2023-11-27 13:28:59
*/
@Service
public class QuickSuggestionsServiceImpl extends ServiceImpl<QuickSuggestionsMapper, QuickSuggestions>
    implements QuickSuggestionsService{



    //新增
    @Override
    public Long addQuickSuggestions(UpdateQuickSuggestionsReq req) {
        QuickSuggestions quickSuggestions = new QuickSuggestions();
        BeanPlusUtil.copyProperties(req,quickSuggestions);
        quickSuggestions.setCreateTime(DateTimeUtil.getCurrentDateTime());
        save(quickSuggestions);
        return quickSuggestions.getId();
    }

    //删除
    @Override
    public boolean delQuickSuggestions(UpdateQuickSuggestionsReq req) {
        return removeById(req.getId());
    }

    //查询
    @Override
    public List<QuickSuggestionsDto> showQuickSuggestions(QueryQuickSuggestionsReq req) {
        List<QuickSuggestions> list = list(new LambdaQueryWrapper<QuickSuggestions>()
                .eq(QuickSuggestions::getUserId, req.getUserId()).eq(QuickSuggestions::getUseType,req.getUseType()));
        List<QuickSuggestionsDto> collect = list.stream().map(quickSuggestions -> {
            QuickSuggestionsDto quickSuggestionsDto = new QuickSuggestionsDto();
            BeanPlusUtil.copyProperties(quickSuggestions, quickSuggestionsDto);
            return quickSuggestionsDto;
        }).collect(Collectors.toList());
        return collect;
    }
}




