package com.junmp.junmpProcess.service;

import com.junmp.junmpProcess.dto.StartProcessInstanceDTO;
import org.flowable.engine.history.HistoricProcessInstance;

public interface IFlowInstanceService {
    /**
     * 激活或挂起流程实例
     *
     * @param state      状态
     * @param instanceId 流程实例ID
     */
    void updateState(Integer state, String instanceId);

    /**
     * 删除流程实例ID
     *
     * @param instanceId   流程实例ID
     * @param deleteReason 删除原因
     */
    void delete(String instanceId, String deleteReason);

    /**
     * 根据实例ID查询历史实例数据
     *
     * @param processInstanceId
     * @return
     */
    HistoricProcessInstance getHistoricProcessInstanceById(String processInstanceId);

    /**
     * 根据流程定义ID启动流程实例
     *
     * @return
     */
    String startProcessInstanceById(StartProcessInstanceDTO processInstanceDto);

    /**
     * 获取下一审核人信息
     *
     * @return
     */
    String GetNextAssign(String processInstanceId);

    /**
     * 通过流程实例id獲取表單ID
     *
     * @return
     */
    String getFormIdByInstanceId(String instanceId);
}
