package com.junmp.junmpProcess.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 快选意见表（审核流审批时的意见表）
 * @TableName flw_quick_suggestions
 */
@TableName(value ="flw_quick_suggestions")
@Data
public class QuickSuggestions implements Serializable {
    /**
     * id
     */
    private Long id;

    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private Long userId;

    /**
     * 审批意见
     */
    @TableField(value = "text")
    private String text;

    /**
     * 应用场景（1为审批时使用）
     */
    @TableField(value = "use_type")
    private Integer useType;
    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}