package com.junmp.junmpProcess.controller;

import com.junmp.junmpProcess.dto.StartProcessInstanceDTO;
import com.junmp.junmpProcess.service.IFlowInstanceService;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@Slf4j
@RestController
@RequestMapping("/FlowInstance")
@Api(tags = "[工作流]流程实例")
public class FlowInstanceController {
    @Autowired
    private IFlowInstanceService flowInstanceService;

    @ApiOperation(value = "根据流程定义id启动流程实例")
    @PostMapping("/startBy/{procDefId}")
    public ApiRes startById(@RequestBody StartProcessInstanceDTO startProcessInstanceDTO) {
        return ApiRes.success(flowInstanceService.startProcessInstanceById(startProcessInstanceDTO));
    }


    @ApiOperation(value = "激活或挂起流程实例")
    @PostMapping(value = "/updateState")
    public ApiRes updateState(@ApiParam(value = "1:激活,2:挂起", required = true) @RequestParam Integer state,
                              @ApiParam(value = "流程实例ID", required = true) @RequestParam String instanceId) {
        flowInstanceService.updateState(state,instanceId);
        return ApiRes.success();
    }

    @ApiOperation(value = "删除流程实例")
    @DeleteMapping(value = "/delete/{instanceIds}")
    public ApiRes delete(@ApiParam(value = "流程实例ID", required = true) @PathVariable String[] instanceIds,
                             @ApiParam(value = "删除原因") @RequestParam(required = false) String deleteReason) {
        for (String instanceId : instanceIds) {
            flowInstanceService.delete(instanceId,deleteReason);
        }
        return ApiRes.success();
    }
}
