package com.junmp.junmpProcess.controller;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.junmp.junmpProcess.common.utils.HttpStatus;
import com.junmp.junmpProcess.common.utils.ResponseResult;
import com.junmp.junmpProcess.common.utils.ReturnMsg;
import com.junmp.junmpProcess.entity.ProcessTemplates;
import com.junmp.junmpProcess.service.IFlowDefinitionService;
import com.junmp.junmpProcess.service.IFlowInstanceService;
import com.junmp.junmpProcess.service.Repository.ProcessTemplateService;
import com.junmp.jyzb.api.bean.query.processReq.InstanceReq;
import com.junmp.jyzb.api.bean.query.processReq.SuspendOrActivateDefinitionReq;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/FlowDefinition")
@Api(tags = "[工作流]流程定义")
public class FlowDefinitionController {
    @Autowired
    private IFlowDefinitionService FlowDefinitionService;
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private IFlowInstanceService flowInstanceService;
    @ApiOperation("停启用流程")
    @PostMapping("StopProcessInstanceById")
    public ApiRes<Boolean> stopProcessInstanceById(@RequestBody SuspendOrActivateDefinitionReq req) {
        return ApiRes.success(FlowDefinitionService.updateState(req));
    }
    @ApiOperation("根据业务ID换取最新的流程信息")
    @PostMapping("GetProcessDefinitionId")
    public ApiRes<String> GetProcessDefinitionId(@RequestBody Map<String,Object> templateId) {
        String temp= templateId.get("formId").toString();
        return FlowDefinitionService.getLatestDefinitionId(temp);
    }
    /**
     * 查询表单模板数据
     *
     * @param process 模板id
     * @return 模板详情数据
     */
    @ApiOperation("根据ID获取表单信息")
    @PostMapping(value = "getFormTemplateById")
    public ResponseResult getFormTemplateById(@RequestBody InstanceReq process) {
        String temp= process.getTemplateId();
        String processInstanceId= process.getProcessId();//
        if (!StringUtils.isEmpty(temp))
        {
            ProcessTemplates processTemplates = processTemplateService.getById(temp);
            processTemplates.setFormId(processTemplates.getTemplateId());
            return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,processTemplates);
        }
        else if (!StringUtils.isEmpty(processInstanceId))
        {
            String tempID= flowInstanceService.getFormIdByInstanceId(processInstanceId);
            ProcessTemplates processTemplates = processTemplateService.getById(tempID);
            processTemplates.setFormId(processTemplates.getTemplateId());
            return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,processTemplates);
        }
        else
        {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.NO_DATA,"");
        }

    }
}
