-- 数据库变更的内容追加在此处
-- 2024-04-12
ALTER TABLE `base_cabinet`
    ADD COLUMN `org_code` VARCHAR(128) NULL;
ALTER TABLE `base_cabinet`
    CHANGE COLUMN `cabinet_num` `dev_sn` VARCHAR (36) CHARACTER SET 'utf8mb4' COLLATE 'utf8mb4_general_ci' NULL DEFAULT NULL COMMENT '单警柜编号';

-- 2024-04-15
ALTER TABLE `base_cabinet_box`
    CHANGE COLUMN `num` `box_no` INT NULL DEFAULT NULL COMMENT '箱门编号';

-- 2024-04-23
ALTER TABLE base_warehouse
    ADD warehouse_type INT COMMENT '仓库类型（1为储备库）';

update base_warehouse set warehouse_type=1 where warehouse_type is null;

-- 2024-04-28
ALTER TABLE `base_cabinet_box`
    ADD COLUMN `box_local_id` VARCHAR(128) NULL COMMENT '智能柜本地主键编号';

-- 2024-04-29 更新字段长度
ALTER TABLE sys_application
    MODIFY `version` VARCHAR(36);

-- 2024-05-07 新增警员表字段
ALTER TABLE `base_policeman`
    ADD COLUMN `user_local_id` VARCHAR(128) NULL COMMENT '用户本地主键编号';

-- 2024-05-09 新增警员指纹表单警柜使用字段
ALTER TABLE `base_police_finger`
    ADD COLUMN `cab_finger_num` int NULL COMMENT '指纹编号（单警柜使用）';

-- 2024-05-13 新增过质保期字段
ALTER TABLE `base_warranty_inventory`
    ADD COLUMN `location_type` int NULL COMMENT '所属位置:0仓库，1单警柜';

ALTER TABLE base_warranty_inventory RENAME COLUMN warehouse_id TO location_id;
ALTER TABLE base_warranty_inventory RENAME COLUMN warehouse_name TO location_name;

ALTER TABLE `vie_warranty_group`
    ADD COLUMN `location_type` int NULL COMMENT '所属位置:0仓库，1单警柜';

ALTER TABLE vie_warranty_group RENAME COLUMN warehouse_id TO location_id;
ALTER TABLE vie_warranty_group RENAME COLUMN warehouse_name TO location_name;


ALTER TABLE `base_destory_broken_inventory`
    ADD COLUMN `location_type` int NULL COMMENT '所属位置:0仓库，1单警柜';

ALTER TABLE base_destory_broken_inventory RENAME COLUMN warehouse_id TO location_id;
ALTER TABLE base_destory_broken_inventory RENAME COLUMN warehouse_name TO location_name;

ALTER TABLE `vie_destory_group`
    ADD COLUMN `location_type` int NULL COMMENT '所属位置:0仓库，1单警柜';

ALTER TABLE vie_destory_group RENAME COLUMN warehouse_id TO location_id;
ALTER TABLE vie_destory_group RENAME COLUMN warehouse_name TO location_name;

--2024-05-14 更新inventory字段
-- 现场已更新
update `base_inventory` set bussiness_state=state
                        where state != "destory" and state !="broken" and
                        location_state !="in" and bussiness_state="normal";

-- 现场已更新
update `base_inventory` set state="normal" where
                        state != "destory" and state !="broken"
                        and location_state !="in" ;

-- 2024-05-16 新建表
-- 现场已更新
CREATE TABLE base_police_equipment_detail (
                                           id VARCHAR(64) PRIMARY KEY COMMENT '主键id',
                                           epc VARCHAR(128) COMMENT 'epc',
                                           org_id VARCHAR(128) COMMENT '组织机构id',
                                           location_id VARCHAR(128) COMMENT '箱门id/仓库id',
                                           police_id varchar(128) comment '警员id',
                                           dev_sn VARCHAR(64) COMMENT '设备编号',
                                           location_state VARCHAR(8) COMMENT '装备状态（in在柜，out出柜）',
                                           type_id VARCHAR(64)  COMMENT '装备类型id',
                                           size_id VARCHAR(128)  COMMENT '装备号型id',
                                           price DECIMAL(38,2) COMMENT '单价',
                                           property INT  COMMENT 'epc类型（0为固定资产，1为库存物资非固定资产）',
                                           create_time DATETIME  COMMENT '创建时间',
                                           update_time DATETIME  COMMENT '更新时间'
);

-- 2024-05-22 修改单警柜默认值
-- 现场已更新
update base_cabinet_box set contain_type=1 where contain_type=0 or contain_type is null


-- 2024-05-28 单警柜箱门绑定装备(不需要)
-- CREATE TABLE base_cabinet_box_equipment (
--                                             id VARCHAR(64) PRIMARY KEY COMMENT '主键id',
--                                             epc VARCHAR(128) COMMENT 'epc',
--                                             org_id VARCHAR(128) COMMENT '组织机构id',
--                                             location_id VARCHAR(128) COMMENT '箱门id',
--                                             dev_sn VARCHAR(64) COMMENT '设备编号',
--                                             location_state VARCHAR(8) COMMENT '装备状态（in在柜，out出柜）',
--                                             type_id VARCHAR(64)  COMMENT '装备类型id',
--                                             size_id VARCHAR(128)  COMMENT '装备号型id',
--                                             price DECIMAL(38,2) COMMENT '单价',
--                                             property INT  COMMENT 'epc类型（0为固定资产，1为库存物资非固定资产）',
--                                             equipment_state int COMMENT '装备状态（0绑定，1解绑）',
--                                          create_time DATETIME  COMMENT '创建时间',
--                                             update_time DATETIME  COMMENT '更新时间'
-- );

-- 新增装备绑定状态

ALTER TABLE base_inventory
    ADD eqs_bind_state INT COMMENT '装备绑定状态（1表示绑定箱门，0或空表示解绑箱门或没有绑定）';

update base_inventory set eqs_bind_state=1 where location_type=1;

-- 更新记账识别数量默认值，
update `bussiness_order_detail` set actual_num = 0 where actual_num is null ;

ALTER TABLE bussiness_order_detail
    ALTER COLUMN actual_num SET DEFAULT 0;

-- 增加领用人字段

ALTER TABLE bussiness_bus_form
    ADD end_org_user_name varchar(128) COMMENT '接收人名称';

ALTER TABLE bussiness_bus_form
    ADD end_org_user_id varchar(128) COMMENT '接收人id';


-- 增加预案发起单位以及单号
ALTER TABLE plan_initiation
    ADD start_org_name varchar(128) COMMENT '发起组织机构名称';

ALTER TABLE plan_initiation
    ADD start_org_id bigint COMMENT '发起组织机构id';

ALTER TABLE plan_initiation
    ADD plan_code varchar(128) COMMENT '发起预案单号';


-- 新增预案附件地址
ALTER TABLE plan_initiation
    ADD attachment_location varchar(128) COMMENT '附件地址';


-- 240708 质保期装备新增字段
ALTER TABLE vie_warranty_group
    ADD price DECIMAL(38,2) COMMENT '单价';
ALTER TABLE vie_warranty_group
    ADD total_price DECIMAL(38,2) COMMENT '总价';

-- 需要将业务单，出入库单子的审核人的varchar（255） 改成longtext
-- 修改装备状态
update `base_inventory` set bussiness_state="normal" where bussiness_state is null or bussiness_state =""
update `base_inventory` set state="normal" where state is null or state =""


-- 添加过质保期的在库状态
ALTER TABLE base_warranty_inventory
    ADD location_state varchar(8) COMMENT '装备状态（in，out）';

ALTER TABLE vie_warranty_group
    ADD location_state varchar(8) COMMENT '装备状态（in，out）';
ALTER TABLE vie_warranty_group
    ADD property int COMMENT '装备类型（0固定资产1非固定资产）';

-- 更新没有号型的装备默认一个无号配号
insert into base_equipment_size(id,type_id,code,name,create_time,update_time)
select UUID(),id,'0','无号配号',SYSDATE(),SYSDATE()
    FROM(select a.*,s.id as size_id,s.name as size_name FROM(SELECT * FROM `base_equipment_type` where type=1)
        as a left join base_equipment_size as s on a.id=s.type_id) as t where t.size_id is null;



-- 添加单子打印单号
ALTER TABLE bussiness_order_main
    ADD print_code varchar(64) COMMENT '打印单号';
ALTER TABLE bussiness_order_main
    ADD print_code_time DATETIME COMMENT '打印单号创建时间';


ALTER TABLE bussiness_bus_form
    ADD print_code varchar(64) COMMENT '打印单号';
ALTER TABLE bussiness_bus_form
    ADD print_code_time DATETIME COMMENT '打印单号创建时间';

CREATE TABLE `bussiness_order_print_num` (
     `id` varchar(128) NOT NULL COMMENT 'id',
     `org_id` bigint NOT NULL COMMENT '组织机构id',
     `create_time` datetime NOT NULL COMMENT '创建时间',
     `order_type` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '单子类型\r\n(领:领用\r\n支:调拨\r\n价:调拨\r\n废:报废\r\n销:销毁\r\n入:采购\r\n赠:赠与\r\n还:归还\r\n其:其他\r\n)',
     `order_year` int DEFAULT NULL COMMENT '年份',
     `order_count` int DEFAULT NULL COMMENT '单子计数',
     PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;



ALTER TABLE base_policeman
    ADD psd varchar(64) COMMENT '密码2.0';
ALTER TABLE base_policeman
    ADD face_info2 longtext COMMENT '人脸信息2.0';
update `base_policeman` set face_info2=face_info;
-- 执行kettlespoon抽取


ALTER TABLE base_police_finger
    ADD type int COMMENT '类别（0：2.0使用，1：3.0使用）';
update `base_police_finger` set type=0 where type is null;


-- CREATE TABLE sys_jp_soft_update (
--       id VARCHAR(36) PRIMARY KEY COMMENT '主键id',
--       name VARCHAR(36) COMMENT '',
--       address VARCHAR(250) COMMENT '',
--       note VARCHAR(255) COMMENT '',
--       sort varchar(125) comment '',
--       version INT COMMENT '',
--       update_time datetime COMMENT '',
--       app_code VARCHAR(64)  COMMENT '',
--       version2 VARCHAR(255)  COMMENT '',
--       fileMD5 VARCHAR(255) COMMENT '',
--       is_auto_update INT  COMMENT '是否自动更新',
--       auto_update_address VARCHAR(255)  COMMENT '自动更新文件地址',
--       auto_update_fileMD5 VARCHAR(255)  COMMENT '自动更新文件MD5',
--       auto_update_version2 VARCHAR(255)  COMMENT '自动更新版本号',
--       type varchar(36)  COMMENT '分类类型');

---------------------------- 以下-----------------------------------------


CREATE TABLE `base_cabinet_in_out_msg` (
   `id` varchar(36) NOT NULL,
   `dev_sn` varchar(36) DEFAULT NULL COMMENT '主柜编号',
   `location` varchar(64) DEFAULT NULL COMMENT '位置信息',
   `box_no` int DEFAULT NULL COMMENT '箱门号',
   `box_id` varchar(36) DEFAULT NULL COMMENT '箱门id',
   `org_id` bigint DEFAULT NULL COMMENT '组织机构id',
   `state` varchar(36) DEFAULT NULL COMMENT '错误类型',
   `msg` longtext COMMENT '错误日志',
   `push_time` datetime DEFAULT NULL COMMENT '操作时间',
   `user_name` varchar(255) DEFAULT NULL COMMENT '操作人',
   `current_user_name` varchar(255) DEFAULT NULL COMMENT '原来警员（错还使用）',
   `epc` varchar(255) DEFAULT NULL COMMENT 'epc',
   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;


CREATE TABLE `base_cabinet_worklog` (
                                        `id` varchar(36) NOT NULL,
                                        `type` varchar(20) DEFAULT NULL,
                                        `name` varchar(60) DEFAULT NULL,
                                        `log_info` varchar(255) DEFAULT NULL,
                                        `date` datetime NOT NULL,
                                        `photo` varchar(255) DEFAULT NULL,
                                        `is_deal` varchar(50) DEFAULT NULL,
                                        `device_no` varchar(50) DEFAULT NULL,
                                        PRIMARY KEY (`id`,`date`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;


-- 分区
-- 步骤1
ALTER TABLE base_cabinet_worklog
    PARTITION BY RANGE (TO_DAYS(`date`)) (
    PARTITION p202401 VALUES LESS THAN (TO_DAYS('2024-01-01')),
    PARTITION p202402 VALUES LESS THAN (TO_DAYS('2024-07-01')),
    PARTITION p202501 VALUES LESS THAN (TO_DAYS('2025-01-01')),
    PARTITION p202502 VALUES LESS THAN (TO_DAYS('2025-07-01')),
    PARTITION p202601 VALUES LESS THAN (TO_DAYS('2026-01-01')),
    PARTITION p202602 VALUES LESS THAN (TO_DAYS('2026-07-01')),
    PARTITION p202701 VALUES LESS THAN (TO_DAYS('2027-01-01')),
    PARTITION p202702 VALUES LESS THAN (TO_DAYS('2027-07-01')),
    PARTITION p202801 VALUES LESS THAN (TO_DAYS('2028-01-01')),
    PARTITION p202802 VALUES LESS THAN (TO_DAYS('2028-07-01'))
    );
-- 步骤2
-- 现场该将数据库改成对应的（jyzb0814进行替换）--查询分区
SELECT table_name, partition_name, subpartition_name, table_rows
FROM information_schema.partitions
WHERE table_schema = 'jyzb0814' AND table_name = 'base_cabinet_worklog';




CREATE TABLE `base_cabinet_outinlog` (
                                         `id` varchar(64) NOT NULL COMMENT 'id',
                                         `state` varchar(36) DEFAULT NULL COMMENT '状态',
                                         `user_name` varchar(64) DEFAULT NULL COMMENT '操作人',
                                         `box_no` int DEFAULT NULL COMMENT '箱门号',
                                         `name` varchar(64) DEFAULT NULL COMMENT '装备名称',
                                         `photo` varchar(255) DEFAULT NULL COMMENT '照片',
                                         `epc` varchar(64) DEFAULT NULL COMMENT 'epc',
                                         `dev_sn` varchar(64) DEFAULT NULL COMMENT '主柜号编号',
                                         `push_time` datetime DEFAULT NULL COMMENT '推送时间',
                                         `operation_time` datetime DEFAULT NULL COMMENT '操作时间',
                                         `create_time` datetime NOT NULL COMMENT '创建时间（用于分区）',
                                         `org_id` bigint DEFAULT NULL COMMENT '组织机构id',
                                         PRIMARY KEY (`id`,`create_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;


ALTER TABLE base_cabinet_outinlog
    PARTITION BY RANGE (TO_DAYS(`create_time`)) (
    PARTITION p202401 VALUES LESS THAN (TO_DAYS('2024-01-01')),
    PARTITION p202402 VALUES LESS THAN (TO_DAYS('2024-07-01')),
    PARTITION p202501 VALUES LESS THAN (TO_DAYS('2025-01-01')),
    PARTITION p202502 VALUES LESS THAN (TO_DAYS('2025-07-01')),
    PARTITION p202601 VALUES LESS THAN (TO_DAYS('2026-01-01')),
    PARTITION p202602 VALUES LESS THAN (TO_DAYS('2026-07-01')),
    PARTITION p202701 VALUES LESS THAN (TO_DAYS('2027-01-01')),
    PARTITION p202702 VALUES LESS THAN (TO_DAYS('2027-07-01')),
    PARTITION p202801 VALUES LESS THAN (TO_DAYS('2028-01-01')),
    PARTITION p202802 VALUES LESS THAN (TO_DAYS('2028-07-01'))
    );
-- 步骤2
-- 现场该将数据库改成对应的（jyzb0814进行替换）--查询分区
SELECT table_name, partition_name, subpartition_name, table_rows
FROM information_schema.partitions
WHERE table_schema = 'jyzb0814' AND table_name = 'base_cabinet_outinlog';



ALTER TABLE sys_application
    ADD version2 varchar(128) COMMENT '版本号1.0.0.0';
ALTER TABLE sys_application
    ADD file_md5 varchar(128) COMMENT '文件MD5';
ALTER TABLE sys_application
    ADD is_auto_update INTEGER COMMENT '是否启用自动更新';
ALTER TABLE sys_application
    ADD auto_update_address varchar(255) COMMENT '自动更新文件地址';
ALTER TABLE sys_application
    ADD auto_update_file_md5 varchar(255) COMMENT '自动更新文件MD5';
ALTER TABLE sys_application
    ADD auto_update_version2 varchar(255) COMMENT '自动更新版本号1.0.0.0';



CREATE TABLE `base_inventory_box_mark` (
       `id` varchar(36) NOT NULL,
       `create_time` datetime DEFAULT NULL COMMENT '创建时间',
       `epc` varchar(128) DEFAULT NULL COMMENT 'epc',
       `one_box_num` int DEFAULT NULL COMMENT '箱内数量',
       `equipment_detail_id` varchar(36) DEFAULT NULL COMMENT '类型id',
       `size_id` varchar(36) DEFAULT NULL COMMENT '号型id',
       `supplier_id` varchar(36) DEFAULT NULL COMMENT '供应商id',
       `current_state` int DEFAULT NULL COMMENT '状态',
       `warehouse_id` varchar(36) DEFAULT NULL COMMENT '仓库id',
       `reload_boxing_state` int DEFAULT NULL COMMENT '重装箱状态，0：未重装箱，1：未打印，2：已打印',
       `old_epc` varchar(128) DEFAULT NULL COMMENT '旧版epc',
       PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;


ALTER TABLE base_inventory
    ADD box_mark_id varchar(36) COMMENT '箱标id';
-- 添加时注意规则utf8mb4_0900_ai_ci，并且添加索引字段
ALTER TABLE base_inventory
    ADD police_id varchar(36) COMMENT '警员id';
-- 添加时注意规则utf8mb4_0900_ai_ci
ALTER TABLE base_inventory
    ADD instantiation_state int DEFAULT NULL COMMENT '标签实例化状态（打印or绑定过）0：其他 1：未打印 2：已打印';
-- 添加索引字段
ALTER TABLE base_inventory
    ADD is_in_box int DEFAULT '0' COMMENT '是否在箱内（箱标未拆箱）';



CREATE TABLE `bussiness_print_epcs` (
            `id` varchar(36) NOT NULL,
            `epc` varchar(255) DEFAULT NULL COMMENT 'epc',
            `order_detail_id` varchar(36) DEFAULT NULL COMMENT '子单据id',
            `current_state` int DEFAULT NULL COMMENT '状态',
            `num` int DEFAULT NULL COMMENT '打印序号',
            `create_time` datetime DEFAULT NULL COMMENT '创建时间',
            `product_time` datetime DEFAULT NULL COMMENT '创建时间',
            `repair_cycle` int DEFAULT NULL COMMENT '生产日期',
            `warranty_cycle` int DEFAULT NULL COMMENT '维保期',
            `use_time` datetime DEFAULT NULL COMMENT '质保期',
            `price` decimal(10,2) DEFAULT NULL COMMENT '时间',
            `use_direction` int DEFAULT '0' COMMENT '单价',
            `supplier_id` varchar(36) DEFAULT NULL COMMENT '供应商id',
            `supplier_name` varchar(200) DEFAULT NULL COMMENT '供应商名称',
            `shelf_id` varchar(36) DEFAULT NULL COMMENT '货架id',
            `shelf_row` int DEFAULT NULL COMMENT '行（货架位置）',
            `shelf_range` int DEFAULT NULL COMMENT '排（货架位置）',
            `shelf_column` int DEFAULT NULL COMMENT '列（货架位置）',
            `tid` varchar(255) DEFAULT NULL COMMENT '标签TID',
            PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--2024-9-24
ALTER TABLE bussiness_order_main
    ADD is_open int DEFAULT 0 COMMENT '是否开启(0关闭1开启)';


-- 2024-10-11
ALTER TABLE base_cabinet
    ADD `version` varchar(64) DEFAULT NULL COMMENT '版本号';

ALTER TABLE base_cabinet
    ADD `is_upgrade` int DEFAULT 0 COMMENT '是否升级（0不升级，1升级） 默认0不升级';

-- 现场已经存在该字段
ALTER TABLE base_log_summary
    ADD `upload_type` int DEFAULT 1 COMMENT '3.0 默认1， 2.0 为null';



-- 添加索引
ALTER TABLE base_warehouse_inventory
    ADD `bind_location_id` varchar(36) DEFAULT NULL COMMENT '装备绑定位置（单警柜箱门id）';
-- 添加索引
ALTER TABLE base_inventory
    ADD `bind_location_id` varchar(36) DEFAULT NULL COMMENT '装备绑定位置（单警柜箱门id）';


-- UPDATE base_inventory AS a
--     JOIN (SELECT epc FROM base_inventory WHERE eqs_bind_state = 1 AND location_type = 1) AS b
-- ON a.epc = b.epc
--     SET a.bind_location_id = a.location_id;
--
--
-- UPDATE base_warehouse_inventory AS a
--     JOIN (SELECT epc FROM base_inventory WHERE eqs_bind_state = 1 AND location_type = 1) AS b
-- ON a.epc = b.epc
--     SET a.bind_location_id = a.location_id;




---------------------------以下-----------------------------------------------------------

ALTER TABLE bussiness_print_epcs
    PARTITION BY RANGE (TO_DAYS(`create_time`)) (
    PARTITION p202401 VALUES LESS THAN (TO_DAYS('2024-01-01')),
    PARTITION p202402 VALUES LESS THAN (TO_DAYS('2024-07-01')),
    PARTITION p202501 VALUES LESS THAN (TO_DAYS('2025-01-01')),
    PARTITION p202502 VALUES LESS THAN (TO_DAYS('2025-07-01')),
    PARTITION p202601 VALUES LESS THAN (TO_DAYS('2026-01-01')),
    PARTITION p202602 VALUES LESS THAN (TO_DAYS('2026-07-01')),
    PARTITION p202701 VALUES LESS THAN (TO_DAYS('2027-01-01')),
    PARTITION p202702 VALUES LESS THAN (TO_DAYS('2027-07-01')),
    PARTITION p202801 VALUES LESS THAN (TO_DAYS('2028-01-01')),
    PARTITION p202802 VALUES LESS THAN (TO_DAYS('2028-07-01'))
    );


--20241023
-- 需要将base_log_summary表添加索引（图片字段--picture）


-- 将vie_equipment_count_summary中的broken_count设计表默认值改为0

-- 20241108 添加旧版设备号 将dev_sn的编码格式改掉
ALTER TABLE base_cabinet
    ADD `old_dev_sn` varchar(36) DEFAULT NULL COMMENT '旧版设备号';


-- 20241118 添加仓库code
ALTER TABLE base_warehouse
    ADD `code` varchar(36) DEFAULT NULL COMMENT '仓库code编码';
-- 并且执行随机生成6位数，并确保6位code表中没有重复值


ALTER TABLE bussiness_order_main
    ADD `sync_flag` smallint DEFAULT NULL COMMENT '是否同步下发或同步拉取(0或null未拉取同步，1拉取同步)';


-- 组织机构新增一个orgId为1 的，用于同步警员时调出未调入的警员不出现在单警柜中（测试完成后更新，不能随意更新）




CREATE TABLE `common_jp_transfer_order` (
                                            `id` varchar(36) NOT NULL COMMENT 'id',
                                            `send_org_id` bigint DEFAULT NULL COMMENT '发物单位id',
                                            `send_org_name` varchar(255) DEFAULT NULL COMMENT '发物单位名称',
                                            `receiver_org_id` bigint DEFAULT NULL COMMENT '收物单位id',
                                            `receiver_org_name` varchar(255) DEFAULT NULL COMMENT '收物单位名称',
                                            `receive_warehouse_id` varchar(36) DEFAULT NULL COMMENT '收物单位仓库id',
                                            `receive_warehouse_name` varchar(255) DEFAULT NULL COMMENT '收物单位仓库名称',
                                            `current_state` int DEFAULT NULL COMMENT '当前状态',
                                            `apply_time` datetime DEFAULT NULL COMMENT '申请时间',
                                            `order_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '订单号',
                                            `create_time` datetime DEFAULT NULL COMMENT '创建时间',
                                            `action_type` int DEFAULT NULL COMMENT '类型',
                                            `transfer_print_code` varchar(128) DEFAULT NULL COMMENT '打印单号',
                                            `transfer_print_time` datetime DEFAULT NULL COMMENT '打印时间',
                                            `apply_id` varchar(36) DEFAULT NULL COMMENT '申请人id',
                                            `apply_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '申请人名称',
                                            PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;




CREATE TABLE `common_jp_transfer_detail` (
                                             `id` varchar(36) NOT NULL COMMENT 'id',
                                             `order_id` varchar(36) DEFAULT NULL COMMENT '主单id',
                                             `type_id` varchar(36) DEFAULT NULL COMMENT '类型id',
                                             `size_id` varchar(36) DEFAULT NULL COMMENT '号型id',
                                             `type_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '类型名称',
                                             `size_name` varchar(64) DEFAULT NULL COMMENT '号型名称',
                                             `state` int DEFAULT NULL COMMENT '状态',
                                             `plan_num` int DEFAULT NULL COMMENT '计划数量',
                                             `real_num` int DEFAULT NULL COMMENT '实际数量',
                                             `send_warehouse_id` varchar(36) DEFAULT NULL COMMENT '发物单位id',
                                             `send_warehouse_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '发物单位名称',
                                             PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;




CREATE TABLE `common_jp_purchase_order` (
                                            `id` varchar(36) NOT NULL COMMENT 'id',
                                            `order_code` varchar(40) DEFAULT NULL COMMENT '单号',
                                            `org_id` bigint DEFAULT NULL COMMENT '组织机构id',
                                            `org_name` varchar(255) DEFAULT NULL COMMENT '组织机构名称',
                                            `d_name` varchar(128) DEFAULT NULL COMMENT '组织机构简称',
                                            `current_state` int DEFAULT NULL COMMENT '单子状态（1已完成，0未完成）',
                                            `apply_id` varchar(36) DEFAULT NULL COMMENT '申请人id',
                                            `apply_reason` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '申请原因',
                                            `apply_name` varchar(128) DEFAULT NULL COMMENT '申请人名称',
                                            `warehouse_id` varchar(36) DEFAULT NULL COMMENT '仓库id',
                                            `warehouse_name` varchar(255) DEFAULT NULL COMMENT '仓库名称',
                                            `create_time` datetime DEFAULT NULL COMMENT '创建时间',
                                            `print_order_code` varchar(255) DEFAULT NULL COMMENT '打印单号',
                                            `print_order_time` datetime DEFAULT NULL COMMENT '打印时间',
                                            `note` varchar(255) DEFAULT NULL COMMENT '备注',
                                            PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;




CREATE TABLE `common_jp_purchase_detail` (
                                             `id` varchar(36) NOT NULL COMMENT '子单id',
                                             `order_id` varchar(36) DEFAULT NULL COMMENT '主单id',
                                             `type_id` varchar(36) DEFAULT NULL COMMENT '类型id',
                                             `type_name` varchar(64) DEFAULT NULL COMMENT '类型名称',
                                             `size_id` varchar(36) DEFAULT NULL COMMENT '号型id',
                                             `size_name` varchar(64) DEFAULT NULL COMMENT '号型名称',
                                             `supplier_id` varchar(36) DEFAULT NULL COMMENT '供应商id',
                                             `quantity` int DEFAULT NULL COMMENT '数量',
                                             `supplier_name` varchar(255) DEFAULT NULL COMMENT '供应商名称',
                                             `note` varchar(255) DEFAULT NULL COMMENT '备注',
                                             `real_count` int DEFAULT NULL COMMENT '实际数量',
                                             `state` int DEFAULT NULL COMMENT '状态（1已完成，0未完成）',
                                             `create_time` datetime DEFAULT NULL COMMENT '创建时间',
                                             PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;



CREATE TABLE `common_jp_noborrow_order` (
                                            `id` varchar(36) NOT NULL COMMENT 'id主键',
                                            `warehouse_id` varchar(36) DEFAULT NULL COMMENT '仓库id',
                                            `warehouse_name` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '仓库名称',
                                            `order_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '单号',
                                            `state` int DEFAULT NULL COMMENT '出入库状态（1入库，0出库）',
                                            `create_time` datetime DEFAULT NULL COMMENT '创建时间',
                                            `org_id` bigint DEFAULT NULL COMMENT '组织机构id',
                                            `d_name` varchar(64) DEFAULT NULL COMMENT '组织机构简称',
                                            `org_name` varchar(128) DEFAULT NULL COMMENT '组织机构名称',
                                            PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;



CREATE TABLE `common_jp_noborrow_detail` (
                                             `id` varchar(36) NOT NULL COMMENT '主键id',
                                             `order_id` varchar(36) DEFAULT NULL COMMENT '主单据id',
                                             `type_id` varchar(36) DEFAULT NULL COMMENT '类型id',
                                             `type_name` varchar(64) DEFAULT NULL COMMENT '类型名称',
                                             `size_id` varchar(36) DEFAULT NULL COMMENT '号型id',
                                             `size_name` varchar(64) DEFAULT NULL COMMENT '号型名称',
                                             `count` int DEFAULT NULL COMMENT '数量',
                                             `out_in_state` int DEFAULT NULL COMMENT '出入库状态（1入库，0出库）',
                                             `type` int DEFAULT NULL COMMENT '借用类型（13本仓库借用入库，14本仓库借用出库）',
                                             `in_time` datetime DEFAULT NULL COMMENT '入库时间',
                                             `out_time` datetime DEFAULT NULL COMMENT '出库时间',
                                             `police_id` varchar(64) DEFAULT NULL COMMENT '警员id',
                                             `create_time` datetime DEFAULT NULL COMMENT '创建时间',
                                             PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;



CREATE TABLE `common_jp_fix_useless_order` (
                                               `id` varchar(36) NOT NULL COMMENT '主键id',
                                               `order_code` varchar(40) DEFAULT NULL COMMENT '单子编号',
                                               `org_name` varchar(255) DEFAULT NULL COMMENT '组织机构名称',
                                               `org_id` bigint DEFAULT NULL COMMENT '组织机构id',
                                               `d_name` varchar(128) DEFAULT NULL COMMENT '单据简称',
                                               `current_state` int DEFAULT NULL COMMENT '状态',
                                               `warehouse_id` varchar(36) DEFAULT NULL COMMENT '仓库id',
                                               `warehouse_name` varchar(128) DEFAULT NULL COMMENT '仓库名称',
                                               `apply_id` varchar(36) DEFAULT NULL COMMENT '申请人id',
                                               `apply_name` varchar(36) DEFAULT NULL COMMENT '申请人',
                                               `action` int DEFAULT NULL COMMENT '类型（0维修，1报废）',
                                               `note` varchar(64) DEFAULT NULL COMMENT '备注',
                                               `create_time` datetime DEFAULT NULL COMMENT '创建时间',
                                               `create_user` varchar(64) DEFAULT NULL COMMENT '创建人员',
                                               `print_order_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '打印单单号',
                                               `print_order_time` datetime DEFAULT NULL COMMENT '打印时间',
                                               PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;




CREATE TABLE `common_jp_fix_useless_detail` (
                                                `id` varchar(36) NOT NULL COMMENT '主键id',
                                                `order_id` varchar(36) DEFAULT NULL COMMENT '主单id',
                                                `size_id` varchar(36) DEFAULT NULL COMMENT '号型id',
                                                `size_name` varchar(64) DEFAULT NULL COMMENT '号型名称',
                                                `type_id` varchar(64) DEFAULT NULL COMMENT '类型id',
                                                `type_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '类型名称',
                                                `quantity` int DEFAULT NULL COMMENT '数量',
                                                `supplier_id` varchar(36) DEFAULT NULL COMMENT '供应商id',
                                                `supplier_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '供应商名称',
                                                `unit_price` decimal(10,2) DEFAULT NULL COMMENT '单价',
                                                `total_price` decimal(10,2) DEFAULT NULL COMMENT '总价',
                                                PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;




CREATE TABLE `common_jp_borrow_return_order` (
                                                 `id` varchar(36) NOT NULL COMMENT 'id',
                                                 `current_state` int DEFAULT NULL COMMENT '当前状态（0未开始，1已出库，2已入库）',
                                                 `action_type` int DEFAULT NULL COMMENT '类型（0借用1领用）',
                                                 `order_code` varchar(36) DEFAULT NULL COMMENT '订单号',
                                                 `apply_id` varchar(64) DEFAULT NULL COMMENT '申请人id',
                                                 `apply_name` varchar(128) DEFAULT NULL COMMENT '申请人',
                                                 `org_id` bigint DEFAULT NULL COMMENT '组织机构id',
                                                 `org_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '组织机构名称',
                                                 `warehouse_id` varchar(36) DEFAULT NULL COMMENT '仓库id',
                                                 `warehouse_name` varchar(128) DEFAULT NULL COMMENT '仓库名称',
                                                 `d_name` varchar(64) DEFAULT NULL COMMENT '组织机构简称',
                                                 `print_order_code` varchar(128) DEFAULT NULL COMMENT '打印单号',
                                                 `print_order_time` datetime DEFAULT NULL COMMENT '打印时间',
                                                 `create_time` datetime DEFAULT NULL COMMENT '创建时间',
                                                 `create_user` varchar(64) DEFAULT NULL COMMENT '创建人员',
                                                 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;




CREATE TABLE `common_jp_borrow_return_detail` (
                                                  `id` varchar(36) NOT NULL COMMENT 'id',
                                                  `order_id` varchar(36) DEFAULT NULL COMMENT '主单id',
                                                  `state` int DEFAULT NULL COMMENT '状态',
                                                  `type_id` varchar(36) DEFAULT NULL COMMENT '类型id',
                                                  `type_name` varchar(64) DEFAULT NULL COMMENT '类型名称',
                                                  `size_id` varchar(36) DEFAULT NULL COMMENT '号型id',
                                                  `size_name` varchar(64) DEFAULT NULL COMMENT '号型名称',
                                                  `plan_num` int DEFAULT NULL COMMENT '计划数量',
                                                  `real_num` int DEFAULT NULL COMMENT '实际数量',
                                                  `supplier_id` varchar(36) DEFAULT NULL COMMENT '供应商id',
                                                  `supplier_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '供应商',
                                                  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;



------2025.1.3添加装备过质保表的数据接口
ALTER TABLE base_warranty_inventory
    ADD `production_date` datetime DEFAULT NULL COMMENT '装备生产日期';
ALTER TABLE base_warranty_inventory
    ADD `warranty_period` int DEFAULT NULL COMMENT '质保期';
ALTER TABLE base_warranty_inventory
    ADD `police_name` varchar(128) DEFAULT NULL COMMENT '警员名称';
ALTER TABLE base_warranty_inventory
    ADD `police_id` varchar(128) DEFAULT NULL COMMENT '警员id';
-- 执行完成后重新执行两个函数（函数有修改）
--需要将函数先进行替换后执行函数！！！
call Insert_into_base_warranty_inventory(null);
call Insert_into_view_warranty_group(null);



-- 20250714添加业务单表字段
ALTER TABLE bussiness_bus_form
    ADD remove_type int DEFAULT NULL COMMENT '报废类型（0本级报废，1上级报废）';
ALTER TABLE bussiness_bus_form
    ADD remove_confirm_state int DEFAULT NULL COMMENT '报废状态（上级报废时使用，只允许确认一次）0未确认，1已确认';

-- 增加号型箱内数量
ALTER TABLE base_equipment_size
    ADD box_num INT default 1 COMMENT '箱内数量';

-- 20250827 将bussiness_order_detail的motidify_quantity字段设置默认值为0