package com.junmp.jyzb.websocket.configurator;

import cn.hutool.core.util.StrUtil;
import com.junmp.jyzb.api.bean.vo.CabinetWsVo;
import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.jyzb.api.exception.JYZBAppException;
import com.junmp.jyzb.api.exception.enums.WsHandshakeExceptionEnum;
import lombok.extern.slf4j.Slf4j;

import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/4/25 13:58
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pr>
 */
@Slf4j
public class JyzbCabinetConfigurator extends ServerEndpointConfig.Configurator {


    /**
     * 1）先验证协议是否允许
     * 2）验证机构代码和设备序号是否存在
     * <p>
     * 同时满足1、2条件允许连接到平台
     */
    @Override
    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        List<String> protocolVal = request.getHeaders().get(JYZBConstant.SEC_WS_PROTOCOL);
        if (null != protocolVal && !protocolVal.isEmpty()) {
            String tmp1 = protocolVal.get(0);
            log.info("[协议签名值]|{}", tmp1);
            if (tmp1.equalsIgnoreCase(JYZBConstant.DEFAULT_JYZB_SIGN_VALUE)) {
                CabinetWsVo wsVo = new CabinetWsVo();
                //1-从请求头中获取机构代码和设备序号
                List<String> orgCode = request.getHeaders().get(JYZBConstant.X_ORG_CODE);
                if (null != orgCode && !orgCode.isEmpty()) {
                    log.info("[机构代码信息]|{}", orgCode.get(0));
                    wsVo.setOrgCode(orgCode.get(0));
                } else {
                    wsVo.setOrgCode("");
                }
                List<String> devSn = request.getHeaders().get(JYZBConstant.X_DEV_SN);
                if (null != devSn && !devSn.isEmpty()) {
                    log.info("[设备序号信息]|{}", devSn.get(0));
                    wsVo.setDevSn(devSn.get(0));
                } else {
                    wsVo.setDevSn("");
                }
                if (StrUtil.isBlank(wsVo.getOrgCode()) || StrUtil.isBlank(wsVo.getDevSn())) {
                    sec.getUserProperties().putIfAbsent(JYZBConstant.CONNECTION_STATUS, false);
                } else {
                    sec.getUserProperties().putIfAbsent(JYZBConstant.CABINET_WS_VALUE, wsVo);
                    sec.getUserProperties().putIfAbsent(JYZBConstant.CONNECTION_STATUS, true);
                }
                super.modifyHandshake(sec, request, response);
            } else {
                log.error("[智能柜授权错误]|{}", WsHandshakeExceptionEnum.WS_SIGN_VERIFY_ERROR.getMessage());
                //验证不通过 签名值无效
                throw new JYZBAppException(WsHandshakeExceptionEnum.WS_SIGN_VERIFY_ERROR);
            }
        } else {
            //签名值为空
            log.error("[智能柜授权]|-->{}", WsHandshakeExceptionEnum.WS_SIGN_EMPTY_ERROR.getMessage());
            throw new JYZBAppException(WsHandshakeExceptionEnum.WS_SIGN_EMPTY_ERROR);
        }
    }
}
