package com.junmp.jyzb.websocket;

import com.alibaba.fastjson2.JSON;
import lombok.extern.slf4j.Slf4j;

import javax.websocket.Session;
import java.io.IOException;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/4/25 11:04
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Slf4j
public class WsMsgProduce {


    /**
     * 发送消息方法
     *
     * @param session 客户端与socket建立的会话
     * @param data    消息
     * @throws IOException
     */
    public static void sendMessage(Session session, Object data) {
        try {
            if (session != null) {
                if (data instanceof String) {
                    session.getBasicRemote().sendText((String) data);
                } else {
                    session.getBasicRemote().sendText(JSON.toJSONString(data));
                }
            }
        } catch (Exception ex) {
            log.error("[Ws消息发送异常]|异常信息：{}", ex.getMessage());
        }
    }
}
