package com.junmp.jyzb.utils;

import java.lang.reflect.Field;
import java.util.Comparator;

public class SortingUtil {
    /**
     * 自定义排序，根据传递的排序字段，排序规则进行排序
     * @param column
     * @param order
     * @return
     * @param <T>
     */
    public  static <T> Comparator<T> createColumnOrderComparator(String column, String order) {
        return (object1, object2) -> {
            try {
                Field field = object1.getClass().getDeclaredField(column);
                field.setAccessible(true);
                Object fieldValue1 = field.get(object1);
                Object fieldValue2 = field.get(object2);

                if (fieldValue1 instanceof Comparable && fieldValue2 instanceof Comparable) {
                    int result = ((Comparable) fieldValue1).compareTo(fieldValue2);
                    return order.equalsIgnoreCase("desc") ? -result : result;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        };
    }

    /**
     * 自定义排序，两个字段排序
     * @param column1
     * @param order1
     * @param column2
     * @param order2
     * @return
     * @param <T>
     */
    public static <T> Comparator<T> createMultiColumnOrderComparator(String column1, String order1, String column2, String order2) {
        return (object1, object2) -> {
            try {
                Field field1 = object1.getClass().getDeclaredField(column1);
                Field field2 = object1.getClass().getDeclaredField(column2);
                field1.setAccessible(true);
                field2.setAccessible(true);
                Object fieldValue1 = field1.get(object1);
                Object fieldValue2 = field1.get(object2);

                if (fieldValue1 instanceof Comparable && fieldValue2 instanceof Comparable) {
                    int result = ((Comparable) fieldValue1).compareTo(fieldValue2);
                    if (result == 0) {
                        fieldValue1 = field2.get(object1);
                        fieldValue2 = field2.get(object2);
                        result = ((Comparable) fieldValue1).compareTo(fieldValue2);
                    }
                    int finalResult = order1.equalsIgnoreCase("desc") ? -result : result;
                    finalResult = (finalResult == 0 && order2.equalsIgnoreCase("desc")) ? -((Comparable)fieldValue1).compareTo(fieldValue2) : finalResult;
                    return finalResult;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        };
    }



    //组织机构排序
    public static <T> Comparator<T> createOrgComparator() {
        return (org1,org2) ->{

            try {
                String orgCode1 = (String) org1.getClass().getMethod("getOrgCode").invoke(org1);
                String orgCode2 = (String) org2.getClass().getMethod("getOrgCode").invoke(org2);

                // 判断是否包含字母
                boolean hasLetter1 = orgCode1.matches(".*[a-zA-Z]+.*");
                boolean hasLetter2 = orgCode2.matches(".*[a-zA-Z]+.*");

                // 如果其中一个包含字母，则将其放到排序的最后
                if (hasLetter1 && !hasLetter2) {
                    return 1; // orgCode1包含字母，orgCode2不包含字母，orgCode1排在orgCode2后面
                } else if (!hasLetter1 && hasLetter2) {
                    return -1; // orgCode1不包含字母，orgCode2包含字母，orgCode1排在orgCode2前面
                }

                // 如果两个orgCode都不含有字母，则按照每两位进行排序
                String[] orgCodeArray1 = orgCode1.split("(?<=\\G..)");
                String[] orgCodeArray2 = orgCode2.split("(?<=\\G..)");

                // 从最后一组（即最后两位）开始比较数字大小
                int index1 = orgCodeArray1.length - 1;
                int index2 = orgCodeArray2.length - 1;
                while (index1 >= 0 && index2 >= 0) {
                    String codeValue1 = orgCodeArray1[index1];
                    String codeValue2 = orgCodeArray2[index2];

                    // 判断是否可以转换为整数，如果不能，则说明包含字母，直接返回结果
                    try {
                        int intValue1 = Integer.parseInt(codeValue1, 10);
                        int intValue2 = Integer.parseInt(codeValue2, 10);
                        int compareResult = Integer.compare(intValue1, intValue2);
                        if (compareResult != 0) {
                            return compareResult;
                        }
                    } catch (NumberFormatException e) {
                        // orgCode包含字母，直接返回结果
                        return codeValue1.compareTo(codeValue2);
                    }

                    index1--;
                    index2--;
                }

                // 在数字比较的基础上，再根据level进行排序
                Integer level1 = (Integer) org1.getClass().getMethod("getLevel").invoke(org1);
                Integer level2 = (Integer) org2.getClass().getMethod("getLevel").invoke(org2);
                return Integer.compare(level1, level2);
            } catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        };
    }
}
