package com.junmp.jyzb.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.junmp.jyzb.api.bean.dto.MQDto;
import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class RabbitMQSendMsg {
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private RabbitAdmin rabbitAdmin;

    public void sendToExchange(String exchangeName, String routingKey, String api,Integer type,String message) {
        MQDto mqDto = new MQDto();
        mqDto.setApi(api);
        mqDto.setType(type);
        mqDto.setMessage(message);
        this.sendToExchange(exchangeName, routingKey, mqDto);
    }

    public void SendMsg(String exchangeName, String name, String api,Integer type,String message,String warehouseId,
                        Integer warehouseState,List<String> idList,String orderId,String orderState) {
        MQDto mqDto = new MQDto();
        mqDto.setApi(api);
        mqDto.setType(type<0?null:type);
        mqDto.setMessage(message);
        mqDto.setWarehouseId(ObjectUtil.isNotNull(warehouseId)?warehouseId:null);
        mqDto.setWarehouseState(ObjectUtil.isNotNull(warehouseState)?warehouseState:null);
        mqDto.setIdList(CollectionUtil.isNotEmpty(idList)?idList:new ArrayList<>());
        mqDto.setOrderId(ObjectUtil.isNotNull(orderId)?orderId:null);
        mqDto.setOrderState(ObjectUtil.isNotNull(orderState)?orderState:null);
        this.SendMsg(exchangeName, name, mqDto);
    }
    public void SendMsg(String exchangeName, String name, Object msg) {
        //exchangeName交换机名称，name组织机构名称，msg发送的消息
        Queue queue = new Queue(name, true, false, false);
        Exchange exchange = new DirectExchange(exchangeName, true, false);
        rabbitAdmin.declareQueue(queue);
        rabbitAdmin.declareExchange(exchange);
        rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(name).noargs());
        String jsonString;
        if (msg instanceof String) {
            jsonString = (String) msg;
        } else {
            jsonString = JSON.toJSONString(msg);
        }

        rabbitTemplate.convertAndSend(exchangeName, name, jsonString);
    }


    // 发布消息到交换机，根据不同的主题和消息内容
    public void publishOrgMessage(String orgId, String message) {
        String routingKey = "org." + orgId;
        rabbitTemplate.convertAndSend("topicExchange", routingKey, message);
    }

    public void publishCabinetMessage(String cabinetId, String message) {
        String routingKey = "cabinet." + cabinetId;
        rabbitTemplate.convertAndSend("topicExchange", routingKey, message);
    }

    public void sendToExchange(String exchangeName, String routingKey, Object msg) {
        String jsonString = JSON.toJSONString(msg);
        rabbitTemplate.convertAndSend(exchangeName, routingKey, jsonString);
    }

    //推送消息（广播式推送）
    public void sendFanoutMsg(String exchangeName, List<String> names, Object msg) {
        //exchangeName交换机名称，name单警柜或本地仓库，msg发送的消息
        for (String name : names) {
            Queue queue = new Queue(name, true, false, false);
            Exchange exchange = new FanoutExchange(exchangeName, true, false);
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareExchange(exchange);
            rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with("").noargs());
            // 将消息发送到交换机
            String jsonString = JSON.toJSONString(msg);
            rabbitTemplate.convertAndSend(exchangeName, name, jsonString);
        }

    }
}
