//package com.junmp.jyzb.utils;
//
//import io.jsonwebtoken.*;
//import org.springframework.beans.factory.annotation.Value;
//import org.springframework.stereotype.Component;
//import java.util.Date;
//
//@Component
//public class JwtUtil {
//    @Value("${jwt.secret}") // 从配置文件读取密钥
//    private String secret;
//    @Value("${jwt.expiration}") // Token过期时间（秒）
//    private long expiration;
//
//    /**
//     * 生成Token（适配您的DefaultJwtPayload）
//     */
//    public String generateToken(Long userId, String account, boolean rememberMe) {
//        Date now = new Date();
//        Date expiryDate = new Date(now.getTime() + expiration * 1000);
//        return Jwts.builder()
//                .setSubject(userId.toString()) // 绑定userId到sub字段
//                .claim("account", account)     // 自定义声明：账号
//                .claim("rememberMe", rememberMe) // 自定义声明：记住我
//                .setIssuedAt(now)
//                .setExpiration(expiryDate)
//                .signWith(SignatureAlgorithm.HS512, secret)
//                .compact();
//    }
//
//    /**
//     * 验证Token有效性
//     */
//    public boolean validateToken(String token) {
//        try {
//            Jwts.parser().setSigningKey(secret).parseClaimsJws(token);
//            return true;
//        } catch (ExpiredJwtException e) {
//            // Token过期
//            return false;
//        } catch (Exception e) {
//            // 签名无效、格式错误等
//            return false;
//        }
//    }
//
//    /**
//     * 从Token中提取userId
//     */
//    public Long getUserIdFromToken(String token) {
//        Claims claims = Jwts.parser()
//                .setSigningKey(secret)
//                .parseClaimsJws(token)
//                .getBody();
//        return Long.parseLong(claims.getSubject());
//    }
//}