package com.junmp.jyzb.utils;

import com.junmp.jyzb.entity.InventorySummary;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


public class BusinessUtil {


    /**
     * 创建补齐空数据(页面显示补齐数据，如每页10条，当前只有6条数据，再创建4条空数据进行补齐)
     */
    public static <T> List<T> createNullData(Long size,Long pageNo,Long pageSize,Class<T> clazz) {

        //余数
        long num= size % pageSize;
        //整数
        long integer=size / pageSize;
        List<T> collect1=new ArrayList<>();
        if (num!=0){
            //判断整数是什么，就在第几页进行补
            if(pageNo-1==integer ){
                for (int i = 0; i < pageSize-num; i++) {
                    try {
                        // 通过传递的 Class 对象创建泛型对象实例
                        T instance = clazz.newInstance();
                        collect1.add(instance);
                    } catch (InstantiationException | IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
//        else {
//
//            if (size>0 && integer!=1 ){
//                for (int i = 0; i < 10; i++) {
//                    try {
//                        // 通过传递的 Class 对象创建泛型对象实例
//                        T instance = clazz.newInstance();
//                        collect1.add(instance);
//                    } catch (InstantiationException | IllegalAccessException e) {
//                        e.printStackTrace();
//                    }
//                }
//            }
//        }
        return collect1;
    }


    /**
     * 判断库存数量是否足够，然后返回入参查询出来的数量（如果传参的数据库存没有，那么直接创建一条库存数量为0新数据返回）
     */
    public static  <T> List<InventorySummary> returnInventorySumData(List<T> list,Class<T> clazz,List<InventorySummary> inventorySummaryList){

        //判断装备的list是否和传入的list的size是否相等，如果相等则表示所有的库存数量都能查询到，如果不相等则进行遍历将不满足要求的进行新增一条装备数量为0的库存信息进行返回给前端
        if (list.size()==inventorySummaryList.size()){
            return inventorySummaryList;
        }else {
            List<InventorySummary> returnList = new ArrayList<>();
            for (T inv : list) {
                boolean flag = false;
                Object orgIdValue=0L;
                Object locationIdValue="";
                Object typeIdValue="";
                Object sizeIdValue="";
                Object unitPriceValue;

                for (InventorySummary is : inventorySummaryList) {
                    try {
                        Field orgIdField = clazz.getDeclaredField("orgId");
                        Field locationIdField = clazz.getDeclaredField("locationId");
                        Field typeIdField = clazz.getDeclaredField("typeId");
                        Field sizeIdField = clazz.getDeclaredField("sizeId");
                        Field unitPriceField = clazz.getDeclaredField("unitPrice");

                        orgIdField.setAccessible(true);
                        locationIdField.setAccessible(true);
                        typeIdField.setAccessible(true);
                        sizeIdField.setAccessible(true);
                        unitPriceField.setAccessible(true);

                        orgIdValue = orgIdField.get(inv);
                        locationIdValue = locationIdField.get(inv);
                        typeIdValue = typeIdField.get(inv);
                        sizeIdValue = sizeIdField.get(inv);
                        unitPriceValue = unitPriceField.get(inv);


                        if (orgIdValue.equals(is.getOrgId()) && locationIdValue.equals(is.getLocationId())
                                && typeIdValue.equals(is.getTypeId()) && sizeIdValue.equals(is.getSizeId())
                                && is.getUnitPrice().compareTo(new BigDecimal(unitPriceValue.toString())) == 0) {
                            flag = true;
                            returnList.add(is);
                            break;
                        }
                    }
                     catch (NoSuchFieldException | IllegalAccessException e) {
                        // 处理异常
                    }
                }
                if (!flag) {
                    InventorySummary inventorySummary = new InventorySummary();
                    // 设置属性值
                    inventorySummary.setOrgId((Long)orgIdValue);
                    inventorySummary.setLocationId((String) locationIdValue);
                    inventorySummary.setTypeId((String) typeIdValue);
                    inventorySummary.setSizeId((String) sizeIdValue);
                    inventorySummary.setUnitPrice(BigDecimal.ZERO);
                    inventorySummary.setStockNumber(0);
                    inventorySummary.setOutboundNumber(0);
                    inventorySummary.setPrice(BigDecimal.ZERO);
                    inventorySummary.setBrokenNumber(0);
                    inventorySummary.setDestructionNumber(0);
                    returnList.add(inventorySummary);
                }
            }
            return returnList;
        }
    }
}
