package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.WarrantyReq;
import com.junmp.jyzb.entity.WarrantyInventory;
import com.junmp.jyzb.service.WarrantyInventoryService;
import com.junmp.jyzb.mapper.WarrantyInventoryMapper;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
* @author Administrator
* @description 针对表【base_warranty_inventory】的数据库操作Service实现
* @createDate 2024-12-31 10:23:36
*/
@Service
public class WarrantyInventoryServiceImpl extends ServiceImpl<WarrantyInventoryMapper, WarrantyInventory>
    implements WarrantyInventoryService{


    @Override
    public PageResult<WarrantyInventory> WarrantyInventoryDetail(WarrantyReq req) {
        LambdaQueryWrapper<WarrantyInventory> wrapper = createWrapper(req);
        Page<WarrantyInventory> page = page(PageFactory.getDefaultPage(req),wrapper);

        return PageResultFactory.createPageResult(page);
    }

    private LambdaQueryWrapper<WarrantyInventory> createWrapper(WarrantyReq req) {
        LambdaQueryWrapper<WarrantyInventory> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isNull(req)){
            return wrapper;
        }
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrgId()), WarrantyInventory::getOrgId, req.getOrgId())
                .eq(ObjectUtil.isNotEmpty(req.getLocationId()), WarrantyInventory::getLocationId, req.getLocationId())
                .eq(ObjectUtil.isNotEmpty(req.getLocationType()), WarrantyInventory::getLocationType, req.getLocationType())
                .eq(ObjectUtil.isNotEmpty(req.getLocationState()), WarrantyInventory::getLocationState, req.getLocationState())
                .eq(ObjectUtil.isNotEmpty(req.getSizeId()), WarrantyInventory::getSizeId, req.getSizeId())
                .eq(ObjectUtil.isNotEmpty(req.getTypeId()), WarrantyInventory::getTypeId, req.getTypeId())
                .eq(ObjectUtil.isNotEmpty(req.getWarrantyType()), WarrantyInventory::getWarrantyType, req.getWarrantyType())
                .like(ObjectUtil.isNotEmpty(req.getTypeName()), WarrantyInventory::getTypeName, req.getTypeName())
                .like(ObjectUtil.isNotEmpty(req.getSizeName()), WarrantyInventory::getSizeName, req.getSizeName());
        return wrapper;
    }
}




