package com.junmp.jyzb.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.fetchingDataDto.WarehouseDevInfoDto;
import com.junmp.jyzb.api.bean.req.UpdateWarehouseDevReq;
import com.junmp.jyzb.api.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.api.exception.enums.ConfigExceptionEnum;
import com.junmp.jyzb.entity.WarehouseDev;
import com.junmp.jyzb.service.WarehouseDevService;
import com.junmp.jyzb.mapper.WarehouseDevMapper;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.jyzb.utils.RabbitMQSendMsg;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* @author lxh专属坐骑
* @description 针对表【sys_temp_humidity(温湿度)】的数据库操作Service实现
* @createDate 2023-12-19 08:33:43
*/
@Service
public class WarehouseDevServiceImpl extends ServiceImpl<WarehouseDevMapper, WarehouseDev>
    implements WarehouseDevService {

    @Resource
    private WarehouseDevService warehouseDevService;

    @Resource
    private WarehouseDevMapper warehouseDevMapper;

    @Autowired
    private RabbitMQSendMsg MQ;

    @Override
    public String addWarehouseDev(UpdateWarehouseDevReq req) {
        List<WarehouseDev> list = list(new LambdaQueryWrapper<WarehouseDev>().eq(WarehouseDev::getDevName, req.getDevName()));
        if (CollectionUtil.isNotEmpty(list)) {
            throw new ServiceException(ConfigExceptionEnum.WAREHOUSE_DEV_NAME_EXIST);
        }
        WarehouseDev warehouseDev = new WarehouseDev();
        BeanPlusUtil.copyProperties(req,warehouseDev);
        warehouseDev.setCreateTime(DateTimeUtil.getCurrentDateTime());
        warehouseDev.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        warehouseDevService.save(warehouseDev);


        //判断是否暂存，将消息下发给本地主机
        //如果为空或者为false，则将直接发送给本地主机
        if(ObjectUtil.isNull(req.getFlag()) ||!req.getFlag()){

            MQ.SendMsg("warehouseMsg",req.getOrgId().toString(),"InfoChange",6,"Adding warehouseDevInfo",
                    null,null,new ArrayList<>(),null,null);
        }
        return warehouseDev.getId();
    }

    @Override
    public boolean updateWarehouseDev(UpdateWarehouseDevReq req) {
        WarehouseDev warehouseDev = new WarehouseDev();
        BeanPlusUtil.copyProperties(req,warehouseDev);
        warehouseDev.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        //判断是否暂存，将消息下发给本地主机

        //如果为空或者为false，则将直接发送给本地主机
        if(ObjectUtil.isNull(req.getFlag()) ||!req.getFlag()){

            MQ.SendMsg("warehouseMsg",req.getOrgId().toString(),"InfoChange",6,"Updating warehouseDevInfo",
                    null,null,new ArrayList<>(),null,null);
        }
        return warehouseDevService.updateById(warehouseDev);
    }

    @Override
    public List<WarehouseDev> showWarehouseDevList(UpdateWarehouseDevReq req) {
        return warehouseDevMapper.showWarehouseDevList(req);
    }

    @Override
    public List<WarehouseDevInfoDto> alignWarehouseDevInfo(UpdateWarehouseDevReq req) {
        String date = DateTimeUtil.TimeLongToString(req.getUpdateTime());
        return warehouseDevMapper.alignWarehouseDevInfo(req.getOrgId(),date);
    }

    @Override
    public boolean delWarehouseDev(UpdateWarehouseDevReq req) {
        if (ObjectUtil.isNull(req.getId())){
            throw new ServiceException(CabinetExceptionEnum.PARAMETER_ERROR);
        }
        return warehouseDevService.removeById(req.getId());
    }

}




