package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.query.WarehouseAreaReq;
import com.junmp.jyzb.api.bean.req.UpdateWarehouseAreaReq;
import com.junmp.jyzb.api.exception.enums.WarehouseAreaExceptionEnum;
import com.junmp.jyzb.entity.WarehouseArea;
import com.junmp.jyzb.service.WarehouseService;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.WarehouseAreaMapper;
import com.junmp.jyzb.service.WarehouseAreaService;

import java.util.ArrayList;
import java.util.List;

@Service
public class WarehouseAreaServiceImpl extends ServiceImpl<WarehouseAreaMapper, WarehouseArea> implements WarehouseAreaService{

    @Resource
    private WarehouseService warehouseService;



    /**
     * 增加区域
     * @param req
     * @return
     */
    @Override
    public String addArea(UpdateWarehouseAreaReq req) {
        WarehouseArea area = new WarehouseArea();
        BeanPlusUtil.copyProperties(req, area);
        //判断仓库是否存在
        warehouseService.WarehoustExist(req.getWarehouseId());
        //判断区域名称是否存在如果存在则抛出异常
        List<WarehouseArea> list = list(new LambdaQueryWrapper<WarehouseArea>()
                .eq(WarehouseArea::getWarehouseId, req.getWarehouseId())
                .eq(WarehouseArea::getAreaName, req.getAreaName()));
        if (list.size()>0){
            throw new ServiceException(WarehouseAreaExceptionEnum.AREA_IS_EXISTS);
        }
        area.setCreateTime(DateTimeUtil.getCurrentDateTime());
        area.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        save(area);
        return area.getAreaId();
    }

    /**
     * 更新区域信息
     * @param req
     * @return
     */
    @Override
    public boolean updateArea(UpdateWarehouseAreaReq req) {
        WarehouseArea warehouseArea = new WarehouseArea();
        BeanPlusUtil.copyProperties(req,warehouseArea);
        //判断仓库是否存在
        warehouseService.WarehoustExist(req.getWarehouseId());
        //判断传入的区域id是否存在
        WarehouseAreaExist(req.getAreaId());
        warehouseArea.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return this.updateById(warehouseArea);
    }

    /**
     * 删除区域
     * @param req
     * @return
     */
    @Override
    public boolean deleteArea(UpdateWarehouseAreaReq req) {
        //判断传入的区域id是否存在
        WarehouseAreaExist(req.getAreaId());
        WarehouseArea warehouseArea = new WarehouseArea();
        BeanPlusUtil.copyProperties(req,warehouseArea);
        return this.removeById(warehouseArea);
    }

    /**
     * 通过区域id查询区域信息
     * @param req
     * @return
     */
    @Override
    public List<WarehouseAreaDto> getAreaList(WarehouseAreaReq req) {
        //判断仓库是否存在
        warehouseService.WarehoustExist(req.getWarehouseId());
        List<WarehouseArea> list = list(new LambdaQueryWrapper<WarehouseArea>()
                .eq(WarehouseArea::getWarehouseId, req.getWarehouseId()));
        List<WarehouseAreaDto> warehouseAreaDtoList=new ArrayList<>();
        for (WarehouseArea warehouseArea:list) {
            WarehouseAreaDto warehouseAreaDto = new WarehouseAreaDto();
            BeanPlusUtil.copyProperties(warehouseArea,warehouseAreaDto);
            warehouseAreaDtoList.add(warehouseAreaDto);
        }
        return warehouseAreaDtoList;
    }



    //判断区域id是否正确存在
    public WarehouseArea WarehouseAreaExist(String id){
        WarehouseArea warehouseArea = this.getById(id);
        if (ObjectUtil.isNull(warehouseArea)){
            throw new ServiceException(WarehouseAreaExceptionEnum.WAREHOUSEAREA_NOT_EXIST);
        }
        return warehouseArea;
    }




}
