package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.tjDto.WarrantyDataDto;
import com.junmp.jyzb.api.bean.req.WarrantyReq;
import com.junmp.jyzb.entity.VieDestoryGroup;
import com.junmp.jyzb.entity.VieWarrantyGroup;
import com.junmp.jyzb.mapper.VieWarrantyGroupMapper;
import com.junmp.jyzb.service.VieWarrantyGroupService;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
@Slf4j
public class VieWarrantyGroupServiceImpl extends ServiceImpl<VieWarrantyGroupMapper, VieWarrantyGroup> implements VieWarrantyGroupService {

    @Resource
    private VieWarrantyGroupMapper vieWarrantyGroupMapper;

    @Override
    public PageResult<WarrantyDataDto> WarrantyData(WarrantyReq req) {
        if(req.getWarrantyType().equals("0"))
        {
//            LambdaQueryWrapper<WarrantyDataDto> wrapper = createWrapper(req);
//            Page<WarrantyDataDto> page = page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), wrapper);

            Page<WarrantyDataDto> page=vieWarrantyGroupMapper.WarrantyData(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()),req);

            return PageResultFactory.createPageResult(page);
        }
        else return PageResultFactory.createPageResult(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()));


    }


    private LambdaQueryWrapper<VieWarrantyGroup> createWrapper(WarrantyReq req) {
        LambdaQueryWrapper<VieWarrantyGroup> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }

        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrgId()), VieWarrantyGroup::getOrgId, req.getOrgId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getSizeId()), VieWarrantyGroup::getSizeId, req.getSizeId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getTypeId()), VieWarrantyGroup::getTypeId, req.getTypeId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getTypeName()), VieWarrantyGroup::getTypeName, req.getTypeName());
        boolean flag=req.getOrder().equals("asc");
        wrapper.orderBy(ObjectUtil.isEmpty(req.getWarrantyDays()),flag,VieWarrantyGroup::getDays);
        wrapper.orderBy(ObjectUtil.isNotEmpty(req.getWarrantyDays()),flag,VieWarrantyGroup::getCountOfItems);

        return wrapper;
    }
    private LambdaQueryWrapper<VieDestoryGroup> CreateDestoryWrapper(WarrantyReq req) {
        LambdaQueryWrapper<VieDestoryGroup> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }

        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrgId()), VieDestoryGroup::getOrgId, req.getOrgId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getSizeId()), VieDestoryGroup::getSizeId, req.getSizeId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getTypeId()), VieDestoryGroup::getTypeId, req.getTypeId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getWarrantyType()), VieDestoryGroup::getState, req.getState());

        return wrapper;
    }
}
