package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.QuerySystemManageReq;
import com.junmp.jyzb.api.bean.req.SystemManageReq;
import com.junmp.jyzb.api.exception.enums.SystemManageExceptionEnum;
import com.junmp.jyzb.entity.SystemManage;
import com.junmp.jyzb.service.SystemManageService;
import com.junmp.jyzb.mapper.SystemManageMapper;
import com.junmp.v2.common.enums.LogicDelEnum;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;

import javax.xml.bind.JAXBException;
import java.util.Date;
import java.util.List;

/**
* @author Administrator
* @description 针对表【base_system(制度管理表)】的数据库操作Service实现
* @createDate 2024-12-04 09:05:24
*/
@Service
public class SystemManageServiceImpl extends ServiceImpl<SystemManageMapper, SystemManage>
    implements SystemManageService {

    @Override
    public boolean add(SystemManageReq req) {
        if (existsSystemName(req.getSystemName())){
           throw new ServiceException(SystemManageExceptionEnum.FILE_NAME_EXIST);
        }
        SystemManage systemManage = new SystemManage();
        BeanPlusUtil.copyProperties(req, systemManage);
        systemManage.setCreateTime(new Date());
        systemManage.setUpdateTime(new Date());
        return save(systemManage);
    }

    @Override
    public boolean updateInfo(SystemManageReq req) {
        SystemManage systemManage = getInfoById(req.getFileId());
        if (!StrUtil.equalsIgnoreCase(req.getSystemName(), systemManage.getSystemName())) {
            if (existsSystemName(req.getSystemName())) {
                throw new ServiceException(SystemManageExceptionEnum.FILE_NAME_EXIST);
            }
        }
        BeanPlusUtil.copyProperties(req, systemManage);
        systemManage.setUpdateTime(new Date());
        return updateById(systemManage);
    }

    @Override
    public boolean del(SystemManageReq req) {
        return removeById(req.getFileId());
    }

    @Override
    public SystemManage detail(QuerySystemManageReq req) {
        return getById(req.getFileId());
    }

    @Override
    public List<SystemManage> findList(QuerySystemManageReq req) {
        LambdaQueryWrapper<SystemManage> wp = this.createWrapper(req);
        return list(wp);
    }

    @Override
    public PageResult<SystemManage> findPage(QuerySystemManageReq req) {
        LambdaQueryWrapper<SystemManage> wp = this.createWrapper(req);
        Page<SystemManage> page = this.page(PageFactory.getDefaultPage(req), wp);
        return PageResultFactory.createPageResult(page);
    }

    private LambdaQueryWrapper<SystemManage> createWrapper(QuerySystemManageReq req) {
        LambdaQueryWrapper<SystemManage> wp = Wrappers.lambdaQuery();
        wp.eq(StrUtil.isNotBlank(req.getSystemName()), SystemManage::getSystemName, req.getSystemName());
        wp.eq(StrUtil.isNotBlank(req.getUrl()), SystemManage::getUrl, req.getUrl());
        wp.eq(ObjectUtil.isNotNull(req.getSortVal()), SystemManage::getSortVal, req.getSortVal());
        return wp;
    }

    private SystemManage getInfoById(String fileId) {
        SystemManage info = this.getById(fileId);
        if (ObjectUtil.isNull(info)) {
            throw new ServiceException(SystemManageExceptionEnum.FILE_INFO_NOT_EXIST);
        }
        return info;
    }
    private boolean existsSystemName(String SystemName) {
        LambdaQueryWrapper<SystemManage> wp = Wrappers.lambdaQuery();
        wp.eq(StrUtil.isNotBlank(SystemName), SystemManage::getSystemName, SystemName);
        return this.count(wp) > 0;
    }
}




